/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.utils.CommonUtils;

public class EmptyPresentation
extends AbstractPresentation {
    private Composite placeholder;

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        UIUtils.createHorizontalLine((Composite)parent);
        this.placeholder = new Canvas(parent, 0);
        this.placeholder.setLayoutData((Object)new GridData(1808));
        this.placeholder.setBackground(controller.getDefaultBackground());
        Font normalFont = parent.getFont();
        FontData[] fontData = normalFont.getFontData();
        fontData[0].setStyle(fontData[0].getStyle() | 1);
        fontData[0].setHeight(18);
        Font largeFont = new Font(normalFont.getDevice(), fontData[0]);
        this.placeholder.addDisposeListener(e -> UIUtils.dispose((Resource)largeFont));
        this.placeholder.addPaintListener(e -> {
            if (controller.isRefreshInProgress()) {
                return;
            }
            e.gc.setFont(largeFont);
            e.gc.setForeground(UIStyles.getDefaultTextForeground());
            String emptyDataMessage = controller.getDecorator().getEmptyDataMessage();
            Point emSize = e.gc.textExtent(emptyDataMessage);
            UIUtils.drawMessageOverControl((Control)this.placeholder, (PaintEvent)e, (String)emptyDataMessage, (int)(-emSize.y));
            e.gc.setFont(normalFont);
            String emptyDataDescription = controller.getDecorator().getEmptyDataDescription();
            if (!CommonUtils.isEmpty((String)emptyDataDescription)) {
                UIUtils.drawMessageOverControl((Control)this.placeholder, (PaintEvent)e, (String)emptyDataDescription, (int)10);
            }
        });
        this.trackPresentationControl();
    }

    @Override
    public Control getControl() {
        return this.placeholder;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return null;
    }

    @Override
    public void setCurrentAttribute(@NotNull DBDAttributeBinding attribute) {
    }

    @Override
    public Point getCursorLocation() {
        return null;
    }

    @Override
    @Nullable
    public String copySelectionToString(ResultSetCopySettings settings) {
        return null;
    }

    @Override
    public void printResultSet() {
    }
}

