/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.scripts.ScriptsHandlerImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorUtils {
    private static final Log log = Log.getLog(SQLEditorUtils.class);
    public static final String SCRIPT_FILE_EXTENSION = "sql";

    public static IFolder getScriptsFolder(DBPProject project, boolean forceCreate) throws CoreException {
        if (project == null) {
            Status status = new Status(4, "org.jkiss.dbeaver.ui.editors.sql", "No active project to locate Script Folder");
            throw new CoreException((IStatus)status);
        }
        return DBWorkbench.getPlatform().getWorkspace().getResourceDefaultRoot(project, ScriptsHandlerImpl.class, forceCreate);
    }

    @Nullable
    public static ResourceInfo findRecentScript(DBPProject project, @Nullable DBPDataSourceContainer container) throws CoreException {
        ArrayList<ResourceInfo> scripts = new ArrayList<ResourceInfo>();
        SQLEditorUtils.findScriptList(SQLEditorUtils.getScriptsFolder(project, false), container, scripts);
        long recentTimestamp = 0L;
        ResourceInfo recentFile = null;
        for (ResourceInfo file : scripts) {
            if (file.localFile.lastModified() <= recentTimestamp) continue;
            recentTimestamp = file.localFile.lastModified();
            recentFile = file;
        }
        return recentFile;
    }

    private static void findScriptList(IFolder folder, @Nullable DBPDataSourceContainer container, List<ResourceInfo> result) {
        if (folder == null) {
            return;
        }
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && SCRIPT_FILE_EXTENSION.equals(resource.getFileExtension())) {
                    DBPDataSourceContainer scriptDataSource = EditorUtils.getFileDataSource((IFile)((IFile)resource));
                    if (container == null || scriptDataSource == container) {
                        result.add(new ResourceInfo((IFile)resource, scriptDataSource));
                    }
                } else if (resource instanceof IFolder) {
                    SQLEditorUtils.findScriptList((IFolder)resource, container, result);
                }
                ++n2;
            }
            if (container != null) {
                for (Map.Entry fileEntry : DBWorkbench.getPlatform().getExternalFileManager().getAllFiles().entrySet()) {
                    File extFile;
                    if (!container.getId().equals(((Map)fileEntry.getValue()).get("sql-editor-data-source-id")) || !(extFile = new File((String)fileEntry.getKey())).exists()) continue;
                    result.add(new ResourceInfo(extFile, container));
                }
            }
        }
        catch (CoreException e) {
            log.debug((Object)e.getMessage());
        }
    }

    public static List<ResourceInfo> findScriptTree(IFolder folder, @Nullable DBPDataSourceContainer[] containers) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceInfo folderInfo;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && SCRIPT_FILE_EXTENSION.equals(resource.getFileExtension())) {
                    DBPDataSourceContainer scriptDataSource = EditorUtils.getFileDataSource((IFile)((IFile)resource));
                    if (containers == null || ArrayUtils.containsRef((Object[])containers, (Object)scriptDataSource)) {
                        result.add(new ResourceInfo((IFile)resource, scriptDataSource));
                    }
                } else if (resource instanceof IFolder && SQLEditorUtils.findChildScripts(folderInfo = new ResourceInfo((IFolder)resource), containers)) {
                    result.add(folderInfo);
                }
                ++n2;
            }
            if (!ArrayUtils.isEmpty((Object[])containers)) {
                block3: for (Map.Entry fileEntry : DBWorkbench.getPlatform().getExternalFileManager().getAllFiles().entrySet()) {
                    File extFile;
                    Object fileContainerId = ((Map)fileEntry.getValue()).get("sql-editor-data-source-id");
                    if (fileContainerId == null || !(extFile = new File((String)fileEntry.getKey())).exists()) continue;
                    DBPDataSourceContainer[] dBPDataSourceContainerArray = containers;
                    int n3 = containers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DBPDataSourceContainer container = dBPDataSourceContainerArray[n4];
                        if (container.getId().equals(fileContainerId)) {
                            result.add(new ResourceInfo(extFile, container));
                            continue block3;
                        }
                        ++n4;
                    }
                }
            }
        }
        catch (CoreException e) {
            log.debug((Object)e);
        }
        return result;
    }

    private static boolean findChildScripts(ResourceInfo folder, @Nullable DBPDataSourceContainer[] containers) throws CoreException {
        boolean hasScripts = false;
        IResource[] iResourceArray = ((IFolder)folder.resource).members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceInfo folderInfo;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && SCRIPT_FILE_EXTENSION.equals(resource.getFileExtension())) {
                DBPDataSourceContainer scriptDataSource = EditorUtils.getFileDataSource((IFile)((IFile)resource));
                if (containers == null || ArrayUtils.containsRef((Object[])containers, (Object)scriptDataSource)) {
                    folder.children.add(new ResourceInfo((IFile)resource, scriptDataSource));
                    hasScripts = true;
                }
            } else if (resource instanceof IFolder && SQLEditorUtils.findChildScripts(folderInfo = new ResourceInfo((IFolder)resource), containers)) {
                folder.children.add(folderInfo);
                hasScripts = true;
            }
            ++n2;
        }
        return hasScripts;
    }

    public static IFile createNewScript(DBPProject project, @Nullable IFolder folder, @Nullable DBPDataSourceContainer dataSourceContainer) throws CoreException {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IFolder scriptsRootFolder = SQLEditorUtils.getScriptsFolder(project, true);
        IFolder scriptsFolder = folder;
        if (scriptsFolder == null) {
            scriptsFolder = scriptsRootFolder;
        }
        if (!scriptsFolder.exists()) {
            scriptsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (CommonUtils.equalObjects((Object)scriptsRootFolder, (Object)scriptsFolder) && dataSourceContainer != null) {
            IFolder dbFolder;
            DBPDataSourceFolder conFolder;
            if (dataSourceContainer.getPreferenceStore().getBoolean("script.auto.connection.folders") && (conFolder = dataSourceContainer.getFolder()) != null) {
                ArrayList<DBPDataSourceFolder> conFolders = new ArrayList<DBPDataSourceFolder>();
                DBPDataSourceFolder f2 = conFolder;
                while (f2 != null) {
                    conFolders.add(0, f2);
                    f2 = f2.getParent();
                }
                for (DBPDataSourceFolder f2 : conFolders) {
                    IFolder dbFolder2 = scriptsFolder.getFolder(CommonUtils.escapeFileName((String)f2.getName()));
                    if (dbFolder2 == null) continue;
                    if (!dbFolder2.exists()) {
                        dbFolder2.create(true, true, (IProgressMonitor)progressMonitor);
                    }
                    scriptsFolder = dbFolder2;
                }
            }
            if (dataSourceContainer.getPreferenceStore().getBoolean("script.auto.folders") && (dbFolder = scriptsFolder.getFolder(CommonUtils.escapeFileName((String)dataSourceContainer.getName()))) != null) {
                if (!dbFolder.exists()) {
                    dbFolder.create(true, true, (IProgressMonitor)progressMonitor);
                }
                scriptsFolder = dbFolder;
            }
        }
        IFile tempFile = ContentUtils.getUniqueFile((IFolder)scriptsFolder, (String)"Script", (String)SCRIPT_FILE_EXTENSION);
        tempFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)progressMonitor);
        if (dataSourceContainer != null) {
            EditorUtils.setFileDataSource((IFile)tempFile, (DBPDataSourceContainer)dataSourceContainer);
        }
        return tempFile;
    }

    public static String getResourceDescription(IResource resource) {
        if (resource instanceof IFolder) {
            return "";
        }
        if (resource instanceof IFile && SCRIPT_FILE_EXTENSION.equals(resource.getFileExtension())) {
            String description = SQLUtils.getScriptDescription((IFile)((IFile)resource));
            if (CommonUtils.isEmptyTrimmed((String)description)) {
                description = "<empty>";
            }
            return description;
        }
        return "";
    }

    public static class ResourceInfo {
        private final IResource resource;
        private final File localFile;
        private final DBPDataSourceContainer dataSource;
        private final List<ResourceInfo> children;
        private String description;

        public ResourceInfo(IFile file, DBPDataSourceContainer dataSource) {
            this.resource = file;
            this.localFile = file.getLocation().toFile();
            this.dataSource = dataSource;
            this.children = null;
        }

        public ResourceInfo(IFolder folder) {
            this.resource = folder;
            this.localFile = folder.getLocation().toFile();
            this.dataSource = null;
            this.children = new ArrayList<ResourceInfo>();
        }

        public ResourceInfo(File localFile, DBPDataSourceContainer dataSource) {
            this.resource = null;
            this.localFile = localFile;
            this.dataSource = dataSource;
            this.children = null;
        }

        public IResource getResource() {
            return this.resource;
        }

        public File getLocalFile() {
            return this.localFile;
        }

        public String getName() {
            return this.resource != null ? this.resource.getName() : this.localFile.getName();
        }

        public DBPDataSourceContainer getDataSource() {
            return this.dataSource;
        }

        public boolean isDirectory() {
            return this.resource instanceof IFolder;
        }

        public List<ResourceInfo> getChildren() {
            return this.children;
        }

        public String getDescription() {
            if (this.description == null) {
                this.description = SQLEditorUtils.getResourceDescription(this.resource);
            }
            return this.description;
        }

        public String toString() {
            return this.getName();
        }
    }
}

