/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.templates.TemplateContext;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLObjectResolver;
import org.jkiss.utils.CommonUtils;

public class SQLContainerResolver<T extends DBSObjectContainer>
extends SQLObjectResolver<T> {
    private static final Log log = Log.getLog(SQLContainerResolver.class);
    public static final String VAR_NAME_SCHEMA = "schema";
    public static final String VAR_NAME_CATALOG = "catalog";
    private Class<T> objectType;

    public SQLContainerResolver(String id, String title, Class<T> objectType) {
        super(id, title);
        this.objectType = objectType;
    }

    @Override
    protected void resolveObjects(DBRProgressMonitor monitor, DBCExecutionContext executionContext, TemplateContext context, List<T> entities) throws DBException {
        DBSObjectContainer objectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)executionContext.getDataSource());
        if (objectContainer != null) {
            this.makeProposalsFromChildren(monitor, objectContainer, entities);
        }
    }

    void makeProposalsFromChildren(DBRProgressMonitor monitor, DBSObjectContainer container, List<T> names) throws DBException {
        DBSObjectSelector objectSelector;
        Collection children = container.getChildren(monitor);
        if (CommonUtils.isEmpty((Collection)children)) {
            return;
        }
        for (DBSObject child : children) {
            if (!this.objectType.isInstance(child)) continue;
            names.add((DBSObjectContainer)this.objectType.cast(child));
        }
        if (names.isEmpty() && (objectSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)container)) != null && (container = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)objectSelector.getDefaultObject())) != null) {
            this.makeProposalsFromChildren(monitor, container, names);
        }
    }
}

