/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates.persistence;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.text.templates.TemplateStoreCore;

public class TemplateStore
extends TemplateStoreCore {
    private IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fPropertyListener;
    private boolean fIgnorePreferenceStoreChanges = false;

    public TemplateStore(IPreferenceStore store, String key) {
        super(null, key);
        Assert.isNotNull((Object)store);
        Assert.isNotNull((Object)key);
        this.fPreferenceStore = store;
    }

    public TemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super((org.eclipse.text.templates.ContextTypeRegistry)registry, null, key);
        this.fPreferenceStore = store;
    }

    public void load() throws IOException {
        this.internalGetTemplates().clear();
        this.loadContributedTemplates();
        this.loadCustomTemplates();
    }

    public final void startListeningForPreferenceChanges() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (!TemplateStore.this.fIgnorePreferenceStoreChanges && TemplateStore.this.getKey().equals(event.getProperty())) {
                        try {
                            TemplateStore.this.load();
                        }
                        catch (IOException x) {
                            TemplateStore.this.handleException(x);
                        }
                    }
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyListener);
        }
    }

    public final void stopListeningForPreferenceChanges() {
        if (this.fPropertyListener != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    public void save() throws IOException {
        ArrayList<org.eclipse.text.templates.TemplatePersistenceData> custom = new ArrayList<org.eclipse.text.templates.TemplatePersistenceData>();
        for (org.eclipse.text.templates.TemplatePersistenceData data : this.internalGetTemplates()) {
            if (!data.isCustom() || data.isUserAdded() && data.isDeleted()) continue;
            custom.add(data);
        }
        StringWriter output = new StringWriter();
        TemplateReaderWriter writer = new TemplateReaderWriter();
        writer.save(custom.toArray(new org.eclipse.text.templates.TemplatePersistenceData[custom.size()]), (Writer)output);
        this.fIgnorePreferenceStoreChanges = true;
        try {
            this.fPreferenceStore.setValue(this.getKey(), output.toString());
            if (this.fPreferenceStore instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)this.fPreferenceStore).save();
            }
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
    }

    public void restoreDefaults(boolean doSave) {
        String oldValue = null;
        if (!doSave) {
            oldValue = this.fPreferenceStore.getString(this.getKey());
        }
        try {
            this.fIgnorePreferenceStoreChanges = true;
            this.fPreferenceStore.setToDefault(this.getKey());
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
        try {
            this.load();
        }
        catch (IOException x) {
            this.handleException(x);
        }
        if (oldValue != null) {
            try {
                this.fIgnorePreferenceStoreChanges = true;
                this.fPreferenceStore.putValue(this.getKey(), oldValue);
            }
            finally {
                this.fIgnorePreferenceStoreChanges = false;
            }
        }
    }

    private void loadCustomTemplates() throws IOException {
        String pref = this.fPreferenceStore.getString(this.getKey());
        if (pref != null && pref.trim().length() > 0) {
            org.eclipse.text.templates.TemplatePersistenceData[] datas;
            StringReader input = new StringReader(pref);
            TemplateReaderWriter reader = new TemplateReaderWriter();
            org.eclipse.text.templates.TemplatePersistenceData[] templatePersistenceDataArray = datas = reader.read((Reader)input);
            int n = datas.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.text.templates.TemplatePersistenceData data = templatePersistenceDataArray[n2];
                this.add(data);
                ++n2;
            }
        }
    }

    protected final ContextTypeRegistry getRegistry() {
        org.eclipse.text.templates.ContextTypeRegistry registry = super.getRegistry();
        if (registry == null) {
            return null;
        }
        ContextTypeRegistry res = new ContextTypeRegistry();
        registry.contextTypes().forEachRemaining(t -> res.addContextType((TemplateContextType)t));
        return res;
    }

    public void add(TemplatePersistenceData data) {
        super.add((org.eclipse.text.templates.TemplatePersistenceData)data);
    }

    public void delete(TemplatePersistenceData data) {
        super.delete((org.eclipse.text.templates.TemplatePersistenceData)data);
    }

    public TemplatePersistenceData[] getTemplateData(boolean includeDeleted) {
        org.eclipse.text.templates.TemplatePersistenceData[] list = super.getTemplateData(includeDeleted);
        TemplatePersistenceData[] wraps = new TemplatePersistenceData[list.length];
        int i = 0;
        while (i < wraps.length) {
            wraps[i] = new TemplatePersistenceData(list[i]);
            ++i;
        }
        return wraps;
    }

    public TemplatePersistenceData getTemplateData(String id) {
        org.eclipse.text.templates.TemplatePersistenceData data = super.getTemplateData(id);
        TemplatePersistenceData wrap = new TemplatePersistenceData(data);
        return wrap;
    }

    protected void internalAdd(TemplatePersistenceData data) {
        super.internalAdd((org.eclipse.text.templates.TemplatePersistenceData)data);
    }
}

