/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format.tokenized;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.format.tokenized.FormatterToken;
import org.jkiss.dbeaver.model.sql.format.tokenized.SQLFormatterTokenized;
import org.jkiss.dbeaver.model.sql.format.tokenized.TokenType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

class IndentFormatter {
    private static final Log log = Log.getLog(SQLFormatterTokenized.class);
    private final SQLFormatterConfiguration formatterCfg;
    private final boolean isCompact;
    private final SQLDialect dialect;
    private List<String> statementDelimiters = new LinkedList<String>();
    private String delimiterRedefiner;
    private int indent = 0;
    private int bracketsDepth = 0;
    private boolean encounterBetween = false;
    private List<Boolean> functionBracket = new ArrayList<Boolean>();
    private final String[] blockHeaderStrings;
    private static final String[] JOIN_BEGIN = new String[]{"LEFT", "RIGHT", "INNER", "OUTER", "FULL", "CROSS", "JOIN"};

    IndentFormatter(SQLFormatterConfiguration formatterCfg, boolean isCompact) {
        this.formatterCfg = formatterCfg;
        this.delimiterRedefiner = formatterCfg.getSyntaxManager().getDialect().getScriptDelimiterRedefiner();
        if (this.delimiterRedefiner != null) {
            this.delimiterRedefiner = this.delimiterRedefiner.toUpperCase(Locale.ENGLISH);
        }
        String[] stringArray = formatterCfg.getSyntaxManager().getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String delim = stringArray[n2];
            this.statementDelimiters.add(delim.toUpperCase(Locale.ENGLISH));
            ++n2;
        }
        this.isCompact = isCompact;
        this.dialect = formatterCfg.getSyntaxManager().getDialect();
        this.blockHeaderStrings = this.dialect.getBlockHeaderStrings();
    }

    private int formatSymbol(String tokenString, List<Integer> bracketIndent, List<FormatterToken> argList, Integer index, FormatterToken prev) {
        int result = index;
        switch (tokenString) {
            case "(": {
                this.functionBracket.add(this.formatterCfg.isFunction(prev.getString()) ? Boolean.TRUE : Boolean.FALSE);
                bracketIndent.add(this.indent);
                ++this.bracketsDepth;
                if (this.isCompact || !this.formatterCfg.getPreferenceStore().getBoolean("sql.format.break.before.close.bracket")) break;
                ++this.indent;
                index = index + this.insertReturnAndIndent(argList, index + 1, this.indent);
                break;
            }
            case ")": {
                if (bracketIndent.isEmpty() || this.functionBracket.isEmpty()) break;
                this.indent = bracketIndent.remove(bracketIndent.size() - 1);
                if (!this.isCompact && this.formatterCfg.getPreferenceStore().getBoolean("sql.format.break.before.close.bracket")) {
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                }
                this.functionBracket.remove(this.functionBracket.size() - 1);
                --this.bracketsDepth;
                break;
            }
            case ",": {
                if (this.isCompact) break;
                boolean lfBeforeComma = this.formatterCfg.getPreferenceStore().getBoolean("sql.format.lf.before.comma");
                result += this.insertReturnAndIndent(argList, lfBeforeComma ? index : index + 1, this.indent);
                break;
            }
            default: {
                if (!this.statementDelimiters.contains(tokenString)) break;
                this.indent = 0;
                result += this.insertReturnAndIndent(argList, index, this.indent);
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private int formatKeyword(List<FormatterToken> argList, String tokenString, int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[41] lbl308 : CaseStatement: default:\u000a, @NONE, blocks:[41] lbl308 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void format(List<FormatterToken> argList) {
        ArrayList<Integer> bracketIndent = new ArrayList<Integer>();
        FormatterToken prev = new FormatterToken(TokenType.SPACE, " ");
        int index = 0;
        while (index < argList.size()) {
            FormatterToken token = argList.get(index);
            String tokenString = token.getString().toUpperCase(Locale.ENGLISH);
            switch (token.getType()) {
                case SYMBOL: {
                    index = this.formatSymbol(tokenString, bracketIndent, argList, index, prev);
                    break;
                }
                case KEYWORD: {
                    index = this.formatKeyword(argList, tokenString, index);
                    break;
                }
                case COMMENT: {
                    index = this.formatComment(argList, index, token);
                    break;
                }
                case COMMAND: {
                    index = this.formatCommand(argList, index, token);
                    break;
                }
                default: {
                    if (!this.statementDelimiters.contains(tokenString)) break;
                    this.indent = 0;
                    index += this.insertReturnAndIndent(argList, index + 1, this.indent);
                }
            }
            prev = token;
            ++index;
        }
    }

    private int formatCommand(List<FormatterToken> argList, int index, FormatterToken token) {
        String delimiter;
        String command;
        int divPos;
        this.indent = 0;
        if (index > 0) {
            index += this.insertReturnAndIndent(argList, index, 0);
        }
        index += this.insertReturnAndIndent(argList, index + 1, 0);
        if (!CommonUtils.isEmpty((String)this.delimiterRedefiner) && token.getString().startsWith(this.delimiterRedefiner) && (divPos = (command = token.getString().trim().toUpperCase(Locale.ENGLISH)).lastIndexOf(32)) > 0 && !CommonUtils.isEmpty((String)(delimiter = command.substring(divPos).trim()))) {
            this.statementDelimiters.clear();
            this.statementDelimiters.add(delimiter);
        }
        return index;
    }

    private int formatComment(List<FormatterToken> argList, int index, FormatterToken token) {
        Pair mlComments;
        boolean isComment = false;
        String[] slComments = this.formatterCfg.getSyntaxManager().getDialect().getSingleLineComments();
        if (slComments != null) {
            String[] stringArray = slComments;
            int n = slComments.length;
            int n2 = 0;
            while (n2 < n) {
                String slc = stringArray[n2];
                if (token.getString().startsWith(slc)) {
                    index += this.insertReturnAndIndent(argList, index, this.indent);
                    isComment = true;
                    break;
                }
                ++n2;
            }
        }
        if (!isComment && (mlComments = this.formatterCfg.getSyntaxManager().getDialect().getMultiLineComments()) != null && token.getString().startsWith((String)mlComments.getFirst())) {
            index += this.insertReturnAndIndent(argList, index + 1, this.indent);
        }
        return index;
    }

    private int insertReturnAndIndent(List<FormatterToken> argList, int argIndex, int argIndent) {
        boolean isDelimiter;
        String s;
        block15: {
            FormatterToken token;
            block14: {
                if (argIndex >= argList.size()) {
                    return 0;
                }
                if (this.functionBracket.contains(Boolean.TRUE)) {
                    return 0;
                }
                try {
                    FormatterToken prevToken;
                    s = GeneralUtils.getDefaultLineSeparator();
                    if (argIndex > 0 && (prevToken = argList.get(argIndex - 1)).getType() == TokenType.COMMENT && SQLUtils.isCommentLine((SQLDialect)this.formatterCfg.getSyntaxManager().getDialect(), (String)prevToken.getString())) {
                        s = "";
                    }
                    int index = 0;
                    while (index < argIndent) {
                        s = String.valueOf(s) + this.formatterCfg.getIndentString();
                        ++index;
                    }
                    token = argList.get(argIndex);
                    if (token.getType() != TokenType.SPACE) break block14;
                    if (!token.getString().contains(s)) {
                        token.setString(s);
                    }
                    return 0;
                }
                catch (IndexOutOfBoundsException e) {
                    log.debug((Object)e);
                    return 0;
                }
            }
            isDelimiter = this.statementDelimiters.contains(token.getString().toUpperCase());
            if (isDelimiter || argIndex <= 0 || (token = argList.get(argIndex - 1)).getType() != TokenType.SPACE) break block15;
            token.setString(s);
            return 0;
        }
        if (isDelimiter) {
            if (argList.size() > argIndex + 1) {
                FormatterToken lineFeed = new FormatterToken(TokenType.SPACE, String.valueOf(s) + s);
                if (argList.get(argIndex + 1).getType() == TokenType.SPACE) {
                    argList.set(argIndex + 1, lineFeed);
                } else {
                    argList.add(argIndex + 1, lineFeed);
                }
            }
        } else {
            argList.add(argIndex, new FormatterToken(TokenType.SPACE, s));
        }
        return 1;
    }

    private boolean isJoinStart(List<FormatterToken> argList, int index) {
        FormatterToken token;
        if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)argList.get(index).getString().toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        int i = index - 1;
        while (i >= 0) {
            token = argList.get(i);
            if (token.getType() != TokenType.SPACE && token.getType() != TokenType.SYMBOL) {
                if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) break;
                return false;
            }
            --i;
        }
        i = index;
        while (i < argList.size()) {
            token = argList.get(i);
            if (token.getType() != TokenType.SPACE && token.getType() != TokenType.SYMBOL) {
                if (token.getString().toUpperCase(Locale.ENGLISH).equals("JOIN")) {
                    return true;
                }
                if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    private String getPrevKeyword(List<FormatterToken> argList, int index) {
        int i = index - 1;
        while (i >= 0) {
            FormatterToken token = argList.get(i);
            if (token.getType() == TokenType.KEYWORD) {
                return token.getString();
            }
            --i;
        }
        return null;
    }

    private static int getNextKeyword(List<FormatterToken> argList, int index) {
        int i = index + 1;
        while (i < argList.size()) {
            if (argList.get(i).getType() == TokenType.KEYWORD) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

