/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueDefaultGenerator;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.local.StatResultSet;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.sql.DBSQLException;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DynamicFindReplaceTarget;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TabFolderReorder;
import org.jkiss.dbeaver.ui.controls.ToolbarSeparatorContribution;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.controls.VerticalFolder;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshControl;
import org.jkiss.dbeaver.ui.controls.resultset.ActiveStatusMessage;
import org.jkiss.dbeaver.ui.controls.resultset.ColorSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.DataFilterRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.EditVirtualAttributePage;
import org.jkiss.dbeaver.ui.controls.resultset.EditVirtualEntityDialog;
import org.jkiss.dbeaver.ui.controls.resultset.FilterSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetFilterManager;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IStatefulControl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetContextImpl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataReceiver;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetFilterPanel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetJobDataRead;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPersister;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPresentationRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPropertyTester;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetReferenceMenu;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveReport;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetSaveSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.StatusLabel;
import org.jkiss.dbeaver.ui.controls.resultset.TransformerSettingsDialog;
import org.jkiss.dbeaver.ui.controls.resultset.ValidateUniqueKeyUsageDialog;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.ResultSetPanelDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.FilterValueEditDialog;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.FilterValueEditPopup;
import org.jkiss.dbeaver.ui.controls.resultset.view.EmptyPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.view.ErrorPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.view.StatisticsPresentation;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetViewer
extends Viewer
implements DBPContextProvider,
IResultSetController,
ISaveablePart2,
IAdaptable,
DBPEventListener {
    private static final Log log = Log.getLog(ResultSetViewer.class);
    private static final String TOOLBAR_GROUP_NAVIGATION = "navigation";
    private static final String TOOLBAR_GROUP_PRESENTATIONS = "presentations";
    private static final String TOOLBAR_GROUP_ADDITIONS = "additions";
    private static final String SETTINGS_SECTION_PRESENTATIONS = "presentations";
    private static final String TOOLBAR_CONTRIBUTION_ID = "toolbar:org.jkiss.dbeaver.ui.controls.resultset.status";
    static final String EMPTY_TRANSFORMER_NAME = "Default";
    static final String CONTROL_ID = ResultSetViewer.class.getSimpleName();
    static final String DEFAULT_QUERY_TEXT = "SQL";
    private static final DecimalFormat ROW_COUNT_FORMAT = new DecimalFormat("###,###,###,###,###,##0");
    private static final String CUSTOM_FILTER_VALUE_STRING = "..";
    private static final IResultSetListener[] EMPTY_LISTENERS = new IResultSetListener[0];
    private IResultSetFilterManager filterManager;
    @NotNull
    private final IWorkbenchPartSite site;
    private final Composite mainPanel;
    private final Composite viewerPanel;
    private final IResultSetDecorator decorator;
    @Nullable
    private ResultSetFilterPanel filtersPanel;
    private SashForm viewerSash;
    private final VerticalFolder panelSwitchFolder;
    private CTabFolder panelFolder;
    private ToolBarManager panelToolBar;
    private final VerticalFolder presentationSwitchFolder;
    private final Composite presentationPanel;
    private final List<ToolBarManager> toolbarList = new ArrayList<ToolBarManager>();
    private Composite statusBar;
    private StatusLabel statusLabel;
    private ActiveStatusMessage rowCountLabel;
    private Text resultSetSize;
    private final DynamicFindReplaceTarget findReplaceTarget;
    private IResultSetPresentation activePresentation;
    private ResultSetPresentationDescriptor activePresentationDescriptor;
    private List<ResultSetPresentationDescriptor> availablePresentations;
    private final List<ResultSetPanelDescriptor> availablePanels = new ArrayList<ResultSetPanelDescriptor>();
    private final Map<ResultSetPresentationDescriptor, PresentationSettings> presentationSettings = new HashMap<ResultSetPresentationDescriptor, PresentationSettings>();
    private final Map<String, IResultSetPanel> activePanels = new HashMap<String, IResultSetPanel>();
    private final Map<String, ToolBarManager> activeToolBars = new HashMap<String, ToolBarManager>();
    @NotNull
    private final IResultSetContainer container;
    @NotNull
    private final ResultSetDataReceiver dataReceiver;
    @Nullable
    private ResultSetRow curRow;
    private boolean recordMode;
    private final List<IResultSetListener> listeners = new ArrayList<IResultSetListener>();
    private final List<ResultSetJobDataRead> dataPumpJobQueue = new ArrayList<ResultSetJobDataRead>();
    private final AtomicBoolean dataPumpRunning = new AtomicBoolean();
    private final ResultSetModel model = new ResultSetModel();
    private HistoryStateItem curState = null;
    private final List<HistoryStateItem> stateHistory = new ArrayList<HistoryStateItem>();
    private int historyPosition = -1;
    private AutoRefreshControl autoRefreshControl;
    private boolean actionsDisabled;
    private volatile boolean isUIUpdateRunning;
    private Color defaultBackground;
    private Color defaultForeground;
    private GC sizingGC;
    private VerticalButton recordModeButton;

    public ResultSetViewer(@NotNull Composite parent, @NotNull IWorkbenchPartSite site, @NotNull IResultSetContainer container) {
        this.site = site;
        this.recordMode = false;
        this.container = container;
        this.decorator = container.createResultSetDecorator();
        this.dataReceiver = new ResultSetDataReceiver(this);
        this.filterManager = (IResultSetFilterManager)GeneralUtils.adapt((Object)this, IResultSetFilterManager.class);
        if (this.filterManager == null) {
            this.filterManager = new SimpleFilterManager();
        }
        this.loadPresentationSettings();
        this.sizingGC = new GC((Drawable)parent);
        this.defaultBackground = UIStyles.getDefaultTextBackground();
        this.defaultForeground = UIStyles.getDefaultTextForeground();
        boolean supportsPanels = (this.decorator.getDecoratorFeatures() & 4L) != 0L;
        this.mainPanel = UIUtils.createPlaceholder((Composite)parent, (int)(supportsPanels ? 3 : 2));
        this.autoRefreshControl = new AutoRefreshControl((Control)this.mainPanel, ResultSetViewer.class.getSimpleName(), monitor -> {
            boolean bl = this.refreshData(null);
        });
        if ((this.decorator.getDecoratorFeatures() & 1L) != 0L) {
            this.filtersPanel = new ResultSetFilterPanel(this, this.mainPanel);
            GridData gd = new GridData(768);
            gd.horizontalSpan = ((GridLayout)this.mainPanel.getLayout()).numColumns;
            this.filtersPanel.setLayoutData(gd);
        }
        this.presentationSwitchFolder = new VerticalFolder(this.mainPanel, 16384);
        this.presentationSwitchFolder.setLayoutData((Object)new GridData(1040));
        CSSUtils.setCSSClass((Widget)this.presentationSwitchFolder, (String)"coloredByConnectionType");
        this.viewerPanel = UIUtils.createPlaceholder((Composite)this.mainPanel, (int)1);
        this.viewerPanel.setLayoutData((Object)new GridData(1808));
        this.viewerPanel.setData(CONTROL_ID, (Object)this);
        CSSUtils.setCSSClass((Widget)this.viewerPanel, (String)"coloredByConnectionType");
        UIUtils.setHelp((Control)this.viewerPanel, (String)"result-set-viewer");
        this.viewerPanel.setRedraw(false);
        if (supportsPanels) {
            this.panelSwitchFolder = new VerticalFolder(this.mainPanel, 131072);
            this.panelSwitchFolder.setLayoutData((Object)new GridData(1040));
            CSSUtils.setCSSClass((Widget)this.panelSwitchFolder, (String)"coloredByConnectionType");
        } else {
            this.panelSwitchFolder = null;
        }
        try {
            this.findReplaceTarget = new DynamicFindReplaceTarget();
            this.viewerSash = UIUtils.createPartDivider((IWorkbenchPart)site.getPart(), (Composite)this.viewerPanel, (int)65792);
            this.viewerSash.setLayoutData((Object)new GridData(1808));
            this.presentationPanel = UIUtils.createPlaceholder((Composite)this.viewerSash, (int)1);
            this.presentationPanel.setLayoutData((Object)new GridData(1808));
            if (supportsPanels) {
                this.panelFolder = new CTabFolder((Composite)this.viewerSash, 0x800080);
                CSSUtils.setCSSClass((Widget)this.panelFolder, (String)"coloredByConnectionType");
                new TabFolderReorder(this.panelFolder);
                this.panelFolder.marginWidth = 0;
                this.panelFolder.marginHeight = 0;
                this.panelFolder.setMinimizeVisible(true);
                this.panelFolder.setMRUVisible(true);
                this.panelFolder.setLayoutData((Object)new GridData(1808));
                this.panelFolder.addListener(8, event -> {
                    if (event.button != 1) {
                        return;
                    }
                    CTabItem selectedItem = this.panelFolder.getItem(new Point(event.getBounds().x, event.getBounds().y));
                    if (selectedItem != null && selectedItem == this.panelFolder.getSelection()) {
                        this.togglePanelsMaximize();
                    }
                });
                this.panelToolBar = new ToolBarManager(8519936);
                ToolBar panelToolbarControl = this.panelToolBar.createControl((Composite)this.panelFolder);
                this.panelFolder.setTopRight((Control)panelToolbarControl, 131136);
                this.panelFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CTabItem activeTab = ResultSetViewer.this.panelFolder.getSelection();
                        if (activeTab != null) {
                            ResultSetViewer.this.setActivePanel((String)activeTab.getData());
                        }
                    }
                });
                this.panelFolder.addListener(11, event -> {
                    if (!this.viewerSash.isDisposed() && !this.isUIUpdateRunning) {
                        int[] weights = this.viewerSash.getWeights();
                        this.getPresentationSettings().panelRatio = weights[1];
                    }
                });
                this.panelFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                    public void close(CTabFolderEvent event) {
                        CTabItem item = (CTabItem)event.item;
                        String panelId = (String)item.getData();
                        ResultSetViewer.this.removePanel(panelId);
                    }

                    public void minimize(CTabFolderEvent event) {
                        ResultSetViewer.this.showPanels(false, true, true);
                    }

                    public void maximize(CTabFolderEvent event) {
                    }
                });
                MenuManager panelsMenuManager = new MenuManager();
                panelsMenuManager.setRemoveAllWhenShown(true);
                panelsMenuManager.addMenuListener(manager -> {
                    for (IContributionItem menuItem : this.fillPanelsMenu()) {
                        panelsMenuManager.add(menuItem);
                    }
                });
                Menu panelsMenu = panelsMenuManager.createContextMenu((Control)this.panelFolder);
                this.panelFolder.setMenu(panelsMenu);
                this.panelFolder.addDisposeListener(e -> panelsMenuManager.dispose());
            }
            this.showEmptyPresentation();
            if (this.supportsStatusBar()) {
                this.createStatusBar();
            }
            this.viewerPanel.addDisposeListener(e -> this.dispose());
            this.changeMode(false);
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
        this.updateFiltersText();
        DBPProject project = container.getProject();
        if (project != null) {
            project.getDataSourceRegistry().addDataSourceListener((DBPEventListener)this);
        }
    }

    @Override
    @NotNull
    public IResultSetContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public IResultSetDecorator getDecorator() {
        return this.decorator;
    }

    AutoRefreshControl getAutoRefresh() {
        return this.autoRefreshControl;
    }

    private boolean supportsPanels() {
        return (this.decorator.getDecoratorFeatures() & 4L) != 0L && this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsPanels();
    }

    private boolean supportsStatusBar() {
        return (this.decorator.getDecoratorFeatures() & 2L) != 0L;
    }

    boolean supportsDataFilter() {
        DBSDataContainer dataContainer = this.getDataContainer();
        return dataContainer != null && (dataContainer.getSupportedFeatures() & 4) == 4;
    }

    boolean supportsNavigation() {
        return this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsNavigation();
    }

    boolean supportsEdit() {
        return this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsEdit();
    }

    public void resetDataFilter(boolean refresh) {
        this.setDataFilter(this.model.createDataFilter(), refresh);
    }

    void showFilterSettingsDialog() {
        new FilterSettingsDialog(this).open();
    }

    void saveDataFilter() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context == null) {
            log.error((Object)"Can't save data filter with null context");
            return;
        }
        DataFilterRegistry.getInstance().saveDataFilter(this.getDataContainer(), this.model.getDataFilter());
        if (this.filtersPanel != null) {
            DBeaverNotifications.showNotification((String)"generalInfo", (String)"Data filter was saved", (String)this.filtersPanel.getFilterText(), (DBPMessageType)DBPMessageType.INFORMATION, null);
        }
    }

    void switchFilterFocus() {
        if (this.filtersPanel == null) {
            return;
        }
        boolean filterFocused = this.filtersPanel.getEditControl().isFocusControl();
        if (filterFocused) {
            if (this.activePresentation != null) {
                this.activePresentation.getControl().setFocus();
            }
        } else {
            this.filtersPanel.getEditControl().setFocus();
        }
    }

    private void updateFiltersText() {
        this.updateFiltersText(true);
    }

    public void updateFiltersText(boolean resetFilterValue) {
        if (this.filtersPanel == null || this.viewerPanel.isDisposed()) {
            return;
        }
        if (this.resultSetSize != null && !this.resultSetSize.isDisposed()) {
            this.resultSetSize.setEnabled(!this.model.getVisibleAttributes().isEmpty());
        }
        this.viewerPanel.setRedraw(false);
        try {
            boolean enableFilters = false;
            DBCExecutionContext context = this.getExecutionContext();
            if (context != null) {
                if (this.activePresentation instanceof StatisticsPresentation) {
                    enableFilters = false;
                } else {
                    StringBuilder where = new StringBuilder();
                    SQLUtils.appendConditionString((DBDDataFilter)this.model.getDataFilter(), (DBPDataSource)context.getDataSource(), null, (StringBuilder)where, (boolean)true);
                    String whereCondition = where.toString().trim();
                    if (resetFilterValue) {
                        this.filtersPanel.setFilterValue(whereCondition);
                        if (!whereCondition.isEmpty()) {
                            this.filtersPanel.addFiltersHistory(whereCondition);
                        }
                    }
                    if (this.container.isReadyToRun() && !this.model.isUpdateInProgress()) {
                        enableFilters = true;
                    }
                }
            }
            this.filtersPanel.enableFilters(enableFilters);
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
    }

    @Override
    public void setDataFilter(DBDDataFilter dataFilter, boolean refreshData) {
        if (refreshData) {
            this.refreshWithFilter(dataFilter);
        } else {
            this.model.setDataFilter(dataFilter);
            this.activePresentation.refreshData(true, false, true);
            this.updateFiltersText();
        }
    }

    @Override
    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context != null) {
            return context.getDataSource().getContainer().getPreferenceStore();
        }
        return DBWorkbench.getPlatform().getPreferenceStore();
    }

    @Override
    @NotNull
    public Color getDefaultBackground() {
        if (this.filtersPanel == null) {
            return this.defaultBackground;
        }
        return UIStyles.getDefaultTextBackground();
    }

    @Override
    @NotNull
    public Color getDefaultForeground() {
        if (this.filtersPanel == null) {
            return this.defaultForeground;
        }
        return UIStyles.getDefaultTextForeground();
    }

    void persistConfig() {
        DBCExecutionContext context = this.getExecutionContext();
        if (context != null) {
            context.getDataSource().getContainer().persistConfiguration();
        }
    }

    @NotNull
    public List<ResultSetPresentationDescriptor> getAvailablePresentations() {
        return this.availablePresentations != null ? this.availablePresentations : Collections.emptyList();
    }

    @Override
    @NotNull
    public IResultSetPresentation getActivePresentation() {
        return this.activePresentation;
    }

    @Override
    public void showEmptyPresentation() {
        this.activePresentationDescriptor = null;
        this.setActivePresentation(new EmptyPresentation());
        this.updatePresentationInToolbar();
    }

    void showErrorPresentation(String sqlText, String message, Throwable error) {
        this.activePresentationDescriptor = null;
        this.setActivePresentation(new ErrorPresentation(sqlText, GeneralUtils.makeErrorStatus((String)message, (Throwable)error)));
        this.updatePresentationInToolbar();
    }

    void updatePresentation(DBCResultSet resultSet, boolean metadataChanged) {
        if (this.getControl().isDisposed()) {
            return;
        }
        boolean changed = false;
        try {
            this.isUIUpdateRunning = true;
            if (resultSet instanceof StatResultSet) {
                this.availablePresentations = Collections.emptyList();
                this.setActivePresentation(new StatisticsPresentation());
                this.activePresentationDescriptor = null;
                changed = true;
            } else {
                ResultSetContextImpl context = new ResultSetContextImpl(this, resultSet);
                List<ResultSetPresentationDescriptor> newPresentations = ResultSetPresentationRegistry.getInstance().getAvailablePresentations(resultSet, context);
                changed = CommonUtils.isEmpty(this.availablePresentations) || !newPresentations.equals(this.availablePresentations);
                this.availablePresentations = newPresentations;
                if (!this.availablePresentations.isEmpty()) {
                    if (this.activePresentationDescriptor != null && (!metadataChanged || this.activePresentationDescriptor.getPresentationType().isPersistent()) && this.availablePresentations.contains((Object)this.activePresentationDescriptor)) {
                        return;
                    }
                    String defaultPresentationId = this.getPreferenceStore().getString("resultset.presentation.active");
                    ResultSetPresentationDescriptor newPresentation = null;
                    if (!CommonUtils.isEmpty((String)defaultPresentationId)) {
                        for (ResultSetPresentationDescriptor pd : this.availablePresentations) {
                            if (!pd.getId().equals(defaultPresentationId)) continue;
                            newPresentation = pd;
                            break;
                        }
                    }
                    changed = true;
                    if (newPresentation == null) {
                        newPresentation = this.availablePresentations.get(0);
                    }
                    try {
                        IResultSetPresentation instance = newPresentation.createInstance();
                        this.activePresentationDescriptor = newPresentation;
                        this.setActivePresentation(instance);
                    }
                    catch (Throwable e) {
                        DBWorkbench.getPlatformUI().showError("Presentation activate", "Can't instantiate data view '" + newPresentation.getLabel() + "'", e);
                    }
                }
            }
        }
        finally {
            if (changed && this.presentationSwitchFolder != null) {
                this.updatePresentationInToolbar();
            }
            this.isUIUpdateRunning = false;
        }
    }

    private void updatePresentationInToolbar() {
        this.viewerPanel.setRedraw(false);
        try {
            try {
                boolean pVisible = this.activePresentationDescriptor != null;
                ((GridData)this.presentationSwitchFolder.getLayoutData()).exclude = !pVisible;
                this.presentationSwitchFolder.setVisible(pVisible);
                if (!pVisible) {
                    this.presentationSwitchFolder.setEnabled(false);
                } else {
                    this.presentationSwitchFolder.setEnabled(true);
                    Control[] controlArray = this.presentationSwitchFolder.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control item = controlArray[n2];
                        item.dispose();
                        ++n2;
                    }
                    for (ResultSetPresentationDescriptor pd : this.availablePresentations) {
                        VerticalButton item = new VerticalButton(this.presentationSwitchFolder, 16400);
                        item.setImage(DBeaverIcons.getImage((DBPImage)pd.getIcon()));
                        item.setText(pd.getLabel());
                        item.setToolTipText(pd.getDescription());
                        item.setData((Object)pd);
                        if (pd == this.activePresentationDescriptor) {
                            this.presentationSwitchFolder.setSelection(item);
                        }
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (e.widget != null && e.widget.getData() != null) {
                                    ResultSetViewer.this.switchPresentation((ResultSetPresentationDescriptor)((Object)e.widget.getData()));
                                }
                            }
                        });
                    }
                    UIUtils.createEmptyLabel((Composite)this.presentationSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
                    this.recordModeButton = new VerticalButton(this.presentationSwitchFolder, 16416);
                    this.recordModeButton.setAction((IAction)new ToggleModeAction(), true);
                    if (this.statusBar != null) {
                        ((GridLayout)this.presentationSwitchFolder.getLayout()).marginBottom = this.statusBar.getSize().y;
                    }
                }
                this.mainPanel.layout(true, true);
            }
            catch (Exception e) {
                log.debug((Object)"Error updating presentation toolbar", (Throwable)e);
                this.viewerPanel.setRedraw(true);
            }
        }
        finally {
            this.viewerPanel.setRedraw(true);
        }
    }

    private void setActivePresentation(@NotNull IResultSetPresentation presentation) {
        boolean focusInPresentation = UIUtils.isParent((Control)this.presentationPanel, (Control)this.viewerPanel.getDisplay().getFocusControl());
        if (this.activePresentation != null) {
            this.activePresentation.dispose();
        }
        UIUtils.disposeChildControls((Composite)this.presentationPanel);
        if (this.panelFolder != null) {
            CTabItem curItem = this.panelFolder.getSelection();
            CTabItem[] cTabItemArray = this.panelFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem panelItem = cTabItemArray[n2];
                if (panelItem != curItem) {
                    panelItem.dispose();
                }
                ++n2;
            }
            if (curItem != null) {
                curItem.dispose();
            }
        }
        this.activePresentation = presentation;
        this.availablePanels.clear();
        this.activePanels.clear();
        if (this.activePresentationDescriptor != null) {
            this.availablePanels.addAll(ResultSetPresentationRegistry.getInstance().getSupportedPanels(this.getDataSource(), this.activePresentationDescriptor.getId(), this.activePresentationDescriptor.getPresentationType()));
        } else if (this.activePresentation instanceof StatisticsPresentation) {
            this.availablePanels.addAll(ResultSetPresentationRegistry.getInstance().getSupportedPanels(this.getDataSource(), null, IResultSetPresentation.PresentationType.COLUMNS));
        }
        this.activePresentation.createPresentation(this, this.presentationPanel);
        if (this.panelSwitchFolder != null) {
            UIUtils.disposeChildControls((Composite)this.panelSwitchFolder);
        }
        if (this.supportsPanels()) {
            boolean panelsVisible = false;
            boolean verticalLayout = false;
            int[] panelWeights = new int[]{700, 300};
            if (this.activePresentationDescriptor != null) {
                PresentationSettings settings = this.getPresentationSettings();
                panelsVisible = settings.panelsVisible;
                verticalLayout = settings.verticalLayout;
                if (settings.panelRatio > 0) {
                    panelWeights = new int[]{1000 - settings.panelRatio, settings.panelRatio};
                }
                this.activateDefaultPanels(settings);
            }
            this.viewerSash.setOrientation(verticalLayout ? 512 : 256);
            this.viewerSash.setWeights(panelWeights);
            this.showPanels(panelsVisible, false, false);
            if (!this.availablePanels.isEmpty()) {
                final VerticalButton panelsButton = new VerticalButton(this.panelSwitchFolder, 131104);
                panelsButton.setText(ResultSetMessages.controls_resultset_config_panels);
                panelsButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.PANEL_CUSTOMIZE));
                panelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ResultSetViewer.this.showPanels(!ResultSetViewer.this.isPanelsVisible(), true, true);
                        panelsButton.setChecked(ResultSetViewer.this.isPanelsVisible());
                        ResultSetViewer.this.updatePanelsButtons();
                    }
                });
                String toolTip = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview", (IServiceLocator)this.getSite(), (boolean)false);
                if (!CommonUtils.isEmpty((String)toolTip)) {
                    panelsButton.setToolTipText(toolTip);
                }
                panelsButton.setChecked(panelsVisible);
                for (final ResultSetPanelDescriptor panel : this.availablePanels) {
                    final VerticalButton panelButton = new VerticalButton(this.panelSwitchFolder, 131104);
                    GridData gd = new GridData(2);
                    gd.verticalIndent = 2;
                    gd.horizontalIndent = 1;
                    panelButton.setLayoutData((Object)gd);
                    panelButton.setData((Object)panel);
                    panelButton.setImage(DBeaverIcons.getImage((DBPImage)panel.getIcon()));
                    panelButton.setToolTipText(panel.getLabel());
                    String toolTip2 = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.grid.togglePanel", (IServiceLocator)this.getSite(), (boolean)true, (String)"panelId", (String)panel.getId());
                    if (!CommonUtils.isEmpty((String)toolTip2)) {
                        panelButton.setToolTipText(String.valueOf(panel.getLabel()) + " (" + toolTip2 + ")");
                    }
                    panelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            boolean isPanelVisible;
                            boolean bl = isPanelVisible = ResultSetViewer.this.isPanelsVisible() && ResultSetViewer.this.isPanelVisible(panel.getId());
                            if (isPanelVisible) {
                                ResultSetViewer.this.closePanel(panel.getId());
                            } else {
                                ResultSetViewer.this.activatePanel(panel.getId(), true, true);
                            }
                            panelButton.setChecked(!isPanelVisible);
                            panelsButton.setChecked(ResultSetViewer.this.isPanelsVisible());
                            if (ResultSetViewer.this.panelSwitchFolder != null) {
                                ResultSetViewer.this.panelSwitchFolder.redraw();
                            }
                        }
                    });
                    panelButton.setChecked(panelsVisible && this.isPanelVisible(panel.getId()));
                }
                UIUtils.createEmptyLabel((Composite)this.panelSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
                VerticalButton.create((VerticalFolder)this.panelSwitchFolder, (int)131104, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.toggleLayout", (boolean)false);
            }
        } else if (this.viewerSash != null) {
            this.viewerSash.setMaximizedControl(this.viewerSash.getChildren()[0]);
        }
        this.mainPanel.layout(true, true);
        if (this.recordModeButton != null) {
            this.recordModeButton.setVisible(this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsRecordMode());
        }
        IFindReplaceTarget nested = null;
        if (presentation instanceof IAdaptable) {
            nested = (IFindReplaceTarget)((IAdaptable)presentation).getAdapter(IFindReplaceTarget.class);
        }
        this.findReplaceTarget.setTarget(nested);
        if (!this.toolbarList.isEmpty()) {
            for (ToolBarManager tb : this.toolbarList) {
                tb.update(true);
            }
        }
        if (presentation instanceof ISelectionProvider) {
            ((ISelectionProvider)presentation).addSelectionChangedListener(this::fireResultSetSelectionChange);
        }
        if (focusInPresentation) {
            UIUtils.asyncExec(() -> {
                Control control = this.activePresentation.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setFocus();
                }
            });
        }
    }

    private void updatePanelsButtons() {
        boolean panelsVisible = this.isPanelsVisible();
        Control[] controlArray = this.panelSwitchFolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof VerticalButton && child.getData() instanceof ResultSetPanelDescriptor) {
                boolean newChecked;
                boolean bl = newChecked = panelsVisible && this.isPanelVisible(((ResultSetPanelDescriptor)((Object)child.getData())).getId());
                if (((VerticalButton)child).isChecked() != newChecked) {
                    ((VerticalButton)child).setChecked(newChecked);
                    child.redraw();
                }
            }
            ++n2;
        }
    }

    void switchPresentation() {
        if (this.availablePresentations.size() < 2) {
            return;
        }
        int index = this.availablePresentations.indexOf((Object)this.activePresentationDescriptor);
        index = index < this.availablePresentations.size() - 1 ? ++index : 0;
        this.switchPresentation(this.availablePresentations.get(index));
    }

    public void switchPresentation(ResultSetPresentationDescriptor selectedPresentation) {
        try {
            IResultSetPresentation instance = selectedPresentation.createInstance();
            this.activePresentationDescriptor = selectedPresentation;
            this.setActivePresentation(instance);
            instance.refreshData(true, false, false);
            if (this.presentationSwitchFolder != null) {
                VerticalButton[] verticalButtonArray = this.presentationSwitchFolder.getItems();
                int n = verticalButtonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VerticalButton item = verticalButtonArray[n2];
                    if (item.getData() == this.activePresentationDescriptor) {
                        this.presentationSwitchFolder.setSelection(item);
                        break;
                    }
                    ++n2;
                }
            }
            if (this.activePresentationDescriptor.getPresentationType().isPersistent()) {
                DBWorkbench.getPlatform().getPreferenceStore().setValue("resultset.presentation.active", this.activePresentationDescriptor.getId());
            }
            this.savePresentationSettings();
        }
        catch (Throwable e1) {
            DBWorkbench.getPlatformUI().showError("Presentation switch", "Can't switch presentation", e1);
        }
    }

    private void loadPresentationSettings() {
        IDialogSettings pSections = ResultSetUtils.getViewerSettings("presentations");
        for (IDialogSettings pSection : ArrayUtils.safeArray((Object[])pSections.getSections())) {
            String pId = pSection.getName();
            ResultSetPresentationDescriptor presentation = ResultSetPresentationRegistry.getInstance().getPresentation(pId);
            if (presentation == null) {
                log.warn((Object)("Presentation '" + pId + "' not found. "));
                continue;
            }
            PresentationSettings settings = new PresentationSettings();
            String panelIdList = pSection.get("enabledPanelIds");
            if (panelIdList != null) {
                Collections.addAll(settings.enabledPanelIds, panelIdList.split(","));
            }
            settings.activePanelId = pSection.get("activePanelId");
            settings.panelRatio = pSection.getInt("panelRatio");
            settings.panelsVisible = pSection.getBoolean("panelsVisible");
            settings.verticalLayout = pSection.getBoolean("verticalLayout");
            this.presentationSettings.put(presentation, settings);
        }
    }

    private PresentationSettings getPresentationSettings() {
        PresentationSettings settings = this.presentationSettings.get((Object)this.activePresentationDescriptor);
        if (settings == null) {
            settings = new PresentationSettings();
            settings.panelsVisible = this.activePresentationDescriptor != null && this.activePresentationDescriptor.getPresentationType() == IResultSetPresentation.PresentationType.COLUMNS;
            this.presentationSettings.put(this.activePresentationDescriptor, settings);
        }
        return settings;
    }

    private void savePresentationSettings() {
        if ((this.decorator.getDecoratorFeatures() & 4L) != 0L) {
            IDialogSettings pSections = ResultSetUtils.getViewerSettings("presentations");
            for (Map.Entry<ResultSetPresentationDescriptor, PresentationSettings> pEntry : this.presentationSettings.entrySet()) {
                if (pEntry.getKey() == null) continue;
                String pId = pEntry.getKey().getId();
                PresentationSettings settings = pEntry.getValue();
                IDialogSettings pSection = UIUtils.getSettingsSection((IDialogSettings)pSections, (String)pId);
                pSection.put("enabledPanelIds", CommonUtils.joinStrings((String)",", settings.enabledPanelIds));
                pSection.put("activePanelId", settings.activePanelId);
                pSection.put("panelRatio", settings.panelRatio);
                pSection.put("panelsVisible", settings.panelsVisible);
                pSection.put("verticalLayout", settings.verticalLayout);
            }
        }
    }

    @Override
    public IResultSetPanel getVisiblePanel() {
        return this.isPanelsVisible() ? this.activePanels.get(this.getPresentationSettings().activePanelId) : null;
    }

    String getActivePanelId() {
        return this.getPresentationSettings().activePanelId;
    }

    void closeActivePanel() {
        CTabItem activePanelItem = this.panelFolder.getSelection();
        if (activePanelItem != null) {
            activePanelItem.dispose();
        }
        if (this.panelFolder.getItemCount() <= 0) {
            this.showPanels(false, true, true);
        }
    }

    @Override
    public IResultSetPanel[] getActivePanels() {
        return this.activePanels.values().toArray(new IResultSetPanel[0]);
    }

    @Override
    public boolean activatePanel(String id, boolean setActive, boolean showPanels) {
        ResultSetPanelDescriptor panelDescriptor;
        if (!this.supportsPanels()) {
            return false;
        }
        if (showPanels && !this.isPanelsVisible()) {
            this.showPanels(true, false, false);
        }
        PresentationSettings presentationSettings = this.getPresentationSettings();
        IResultSetPanel panel = this.activePanels.get(id);
        if (panel != null) {
            CTabItem panelTab = this.getPanelTab(id);
            if (panelTab != null) {
                if (setActive) {
                    this.panelFolder.setSelection(panelTab);
                    presentationSettings.activePanelId = id;
                }
                return true;
            }
            log.debug((Object)("Panel '" + id + "' tab not found"));
        }
        if ((panelDescriptor = this.getPanelDescriptor(id)) == null) {
            log.debug((Object)("Panel '" + id + "' not found"));
            return false;
        }
        try {
            panel = panelDescriptor.createInstance();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Can't show panel", "Can't create panel '" + id + "'", (Throwable)e);
            return false;
        }
        this.activePanels.put(id, panel);
        this.panelFolder.setRedraw(false);
        try {
            Control panelControl = panel.createContents(this.activePresentation, (Composite)this.panelFolder);
            boolean firstPanel = this.panelFolder.getItemCount() == 0;
            CTabItem panelTab = new CTabItem(this.panelFolder, 64);
            panelTab.setData((Object)id);
            panelTab.setText(panelDescriptor.getLabel());
            panelTab.setImage(DBeaverIcons.getImage((DBPImage)panelDescriptor.getIcon()));
            panelTab.setToolTipText(panelDescriptor.getDescription());
            panelTab.setControl(panelControl);
            UIUtils.disposeControlOnItemDispose((CTabItem)panelTab);
            if (setActive || firstPanel) {
                this.panelFolder.setSelection(panelTab);
            }
        }
        finally {
            this.panelFolder.setRedraw(true);
        }
        presentationSettings.enabledPanelIds.add(id);
        if (setActive) {
            this.setActivePanel(id);
        }
        this.updatePanelsButtons();
        return true;
    }

    private void activateDefaultPanels(PresentationSettings settings) {
        settings.enabledPanelIds.removeIf(CommonUtils::isEmpty);
        if (settings.enabledPanelIds.isEmpty()) {
            for (ResultSetPanelDescriptor pd : this.availablePanels) {
                if (!pd.isShowByDefault()) continue;
                settings.enabledPanelIds.add(pd.getId());
            }
        }
        if (!settings.enabledPanelIds.contains(settings.activePanelId)) {
            settings.activePanelId = null;
        }
        if (!settings.enabledPanelIds.isEmpty()) {
            if (settings.activePanelId == null) {
                settings.activePanelId = settings.enabledPanelIds.iterator().next();
            }
            for (String panelId : new ArrayList<String>(settings.enabledPanelIds)) {
                if (CommonUtils.isEmpty((String)panelId) || this.activatePanel(panelId, panelId.equals(settings.activePanelId), false)) continue;
                settings.enabledPanelIds.remove(panelId);
            }
        }
    }

    private void setActivePanel(String panelId) {
        PresentationSettings settings = this.getPresentationSettings();
        settings.activePanelId = panelId;
        IResultSetPanel panel = this.activePanels.get(panelId);
        if (panel != null) {
            panel.activatePanel();
            this.updatePanelActions();
            this.savePresentationSettings();
        }
    }

    private void removePanel(String panelId) {
        IResultSetPanel panel = this.activePanels.remove(panelId);
        if (panel != null) {
            panel.deactivatePanel();
        }
        this.getPresentationSettings().enabledPanelIds.remove(panelId);
        if (this.activePanels.isEmpty()) {
            this.showPanels(false, true, true);
        }
        this.updatePanelsButtons();
    }

    private ResultSetPanelDescriptor getPanelDescriptor(String id) {
        for (ResultSetPanelDescriptor panel : this.availablePanels) {
            if (!panel.getId().equals(id)) continue;
            return panel;
        }
        return null;
    }

    private CTabItem getPanelTab(String panelId) {
        if (this.panelFolder != null) {
            CTabItem[] cTabItemArray = this.panelFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tab = cTabItemArray[n2];
                if (CommonUtils.equalObjects((Object)tab.getData(), (Object)panelId)) {
                    return tab;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public boolean isPanelsVisible() {
        return this.viewerSash != null && this.viewerSash.getMaximizedControl() == null;
    }

    void showPanels(boolean show, boolean showDefaults, boolean saveSettings) {
        if (!this.supportsPanels() || show == this.isPanelsVisible()) {
            return;
        }
        CTabItem activePanelTab = this.panelFolder.getSelection();
        if (!show) {
            this.viewerSash.setMaximizedControl(this.viewerSash.getChildren()[0]);
            if (activePanelTab != null && !activePanelTab.getControl().isDisposed() && UIUtils.hasFocus((Control)activePanelTab.getControl())) {
                this.activePresentation.getControl().setFocus();
            }
        } else {
            if (showDefaults) {
                this.activateDefaultPanels(this.getPresentationSettings());
            }
            this.viewerSash.setMaximizedControl(null);
            this.updatePanelActions();
            this.updatePanelsContent(false);
            this.activePresentation.updateValueView();
            if (activePanelTab != null && !activePanelTab.getControl().isDisposed() && UIUtils.hasFocus((Control)this.activePresentation.getControl())) {
                activePanelTab.getControl().setFocus();
            }
        }
        this.getPresentationSettings().panelsVisible = show;
        if (saveSettings) {
            this.savePresentationSettings();
        }
        this.updatePanelsButtons();
    }

    void togglePanelsFocus() {
        CTabItem activePanelTab;
        boolean panelsActive = UIUtils.hasFocus((Control)this.panelFolder);
        if (panelsActive) {
            this.presentationPanel.setFocus();
        } else if (this.panelFolder != null && (activePanelTab = this.panelFolder.getSelection()) != null && activePanelTab.getControl() != null) {
            activePanelTab.getControl().setFocus();
        }
    }

    boolean isPanelVisible(String panelId) {
        return this.getPresentationSettings().enabledPanelIds.contains(panelId);
    }

    void closePanel(String panelId) {
        CTabItem panelTab = this.getPanelTab(panelId);
        if (panelTab != null) {
            panelTab.dispose();
            this.removePanel(panelId);
        }
    }

    void toggleVerticalLayout() {
        PresentationSettings settings = this.getPresentationSettings();
        settings.verticalLayout = !settings.verticalLayout;
        this.viewerSash.setOrientation(settings.verticalLayout ? 512 : 256);
        this.savePresentationSettings();
    }

    void togglePanelsMaximize() {
        if (this.viewerSash.getMaximizedControl() == null) {
            this.viewerSash.setMaximizedControl((Control)this.panelFolder);
        } else {
            this.viewerSash.setMaximizedControl(null);
        }
    }

    private List<IContributionItem> fillPanelsMenu() {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (ResultSetPanelDescriptor panel : this.availablePanels) {
            CommandContributionItemParameter params = new CommandContributionItemParameter((IServiceLocator)this.site, panel.getId(), "org.jkiss.dbeaver.core.resultset.grid.togglePanel", 32);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("panelId", panel.getId());
            params.parameters = parameters;
            items.add((IContributionItem)new CommandContributionItem(params));
        }
        items.add((IContributionItem)new Separator());
        items.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.togglePanelMaximize"));
        items.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.activatePreview"));
        return items;
    }

    void fillOpenWithMenu(IContributionManager openWithMenu) {
        ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        ResultSetDataContainer dataContainer = new ResultSetDataContainer(this, options);
        ArrayList<DataTransferProcessorDescriptor> appProcessors = new ArrayList<DataTransferProcessorDescriptor>();
        for (DataTransferNodeDescriptor consumerNode : DataTransferRegistry.getInstance().getAvailableConsumers(Collections.singleton(dataContainer))) {
            DataTransferProcessorDescriptor[] dataTransferProcessorDescriptorArray = consumerNode.getProcessors();
            int n = dataTransferProcessorDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataTransferProcessorDescriptor processor = dataTransferProcessorDescriptorArray[n2];
                if (processor.getAppFileExtension() != null) {
                    appProcessors.add(processor);
                }
                ++n2;
            }
        }
        appProcessors.sort(Comparator.comparingInt(DataTransferProcessorDescriptor::getOrder));
        for (DataTransferProcessorDescriptor processor : appProcessors) {
            CommandContributionItemParameter params = new CommandContributionItemParameter((IServiceLocator)this.site, processor.getId(), "org.jkiss.dbeaver.core.resultset.openWith", 16);
            params.label = processor.getAppName();
            if (processor.getIcon() != null) {
                params.icon = DBeaverIcons.getImageDescriptor((DBPImage)processor.getIcon());
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("processorId", processor.getFullId());
            params.parameters = parameters;
            openWithMenu.add((IContributionItem)new CommandContributionItem(params));
        }
    }

    void fillCopyAsMenu(IContributionManager copyAsMenu) {
        copyAsMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.edit.copy.special"));
        copyAsMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyColumnNames"));
        copyAsMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyRowNames"));
        copyAsMenu.add((IContributionItem)new Separator());
        ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        ResultSetDataContainer dataContainer = new ResultSetDataContainer(this, options);
        ArrayList<DataTransferProcessorDescriptor> appProcessors = new ArrayList<DataTransferProcessorDescriptor>();
        for (DataTransferNodeDescriptor consumerNode : DataTransferRegistry.getInstance().getAvailableConsumers(Collections.singleton(dataContainer))) {
            DataTransferProcessorDescriptor[] dataTransferProcessorDescriptorArray = consumerNode.getProcessors();
            int n = dataTransferProcessorDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataTransferProcessorDescriptor processor = dataTransferProcessorDescriptorArray[n2];
                if (!processor.isBinaryFormat()) {
                    appProcessors.add(processor);
                }
                ++n2;
            }
        }
        appProcessors.sort(Comparator.comparing(DataTransferProcessorDescriptor::getName));
        for (DataTransferProcessorDescriptor processor : appProcessors) {
            CommandContributionItemParameter params = new CommandContributionItemParameter((IServiceLocator)this.site, processor.getId(), "org.jkiss.dbeaver.core.resultset.copyAs", 8);
            params.label = processor.getName();
            if (processor.getIcon() != null) {
                params.icon = DBeaverIcons.getImageDescriptor((DBPImage)processor.getIcon());
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("processorId", processor.getFullId());
            params.parameters = parameters;
            copyAsMenu.add((IContributionItem)new CommandContributionItem(params));
        }
    }

    private void addDefaultPanelActions() {
        this.panelToolBar.add((IAction)new Action("View Menu", DBeaverIcons.getViewMenuImageDescriptor()){

            public void run() {
                ToolBar tb = ResultSetViewer.this.panelToolBar.getControl();
                ToolItem[] toolItemArray = tb.getItems();
                int n = toolItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item = toolItemArray[n2];
                    if (item.getData() instanceof ActionContributionItem && ((ActionContributionItem)item.getData()).getAction() == this) {
                        MenuManager panelMenu = new MenuManager();
                        for (IContributionItem menuItem : ResultSetViewer.this.fillPanelsMenu()) {
                            panelMenu.add(menuItem);
                        }
                        Menu swtMenu = panelMenu.createContextMenu((Control)ResultSetViewer.this.panelToolBar.getControl());
                        Rectangle ib = item.getBounds();
                        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
                        swtMenu.setLocation(displayAt);
                        swtMenu.setVisible(true);
                        tb.addDisposeListener(e -> panelMenu.dispose());
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    boolean isActionsDisabled() {
        return this.actionsDisabled;
    }

    @Override
    public void lockActionsByControl(Control lockedBy) {
        if (this.checkDoubleLock(lockedBy)) {
            return;
        }
        this.actionsDisabled = true;
        lockedBy.addDisposeListener(e -> {
            boolean bl = this.actionsDisabled = false;
        });
    }

    @Override
    public void lockActionsByFocus(final Control lockedBy) {
        lockedBy.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ResultSetViewer.this.checkDoubleLock(lockedBy);
                ResultSetViewer.this.actionsDisabled = true;
            }

            public void focusLost(FocusEvent e) {
                ResultSetViewer.this.actionsDisabled = false;
            }
        });
        lockedBy.addDisposeListener(e -> {
            boolean bl = this.actionsDisabled = false;
        });
    }

    boolean isPresentationInFocus() {
        Control activeControl = this.getActivePresentation().getControl();
        return !activeControl.isDisposed() && activeControl.isFocusControl();
    }

    private boolean checkDoubleLock(Control lockedBy) {
        if (this.actionsDisabled) {
            log.debug((Object)("Internal error: actions double-lock by [" + lockedBy + "]"));
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (UIUtils.isUIThread()) {
            Object adapted;
            IResultSetPanel visiblePanel;
            if (UIUtils.hasFocus((Control)this.filtersPanel)) {
                T result = this.filtersPanel.getAdapter(adapter);
                if (result != null) {
                    return result;
                }
            } else if (UIUtils.hasFocus((Control)this.panelFolder) && (visiblePanel = this.getVisiblePanel()) instanceof IAdaptable && (adapted = ((IAdaptable)visiblePanel).getAdapter(adapter)) != null) {
                return (T)adapted;
            }
        }
        if (this.activePresentation != null) {
            Object adapted;
            if (adapter.isAssignableFrom(this.activePresentation.getClass())) {
                return adapter.cast(this.activePresentation);
            }
            if (this.activePresentation instanceof IAdaptable && (adapted = ((IAdaptable)this.activePresentation).getAdapter(adapter)) != null) {
                return (T)adapted;
            }
        }
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IResultSetListener listener) {
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IResultSetListener listener) {
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void updateEditControls() {
        ResultSetPropertyTester.firePropertyChange("editable");
        ResultSetPropertyTester.firePropertyChange("changed");
        this.fireResultSetChange();
        this.updateToolbar();
        VerticalButton[] verticalButtonArray = this.presentationSwitchFolder.getItems();
        int n = verticalButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalButton pb = verticalButtonArray[n2];
            if (pb.getData() instanceof ResultSetPresentationDescriptor) {
                pb.setVisible(!this.recordMode || ((ResultSetPresentationDescriptor)((Object)pb.getData())).supportsRecordMode());
            }
            ++n2;
        }
    }

    private void updateToolbar() {
        for (ToolBarManager tb : this.toolbarList) {
            UIUtils.updateContributionItems((IContributionManager)tb);
        }
        if (this.panelToolBar != null) {
            UIUtils.updateContributionItems((IContributionManager)this.panelToolBar);
        }
    }

    @Override
    public void redrawData(boolean attributesChanged, boolean rowsChanged) {
        if (this.viewerPanel.isDisposed()) {
            return;
        }
        if (rowsChanged) {
            int rowCount = this.model.getRowCount();
            if (this.curRow == null || this.curRow.getVisualNumber() >= rowCount) {
                ResultSetRow resultSetRow = this.curRow = rowCount == 0 ? null : this.model.getRow(rowCount - 1);
            }
            if (!this.recordMode) {
                this.updateFiltersText();
            }
        }
        this.activePresentation.refreshData(attributesChanged || rowsChanged && this.recordMode, false, true);
        this.updateStatusMessage();
    }

    private void createStatusBar() {
        this.statusBar = new Composite(this.viewerPanel, 0);
        this.statusBar.setBackgroundMode(2);
        GridData gd = new GridData(768);
        this.statusBar.setLayoutData((Object)gd);
        CSSUtils.setCSSClass((Widget)this.statusBar, (String)"coloredByConnectionType");
        RowLayout toolbarsLayout = new RowLayout(256);
        toolbarsLayout.marginTop = 0;
        toolbarsLayout.marginBottom = 0;
        toolbarsLayout.center = true;
        toolbarsLayout.wrap = true;
        toolbarsLayout.pack = true;
        this.statusBar.setLayout((Layout)toolbarsLayout);
        ToolBarManager editToolBarManager = new ToolBarManager(8519936);
        editToolBarManager.add((IContributionItem)new Separator());
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.applyChanges", (String)"Save", null, null, (boolean)true));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.rejectChanges", (String)"Cancel", null, null, (boolean)true));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.generateScript", (String)"Script", null, null, (boolean)true));
        editToolBarManager.add((IContributionItem)new Separator());
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.edit"));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.add"));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.copy"));
        editToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.delete"));
        ToolBar editorToolBar = editToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)editorToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(editToolBarManager);
        ToolBarManager navToolBarManager = new ToolBarManager(8519936);
        navToolBarManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.first"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.previous"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.next"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.last"));
        navToolBarManager.add((IContributionItem)new Separator());
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.page"));
        navToolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.all"));
        navToolBarManager.add((IContributionItem)new Separator(TOOLBAR_GROUP_NAVIGATION));
        ToolBar navToolBar = navToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)navToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(navToolBarManager);
        ToolBarManager configToolBarManager = new ToolBarManager(8519936);
        configToolBarManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        ToolBar configToolBar = configToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)configToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(configToolBarManager);
        ToolBarManager addToolbBarManagerar = new ToolBarManager(8519936);
        addToolbBarManagerar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.export"));
        addToolbBarManagerar.add((IContributionItem)new GroupMarker("presentations"));
        addToolbBarManagerar.add((IContributionItem)new Separator(TOOLBAR_GROUP_ADDITIONS));
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)addToolbBarManagerar, TOOLBAR_CONTRIBUTION_ID);
        }
        ToolBar addToolBar = addToolbBarManagerar.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)addToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(addToolbBarManagerar);
        configToolBarManager = new ToolBarManager(8519936);
        configToolBarManager.add((IContributionItem)new ToolbarSeparatorContribution(true));
        configToolBarManager.add((IAction)new ConfigAction());
        configToolBarManager.update(true);
        configToolBar = configToolBarManager.createControl(this.statusBar);
        CSSUtils.setCSSClass((Widget)configToolBar, (String)"coloredByConnectionType");
        this.toolbarList.add(configToolBarManager);
        int fontHeight = UIUtils.getFontHeight((Control)this.statusBar);
        this.resultSetSize = new Text(this.statusBar, 2048);
        this.resultSetSize.setLayoutData((Object)new RowData(5 * fontHeight, -1));
        this.resultSetSize.setBackground(UIStyles.getDefaultTextBackground());
        this.resultSetSize.setToolTipText(DataEditorsMessages.resultset_segment_size);
        this.resultSetSize.addModifyListener(e -> {
            DBPPreferenceStore store;
            int oldFetchSize;
            DBSDataContainer dataContainer = this.getDataContainer();
            int fetchSize = CommonUtils.toInt((Object)this.resultSetSize.getText());
            if (fetchSize > 0 && dataContainer != null && dataContainer.getDataSource() != null && (oldFetchSize = (store = dataContainer.getDataSource().getContainer().getPreferenceStore()).getInt("resultset.maxrows")) > 0 && oldFetchSize != fetchSize) {
                store.setValue("resultset.maxrows", fetchSize);
                PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
            }
        });
        UIUtils.addDefaultEditActionsSupport((IServiceLocator)this.site, (Control)this.resultSetSize);
        this.rowCountLabel = new ActiveStatusMessage(this.statusBar, DBeaverIcons.getImage((DBPImage)UIIcon.RS_REFRESH), ResultSetMessages.controls_resultset_viewer_calculate_row_count, this){

            @Override
            protected boolean isActionEnabled() {
                return ResultSetViewer.this.hasData();
            }

            @Override
            protected ILoadService<String> createLoadService() {
                return new DatabaseLoadService<String>("Load row count", ResultSetViewer.this.getExecutionContext()){

                    public String evaluate(DBRProgressMonitor monitor) {
                        try {
                            long rowCount = ResultSetViewer.this.readRowCount(monitor);
                            return ROW_COUNT_FORMAT.format(rowCount);
                        }
                        catch (DBException e) {
                            log.error((Object)e);
                            return e.getMessage();
                        }
                    }
                };
            }
        };
        this.rowCountLabel.setLayoutData(new RowData(10 * fontHeight, -1));
        CSSUtils.setCSSClass((Widget)this.rowCountLabel, (String)"coloredByConnectionType");
        this.rowCountLabel.setMessage("Row Count");
        UIUtils.createToolBarSeparator((Composite)this.statusBar, (int)512);
        this.statusLabel = new StatusLabel(this.statusBar, 0, this);
        this.statusLabel.setLayoutData(new RowData(30 * fontHeight, -1));
        CSSUtils.setCSSClass((Widget)this.statusLabel, (String)"coloredByConnectionType");
        this.statusBar.addListener(11, event -> this.statusBar.computeSize(-1, -1));
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.getDataContainer() == null ? null : this.getDataContainer().getDataSource();
    }

    @Override
    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.curState != null ? this.curState.dataContainer : this.container.getDataContainer();
    }

    public void setDataContainer(DBSDataContainer targetEntity, DBDDataFilter newFilter) {
        if (this.curState == null) {
            this.setNewState(targetEntity, this.model.getDataFilter());
        }
        this.runDataPump(targetEntity, newFilter, 0, this.getSegmentMaxRows(), -1, true, false, null);
    }

    @Override
    public boolean isRecordMode() {
        return this.recordMode;
    }

    void toggleMode() {
        this.changeMode(!this.recordMode);
        if (this.recordModeButton != null) {
            this.recordModeButton.redraw();
        }
        this.updateEditControls();
    }

    private void changeMode(boolean recordMode) {
        this.recordMode = recordMode;
        this.activePresentation.refreshData(true, false, false);
        this.activePresentation.changeMode(recordMode);
        this.updateStatusMessage();
    }

    private void dispose() {
        DBPProject project;
        if (this.activePresentation != null) {
            this.activePresentation.dispose();
        }
        if ((project = this.container.getProject()) != null) {
            project.getDataSourceRegistry().removeDataSourceListener((DBPEventListener)this);
        }
        this.savePresentationSettings();
        this.clearData();
        for (ToolBarManager tb : this.toolbarList) {
            try {
                tb.dispose();
            }
            catch (Throwable e) {
                log.debug((Object)("Error disposing toolbar " + tb), e);
            }
        }
        this.toolbarList.clear();
        UIUtils.dispose((Resource)this.sizingGC);
    }

    @Override
    public boolean isAttributeReadOnly(DBDAttributeBinding attribute) {
        if (this.isReadOnly()) {
            return true;
        }
        if (!this.model.isAttributeReadOnly(attribute)) {
            return false;
        }
        boolean newRow = this.curRow != null && this.curRow.getState() == 2;
        return !newRow;
    }

    private Object savePresentationState() {
        Object[] state = new Object[1];
        if (this.activePresentation instanceof IStatefulControl) {
            UIUtils.syncExec(() -> {
                Object object = ((IStatefulControl)((Object)this.activePresentation)).saveState();
            });
        }
        return state[0];
    }

    private boolean restorePresentationState(Object state) {
        if (this.activePresentation instanceof IStatefulControl) {
            UIUtils.syncExec(() -> ((IStatefulControl)((Object)this.activePresentation)).restoreState(state));
            return true;
        }
        return false;
    }

    List<HistoryStateItem> getStateHistory() {
        return this.stateHistory;
    }

    private void setNewState(DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter) {
        dataFilter = new DBDDataFilter(dataFilter == null ? this.model.getDataFilter() : dataFilter);
        int i = 0;
        while (i < this.stateHistory.size()) {
            HistoryStateItem item = this.stateHistory.get(i);
            if (item.dataContainer == dataContainer && item.filter != null && item.filter.equalFilters(dataFilter, false)) {
                item.filter = dataFilter;
                this.curState = item;
                this.historyPosition = i;
                return;
            }
            ++i;
        }
        while (this.historyPosition < this.stateHistory.size() - 1) {
            this.stateHistory.remove(this.stateHistory.size() - 1);
        }
        this.curState = new HistoryStateItem(dataContainer, dataFilter, this.curRow == null ? -1 : this.curRow.getVisualNumber());
        this.stateHistory.add(this.curState);
        this.historyPosition = this.stateHistory.size() - 1;
    }

    public void resetHistory() {
        this.curState = null;
        this.stateHistory.clear();
        this.historyPosition = -1;
    }

    @Override
    @Nullable
    public ResultSetRow getCurrentRow() {
        return this.curRow;
    }

    @Override
    public void setCurrentRow(@Nullable ResultSetRow curRow) {
        this.curRow = curRow;
        if (this.curState != null && curRow != null) {
            this.curState.rowNumber = curRow.getVisualNumber();
        }
    }

    public void setStatus(String status) {
        this.setStatus(status, DBPMessageType.INFORMATION);
    }

    @Override
    public void setStatus(String status, DBPMessageType messageType) {
        if (this.statusLabel == null || this.statusLabel.isDisposed()) {
            return;
        }
        this.statusLabel.setStatus(status, messageType);
        this.rowCountLabel.updateActionState();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && dataContainer.getDataSource() != null) {
            this.resultSetSize.setText(String.valueOf(dataContainer.getDataSource().getContainer().getPreferenceStore().getInt("resultset.maxrows")));
        }
    }

    @Override
    public void updateStatusMessage() {
        DBPDataSource dataSource;
        DBSDataContainer dataContainer;
        boolean hasWarnings;
        String statusMessage = this.model.getRowCount() == 0 ? (this.model.getVisibleAttributeCount() == 0 ? String.valueOf(ResultSetMessages.controls_resultset_viewer_status_empty) + this.getExecutionTimeMessage() : String.valueOf(ResultSetMessages.controls_resultset_viewer_status_no_data) + this.getExecutionTimeMessage()) : (this.recordMode ? String.valueOf(ResultSetMessages.controls_resultset_viewer_status_row) + (this.curRow == null ? 0 : this.curRow.getVisualNumber() + 1) + "/" + this.model.getRowCount() + (this.curRow == null ? this.getExecutionTimeMessage() : "") : String.valueOf(String.valueOf(this.model.getRowCount())) + ResultSetMessages.controls_resultset_viewer_status_rows_fetched + this.getExecutionTimeMessage());
        boolean bl = hasWarnings = !this.dataReceiver.getErrorList().isEmpty();
        if (hasWarnings) {
            statusMessage = String.valueOf(statusMessage) + " - " + this.dataReceiver.getErrorList().size() + " warning(s)";
        }
        if (this.getPreferenceStore().getBoolean("resultset.show.connectionName") && (dataContainer = this.getDataContainer()) != null && (dataSource = dataContainer.getDataSource()) != null) {
            statusMessage = String.valueOf(statusMessage) + " [" + dataSource.getContainer().getName() + "]";
        }
        this.setStatus(statusMessage, hasWarnings ? DBPMessageType.WARNING : DBPMessageType.INFORMATION);
        if (this.rowCountLabel != null && !this.rowCountLabel.isDisposed()) {
            if (!this.hasData()) {
                this.rowCountLabel.setMessage("No Data");
            } else if (!this.isHasMoreData()) {
                this.rowCountLabel.setMessage(ROW_COUNT_FORMAT.format(this.model.getRowCount()));
            } else if (this.model.getTotalRowCount() == null) {
                this.rowCountLabel.setMessage(String.valueOf(ROW_COUNT_FORMAT.format(this.model.getRowCount())) + "+");
            } else {
                this.rowCountLabel.setMessage(ROW_COUNT_FORMAT.format(this.model.getTotalRowCount()));
            }
            this.rowCountLabel.updateActionState();
        }
    }

    private String getExecutionTimeMessage() {
        DBCStatistics statistics = this.model.getStatistics();
        if (statistics == null || statistics.isEmpty()) {
            return "";
        }
        long fetchTime = statistics.getFetchTime();
        long totalTime = statistics.getTotalTime();
        if (fetchTime <= 0L) {
            return " - " + RuntimeUtils.formatExecutionTime((long)totalTime);
        }
        return " - " + RuntimeUtils.formatExecutionTime((long)statistics.getExecuteTime()) + " (+" + RuntimeUtils.formatExecutionTime((long)fetchTime) + ")";
    }

    @Override
    public void toggleSortOrder(DBDAttributeBinding columnElement, boolean forceAscending, boolean forceDescending) {
        DBDDataFilter dataFilter = this.getModel().getDataFilter();
        if (forceAscending) {
            dataFilter.resetOrderBy();
        }
        DBDAttributeBinding metaColumn = columnElement;
        DBDAttributeConstraint constraint = dataFilter.getConstraint(metaColumn);
        assert (constraint != null);
        if (constraint.getOrderPosition() == 0) {
            if (ResultSetUtils.isServerSideFiltering(this) && this.supportsDataFilter() && ConfirmationDialog.showConfirmDialogNoToggle((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.viewerPanel.getShell(), (String)"order_resultset", (int)3, (int)4, (Object[])new Object[]{metaColumn.getName()}) != 2) {
                return;
            }
            constraint.setOrderPosition(dataFilter.getMaxOrderingPosition() + 1);
            constraint.setOrderDescending(forceDescending);
        } else if (!constraint.isOrderDescending()) {
            constraint.setOrderDescending(true);
        } else {
            for (DBDAttributeConstraint con2 : dataFilter.getConstraints()) {
                if (con2.getOrderPosition() <= constraint.getOrderPosition()) continue;
                con2.setOrderPosition(con2.getOrderPosition() - 1);
            }
            constraint.setOrderPosition(0);
            constraint.setOrderDescending(false);
        }
        dataFilter.setOrder(null);
        if (!ResultSetUtils.isServerSideFiltering(this) || !this.isHasMoreData()) {
            if (!this.checkForChanges()) {
                return;
            }
            this.reorderLocally();
        } else {
            this.refreshData(null);
        }
    }

    private void reorderLocally() {
        this.rejectChanges();
        this.getModel().resetOrdering();
        this.getActivePresentation().refreshData(false, false, true);
    }

    void setMetaData(@NotNull DBCResultSet resultSet, @NotNull DBDAttributeBinding[] attributes) {
        this.model.setMetaData(resultSet, attributes);
        this.activePresentation.clearMetaData();
    }

    void setData(List<Object[]> rows, int focusRow) {
        Boolean autoRecordMode;
        if (this.viewerPanel.isDisposed()) {
            return;
        }
        this.curRow = null;
        this.model.setData(rows);
        ResultSetRow resultSetRow = this.curRow = this.model.getRowCount() > 0 ? this.model.getRow(0) : null;
        if (focusRow > 0 && focusRow < this.model.getRowCount()) {
            this.curRow = this.model.getRow(focusRow);
        }
        if ((autoRecordMode = this.getDecorator().getAutoRecordMode()) != null || this.model.isMetadataChanged() && this.getPreferenceStore().getBoolean("resultset.behavior.autoSwitchMode")) {
            boolean newRecordMode;
            if (autoRecordMode != null) {
                newRecordMode = rows.size() <= 1 ? autoRecordMode : false;
            } else {
                boolean bl = newRecordMode = rows.size() <= 1;
            }
            if (newRecordMode != this.recordMode) {
                this.toggleMode();
            }
        }
    }

    void appendData(List<Object[]> rows, boolean resetOldRows) {
        this.model.appendData(rows, resetOldRows);
        this.setStatus(String.valueOf(NLS.bind((String)ResultSetMessages.controls_resultset_viewer_status_rows_size, (Object)this.model.getRowCount(), (Object)rows.size())) + this.getExecutionTimeMessage());
        this.updateEditControls();
    }

    public int promptToSaveOnClose() {
        if (!this.isDirty()) {
            return 0;
        }
        int result = ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.viewerPanel.getShell(), (String)"close_resultset_edit", (int)6, (Object[])new Object[0]);
        if (result == 2) {
            return 0;
        }
        if (result == 3) {
            this.rejectChanges();
            return 1;
        }
        return 2;
    }

    public void doSave(IProgressMonitor monitor) {
        this.doSave(RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
    }

    public void doSave(DBRProgressMonitor monitor) {
        this.applyChanges(monitor, new ResultSetSaveSettings());
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.model.isDirty() || this.activePresentation != null && this.activePresentation.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    @Override
    public boolean hasData() {
        return this.model.hasData();
    }

    @Override
    public boolean isHasMoreData() {
        return this.getExecutionContext() != null && this.dataReceiver.isHasMoreData();
    }

    @Override
    public boolean isReadOnly() {
        if (this.model.isUpdateInProgress() || !(this.activePresentation instanceof IResultSetEditor) || (this.decorator.getDecoratorFeatures() & 8L) == 0L) {
            return true;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        return executionContext == null || !executionContext.isConnected() || !executionContext.getDataSource().getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_DATA) || executionContext.getDataSource().getInfo().isReadOnlyData();
    }

    boolean isInsertable() {
        return !this.isReadOnly() && this.model.isSingleSource() && this.model.getVisibleAttributeCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRefreshInProgress() {
        List<ResultSetJobDataRead> list = this.dataPumpJobQueue;
        synchronized (list) {
            return this.dataPumpRunning.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs() {
        ArrayList<ResultSetJobDataRead> dpjCopy;
        List<ResultSetJobDataRead> list = this.dataPumpJobQueue;
        synchronized (list) {
            dpjCopy = new ArrayList<ResultSetJobDataRead>(this.dataPumpJobQueue);
            this.dataPumpJobQueue.clear();
        }
        for (ResultSetJobDataRead dpj : dpjCopy) {
            if (!dpj.isActiveTask()) continue;
            dpj.cancel();
        }
    }

    @NotNull
    IResultSetFilterManager getFilterManager() {
        return this.filterManager;
    }

    void showFiltersMenu() {
        DBDAttributeBinding curAttribute = this.getActivePresentation().getCurrentAttribute();
        if (curAttribute == null) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillFiltersMenu((IMenuManager)menuManager, curAttribute, this.getCurrentRow());
        this.showContextMenuAtCursor(menuManager);
        this.viewerPanel.addDisposeListener(e -> menuManager.dispose());
    }

    @Override
    public void showDistinctFilter(DBDAttributeBinding curAttribute) {
        this.showFiltersDistinctMenu(curAttribute, false);
    }

    void showFiltersDistinctMenu(DBDAttributeBinding curAttribute, boolean atKeyboardCursor) {
        List<ResultSetRow> selectedRows = this.getSelection().getSelectedRows();
        ResultSetRow[] rows = selectedRows.toArray(new ResultSetRow[0]);
        FilterValueEditPopup menu = new FilterValueEditPopup(this.getSite().getShell(), this, curAttribute, rows);
        Point location = atKeyboardCursor ? this.getKeyboardCursorLocation() : this.getSite().getWorkbenchWindow().getWorkbench().getDisplay().getCursorLocation();
        if (location != null) {
            menu.setLocation(location);
        }
        if (menu.open() == 0) {
            Object value = menu.getValue();
            DBDDataFilter filter = new DBDDataFilter(this.model.getDataFilter());
            DBDAttributeConstraint constraint = filter.getConstraint(curAttribute);
            if (constraint != null) {
                constraint.setOperator(DBCLogicalOperator.EQUALS);
                constraint.setValue(value);
                this.setDataFilter(filter, true);
            }
        }
    }

    void showReferencesMenu(boolean openInNewWindow) {
        MenuManager[] menuManager = new MenuManager[1];
        try {
            UIUtils.runInProgressService(monitor -> {
                menuManagerArray[0] = this.createRefTablesMenu(monitor, openInNewWindow);
            });
        }
        catch (InvocationTargetException e2) {
            log.error((Object)e2.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        if (menuManager[0] != null) {
            this.showContextMenuAtCursor(menuManager[0]);
            this.viewerPanel.addDisposeListener(e -> menuManager[0].dispose());
        }
    }

    private void showContextMenuAtCursor(MenuManager menuManager) {
        Point location = this.getKeyboardCursorLocation();
        if (location != null) {
            Menu contextMenu = menuManager.createContextMenu(this.getActivePresentation().getControl());
            contextMenu.setLocation(location);
            contextMenu.setVisible(true);
        }
    }

    @Nullable
    private Point getKeyboardCursorLocation() {
        Control control = this.getActivePresentation().getControl();
        Point cursorLocation = this.getActivePresentation().getCursorLocation();
        if (cursorLocation == null) {
            return null;
        }
        return control.getDisplay().map(control, null, cursorLocation);
    }

    @Override
    public void fillContextMenu(@NotNull IMenuManager manager, @Nullable DBDAttributeBinding attr, @Nullable ResultSetRow row) {
        MenuManager viewMenu;
        ResultSetValueController valueController = attr != null && row != null ? new ResultSetValueController(this, attr, row, IValueController.EditType.NONE, null) : null;
        if (attr == null && row != null) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyRowNames"));
        } else if (attr != null && row == null) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyColumnNames", (int)8, null, null, null, (boolean)false, Collections.singletonMap("columns", attr.getName())));
        } else {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.copy"));
        }
        if (row != null) {
            MenuManager extCopyMenu = new MenuManager(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.edit.copy.special"));
            extCopyMenu.setRemoveAllWhenShown(true);
            extCopyMenu.addMenuListener(this::fillCopyAsMenu);
            manager.add((IContributionItem)extCopyMenu);
        }
        if (row != null) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.paste"));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.edit.paste.special"));
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.cut"));
        }
        manager.add((IContributionItem)new Separator());
        MenuManager filtersMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_filter, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER), "filters");
        filtersMenu.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.filterMenu");
        filtersMenu.setRemoveAllWhenShown(true);
        filtersMenu.addMenuListener(manager1 -> this.fillFiltersMenu(manager1, attr, row));
        manager.add((IContributionItem)filtersMenu);
        MenuManager orderMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_order, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SORT), "orderings");
        orderMenu.setRemoveAllWhenShown(true);
        orderMenu.addMenuListener(manager1 -> this.fillOrderingsMenu(manager1, attr, row));
        manager.add((IContributionItem)orderMenu);
        MenuManager navigateMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_navigate, null, "navigate");
        this.fillNavigateMenu((IMenuManager)navigateMenu);
        manager.add((IContributionItem)navigateMenu);
        if (row != null) {
            manager.add((IContributionItem)new Separator());
            this.fillEditMenu(manager, attr, row, valueController);
        }
        manager.add((IContributionItem)new GroupMarker("edit"));
        if (this.getDataSource() != null && attr != null && this.model.getVisibleAttributeCount() > 0 && !this.model.isUpdateInProgress()) {
            viewMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_column_view, null, "view");
            viewMenu.setRemoveAllWhenShown(true);
            viewMenu.addMenuListener(manager1 -> this.fillColumnViewMenu(manager1, attr, row, valueController));
            manager.add((IContributionItem)viewMenu);
        }
        viewMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_logical_structure, null, "virtual_model");
        viewMenu.setRemoveAllWhenShown(true);
        viewMenu.addMenuListener(manager1 -> this.fillVirtualModelMenu(manager1, attr, row, valueController));
        manager.add((IContributionItem)viewMenu);
        manager.add((IContributionItem)new Separator());
        DBSDataContainer dataContainer = this.getDataContainer();
        if (row != null && dataContainer != null && this.model.hasData()) {
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.export"));
            MenuManager openWithMenu = new MenuManager(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.openWith"));
            openWithMenu.setRemoveAllWhenShown(true);
            openWithMenu.addMenuListener(this::fillOpenWithMenu);
            manager.add((IContributionItem)openWithMenu);
        }
        if (attr != null && row != null) {
            manager.add((IContributionItem)new GroupMarker("tools"));
            manager.add((IContributionItem)new GroupMarker("results_export"));
        }
        manager.add((IContributionItem)new Separator(TOOLBAR_GROUP_ADDITIONS));
        if (dataContainer != null && this.model.hasData()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.file.refresh"));
        }
        manager.add((IContributionItem)new Separator(TOOLBAR_GROUP_ADDITIONS));
        this.decorator.fillContributions((IContributionManager)manager);
    }

    private void fillColumnViewMenu(IMenuManager viewMenu, @NotNull DBDAttributeBinding attr, @Nullable ResultSetRow row, ResultSetValueController valueController) {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return;
        }
        List transformers = dataSource.getContainer().getPlatform().getValueHandlerRegistry().findTransformers(dataSource, (DBSTypedObject)attr, null);
        if (!CommonUtils.isEmpty((Collection)transformers)) {
            MenuManager transformersMenu = new MenuManager(NLS.bind((String)ResultSetMessages.controls_resultset_viewer_action_view_column_type, (Object)attr.getName()));
            transformersMenu.setRemoveAllWhenShown(true);
            transformersMenu.addMenuListener(manager12 -> this.fillAttributeTransformersMenu(manager12, attr));
            viewMenu.add((IContributionItem)transformersMenu);
        }
        viewMenu.add((IAction)new TransformerSettingsAction());
        viewMenu.add((IAction)new TransformComplexTypesToggleAction());
        viewMenu.add((IContributionItem)new Separator());
        if (valueController != null) {
            viewMenu.add((IAction)new SetRowColorAction(attr, valueController.getValue()));
            if (this.getModel().hasColorMapping(attr)) {
                viewMenu.add((IAction)new ResetRowColorAction(attr, valueController.getValue()));
            }
        }
        viewMenu.add((IAction)new CustomizeColorsAction(attr, row));
    }

    private void fillVirtualModelMenu(@NotNull IMenuManager vmMenu, @Nullable DBDAttributeBinding attr, @Nullable ResultSetRow row, ResultSetValueController valueController) {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return;
        }
        ArrayList<Action> possibleActions = new ArrayList<Action>();
        possibleActions.add(new VirtualAttributeAddAction());
        if (attr != null) {
            possibleActions.add(new VirtualAttributeEditAction(attr));
            possibleActions.add(new VirtualAttributeDeleteAction(attr));
        }
        possibleActions.add(new VirtualForeignKeyEditAction());
        possibleActions.add(new VirtualUniqueKeyEditAction(true));
        possibleActions.add(new VirtualUniqueKeyEditAction(false));
        for (IAction iAction : possibleActions) {
            if (!iAction.isEnabled()) continue;
            vmMenu.add(iAction);
        }
        vmMenu.add((IContributionItem)new Separator());
        vmMenu.add((IAction)new VirtualEntityEditAction());
    }

    private void fillEditMenu(IMenuManager editMenu, @Nullable DBDAttributeBinding attr, @NotNull ResultSetRow row, ResultSetValueController valueController) {
        if (valueController != null) {
            Object value = valueController.getValue();
            if (!valueController.isReadOnly()) {
                if (!DBUtils.isNullValue((Object)value)) {
                    editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.setNull"));
                }
                if (valueController.getValueHandler() instanceof DBDValueDefaultGenerator) {
                    String commandName = String.valueOf(ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.cell.setDefault")) + " (" + ((DBDValueDefaultGenerator)valueController.getValueHandler()).getDefaultValueLabel() + ")";
                    DBPImage image = DBValueFormatting.getObjectImage((DBPObject)attr);
                    editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.setDefault", (String)commandName, (DBPImage)image));
                }
            }
            if (row.getState() == 3 || row.changes != null && row.changes.containsKey(attr)) {
                editMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.cell.reset"));
            }
            try {
                valueController.getValueManager().contributeActions((IContributionManager)editMenu, valueController, null);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            editMenu.add((IContributionItem)new Separator());
        }
    }

    private void fillLayoutMenu(IMenuManager layoutMenu) {
        if (this.activePresentationDescriptor != null && this.activePresentationDescriptor.supportsRecordMode()) {
            layoutMenu.add((IAction)new ToggleModeAction());
        }
        layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview"));
        layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.grid.toggleLayout"));
        layoutMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.switchPresentation"));
        MenuManager panelsMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_panels, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PANEL_CUSTOMIZE), "result_panels");
        layoutMenu.add((IContributionItem)panelsMenu);
        for (IContributionItem item : this.fillPanelsMenu()) {
            panelsMenu.add(item);
        }
        layoutMenu.add((IContributionItem)new Separator());
        for (ResultSetPresentationDescriptor pd : this.getAvailablePresentations()) {
            Action psAction = new Action(pd.getLabel(), 2, pd){
                ResultSetPresentationDescriptor presentation;
                {
                    this.presentation = resultSetPresentationDescriptor;
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)this.presentation.getIcon()));
                }

                public boolean isChecked() {
                    return ResultSetViewer.this.activePresentationDescriptor == this.presentation;
                }

                public void run() {
                    ResultSetViewer.this.switchPresentation(this.presentation);
                }
            };
            layoutMenu.add((IAction)psAction);
        }
    }

    private void fillNavigateMenu(IMenuManager navigateMenu) {
        MenuManager refTablesMenu;
        boolean hasNavTables = false;
        if (ActionUtils.isCommandEnabled((String)"org.jkiss.dbeaver.core.resultset.navigateLink", (IWorkbenchPartSite)this.site)) {
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.navigateLink"));
            hasNavTables = true;
        }
        if (this.model.isSingleSource() && (refTablesMenu = this.createRefTablesMenu(null, false)) != null) {
            navigateMenu.add((IContributionItem)refTablesMenu);
            hasNavTables = true;
        }
        if (hasNavTables) {
            navigateMenu.add((IContributionItem)new Separator());
        }
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.focus.filter"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.edit.text.goto.line"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.first"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.previous"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.next"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.row.last"));
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.page"));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.fetch.all"));
        if (this.isHasMoreData() && this.getDataContainer() != null && (this.getDataContainer().getSupportedFeatures() & 1) != 0) {
            navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.count"));
        }
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IAction)new ToggleRefreshOnScrollingAction());
        navigateMenu.add((IContributionItem)new Separator());
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.navigate.backwardHistory", (int)8, (DBPImage)UIIcon.RS_BACK));
        navigateMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.navigate.forwardHistory", (int)8, (DBPImage)UIIcon.RS_FORWARD));
    }

    @Nullable
    private MenuManager createRefTablesMenu(@Nullable DBRProgressMonitor monitor, boolean openInNewWindow) {
        DBSEntity singleSource = this.model.getSingleSource();
        if (singleSource == null) {
            return null;
        }
        String menuName = ActionUtils.findCommandName((String)"org.jkiss.dbeaver.core.resultset.referencesMenu");
        MenuManager refTablesMenu = new MenuManager(menuName, null, "ref-tables");
        refTablesMenu.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.referencesMenu");
        refTablesMenu.add((IAction)ResultSetReferenceMenu.NOREFS_ACTION);
        if (monitor != null) {
            ResultSetReferenceMenu.fillRefTablesActions(monitor, this, this.getSelection().getSelectedRows(), singleSource, (IMenuManager)refTablesMenu, openInNewWindow);
        } else {
            refTablesMenu.addMenuListener(manager -> ResultSetReferenceMenu.fillRefTablesActions(null, this, this.getSelection().getSelectedRows(), singleSource, manager, openInNewWindow));
        }
        return refTablesMenu;
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (event.getObject() instanceof DBVEntity && event.getData() instanceof DBVEntityForeignKey && event.getObject() == this.model.getVirtualEntity(false)) {
            this.refreshData(null);
        }
    }

    private void fillAttributeTransformersMenu(IMenuManager manager, final DBDAttributeBinding attr) {
        List applicableTransformers;
        List customTransformers;
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer == null) {
            return;
        }
        DBPDataSource dataSource = dataContainer.getDataSource();
        DBDRegistry registry = DBWorkbench.getPlatform().getValueHandlerRegistry();
        DBVTransformSettings transformSettings = DBVUtils.getTransformSettings((DBDAttributeBinding)attr, (boolean)false);
        DBDAttributeTransformerDescriptor customTransformer = null;
        if (transformSettings != null && transformSettings.getCustomTransformer() != null) {
            customTransformer = registry.getTransformer(transformSettings.getCustomTransformer());
        }
        if ((customTransformers = registry.findTransformers(dataSource, (DBSTypedObject)attr, Boolean.valueOf(true))) != null && !customTransformers.isEmpty()) {
            manager.add((IAction)new TransformerAction(this, attr, EMPTY_TRANSFORMER_NAME, 8, transformSettings == null || CommonUtils.isEmpty((String)transformSettings.getCustomTransformer())){

                public void run() {
                    if (this.isChecked()) {
                        this.getTransformSettings().setCustomTransformer(null);
                        this.saveTransformerSettings();
                    }
                }
            });
            for (final DBDAttributeTransformerDescriptor descriptor : customTransformers) {
                TransformerAction action = new TransformerAction(this, attr, descriptor.getName(), 8, transformSettings != null && descriptor.getId().equals(transformSettings.getCustomTransformer())){

                    public void run() {
                        try {
                            if (this.isChecked()) {
                                DBVTransformSettings settings = this.getTransformSettings();
                                String oldCustomTransformer = settings.getCustomTransformer();
                                settings.setCustomTransformer(descriptor.getId());
                                TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(this, attr, false);
                                if (settingsDialog.open() == 0) {
                                    this.saveTransformerSettings();
                                } else {
                                    settings.setCustomTransformer(oldCustomTransformer);
                                }
                            }
                        }
                        catch (Exception e) {
                            DBWorkbench.getPlatformUI().showError("Transform error", "Error transforming column", (Throwable)e);
                        }
                    }
                };
                manager.add((IAction)action);
            }
        }
        if (customTransformer != null && !CommonUtils.isEmpty((Collection)customTransformer.getProperties())) {
            manager.add((IAction)new TransformerAction(this, attr, "Settings ...", 0, false){

                public void run() {
                    TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(this, attr, false);
                    if (settingsDialog.open() == 0) {
                        this.saveTransformerSettings();
                    }
                }
            });
        }
        if ((applicableTransformers = registry.findTransformers(dataSource, (DBSTypedObject)attr, Boolean.valueOf(false))) != null) {
            manager.add((IContributionItem)new Separator());
            for (final DBDAttributeTransformerDescriptor descriptor : applicableTransformers) {
                boolean checked = transformSettings != null ? (descriptor.isApplicableByDefault() ? !transformSettings.isExcluded(descriptor.getId()) : transformSettings.isIncluded(descriptor.getId())) : descriptor.isApplicableByDefault();
                manager.add((IAction)new TransformerAction(this, attr, descriptor.getName(), 2, checked){

                    public void run() {
                        this.getTransformSettings().enableTransformer(descriptor, !this.isChecked());
                        this.saveTransformerSettings();
                    }
                });
            }
        }
    }

    private void fillFiltersMenu(@NotNull IMenuManager filtersMenu, @Nullable DBDAttributeBinding attribute, @Nullable ResultSetRow row) {
        if (attribute != null && this.supportsDataFilter()) {
            if (row != null) {
                FilterByAttributeType operator;
                filtersMenu.add((IContributionItem)new Separator());
                DBCLogicalOperator[] operators = attribute.getValueHandler().getSupportedOperators((DBSTypedObject)attribute);
                FilterByAttributeType[] filterByAttributeTypeArray = FilterByAttributeType.values();
                int n = filterByAttributeTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterByAttributeType type = filterByAttributeTypeArray[n2];
                    if (type != FilterByAttributeType.NONE) {
                        MenuManager subMenu = null;
                        if (type.getValue(this, attribute, DBCLogicalOperator.EQUALS, true) != null) {
                            DBCLogicalOperator[] dBCLogicalOperatorArray = operators;
                            int n3 = operators.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                DBCLogicalOperator operator2 = dBCLogicalOperatorArray[n4];
                                if (operator2.getArgumentCount() > 0) {
                                    if (subMenu == null) {
                                        subMenu = new MenuManager(type.title, type.icon, type.name());
                                    }
                                    subMenu.add((IAction)new FilterByAttributeAction(operator2, type, attribute));
                                }
                                ++n4;
                            }
                            if (subMenu != null) {
                                filtersMenu.add(subMenu);
                            }
                        }
                    }
                    ++n2;
                }
                filtersMenu.add((IContributionItem)new Separator());
                filterByAttributeTypeArray = operators;
                n = operators.length;
                n2 = 0;
                while (n2 < n) {
                    operator = filterByAttributeTypeArray[n2];
                    if (operator.getArgumentCount() < 0) {
                        filtersMenu.add((IAction)new FilterByAttributeAction((DBCLogicalOperator)operator, FilterByAttributeType.INPUT, attribute));
                    }
                    ++n2;
                }
                filterByAttributeTypeArray = operators;
                n = operators.length;
                n2 = 0;
                while (n2 < n) {
                    operator = filterByAttributeTypeArray[n2];
                    if (operator.getArgumentCount() == 0) {
                        filtersMenu.add((IAction)new FilterByAttributeAction((DBCLogicalOperator)operator, FilterByAttributeType.NONE, attribute));
                    }
                    ++n2;
                }
                filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterMenu.distinct"));
            }
            filtersMenu.add((IContributionItem)new Separator());
            DBDAttributeConstraint constraint = this.model.getDataFilter().getConstraint(attribute);
            if (constraint != null && constraint.hasCondition()) {
                filtersMenu.add((IAction)new FilterResetAttributeAction(attribute));
            }
        }
        filtersMenu.add((IContributionItem)new Separator());
        filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterSave"));
        filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterClear"));
        filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.filterSettings"));
    }

    private void fillOrderingsMenu(@NotNull IMenuManager filtersMenu, @Nullable DBDAttributeBinding attribute, @Nullable ResultSetRow row) {
        if (attribute != null) {
            filtersMenu.add((IContributionItem)new Separator());
            filtersMenu.add((IAction)new OrderByAttributeAction(attribute, true));
            filtersMenu.add((IAction)new OrderByAttributeAction(attribute, false));
            filtersMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.resultset.toggleOrder"));
            filtersMenu.add((IAction)new ToggleServerSideOrderingAction());
        }
    }

    @Override
    public void navigateAssociation(@NotNull DBRProgressMonitor monitor, @NotNull ResultSetModel bindingsModel, @NotNull DBSEntityAssociation association, @NotNull List<ResultSetRow> rows, boolean newWindow) throws DBException {
        if (!this.confirmProceed()) {
            return;
        }
        if (!newWindow && !this.confirmPanelsReset()) {
            return;
        }
        if (this.getExecutionContext() == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        DBSEntityConstraint refConstraint = association.getReferencedConstraint();
        if (refConstraint == null) {
            throw new DBException("Broken association (referenced constraint missing)");
        }
        if (!(refConstraint instanceof DBSEntityReferrer)) {
            throw new DBException("Referenced constraint [" + refConstraint + "] is not a referrer");
        }
        DBSEntity targetEntity = refConstraint.getParentObject();
        if (!((targetEntity = DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)targetEntity)) instanceof DBSDataContainer)) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is not a data container");
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        List ownAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)association).getAttributeReferences(monitor));
        List refAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)refConstraint).getAttributeReferences(monitor));
        if (ownAttrs.size() != refAttrs.size()) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] association [" + association.getName() + "] columns differs from referenced constraint [" + refConstraint.getName() + "] (" + ownAttrs.size() + "<>" + refAttrs.size() + ")");
        }
        int i = 0;
        while (i < ownAttrs.size()) {
            DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownAttrs.get(i);
            DBSEntityAttributeRef refAttr = (DBSEntityAttributeRef)refAttrs.get(i);
            DBDAttributeBinding ownBinding = bindingsModel.getAttributeBinding((DBSAttributeBase)ownAttr.getAttribute());
            if (ownBinding == null) {
                DBWorkbench.getPlatformUI().showError("Can't navigate", "Attribute " + ownAttr.getAttribute() + " is missing in result set");
                return;
            }
            DBSEntityAttribute attribute = refAttr.getAttribute();
            if (attribute != null) {
                DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)attribute, DBDAttributeConstraint.NULL_VISUAL_POSITION);
                constraint.setVisible(true);
                constraints.add(constraint);
                this.createFilterConstraint(rows, ownBinding, constraint);
            }
            ++i;
        }
        if (this.curState == null) {
            this.setNewState((DBSDataContainer)targetEntity, this.model.getDataFilter());
        }
        this.curState.filter = new DBDDataFilter(bindingsModel.getDataFilter());
        this.navigateEntity(monitor, newWindow, targetEntity, constraints);
    }

    @Override
    public void navigateReference(@NotNull DBRProgressMonitor monitor, @NotNull ResultSetModel bindingsModel, @NotNull DBSEntityAssociation association, @NotNull List<ResultSetRow> rows, boolean newWindow) throws DBException {
        if (!this.confirmProceed()) {
            return;
        }
        if (this.getExecutionContext() == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        DBSEntity targetEntity = association.getParentObject();
        if (!((targetEntity = DBVUtils.getRealEntity((DBRProgressMonitor)monitor, (DBSEntity)targetEntity)) instanceof DBSDataContainer)) {
            throw new DBException("Referencing entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is not a data container");
        }
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        DBSEntityConstraint refConstraint = association.getReferencedConstraint();
        if (refConstraint == null) {
            throw new DBException("Can't obtain association '" + DBUtils.getQuotedIdentifier((DBSObject)association) + "' target constraint (table " + (association.getAssociatedEntity() == null ? "???" : DBUtils.getQuotedIdentifier((DBSObject)association.getAssociatedEntity())) + ")");
        }
        List ownAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)association).getAttributeReferences(monitor));
        List refAttrs = CommonUtils.safeList((List)((DBSEntityReferrer)refConstraint).getAttributeReferences(monitor));
        if (ownAttrs.size() != refAttrs.size()) {
            throw new DBException("Entity [" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "] association [" + association.getName() + "] columns differ from referenced constraint [" + refConstraint.getName() + "] (" + ownAttrs.size() + "<>" + refAttrs.size() + ")");
        }
        if (ownAttrs.isEmpty()) {
            throw new DBException("Association '" + DBUtils.getQuotedIdentifier((DBSObject)association) + "' has empty column list");
        }
        int i = 0;
        while (i < refAttrs.size()) {
            DBSEntityAttributeRef refAttr = (DBSEntityAttributeRef)refAttrs.get(i);
            DBDAttributeBinding attrBinding = bindingsModel.getAttributeBinding((DBSAttributeBase)refAttr.getAttribute());
            if (attrBinding == null) {
                log.error((Object)("Can't find attribute binding for ref attribute '" + refAttr.getAttribute().getName() + "'"));
            } else {
                DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownAttrs.get(i);
                DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)ownAttr.getAttribute(), DBDAttributeConstraint.NULL_VISUAL_POSITION);
                constraint.setVisible(true);
                constraints.add(constraint);
                this.createFilterConstraint(rows, attrBinding, constraint);
            }
            ++i;
        }
        this.navigateEntity(monitor, newWindow, targetEntity, constraints);
    }

    private void createFilterConstraint(@NotNull List<ResultSetRow> rows, DBDAttributeBinding attrBinding, DBDAttributeConstraint constraint) {
        if (rows.size() == 1) {
            Object keyValue = this.model.getCellValue(attrBinding, rows.get(0));
            constraint.setOperator(DBCLogicalOperator.EQUALS);
            constraint.setValue(keyValue);
        } else {
            Object[] keyValues = new Object[rows.size()];
            int k = 0;
            while (k < rows.size()) {
                keyValues[k] = this.model.getCellValue(attrBinding, rows.get(k));
                ++k;
            }
            constraint.setOperator(DBCLogicalOperator.IN);
            constraint.setValue((Object)keyValues);
        }
    }

    private void navigateEntity(@NotNull DBRProgressMonitor monitor, boolean newWindow, DBSEntity targetEntity, List<DBDAttributeConstraint> constraints) {
        DBDDataFilter newFilter = new DBDDataFilter(constraints);
        if (newWindow) {
            this.openResultsInNewWindow(monitor, targetEntity, newFilter);
        } else {
            this.setDataContainer((DBSDataContainer)targetEntity, newFilter);
        }
    }

    private boolean confirmProceed() {
        return new UIConfirmation(){

            public Boolean runTask() {
                return ResultSetViewer.this.checkForChanges();
            }
        }.confirm();
    }

    private boolean confirmPanelsReset() {
        return new UIConfirmation(){

            public Boolean runTask() {
                boolean panelsDirty = false;
                IResultSetPanel[] iResultSetPanelArray = ResultSetViewer.this.getActivePanels();
                int n = iResultSetPanelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResultSetPanel panel = iResultSetPanelArray[n2];
                    if (panel.isDirty()) {
                        panelsDirty = true;
                        break;
                    }
                    ++n2;
                }
                if (panelsDirty) {
                    int result = ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)ResultSetViewer.this.viewerPanel.getShell(), (String)"reset_panels_content", (int)5, (Object[])new Object[0]);
                    if (result != 1) {
                        return true;
                    }
                    return false;
                }
                return true;
            }
        }.confirm();
    }

    private void openResultsInNewWindow(DBRProgressMonitor monitor, DBSEntity targetEntity, DBDDataFilter newFilter) {
        if (targetEntity instanceof DBSDataContainer) {
            this.getContainer().openNewContainer(monitor, (DBSDataContainer)targetEntity, newFilter);
        } else {
            UIUtils.showMessageBox(null, (String)"Open link", (String)("Target entity '" + DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' - is not a data container"), (int)1);
        }
    }

    @Override
    public int getHistoryPosition() {
        return this.historyPosition;
    }

    @Override
    public int getHistorySize() {
        return this.stateHistory.size();
    }

    @Override
    public void navigateHistory(int position) {
        if (position < 0 || position >= this.stateHistory.size()) {
            log.debug((Object)("Wrong history position: " + position));
            return;
        }
        HistoryStateItem state = this.stateHistory.get(position);
        int segmentSize = this.getSegmentMaxRows();
        if (state.rowNumber >= 0 && state.rowNumber >= segmentSize && segmentSize > 0) {
            segmentSize = (state.rowNumber / segmentSize + 1) * segmentSize;
        }
        this.runDataPump(state.dataContainer, state.filter, 0, segmentSize, state.rowNumber, true, false, null);
    }

    @Override
    public void updatePanelsContent(boolean forceRefresh) {
        this.updateEditControls();
        IResultSetPanel visiblePanel = this.getVisiblePanel();
        if (visiblePanel != null) {
            visiblePanel.refresh(forceRefresh);
        }
    }

    @Override
    public void updatePanelActions() {
        IResultSetPanel visiblePanel = this.getVisiblePanel();
        this.panelToolBar.removeAll();
        if (visiblePanel != null) {
            visiblePanel.contributeActions((IContributionManager)this.panelToolBar);
        }
        this.addDefaultPanelActions();
        this.panelToolBar.update(true);
        if (this.panelFolder != null) {
            ToolBar toolBar = this.panelToolBar.getControl();
            Point toolBarSize = toolBar.computeSize(-1, -1);
            this.panelFolder.setTabHeight(toolBarSize.y);
        }
    }

    @Override
    public Composite getControl() {
        return this.mainPanel;
    }

    public Composite getViewerPanel() {
        return this.viewerPanel;
    }

    @Override
    @NotNull
    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    @Override
    @NotNull
    public ResultSetModel getModel() {
        return this.model;
    }

    public ResultSetModel getInput() {
        return this.model;
    }

    public void setInput(Object input) {
        throw new IllegalArgumentException("ResultSet model can't be changed");
    }

    @Override
    @NotNull
    public IResultSetSelection getSelection() {
        if (this.activePresentation instanceof ISelectionProvider) {
            ISelection selection = ((ISelectionProvider)this.activePresentation).getSelection();
            if (selection.isEmpty()) {
                return new EmptySelection();
            }
            if (selection instanceof IResultSetSelection) {
                return (IResultSetSelection)selection;
            }
            log.debug((Object)("Bad selection type (" + selection + ") in presentation " + this.activePresentation));
        }
        return new EmptySelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.activePresentation instanceof ISelectionProvider) {
            ((ISelectionProvider)this.activePresentation).setSelection(selection);
        }
    }

    @Override
    @NotNull
    public ResultSetDataReceiver getDataReceiver() {
        return this.dataReceiver;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.container.getExecutionContext();
    }

    @Override
    public boolean checkForChanges() {
        if (this.isDirty()) {
            int checkResult = (Integer)new UITask<Integer>(){

                protected Integer runTask() {
                    return ResultSetViewer.this.promptToSaveOnClose();
                }
            }.execute();
            switch (checkResult) {
                case 2: {
                    return false;
                }
                case 0: {
                    this.saveChanges(null, new ResultSetSaveSettings(), success -> {
                        if (success) {
                            UIUtils.asyncExec(() -> {
                                boolean bl = this.refreshData(null);
                            });
                        }
                    });
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public void refresh() {
        if (!this.checkForChanges()) {
            return;
        }
        this.autoRefreshControl.enableAutoRefresh(false);
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            DBDDataFilter dataFilter = this.restoreDataFilter(dataContainer);
            int segmentSize = this.getSegmentMaxRows();
            Runnable finalizer = () -> {
                if (this.activePresentation.getControl() != null && !this.activePresentation.getControl().isDisposed()) {
                    this.activePresentation.formatData(true);
                }
            };
            this.dataReceiver.setNextSegmentRead(false);
            this.runDataPump(dataContainer, dataFilter, 0, segmentSize, 0, true, false, finalizer);
        } else {
            DBWorkbench.getPlatformUI().showError("Error executing query", "Viewer detached from data source");
        }
    }

    private DBDDataFilter restoreDataFilter(DBSDataContainer dataContainer) {
        DataFilterRegistry.SavedDataFilter savedConfig = DataFilterRegistry.getInstance().getSavedConfig(dataContainer);
        if (savedConfig != null) {
            DBDDataFilter dataFilter = new DBDDataFilter();
            DBRRunnableWithProgress restoreTask = monitor -> {
                try {
                    savedConfig.restoreDataFilter(monitor, dataContainer, dataFilter);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            };
            RuntimeUtils.runTask((DBRRunnableWithProgress)restoreTask, (String)"Restore data filter", (long)60000L);
            if (dataFilter.hasFilters()) {
                return dataFilter;
            }
        }
        return null;
    }

    public void refreshWithFilter(DBDDataFilter filter) {
        if (!this.checkForChanges()) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            this.dataReceiver.setNextSegmentRead(false);
            this.runDataPump(dataContainer, filter, 0, this.getSegmentMaxRows(), this.curRow == null ? -1 : this.curRow.getRowNumber(), true, false, null);
        }
    }

    @Override
    public boolean refreshData(@Nullable Runnable onSuccess) {
        if (!this.checkForChanges()) {
            return false;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null) {
            int segmentSize = this.getSegmentMaxRows();
            if (this.curRow != null && this.curRow.getVisualNumber() >= segmentSize && segmentSize > 0) {
                segmentSize = (this.curRow.getVisualNumber() / segmentSize + 1) * segmentSize;
            }
            this.dataReceiver.setNextSegmentRead(false);
            return this.runDataPump(dataContainer, null, 0, segmentSize, this.curRow == null ? 0 : this.curRow.getRowNumber(), false, false, onSuccess);
        }
        return false;
    }

    public boolean refreshMetaData() {
        DBPDataSource dataSource = this.getDataSource();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataSource == null || dataContainer == null) {
            log.error((Object)"Can't refresh metadata on disconnected data viewer");
            return false;
        }
        DBDAttributeBinding[] curAttributes = this.model.getRealAttributes();
        DBDAttributeBinding[] newAttributes = DBUtils.injectAndFilterAttributeBindings((DBPDataSource)dataSource, (DBSDataContainer)dataContainer, (DBDAttributeBinding[])curAttributes, (boolean)false);
        if (newAttributes.length > curAttributes.length) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)dataContainer, (String)"Bind custom attributes");){
                int rowCount = this.model.getRowCount();
                ArrayList<Object[]> rows = new ArrayList<Object[]>(rowCount);
                int i = 0;
                while (i < rowCount) {
                    rows.add(this.model.getRowData(i));
                    ++i;
                }
                DBDAttributeBinding[] dBDAttributeBindingArray = newAttributes;
                int n = newAttributes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                    if (attr instanceof DBDAttributeBindingCustom) {
                        try {
                            attr.lateBinding(session, rows);
                        }
                        catch (DBException e) {
                            log.debug((Object)("Error binding virtual attribute '" + attr.getName() + "'"), (Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.model.updateMetaData(newAttributes);
        this.model.updateDataFilter();
        this.redrawData(true, false);
        this.updatePanelsContent(true);
        return true;
    }

    @Override
    public void readNextSegment() {
        if (!this.dataReceiver.isHasMoreData()) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && !this.model.isUpdateInProgress()) {
            this.dataReceiver.setHasMoreData(false);
            this.dataReceiver.setNextSegmentRead(true);
            this.runDataPump(dataContainer, this.model.getDataFilter(), this.model.getRowCount(), this.getSegmentMaxRows(), -1, false, true, null);
        }
    }

    @Override
    public void readAllData() {
        if (!this.dataReceiver.isHasMoreData()) {
            return;
        }
        if (ConfirmationDialog.showConfirmDialogEx((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages"), (Shell)this.viewerPanel.getShell(), (String)"fetch_all_rows", (int)3, (int)4, (Object[])new Object[0]) != 2) {
            return;
        }
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer != null && !this.model.isUpdateInProgress()) {
            this.dataReceiver.setHasMoreData(false);
            this.dataReceiver.setNextSegmentRead(true);
            this.runDataPump(dataContainer, this.model.getDataFilter(), this.model.getRowCount(), -1, this.curRow == null ? -1 : this.curRow.getRowNumber(), false, true, null);
        }
    }

    void updateRowCount() {
        this.rowCountLabel.executeAction();
    }

    private long readRowCount(DBRProgressMonitor monitor) throws DBException {
        DBCExecutionContext executionContext = this.getExecutionContext();
        DBSDataContainer dataContainer = this.getDataContainer();
        if (executionContext == null || dataContainer == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        long[] result = new long[1];
        DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), param -> {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.USER, "Read total row count");){
                    long rowCount = dataContainer.countData((DBCExecutionSource)new AbstractExecutionSource(dataContainer, executionContext, (Object)this), session, this.model.getDataFilter(), 0L);
                    this.model.setTotalRowCount(rowCount);
                    lArray[0] = rowCount;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBCException e) {
                throw new InvocationTargetException(e);
            }
        });
        return result[0];
    }

    private int getSegmentMaxRows() {
        if (this.getDataContainer() == null) {
            return 0;
        }
        return this.getPreferenceStore().getInt("resultset.maxrows");
    }

    @NotNull
    public String getActiveQueryText() {
        String queryText;
        DBCStatistics statistics = this.getModel().getStatistics();
        String string = queryText = statistics == null ? null : statistics.getQueryText();
        if (queryText == null || queryText.isEmpty()) {
            DBSDataContainer dataContainer = this.getDataContainer();
            if (dataContainer != null) {
                SQLScriptElement query;
                if (dataContainer instanceof SQLQueryContainer && (query = ((SQLQueryContainer)dataContainer).getQuery()) != null) {
                    return query.getText();
                }
                return dataContainer.getName();
            }
            queryText = DEFAULT_QUERY_TEXT;
        }
        return queryText;
    }

    private boolean runDataPump(@NotNull DBSDataContainer dataContainer, final @Nullable DBDDataFilter dataFilter, int offset, int maxRows, final int focusRow, final boolean saveHistory, final boolean scroll, final @Nullable Runnable finalizer) {
        if (this.viewerPanel.isDisposed()) {
            return false;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null || dataContainer.getDataSource() != executionContext.getDataSource()) {
            executionContext = DBUtils.getDefaultContext((DBSObject)dataContainer, (boolean)false);
        }
        if (executionContext == null) {
            UIUtils.showMessageBox((Shell)this.viewerPanel.getShell(), (String)"Data read", (String)"Can't read data - no active connection", (int)8);
            return false;
        }
        this.autoRefreshControl.cancelRefresh();
        final DBDDataFilter useDataFilter = dataFilter != null ? dataFilter : (dataContainer == this.getDataContainer() ? this.model.getDataFilter() : null);
        Composite progressControl = this.viewerPanel;
        if (this.activePresentation.getControl() instanceof Composite) {
            progressControl = (Composite)this.activePresentation.getControl();
        }
        final Object presentationState = this.savePresentationState();
        ResultSetJobDataRead dataPumpJob = new ResultSetJobDataRead(dataContainer, useDataFilter, this, executionContext, progressControl){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected IStatus run(DBRProgressMonitor monitor) {
                IStatus iStatus;
                List list = ResultSetViewer.this.dataPumpJobQueue;
                synchronized (list) {
                    if (ResultSetViewer.this.dataPumpRunning.get()) {
                        log.debug((Object)("Internal error: multiple data reads started (" + ResultSetViewer.this.dataPumpJobQueue + ")"));
                        return Status.CANCEL_STATUS;
                    }
                    ResultSetViewer.this.dataPumpRunning.set(true);
                }
                this.beforeDataRead();
                try {
                    IStatus status = super.run(monitor);
                    this.afterDataRead();
                    iStatus = status;
                }
                catch (Throwable throwable) {
                    List list2 = ResultSetViewer.this.dataPumpJobQueue;
                    synchronized (list2) {
                        if (!ResultSetViewer.this.dataPumpRunning.get()) {
                            log.debug((Object)"Internal error: data read status is empty");
                        }
                        ResultSetViewer.this.dataPumpRunning.set(false);
                    }
                    throw throwable;
                }
                List list3 = ResultSetViewer.this.dataPumpJobQueue;
                synchronized (list3) {
                    if (!ResultSetViewer.this.dataPumpRunning.get()) {
                        log.debug((Object)"Internal error: data read status is empty");
                    }
                    ResultSetViewer.this.dataPumpRunning.set(false);
                }
                return iStatus;
            }

            private void beforeDataRead() {
                ResultSetViewer.this.dataReceiver.setFocusRow(focusRow);
                ResultSetViewer.this.dataReceiver.setTargetDataContainer(this.dataContainer);
                ResultSetViewer.this.model.setUpdateInProgress(true);
                ResultSetViewer.this.model.setStatistics(null);
                if (ResultSetViewer.this.filtersPanel != null) {
                    UIUtils.syncExec(() -> ResultSetViewer.this.filtersPanel.enableFilters(false));
                }
            }

            private void afterDataRead() {
                Throwable error = this.getError();
                if (this.getStatistics() != null) {
                    ResultSetViewer.this.model.setStatistics(this.getStatistics());
                }
                UIUtils.syncExec(() -> {
                    try {
                        Composite control1 = ResultSetViewer.this.getControl();
                        if (control1.isDisposed()) {
                            return;
                        }
                        ResultSetViewer.this.model.setUpdateInProgress(false);
                        if (saveHistory && error == null) {
                            ResultSetViewer.this.setNewState(this.dataContainer, useDataFilter);
                        }
                        boolean metadataChanged = ResultSetViewer.this.model.isMetadataChanged();
                        if (error != null) {
                            SQLScriptElement query;
                            String errorMessage = error.getMessage();
                            ResultSetViewer.this.setStatus(errorMessage, DBPMessageType.ERROR);
                            String sqlText = error instanceof DBSQLException ? ((DBSQLException)error).getSqlQuery() : (this.dataContainer instanceof SQLQueryContainer ? ((query = ((SQLQueryContainer)this.dataContainer).getQuery()) == null ? ResultSetViewer.this.getActiveQueryText() : query.getText()) : ResultSetViewer.this.getActiveQueryText());
                            if (ResultSetViewer.this.getPreferenceStore().getBoolean("resultset.show.errorDialog")) {
                                DBWorkbench.getPlatformUI().showError("Error executing query", "Query execution failed", error);
                            } else {
                                ResultSetViewer.this.showErrorPresentation(sqlText, CommonUtils.isEmpty((String)errorMessage) ? "Error executing query" : errorMessage, error);
                                log.error((Object)"Error executing query", error);
                            }
                        } else if (!metadataChanged) {
                            if (!ResultSetViewer.this.restorePresentationState(presentationState)) {
                                ResultSetViewer.this.updatePanelsContent(false);
                            }
                        } else if (focusRow >= 0 && focusRow < ResultSetViewer.this.model.getRowCount() && ResultSetViewer.this.model.getVisibleAttributeCount() > 0) {
                            if (ResultSetViewer.this.getCurrentRow() == null) {
                                ResultSetViewer.this.setCurrentRow(ResultSetViewer.this.getModel().getRow(focusRow));
                            }
                            if (ResultSetViewer.this.getActivePresentation().getCurrentAttribute() == null) {
                                ResultSetViewer.this.getActivePresentation().setCurrentAttribute(ResultSetViewer.this.model.getVisibleAttribute(0));
                            }
                            ResultSetViewer.this.updatePanelsContent(false);
                        }
                        if (metadataChanged) {
                            ResultSetViewer.this.activePresentation.updateValueView();
                        }
                        if (!scroll && dataFilter != null) {
                            ResultSetViewer.this.model.updateDataFilter(dataFilter, true);
                            ResultSetViewer.this.redrawData(true, false);
                        }
                        if (this.getStatistics() == null || !this.getStatistics().isEmpty()) {
                            if (error == null) {
                                ResultSetViewer.this.updateStatusMessage();
                            }
                            ResultSetViewer.this.updateFiltersText(true);
                            ResultSetViewer.this.updateToolbar();
                            ResultSetViewer.this.fireResultSetLoad();
                        }
                        ResultSetViewer.this.autoRefreshControl.scheduleAutoRefresh(error != null);
                    }
                    finally {
                        if (finalizer != null) {
                            try {
                                finalizer.run();
                            }
                            catch (Throwable e) {
                                log.error((Object)e);
                            }
                        }
                    }
                });
            }
        };
        dataPumpJob.setOffset(offset);
        dataPumpJob.setMaxRows(maxRows);
        this.queueDataPump(dataPumpJob);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueDataPump(ResultSetJobDataRead dataPumpJob) {
        List<ResultSetJobDataRead> list = this.dataPumpJobQueue;
        synchronized (list) {
            this.dataPumpJobQueue.clear();
            this.dataPumpJobQueue.add(dataPumpJob);
        }
        new AbstractJob("Initiate data read"){
            {
                this.setUser(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(DBRProgressMonitor monitor) {
                if (ResultSetViewer.this.dataPumpRunning.get()) {
                    this.schedule(50L);
                } else {
                    List list = ResultSetViewer.this.dataPumpJobQueue;
                    synchronized (list) {
                        if (ResultSetViewer.this.dataPumpRunning.get()) {
                            this.schedule(50L);
                        } else if (!ResultSetViewer.this.dataPumpJobQueue.isEmpty()) {
                            ResultSetJobDataRead curJob = (ResultSetJobDataRead)((Object)ResultSetViewer.this.dataPumpJobQueue.get(0));
                            ResultSetViewer.this.dataPumpJobQueue.remove((Object)curJob);
                            curJob.schedule();
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void clearData() {
        this.model.clearData();
        this.curRow = null;
        this.activePresentation.clearMetaData();
    }

    @Override
    public boolean applyChanges(@Nullable DBRProgressMonitor monitor, @NotNull ResultSetSaveSettings settings) {
        return this.saveChanges(monitor, settings, null);
    }

    private boolean saveChanges(@Nullable DBRProgressMonitor monitor, @NotNull ResultSetSaveSettings settings, @Nullable ResultSetPersister.DataUpdateListener listener) {
        UIUtils.syncExec(() -> this.getActivePresentation().applyChanges());
        try {
            ResultSetPersister persister = this.createDataPersister(false);
            ResultSetPersister.DataUpdateListener applyListener = success -> {
                if (listener != null) {
                    listener.onUpdate(success);
                }
                if (success && this.getPreferenceStore().getBoolean("resultset.edit.refreshAfterUpdate")) {
                    try {
                        persister.refreshInsertedRows();
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error refreshing rows after update", e);
                    }
                }
            };
            return persister.applyChanges(monitor, false, settings, applyListener);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Apply changes error", "Error saving changes in database", (Throwable)e);
            return false;
        }
    }

    @Override
    public void rejectChanges() {
        if (!this.isDirty()) {
            return;
        }
        try {
            this.createDataPersister(true).rejectChanges();
            if (this.model.getAllRows().isEmpty()) {
                this.curRow = null;
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
    }

    @Override
    @Nullable
    public ResultSetSaveReport generateChangesReport() {
        try {
            return this.createDataPersister(false).generateReport();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Report error", "Error generating changes report", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<DBEPersistAction> generateChangesScript(@NotNull DBRProgressMonitor monitor, @NotNull ResultSetSaveSettings settings) {
        try {
            ResultSetPersister persister = this.createDataPersister(false);
            persister.applyChanges(monitor, true, settings, null);
            return persister.getScript();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("SQL script generate error", "Error saving changes in database", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private ResultSetPersister createDataPersister(boolean skipKeySearch) throws DBException {
        boolean needPK = false;
        if (!skipKeySearch) {
            for (ResultSetRow row : this.model.getAllRows()) {
                if (row.getState() != 3 && (row.getState() != 1 || !row.isChanged())) continue;
                needPK = true;
                break;
            }
        }
        ResultSetPersister persister = new ResultSetPersister(this);
        if (needPK) {
            this.checkEntityIdentifiers(persister);
        }
        return persister;
    }

    @Override
    @NotNull
    public ResultSetRow addNewRow(boolean copyCurrent, boolean afterCurrent, boolean updatePresentation) {
        DBCExecutionContext executionContext;
        int initRowCount;
        ArrayList<ResultSetRow> selectedRows = new ArrayList<ResultSetRow>(this.getSelection().getSelectedRows());
        int rowNum = this.curRow == null ? 0 : this.curRow.getVisualNumber();
        if (rowNum >= (initRowCount = this.model.getRowCount())) {
            rowNum = initRowCount - 1;
        }
        if (rowNum < 0) {
            rowNum = 0;
        }
        if ((executionContext = this.getExecutionContext()) == null) {
            throw new IllegalStateException("Can't add/copy rows in disconnected results");
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (DBCSession session = executionContext.openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, ResultSetMessages.controls_resultset_viewer_add_new_row_context_name);){
            int newRowIndex;
            int[] rowsToCopy;
            DBDAttributeBinding docAttribute = this.model.getDocumentAttribute();
            DBDAttributeBinding[] attributes = this.model.getAttributes();
            if (selectedRows.size() > 1) {
                rowsToCopy = new int[selectedRows.size()];
                int i = 0;
                while (i < selectedRows.size()) {
                    rowsToCopy[i] = ((ResultSetRow)selectedRows.get(i)).getVisualNumber();
                    ++i;
                }
                rowNum = rowsToCopy[0];
            } else {
                rowsToCopy = new int[]{rowNum};
            }
            int n = newRowIndex = afterCurrent ? rowNum + rowsToCopy.length : rowNum;
            if (newRowIndex > initRowCount) {
                newRowIndex = initRowCount;
            }
            int rowIndex = rowsToCopy.length - 1;
            int rowCount = 0;
            while (rowIndex >= 0) {
                Object[] cells;
                int currentRowNumber = rowsToCopy[rowIndex];
                if (!afterCurrent) {
                    currentRowNumber += rowCount;
                }
                if (docAttribute != null) {
                    cells = new Object[1];
                    if (copyCurrent && currentRowNumber >= 0 && currentRowNumber < this.model.getRowCount()) {
                        Object[] origRow = this.model.getRowData(currentRowNumber);
                        try {
                            cells[0] = docAttribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)docAttribute, origRow[0], true);
                        }
                        catch (DBCException e) {
                            log.warn((Object)e);
                        }
                    }
                    if (cells[0] == null) {
                        try {
                            cells[0] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)docAttribute.getValueHandler(), (DBSTypedObject)docAttribute.getAttribute());
                        }
                        catch (DBCException e) {
                            log.warn((Object)e);
                        }
                    }
                } else {
                    cells = new Object[attributes.length];
                    if (copyCurrent && currentRowNumber >= 0 && currentRowNumber < this.model.getRowCount()) {
                        Object[] origRow = this.model.getRowData(currentRowNumber);
                        int i = 0;
                        while (i < attributes.length) {
                            DBDAttributeBinding metaAttr = attributes[i];
                            if (metaAttr.isPseudoAttribute() || metaAttr.isAutoGenerated()) {
                                cells[i] = null;
                            } else {
                                DBSAttributeBase attribute = metaAttr.getAttribute();
                                try {
                                    cells[i] = metaAttr.getValueHandler().getValueFromObject(session, (DBSTypedObject)attribute, origRow[i], true);
                                }
                                catch (DBCException e) {
                                    log.warn((Object)e);
                                    try {
                                        cells[i] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)metaAttr.getValueHandler(), (DBSTypedObject)attribute);
                                    }
                                    catch (DBCException e1) {
                                        log.warn((Object)e1);
                                    }
                                }
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < attributes.length) {
                            DBDAttributeBinding metaAttr = attributes[i];
                            try {
                                cells[i] = DBUtils.makeNullValue((DBCSession)session, (DBDValueHandler)metaAttr.getValueHandler(), (DBSTypedObject)metaAttr.getAttribute());
                            }
                            catch (DBCException e) {
                                log.warn((Object)e);
                            }
                            ++i;
                        }
                    }
                }
                this.curRow = this.model.addNewRow(newRowIndex, cells);
                --rowIndex;
                ++rowCount;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (updatePresentation) {
            this.redrawData(false, true);
            this.updateEditControls();
            this.fireResultSetChange();
        }
        return this.curRow;
    }

    void deleteSelectedRows() {
        LinkedHashSet<ResultSetRow> rowsToDelete = new LinkedHashSet<ResultSetRow>();
        if (this.recordMode) {
            rowsToDelete.add(this.curRow);
        } else {
            IResultSetSelection selection = this.getSelection();
            if (!selection.isEmpty()) {
                rowsToDelete.addAll(selection.getSelectedRows());
            }
        }
        if (rowsToDelete.isEmpty()) {
            return;
        }
        int rowsRemoved = 0;
        int lastRowNum = -1;
        for (ResultSetRow row : rowsToDelete) {
            if (this.model.deleteRow(row)) {
                ++rowsRemoved;
            }
            lastRowNum = row.getVisualNumber();
        }
        this.redrawData(false, rowsRemoved > 0);
        if (!this.recordMode && lastRowNum < this.model.getRowCount() - 1 && rowsRemoved == 0) {
            this.activePresentation.scrollToRow(IResultSetPresentation.RowPosition.NEXT);
        } else {
            this.activePresentation.scrollToRow(IResultSetPresentation.RowPosition.CURRENT);
        }
        this.updateEditControls();
        this.fireResultSetChange();
    }

    @Nullable
    DBDRowIdentifier getVirtualEntityIdentifier() {
        DBSEntityConstraint identifier;
        if (this.model.getVisibleAttributeCount() == 0) {
            return null;
        }
        DBDRowIdentifier rowIdentifier = this.model.getVisibleAttribute(0).getRowIdentifier();
        DBSEntityConstraint dBSEntityConstraint = identifier = rowIdentifier == null ? null : rowIdentifier.getUniqueKey();
        if (identifier instanceof DBVEntityConstraint) {
            return rowIdentifier;
        }
        return null;
    }

    private void checkEntityIdentifiers(ResultSetPersister persister) throws DBException {
        DBDRowIdentifier identifier;
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            throw new DBCException("Can't persist data - not connected to database");
        }
        boolean needsSingleEntity = persister.hasInserts() || persister.hasDeletes();
        DBSEntity entity = this.model.getSingleSource();
        if (needsSingleEntity && entity == null) {
            throw new DBCException("Can't detect source entity");
        }
        if (entity != null && (identifier = this.getVirtualEntityIdentifier()) != null && CommonUtils.isEmpty((Collection)identifier.getAttributes()) && !((Boolean)UIConfirmation.run(() -> ValidateUniqueKeyUsageDialog.validateUniqueKey(this, executionContext))).booleanValue()) {
            throw new DBCException("No unique key defined");
        }
        List<DBDAttributeBinding> updatedAttributes = persister.getUpdatedAttributes();
        if (persister.hasDeletes()) {
            DBDRowIdentifier defIdentifier = persister.getDefaultRowIdentifier();
            if (defIdentifier == null) {
                throw new DBCException("No unique row identifier is result set. Cannot proceed with row(s) delete.");
            }
            if (!defIdentifier.isValidIdentifier()) {
                throw new DBCException("Attributes of unique key '" + DBUtils.getObjectFullName((DBPNamedObject)defIdentifier.getUniqueKey(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "' are missing in result set. Cannot proceed with row(s) delete.");
            }
        }
        for (DBDAttributeBinding attr : updatedAttributes) {
            DBDRowIdentifier rowIdentifier = attr.getRowIdentifier();
            if (rowIdentifier == null) {
                throw new DBCException("Attribute " + attr.getName() + " was changed but it hasn't associated unique key");
            }
            if (rowIdentifier.isValidIdentifier()) continue;
            throw new DBCException("Can't update attribute '" + attr.getName() + "' - attributes of key '" + DBUtils.getObjectFullName((DBPNamedObject)rowIdentifier.getUniqueKey(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "' are missing in result set");
        }
    }

    boolean editEntityIdentifier() {
        EditVirtualEntityDialog dialog = new EditVirtualEntityDialog(this, this.model.getSingleSource(), this.model.getVirtualEntity(true));
        dialog.setInitPage(EditVirtualEntityDialog.InitPage.UNIQUE_KEY);
        if (dialog.open() == 0) {
            DBDRowIdentifier virtualID = this.getVirtualEntityIdentifier();
            if (virtualID != null) {
                try {
                    virtualID.reloadAttributes((DBRProgressMonitor)new VoidProgressMonitor(), this.getModel().getAttributes());
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            this.persistConfig();
            return true;
        }
        return false;
    }

    private void clearEntityIdentifier() {
        DBVEntity vEntity = this.model.getVirtualEntity(false);
        if (vEntity != null) {
            DBDAttributeBinding firstAttribute;
            DBDRowIdentifier rowIdentifier;
            DBVEntityConstraint vConstraint = vEntity.getBestIdentifier();
            if (vConstraint != null) {
                vConstraint.setAttributes(Collections.emptyList());
            }
            if ((rowIdentifier = (firstAttribute = this.model.getVisibleAttribute(0)).getRowIdentifier()) != null && rowIdentifier.getUniqueKey() == vConstraint) {
                rowIdentifier.clearAttributes();
            }
            this.persistConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private IResultSetListener[] getListenersCopy() {
        IResultSetListener[] listenersCopy;
        List<IResultSetListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return EMPTY_LISTENERS;
            }
            listenersCopy = this.listeners.toArray(new IResultSetListener[0]);
        }
        return listenersCopy;
    }

    void fireResultSetChange() {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetChange();
            ++n2;
        }
    }

    private void fireResultSetLoad() {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetLoad();
            ++n2;
        }
    }

    private void fireResultSetSelectionChange(SelectionChangedEvent event) {
        IResultSetListener[] iResultSetListenerArray = this.getListenersCopy();
        int n = iResultSetListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResultSetListener listener = iResultSetListenerArray[n2];
            listener.handleResultSetSelectionChange(event);
            ++n2;
        }
    }

    private String translateFilterPattern(DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute) {
        Object value = type.getValue(this, attribute, operator, true);
        DBCExecutionContext executionContext = this.getExecutionContext();
        String strValue = executionContext == null ? String.valueOf(value) : attribute.getValueHandler().getValueDisplayString((DBSTypedObject)attribute, value, DBDDisplayFormat.UI);
        strValue = strValue.replaceAll("\\s+", " ").replace("@", "^").trim();
        strValue = UITextUtils.getShortText((GC)this.sizingGC, (String)strValue, (int)150);
        if (operator.getArgumentCount() == 0) {
            return operator.getStringValue();
        }
        if (!CUSTOM_FILTER_VALUE_STRING.equals(strValue)) {
            strValue = "'" + strValue + "'";
        }
        return String.valueOf(operator.getStringValue()) + " " + strValue;
    }

    private abstract class ColorAction
    extends Action {
        ColorAction(String name) {
            super(name);
        }

        @NotNull
        DBVEntity getVirtualEntity(DBDAttributeBinding binding) throws IllegalStateException {
            return DBVUtils.getVirtualEntity((DBDAttributeBinding)binding, (boolean)true);
        }

        void updateColors(DBVEntity entity) {
            ResultSetViewer.this.model.updateColorMapping(true);
            ResultSetViewer.this.redrawData(false, false);
            entity.persistConfiguration();
        }
    }

    private class ColorizeDataTypesToggleAction
    extends Action {
        ColorizeDataTypesToggleAction() {
            super(ResultSetMessages.actions_name_colorize_data_types, 2);
            this.setToolTipText("Set different foreground color for data types");
        }

        public boolean isChecked() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.show.colorizeDataTypes");
        }

        public void run() {
            DBPPreferenceStore dsStore;
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            boolean curValue = (dsStore = dataSource.getContainer().getPreferenceStore()).getBoolean("resultset.show.colorizeDataTypes");
            dsStore.setValue("resultset.show.colorizeDataTypes", !curValue);
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class ConfigAction
    extends Action {
        ConfigAction() {
            super(ResultSetMessages.controls_resultset_viewer_action_options, 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        }

        public IMenuCreator getMenuCreator() {
            return new MenuCreator(control -> {
                MenuManager configMenuManager = new MenuManager();
                configMenuManager.add((IContributionItem)new Separator());
                MenuManager layoutMenu = new MenuManager(ResultSetMessages.controls_resultset_viewer_action_layout, null, "layout");
                ResultSetViewer.this.fillLayoutMenu((IMenuManager)layoutMenu);
                configMenuManager.add((IContributionItem)layoutMenu);
                configMenuManager.add((IContributionItem)new Separator());
                configMenuManager.add((IAction)new ColorizeDataTypesToggleAction());
                configMenuManager.add((IAction)new Action(ResultSetMessages.controls_resultset_viewer_action_data_formats){

                    public void run() {
                        UIUtils.showPreferencesFor((Shell)ResultSetViewer.this.getControl().getShell(), (Object)ResultSetViewer.this, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.dataformat"});
                    }
                });
                configMenuManager.add((IContributionItem)new Separator());
                configMenuManager.add((IAction)new Action("Preferences"){

                    public void run() {
                        UIUtils.showPreferencesFor((Shell)ResultSetViewer.this.getControl().getShell(), (Object)ResultSetViewer.this, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.resultset"});
                    }
                });
                return configMenuManager;
            });
        }

        public void runWithEvent(Event event) {
            UIUtils.showPreferencesFor((Shell)ResultSetViewer.this.getControl().getShell(), (Object)ResultSetViewer.this, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.resultset"});
        }
    }

    private class CustomizeColorsAction
    extends ColorAction {
        private final DBDAttributeBinding curAttribute;
        private final ResultSetRow row;

        CustomizeColorsAction(DBDAttributeBinding curAttribute, ResultSetRow row) {
            super(ResultSetMessages.actions_name_row_colors);
            this.curAttribute = curAttribute;
            this.row = row;
        }

        public void run() {
            ColorSettingsDialog dialog = new ColorSettingsDialog(ResultSetViewer.this, this.curAttribute, this.row);
            if (dialog.open() != 0) {
                return;
            }
            DBVEntity vEntity = this.getVirtualEntity(this.curAttribute);
            this.updateColors(vEntity);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class EmptySelection
    extends StructuredSelection
    implements IResultSetSelection {
        private EmptySelection() {
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return ResultSetViewer.this;
        }

        @Override
        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            return Collections.emptyList();
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            return null;
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return null;
        }
    }

    private class FilterByAttributeAction
    extends Action {
        private final DBCLogicalOperator operator;
        private final FilterByAttributeType type;
        private final DBDAttributeBinding attribute;

        FilterByAttributeAction(DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute) {
            super(String.valueOf(attribute.getName()) + " " + ResultSetViewer.this.translateFilterPattern(operator, type, attribute), type.icon);
            this.operator = operator;
            this.type = type;
            this.attribute = attribute;
        }

        public void run() {
            Object value = this.type.getValue(ResultSetViewer.this, this.attribute, this.operator, false);
            if (this.operator.getArgumentCount() != 0 && value == null) {
                return;
            }
            DBDDataFilter filter = new DBDDataFilter(ResultSetViewer.this.model.getDataFilter());
            DBDAttributeConstraint constraint = filter.getConstraint(this.attribute);
            if (constraint != null) {
                constraint.setOperator(this.operator);
                constraint.setValue(value);
                ResultSetViewer.this.setDataFilter(filter, true);
            }
        }
    }

    private static enum FilterByAttributeType {
        CLIPBOARD("Clipboard", (DBPImage)UIIcon.FILTER_CLIPBOARD){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                try {
                    return ResultSetUtils.getAttributeValueFromClipboard(attribute);
                }
                catch (Exception e) {
                    log.debug((Object)"Error copying from clipboard", (Throwable)e);
                    return null;
                }
            }
        }
        ,
        VALUE("Cell value", (DBPImage)UIIcon.FILTER_VALUE){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                ResultSetRow row = viewer.getCurrentRow();
                if (attribute == null || row == null) {
                    return null;
                }
                Object cellValue = viewer.model.getCellValue(attribute, row);
                if (operator == DBCLogicalOperator.LIKE && cellValue != null) {
                    cellValue = "%" + cellValue + "%";
                }
                return cellValue;
            }
        }
        ,
        INPUT("Custom", (DBPImage)UIIcon.FILTER_INPUT){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                if (useDefault) {
                    return ResultSetViewer.CUSTOM_FILTER_VALUE_STRING;
                }
                ResultSetRow[] rows = null;
                if (operator.getArgumentCount() < 0) {
                    List<ResultSetRow> selectedRows = viewer.getSelection().getSelectedRows();
                    rows = selectedRows.toArray(new ResultSetRow[0]);
                } else {
                    ResultSetRow focusRow = viewer.getCurrentRow();
                    if (focusRow != null) {
                        rows = new ResultSetRow[]{focusRow};
                    }
                }
                if (rows == null || rows.length == 0) {
                    return null;
                }
                FilterValueEditDialog dialog = new FilterValueEditDialog(viewer, attribute, rows, operator);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return null;
            }
        }
        ,
        NONE("None", (DBPImage)UIIcon.FILTER_VALUE){

            @Override
            Object getValue(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull DBCLogicalOperator operator, boolean useDefault) {
                return null;
            }
        };

        final String title;
        final ImageDescriptor icon;

        private FilterByAttributeType(String title, DBPImage icon) {
            this.title = title;
            this.icon = DBeaverIcons.getImageDescriptor((DBPImage)icon);
        }

        @Nullable
        abstract Object getValue(@NotNull ResultSetViewer var1, @NotNull DBDAttributeBinding var2, @NotNull DBCLogicalOperator var3, boolean var4);
    }

    private class FilterByValueAction
    extends Action {
        private final DBCLogicalOperator operator;
        private final FilterByAttributeType type;
        private final DBDAttributeBinding attribute;
        private final Object value;

        FilterByValueAction(DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute, Object value) {
            super(String.valueOf(attribute.getName()) + " = " + CommonUtils.truncateString((String)String.valueOf(value), (int)64), null);
            this.operator = operator;
            this.type = type;
            this.attribute = attribute;
            this.value = value;
        }

        public void run() {
            if (this.operator.getArgumentCount() != 0 && this.value == null) {
                return;
            }
            DBDDataFilter filter = new DBDDataFilter(ResultSetViewer.this.model.getDataFilter());
            DBDAttributeConstraint constraint = filter.getConstraint(this.attribute);
            if (constraint != null) {
                constraint.setOperator(this.operator);
                constraint.setValue(this.value);
                ResultSetViewer.this.setDataFilter(filter, true);
            }
        }
    }

    private class FilterResetAttributeAction
    extends Action {
        private final DBDAttributeBinding attribute;

        FilterResetAttributeAction(DBDAttributeBinding attribute) {
            super("Remove filter for '" + attribute.getName() + "'", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REVERT));
            this.attribute = attribute;
        }

        public void run() {
            DBDDataFilter dataFilter = new DBDDataFilter(ResultSetViewer.this.model.getDataFilter());
            DBDAttributeConstraint constraint = dataFilter.getConstraint(this.attribute);
            if (constraint != null) {
                constraint.setCriteria(null);
                ResultSetViewer.this.setDataFilter(dataFilter, true);
            }
        }
    }

    class HistoryStateItem {
        DBSDataContainer dataContainer;
        DBDDataFilter filter;
        int rowNumber;

        HistoryStateItem(@Nullable DBSDataContainer dataContainer, DBDDataFilter filter, int rowNumber) {
            this.dataContainer = dataContainer;
            this.filter = filter;
            this.rowNumber = rowNumber;
        }

        String describeState() {
            DBCExecutionContext context = ResultSetViewer.this.getExecutionContext();
            String desc = this.dataContainer.getName();
            if (context != null && this.filter != null && this.filter.hasConditions()) {
                StringBuilder condBuffer = new StringBuilder();
                SQLUtils.appendConditionString((DBDDataFilter)this.filter, (DBPDataSource)context.getDataSource(), null, (StringBuilder)condBuffer, (boolean)true);
                desc = String.valueOf(desc) + " [" + condBuffer + "]";
            }
            return desc;
        }
    }

    private class OpenWithAction
    extends Action {
        OpenWithAction() {
            super(null, 4);
            this.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.openWith");
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SAVE_AS));
        }

        public IMenuCreator getMenuCreator() {
            return new MenuCreator(control -> {
                MenuManager menuManager = new MenuManager();
                ResultSetViewer.this.fillOpenWithMenu((IContributionManager)menuManager);
                return menuManager;
            });
        }

        public void runWithEvent(Event event) {
        }
    }

    private class OrderByAttributeAction
    extends Action {
        private final DBDAttributeBinding attribute;
        private final boolean ascending;

        OrderByAttributeAction(DBDAttributeBinding attribute, boolean ascending) {
            super("Order by " + attribute.getName() + " " + (ascending ? "ASC" : "DESC"), 2);
            this.attribute = attribute;
            this.ascending = ascending;
        }

        public boolean isChecked() {
            DBDDataFilter dataFilter = ResultSetViewer.this.getModel().getDataFilter();
            DBDAttributeConstraint constraint = dataFilter.getConstraint(this.attribute);
            return constraint != null && constraint.getOrderPosition() > 0 && constraint.isOrderDescending() != this.ascending;
        }

        public void run() {
            ResultSetViewer.this.toggleSortOrder(this.attribute, this.ascending, !this.ascending);
        }
    }

    public static class PanelsMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart());
            if (rsv == null) {
                return new IContributionItem[0];
            }
            List items = rsv.fillPanelsMenu();
            return items.toArray(new IContributionItem[items.size()]);
        }
    }

    static class PresentationSettings {
        final Set<String> enabledPanelIds = new LinkedHashSet<String>();
        String activePanelId;
        int panelRatio;
        boolean panelsVisible;
        boolean verticalLayout;

        PresentationSettings() {
        }
    }

    private class ResetAllColorAction
    extends ColorAction {
        ResetAllColorAction() {
            super("Reset all colors");
        }

        public void run() {
            DBVEntity vEntity = this.getVirtualEntity(ResultSetViewer.this.getModel().getAttributes()[0]);
            if (!UIUtils.confirmAction((String)"Reset all row coloring", (String)("Are you sure you want to reset all color settings for '" + vEntity.getName() + "'?"))) {
                return;
            }
            vEntity.removeAllColorOverride();
            this.updateColors(vEntity);
        }
    }

    private class ResetRowColorAction
    extends ColorAction {
        private final DBDAttributeBinding attribute;

        ResetRowColorAction(DBDAttributeBinding attr, Object value) {
            super(NLS.bind((String)ResultSetMessages.actions_name_color_reset_by, (Object)(String.valueOf(attr.getName()) + " = " + UITextUtils.getShortText((GC)ResultSetViewer.this.sizingGC, (String)CommonUtils.toString((Object)value), (int)100))));
            this.attribute = attr;
        }

        public void run() {
            DBVEntity vEntity = this.getVirtualEntity(this.attribute);
            vEntity.removeColorOverride(this.attribute);
            this.updateColors(vEntity);
        }
    }

    private class SetRowColorAction
    extends ColorAction {
        private final DBDAttributeBinding attribute;
        private final Object value;

        SetRowColorAction(DBDAttributeBinding attr, Object value) {
            super(NLS.bind((String)ResultSetMessages.actions_name_color_by, (Object)(String.valueOf(attr.getName()) + " = " + UITextUtils.getShortText((GC)ResultSetViewer.this.sizingGC, (String)CommonUtils.toString((Object)value), (int)100))));
            this.attribute = attr;
            this.value = value;
        }

        public void run() {
            RGB color;
            Shell shell = UIUtils.createCenteredShell((Shell)ResultSetViewer.this.getControl().getShell());
            try {
                ColorDialog cd = new ColorDialog(shell);
                color = cd.open();
                if (color == null) {
                    return;
                }
            }
            finally {
                shell.dispose();
            }
            try {
                DBVEntity vEntity = this.getVirtualEntity(this.attribute);
                vEntity.setColorOverride(this.attribute, this.value, null, StringConverter.asString((RGB)color));
                this.updateColors(vEntity);
            }
            catch (IllegalStateException e) {
                DBWorkbench.getPlatformUI().showError("Row color", "Can't set row color", (Throwable)e);
            }
        }
    }

    private static class SimpleFilterManager
    implements IResultSetFilterManager {
        private final Map<String, List<String>> filterHistory = new HashMap<String, List<String>>();

        private SimpleFilterManager() {
        }

        @NotNull
        public List<String> getQueryFilterHistory(@NotNull String query) {
            List<String> filters = this.filterHistory.get(query);
            if (filters != null) {
                return filters;
            }
            return Collections.emptyList();
        }

        @Override
        public void saveQueryFilterValue(@NotNull String query, @NotNull String filterValue) {
            List<String> filters = this.filterHistory.get(query);
            if (filters == null) {
                filters = new ArrayList<String>();
                this.filterHistory.put(query, filters);
            }
            filters.add(filterValue);
        }

        @Override
        public void deleteQueryFilterValue(@NotNull String query, String filterValue) throws DBException {
            List<String> filters = this.filterHistory.get(query);
            if (filters != null) {
                filters.add(filterValue);
            }
        }
    }

    private abstract class ToggleConnectionPreferenceAction
    extends Action {
        private final String prefId;

        ToggleConnectionPreferenceAction(String prefId, String title) {
            super(title);
            this.prefId = prefId;
        }

        public int getStyle() {
            return 2;
        }

        public boolean isChecked() {
            return ResultSetViewer.this.getPreferenceStore().getBoolean(this.prefId);
        }

        public void run() {
            DBPPreferenceStore preferenceStore;
            preferenceStore.setValue(this.prefId, !(preferenceStore = ResultSetViewer.this.getPreferenceStore()).getBoolean(this.prefId));
        }
    }

    private class ToggleModeAction
    extends Action {
        ToggleModeAction() {
            super(ResultSetMessages.dialog_text_check_box_record, 2);
            this.setActionDefinitionId("org.jkiss.dbeaver.core.resultset.toggleMode");
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.RS_DETAILS));
            String toolTip = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.toggleMode", (IServiceLocator)ResultSetViewer.this.getSite(), (boolean)false);
            if (!CommonUtils.isEmpty((String)toolTip)) {
                this.setToolTipText(toolTip);
            }
        }

        public boolean isChecked() {
            return ResultSetViewer.this.isRecordMode();
        }

        public void run() {
            ResultSetViewer.this.toggleMode();
        }
    }

    private class ToggleRefreshOnScrollingAction
    extends ToggleConnectionPreferenceAction {
        ToggleRefreshOnScrollingAction() {
            super("resultset.reread.on.scroll", ResultSetMessages.pref_page_database_resultsets_label_reread_on_scrolling);
        }
    }

    private class ToggleServerSideOrderingAction
    extends ToggleConnectionPreferenceAction {
        ToggleServerSideOrderingAction() {
            super("resultset.order.serverSide", ResultSetMessages.pref_page_database_resultsets_label_server_side_order);
        }
    }

    private class TransformComplexTypesToggleAction
    extends Action {
        TransformComplexTypesToggleAction() {
            super(ResultSetMessages.actions_name_structurize_complex_types, 2);
            this.setToolTipText("Visualize complex types (arrays, structures, maps) in results grid as separate columns");
        }

        public boolean isChecked() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            return dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type");
        }

        public void run() {
            DBPPreferenceStore preferenceStore;
            DBPDataSource dataSource = ResultSetViewer.this.getDataContainer().getDataSource();
            if (dataSource == null) {
                return;
            }
            boolean curValue = (preferenceStore = dataSource.getContainer().getPreferenceStore()).getBoolean("resultset.transform.complex.type");
            preferenceStore.setValue("resultset.transform.complex.type", !curValue);
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class TransformerAction
    extends Action {
        private final DBDAttributeBinding attribute;

        TransformerAction(DBDAttributeBinding attr, String text, int style, boolean checked) {
            super(text, style);
            this.attribute = attr;
            this.setChecked(checked);
        }

        @NotNull
        DBVTransformSettings getTransformSettings() {
            DBVTransformSettings settings = DBVUtils.getTransformSettings((DBDAttributeBinding)this.attribute, (boolean)true);
            if (settings == null) {
                throw new IllegalStateException("Can't get/create transformer settings for '" + this.attribute.getFullyQualifiedName(DBPEvaluationContext.UI) + "'");
            }
            return settings;
        }

        void saveTransformerSettings() {
            this.attribute.getDataSource().getContainer().persistConfiguration();
            ResultSetViewer.this.refreshData(null);
        }
    }

    private class TransformerSettingsAction
    extends Action {
        TransformerSettingsAction() {
            super(ResultSetMessages.controls_resultset_viewer_action_view_column_types);
        }

        public void run() {
            DBPDataSource dataSource = ResultSetViewer.this.getDataSource();
            if (dataSource == null) {
                return;
            }
            TransformerSettingsDialog settingsDialog = new TransformerSettingsDialog(ResultSetViewer.this, null, true);
            if (settingsDialog.open() == 0) {
                dataSource.getContainer().persistConfiguration();
                ResultSetViewer.this.refreshMetaData();
            }
        }
    }

    private class VirtualAttributeAddAction
    extends Action {
        VirtualAttributeAddAction() {
            super("Add virtual column");
        }

        public void run() {
            DBVEntity vEntity = ResultSetViewer.this.model.getVirtualEntity(false);
            DBVEntityAttribute vAttr = new DBVEntityAttribute(vEntity, null, "vcolumn");
            if (new EditVirtualAttributePage(ResultSetViewer.this, vAttr).edit(ResultSetViewer.this.getControl().getShell())) {
                vAttr.setCustom(true);
                vEntity.addVirtualAttribute(vAttr);
                vEntity.persistConfiguration();
                ResultSetViewer.this.refreshMetaData();
            }
        }
    }

    private class VirtualAttributeDeleteAction
    extends Action {
        private DBDAttributeBinding attr;

        VirtualAttributeDeleteAction(DBDAttributeBinding attr) {
            super("Delete virtual column '" + attr.getName() + "'");
            this.attr = attr;
        }

        public boolean isEnabled() {
            return this.attr instanceof DBDAttributeBindingCustom;
        }

        public void run() {
            if (!(this.attr instanceof DBDAttributeBindingCustom)) {
                return;
            }
            DBVEntityAttribute vAttr = ((DBDAttributeBindingCustom)this.attr).getEntityAttribute();
            if (!UIUtils.confirmAction((Shell)ResultSetViewer.this.getControl().getShell(), (String)("Delete column '" + vAttr.getName() + "'"), (String)("Are you sure you want to delete virtual column '" + vAttr.getName() + "'?"))) {
                return;
            }
            DBVEntity vEntity = ResultSetViewer.this.model.getVirtualEntity(false);
            vEntity.removeVirtualAttribute(vAttr);
            vEntity.persistConfiguration();
            ResultSetViewer.this.refreshMetaData();
        }
    }

    private class VirtualAttributeEditAction
    extends Action {
        private DBDAttributeBinding attr;

        VirtualAttributeEditAction(DBDAttributeBinding attr) {
            super("Edit virtual column '" + attr.getName() + "'");
            this.attr = attr;
        }

        public boolean isEnabled() {
            return this.attr instanceof DBDAttributeBindingCustom;
        }

        public void run() {
            if (this.attr == null) {
                return;
            }
            DBVEntityAttribute vAttr = ((DBDAttributeBindingCustom)this.attr).getEntityAttribute();
            DBVEntity vEntity = ResultSetViewer.this.model.getVirtualEntity(false);
            if (new EditVirtualAttributePage(ResultSetViewer.this, vAttr).edit(ResultSetViewer.this.getControl().getShell())) {
                vEntity.persistConfiguration();
                ResultSetViewer.this.refreshMetaData();
            }
        }
    }

    private class VirtualEntityEditAction
    extends Action {
        VirtualEntityEditAction() {
            super("Edit ...");
        }

        public void run() {
            DBSDataContainer dataContainer = ResultSetViewer.this.getDataContainer();
            if (dataContainer == null) {
                return;
            }
            DBSEntity entity = ResultSetViewer.this.model.isSingleSource() ? ResultSetViewer.this.model.getSingleSource() : null;
            DBVEntity vEntity = ResultSetViewer.this.model.getVirtualEntity(entity, true);
            EditVirtualEntityDialog dialog = new EditVirtualEntityDialog(ResultSetViewer.this, entity, vEntity);
            dialog.setInitPage(EditVirtualEntityDialog.InitPage.ATTRIBUTES);
            if (dialog.open() == 0) {
                ResultSetViewer.this.refreshMetaData();
            }
        }
    }

    private class VirtualForeignKeyEditAction
    extends Action {
        VirtualForeignKeyEditAction() {
            super("Add virtual foreign key");
        }

        public void run() {
            if (EditForeignKeyPage.createVirtualForeignKey((DBVEntity)ResultSetViewer.this.model.getVirtualEntity(true)) != null) {
                ResultSetViewer.this.persistConfig();
                ResultSetViewer.this.refreshMetaData();
            }
        }
    }

    private class VirtualUniqueKeyEditAction
    extends Action {
        private boolean define;

        VirtualUniqueKeyEditAction(boolean define) {
            super(define ? "Define virtual unique key" : "Clear virtual unique key");
            this.define = define;
        }

        public boolean isEnabled() {
            DBVEntityConstraint vConstraint;
            DBVEntity vEntity = ResultSetViewer.this.model.getVirtualEntity(false);
            DBVEntityConstraint dBVEntityConstraint = vConstraint = vEntity == null ? null : vEntity.getBestIdentifier();
            return vConstraint != null && this.define != vConstraint.hasAttributes();
        }

        public void run() {
            if (this.define) {
                ResultSetViewer.this.editEntityIdentifier();
            } else {
                ResultSetViewer.this.clearEntityIdentifier();
            }
        }
    }
}

