/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public final class ExasolTableUniqueKeyCache
extends JDBCCompositeCache<ExasolSchema, ExasolTable, ExasolTableUniqueKey, ExasolTableKeyColumn> {
    private static final String SQL_UK_TAB = "SELECT\r\n\tC.CONSTRAINT_SCHEMA,\r\n\tc.CONSTRAINT_TABLE,\r\n\tc.CONSTRAINT_NAME,\r\n\tc.CONSTRAINT_OWNER,\r\n\tc.CONSTRAINT_TYPE,\r\n\tc.CONSTRAINT_ENABLED,\r\n\tcc.ORDINAL_POSITION,\r\n\tcc.COLUMN_NAME,\r\n\tcc.REFERENCED_COLUMN,\r\n\tcc.REFERENCED_SCHEMA,\r\n\tcc.REFERENCED_TABLE\r\nFROM\r\n\t(SELECT * FROM SYS.EXA_ALL_CONSTRAINTS c\tWHERE\r\n\t\tc.CONSTRAINT_SCHEMA = '%s'\r\n\t\tAND c.CONSTRAINT_TYPE = 'PRIMARY KEY'\r\n\t\tAND c.CONSTRAINT_TABLE = '%s' order by 1,2,3,4\r\n\t) c\r\nINNER JOIN (SELECT * FROM SYS.EXA_ALL_CONSTRAINT_COLUMNS c \tWHERE\r\n\t\tc.CONSTRAINT_SCHEMA = '%s'\r\n\t\tAND c.CONSTRAINT_TYPE = 'PRIMARY KEY'\r\n\t\tAND c.CONSTRAINT_TABLE = '%s' order by 1,2,3,4\r\n\t)cc ON\r\n\t(\r\n\t\tc.CONSTRAINT_SCHEMA = cc.CONSTRAINT_SCHEMA\r\n\t\tAND c.CONSTRAINT_TABLE = cc.CONSTRAINT_TABLE\r\n\t\tAND c.CONSTRAINT_NAME = cc.CONSTRAINT_NAME\r\n\t\tAND c.CONSTRAINT_OWNER = cc.CONSTRAINT_OWNER\r\n\t\tAND c.CONSTRAINT_TYPE = cc.CONSTRAINT_TYPE\r\n\t)\r\nORDER BY\r\n\tORDINAL_POSITION";
    private static final String SQL_UK_ALL = "SELECT\r\n\tC.CONSTRAINT_SCHEMA,\r\n\tc.CONSTRAINT_TABLE,\r\n\tc.CONSTRAINT_NAME,\r\n\tc.CONSTRAINT_OWNER,\r\n\tc.CONSTRAINT_TYPE,\r\n\tc.CONSTRAINT_ENABLED,\r\n\tcc.ORDINAL_POSITION,\r\n\tcc.COLUMN_NAME,\r\n\tcc.REFERENCED_COLUMN,\r\n\tcc.REFERENCED_SCHEMA,\r\n\tcc.REFERENCED_TABLE\r\nFROM\r\n\t(SELECT * FROM SYS.EXA_ALL_CONSTRAINTS c\tWHERE\r\n\t\tc.CONSTRAINT_SCHEMA = '%s'\r\n\t\tAND c.CONSTRAINT_TYPE = 'PRIMARY KEY'\r\n\t\torder by 1,2,3,4\r\n\t) c\r\nINNER JOIN (SELECT * FROM SYS.EXA_ALL_CONSTRAINT_COLUMNS c \tWHERE\r\n\t\tc.CONSTRAINT_SCHEMA = '%s'\r\n\t\tAND c.CONSTRAINT_TYPE = 'PRIMARY KEY'\r\n\t\torder by 1,2,3,4\r\n\t)cc ON\r\n\t(\r\n\t\tc.CONSTRAINT_SCHEMA = cc.CONSTRAINT_SCHEMA\r\n\t\tAND c.CONSTRAINT_TABLE = cc.CONSTRAINT_TABLE\r\n\t\tAND c.CONSTRAINT_NAME = cc.CONSTRAINT_NAME\r\n\t\tAND c.CONSTRAINT_OWNER = cc.CONSTRAINT_OWNER\r\n\t\tAND c.CONSTRAINT_TYPE = cc.CONSTRAINT_TYPE\r\n\t)\r\nORDER BY\r\n\tORDINAL_POSITION";

    public ExasolTableUniqueKeyCache(ExasolTableCache tableCache) {
        super((JDBCStructCache)tableCache, ExasolTable.class, (Object)"CONSTRAINT_TABLE", (Object)"CONSTRAINT_NAME");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(JDBCSession session, ExasolSchema exasolSchema, ExasolTable forTable) throws SQLException {
        String sql = forTable != null ? String.format(SQL_UK_TAB, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forTable.getName()), ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forTable.getName())) : String.format(SQL_UK_ALL, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(exasolSchema.getName()));
        JDBCStatement dbStat = session.createStatement();
        ((JDBCStatementImpl)dbStat).setQueryString(sql);
        return dbStat;
    }

    @Nullable
    protected ExasolTableUniqueKey fetchObject(JDBCSession session, ExasolSchema exasolSchema, ExasolTable exasolTable, String constName, JDBCResultSet dbResult) throws SQLException, DBException {
        DBSEntityConstraintType type = DBSEntityConstraintType.PRIMARY_KEY;
        return new ExasolTableUniqueKey(session.getProgressMonitor(), exasolTable, (ResultSet)dbResult, type);
    }

    @Nullable
    protected ExasolTableKeyColumn[] fetchObjectRow(JDBCSession session, ExasolTable exasolTable, ExasolTableUniqueKey object, JDBCResultSet dbResult) throws SQLException, DBException {
        String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        ExasolTableColumn tableColumn = exasolTable.getAttribute(session.getProgressMonitor(), columnName);
        if (tableColumn == null) {
            log.info((Object)("Column '" + columnName + "' not found in table '" + exasolTable.getFullyQualifiedName(DBPEvaluationContext.UI) + "' ??"));
            return null;
        }
        tableColumn.setRequired(true);
        return new ExasolTableKeyColumn[]{new ExasolTableKeyColumn((AbstractTableConstraint<ExasolTable>)object, tableColumn, JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"ORDINAL_POSITION"))};
    }

    protected void cacheChildren(DBRProgressMonitor monitor, ExasolTableUniqueKey constraint, List<ExasolTableKeyColumn> rows) {
        constraint.setColumns(rows);
    }
}

