/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application.rpc;

import java.io.File;
import java.io.FileOutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.application.rpc.IInstanceController;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.OpenHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBeaverInstanceServer
implements IInstanceController {
    private static final Log log = Log.getLog(DBeaverInstanceServer.class);
    private static int portNumber;
    private static Registry registry;

    @Override
    public String getVersion() {
        return GeneralUtils.getProductVersion().toString();
    }

    @Override
    public void openExternalFiles(String[] fileNames) {
        log.debug((Object)("Open external file(s) [" + Arrays.toString(fileNames) + "]"));
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        UIUtils.syncExec(() -> {
            String[] stringArray2 = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String filePath = stringArray2[n2];
                File file = new File(filePath);
                if (file.exists()) {
                    EditorUtils.openExternalFileEditor((File)file, (IWorkbenchWindow)window);
                } else {
                    DBWorkbench.getPlatformUI().showError("Open file", "Can't open '" + file.getAbsolutePath() + "': file doesn't exist");
                }
                ++n2;
            }
            shell.setMinimized(false);
            shell.forceActive();
        });
    }

    @Override
    public void openDatabaseConnection(String connectionSpec) throws RemoteException {
        InstanceConnectionParameters instanceConParameters = new InstanceConnectionParameters();
        DBPDataSourceContainer dataSource = DataSourceUtils.getDataSourceBySpec((DBPProject)DBWorkbench.getPlatform().getWorkspace().getActiveProject(), (String)connectionSpec, (GeneralUtils.IParameterHandler)instanceConParameters, (boolean)false, (boolean)instanceConParameters.createNewConnection);
        if (dataSource == null) {
            return;
        }
        if (instanceConParameters.openConsole) {
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            UIUtils.syncExec(() -> {
                OpenHandler.openSQLConsole((IWorkbenchWindow)workbenchWindow, (DBPDataSourceContainer)dataSource, (String)dataSource.getName(), (String)"");
                workbenchWindow.getShell().forceActive();
            });
        } else if (instanceConParameters.makeConnect) {
            DataSourceHandler.connectToDataSource(null, (DBPDataSourceContainer)dataSource, null);
        }
    }

    @Override
    public String getThreadDump() {
        log.info((Object)"Making thread dump");
        StringBuilder td = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> tde : Thread.getAllStackTraces().entrySet()) {
            td.append(tde.getKey().getId()).append(" ").append(tde.getKey().getName()).append(":\n");
            StackTraceElement[] stackTraceElementArray = tde.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                td.append("\t").append(ste.toString()).append("\n");
                ++n2;
            }
        }
        return td.toString();
    }

    @Override
    public void quit() {
        log.info((Object)"Program termination requested");
        System.exit(-1);
    }

    @Override
    public void closeAllEditors() {
        log.debug((Object)"Close all open editor tabs");
        UIUtils.syncExec(() -> {
            IWorkbenchPage page;
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                page.closeAllEditors(false);
            }
        });
    }

    @Override
    public void executeWorkbenchCommand(String commandId) throws RemoteException {
        log.debug((Object)("Execute workbench command " + commandId));
        try {
            ActionUtils.runCommand((String)commandId, (IServiceLocator)UIUtils.getActiveWorkbenchWindow());
        }
        catch (Exception e) {
            throw new RemoteException("Can't execute command '" + commandId + "'", e);
        }
    }

    public static IInstanceController startInstanceServer(IInstanceController server) {
        try {
            portNumber = IOUtils.findFreePort((int)20000, (int)65000);
            log.debug((Object)("Starting RMI server at " + portNumber));
            IInstanceController stub = (IInstanceController)UnicastRemoteObject.exportObject((Remote)server, 0);
            registry = LocateRegistry.createRegistry(portNumber);
            registry.bind("DBeaver.InstanceController", stub);
            File rmiFile = new File(GeneralUtils.getMetadataFolder(), "dbeaver-instance.properties");
            Properties props = new Properties();
            props.setProperty("port", String.valueOf(portNumber));
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream os = new FileOutputStream(rmiFile);){
                props.store(os, "DBeaver instance server properties");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return server;
        }
        catch (Exception e) {
            log.error((Object)"Can't start RMI server", (Throwable)e);
            return null;
        }
    }

    public static void stopInstanceServer() {
        try {
            log.debug((Object)"Stop RMI server");
            registry.unbind("DBeaver.InstanceController");
            File rmiFile = new File(GeneralUtils.getMetadataFolder(), "dbeaver-instance.properties");
            if (rmiFile.exists() && !rmiFile.delete()) {
                log.debug((Object)"Can't delete props file");
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't stop RMI server", (Throwable)e);
        }
    }

    private static class InstanceConnectionParameters
    implements GeneralUtils.IParameterHandler {
        boolean makeConnect = true;
        boolean openConsole = false;
        boolean createNewConnection = true;

        private InstanceConnectionParameters() {
        }

        public boolean setParameter(String name, String value) {
            switch (name) {
                case "connect": {
                    this.makeConnect = CommonUtils.toBoolean((Object)value);
                    return true;
                }
                case "openConsole": {
                    this.openConsole = CommonUtils.toBoolean((Object)value);
                    return true;
                }
                case "create": {
                    this.createNewConnection = CommonUtils.toBoolean((Object)value);
                    return true;
                }
            }
            return false;
        }
    }
}

