/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.task.TaskConfigurationWizardDialog;

public class TaskHandlerEdit
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof DBTTask) {
            DBTTask task = (DBTTask)element;
            DBTTaskCategory taskTypeDescriptor = task.getType().getCategory();
            if (!taskTypeDescriptor.supportsConfigurator()) {
                return null;
            }
            try {
                Object wizard = taskTypeDescriptor.createConfigurator().createTaskConfigWizard(task);
                if (wizard instanceof TaskConfigurationWizard) {
                    TaskConfigurationWizardDialog dialog = new TaskConfigurationWizardDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), (TaskConfigurationWizard)((Object)wizard));
                    dialog.open();
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Task configuration", "Error opening task '" + task.getName() + "' configuration editor", (Throwable)e);
            }
        }
        return null;
    }
}

