/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.mapping.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.core.mapping.ResourceMappingScope;
import org.eclipse.team.internal.core.mapping.ScopeChangeEvent;
import org.eclipse.team.internal.core.mapping.ScopeManagerEventHandler;

public class SynchronizationScopeManager
extends PlatformObject
implements ISynchronizationScopeManager {
    private static final int MAX_ITERATION = 10;
    private final ResourceMappingContext context;
    private final boolean consultModels;
    private ISynchronizationScope scope;
    private boolean initialized;
    private ScopeManagerEventHandler handler;
    private final String name;

    public static ResourceMapping[] getMappingsFromProviders(ResourceTraversal[] traversals, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        IModelProviderDescriptor[] descriptors;
        HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
        IModelProviderDescriptor[] iModelProviderDescriptorArray = descriptors = ModelProvider.getModelProviderDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor descriptor = iModelProviderDescriptorArray[n2];
            ResourceMapping[] mappings = SynchronizationScopeManager.getMappings(descriptor, traversals, context, monitor);
            result.addAll(Arrays.asList(mappings));
            Policy.checkCanceled(monitor);
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    private static ResourceMapping[] getMappings(IModelProviderDescriptor descriptor, ResourceTraversal[] traversals, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] matchingTraversals = descriptor.getMatchingTraversals(traversals);
        return descriptor.getModelProvider().getMappings(matchingTraversals, context, monitor);
    }

    public SynchronizationScopeManager(String name, ResourceMapping[] inputMappings, ResourceMappingContext resourceMappingContext, boolean consultModels) {
        this.name = name;
        this.context = resourceMappingContext;
        this.consultModels = consultModels;
        this.scope = this.createScope(inputMappings);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public ISchedulingRule getSchedulingRule() {
        ResourceMapping[] mappings;
        HashSet<IProject> projects = new HashSet<IProject>();
        ResourceMapping[] resourceMappingArray = mappings = this.scope.getInputMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            ResourceMapping mapping = resourceMappingArray[n2];
            Object modelObject = mapping.getModelObject();
            if (modelObject instanceof IResource) {
                resource = (IResource)modelObject;
                if (resource.getType() == 8) {
                    return ResourcesPlugin.getWorkspace().getRoot();
                }
            } else {
                return ResourcesPlugin.getWorkspace().getRoot();
            }
            projects.add(resource.getProject());
            ++n2;
        }
        return MultiRule.combine((ISchedulingRule[])((ISchedulingRule[])projects.toArray(new IProject[projects.size()])));
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(monitor1 -> this.internalPrepareContext(monitor1), this.getSchedulingRule(), 0, monitor);
    }

    @Override
    public ResourceTraversal[] refresh(ResourceMapping[] mappings, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[][] traversals = new ResourceTraversal[][]{new ResourceTraversal[0]};
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.run(monitor1 -> {
            ResourceTraversal[] resourceTraversalArray2 = this.internalRefreshScope(mappings, true, monitor1);
        }, this.getSchedulingRule(), 0, monitor);
        return traversals[0];
    }

    private void internalPrepareContext(IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] newTraversals;
        if (this.initialized) {
            return;
        }
        monitor.beginTask(null, -1);
        ((ResourceMappingScope)this.scope).reset();
        ResourceMapping[] targetMappings = this.scope.getInputMappings();
        boolean firstTime = true;
        boolean hasAdditionalResources = false;
        int count = 0;
        do {
            Policy.checkCanceled(monitor);
            newTraversals = this.addMappingsToScope(targetMappings, Policy.subMonitorFor(monitor, -1));
            if (newTraversals.length <= 0 || !this.consultModels) continue;
            ResourceTraversal[] adjusted = this.adjustInputTraversals(newTraversals);
            targetMappings = SynchronizationScopeManager.getMappingsFromProviders(adjusted, this.context, Policy.subMonitorFor(monitor, -1));
            if (firstTime) {
                firstTime = false;
                continue;
            }
            if (hasAdditionalResources) continue;
            hasAdditionalResources = newTraversals.length != 0;
        } while (this.consultModels & newTraversals.length != 0 && count++ < 10);
        this.setHasAdditionalMappings(this.scope, this.consultModels && this.internalHasAdditionalMappings());
        this.setHasAdditionalResources(this.consultModels && hasAdditionalResources);
        monitor.done();
        this.initialized = true;
        this.fireMappingsChangedEvent(this.scope.getMappings(), this.scope.getTraversals());
    }

    private ResourceTraversal[] internalRefreshScope(ResourceMapping[] mappings, boolean checkForContraction, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100 * mappings.length + 100);
        ScopeChangeEvent change = new ScopeChangeEvent(this.scope);
        CompoundResourceTraversal refreshTraversals = new CompoundResourceTraversal();
        CompoundResourceTraversal removedTraversals = new CompoundResourceTraversal();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            ResourceTraversal[] previousTraversals = this.scope.getTraversals(mapping);
            ResourceTraversal[] mappingTraversals = mapping.getTraversals(this.context, Policy.subMonitorFor(monitor, 100));
            refreshTraversals.addTraversals(mappingTraversals);
            ResourceTraversal[] uncovered = this.getUncoveredTraversals(mappingTraversals);
            if (checkForContraction && previousTraversals != null && previousTraversals.length > 0) {
                ResourceTraversal[] removed = this.getUncoveredTraversals(mappingTraversals, previousTraversals);
                removedTraversals.addTraversals(removed);
            }
            if (uncovered.length > 0) {
                change.setExpanded(true);
                ResourceTraversal[] result = this.performExpandScope(mapping, mappingTraversals, uncovered, monitor);
                refreshTraversals.addTraversals(result);
            }
            ++n2;
        }
        if (checkForContraction && removedTraversals.getRoots().length > 0) {
            ((ResourceMappingScope)this.scope).reset();
            this.internalRefreshScope(this.scope.getInputMappings(), false, monitor);
            change.setContracted(true);
        }
        if (change.shouldFireChange()) {
            this.fireMappingsChangedEvent(change.getChangedMappings(), change.getChangedTraversals(refreshTraversals));
        }
        monitor.done();
        return refreshTraversals.asTraversals();
    }

    private ResourceTraversal[] getUncoveredTraversals(ResourceTraversal[] newTraversals, ResourceTraversal[] previousTraversals) {
        CompoundResourceTraversal t = new CompoundResourceTraversal();
        t.addTraversals(newTraversals);
        return t.getUncoveredTraversals(previousTraversals);
    }

    private ResourceTraversal[] performExpandScope(ResourceMapping mapping, ResourceTraversal[] mappingTraversals, ResourceTraversal[] uncovered, IProgressMonitor monitor) throws CoreException {
        ResourceMapping ancestor = this.findAncestor(mapping);
        if (ancestor == null) {
            uncovered = this.addMappingToScope(mapping, mappingTraversals);
            this.addResourcesToScope(uncovered, monitor);
            return mappingTraversals;
        }
        ResourceTraversal[] ancestorTraversals = ancestor.getTraversals(this.context, Policy.subMonitorFor(monitor, 100));
        uncovered = this.addMappingToScope(ancestor, ancestorTraversals);
        this.addResourcesToScope(uncovered, monitor);
        return ancestorTraversals;
    }

    private ResourceMapping findAncestor(ResourceMapping mapping) {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = this.scope.getMappings(mapping.getModelProviderId());
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping m = resourceMappingArray[n2];
            if (m.contains(mapping)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private ResourceTraversal[] getUncoveredTraversals(ResourceTraversal[] traversals) {
        return ((ResourceMappingScope)this.scope).getCompoundTraversal().getUncoveredTraversals(traversals);
    }

    private void addResourcesToScope(ResourceTraversal[] newTraversals, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] adjusted;
        ResourceMapping[] targetMappings;
        if (!this.consultModels) {
            return;
        }
        int count = 0;
        while ((newTraversals = this.addMappingsToScope(targetMappings = SynchronizationScopeManager.getMappingsFromProviders(adjusted = this.adjustInputTraversals(newTraversals), this.context, Policy.subMonitorFor(monitor, -1)), Policy.subMonitorFor(monitor, -1))).length != 0 && count++ < 10) {
        }
        if (!this.scope.hasAdditionalMappings()) {
            this.setHasAdditionalMappings(this.scope, this.internalHasAdditionalMappings());
        }
        if (!this.scope.hasAdditonalResources()) {
            this.setHasAdditionalResources(true);
        }
    }

    private void fireMappingsChangedEvent(ResourceMapping[] newMappings, ResourceTraversal[] newTraversals) {
        ((ResourceMappingScope)this.scope).fireTraversalsChangedEvent(newTraversals, newMappings);
    }

    protected final void setHasAdditionalMappings(ISynchronizationScope scope, boolean hasAdditionalMappings) {
        ((ResourceMappingScope)scope).setHasAdditionalMappings(hasAdditionalMappings);
    }

    protected final void setHasAdditionalResources(boolean hasAdditionalResources) {
        ((ResourceMappingScope)this.scope).setHasAdditionalResources(hasAdditionalResources);
    }

    protected final ISynchronizationScope createScope(ResourceMapping[] inputMappings) {
        return new ResourceMappingScope(inputMappings, this);
    }

    protected ResourceTraversal[] adjustInputTraversals(ResourceTraversal[] traversals) {
        return traversals;
    }

    private ResourceTraversal[] addMappingsToScope(ResourceMapping[] targetMappings, IProgressMonitor monitor) throws CoreException {
        CompoundResourceTraversal result = new CompoundResourceTraversal();
        ResourceMappingContext context = this.context;
        ResourceMapping[] resourceMappingArray = targetMappings;
        int n = targetMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (this.scope.getTraversals(mapping) == null) {
                ResourceTraversal[] traversals = mapping.getTraversals(context, Policy.subMonitorFor(monitor, 100));
                ResourceTraversal[] newOnes = this.addMappingToScope(mapping, traversals);
                result.addTraversals(newOnes);
            }
            Policy.checkCanceled(monitor);
            ++n2;
        }
        return result.asTraversals();
    }

    protected final ResourceTraversal[] addMappingToScope(ResourceMapping mapping, ResourceTraversal[] traversals) {
        return ((ResourceMappingScope)this.scope).addMapping(mapping, traversals);
    }

    private boolean internalHasAdditionalMappings() {
        ResourceMapping[] mappings;
        ResourceMapping[] inputMappings = this.scope.getInputMappings();
        if (inputMappings.length == (mappings = this.scope.getMappings()).length) {
            HashSet testSet = new HashSet();
            Collections.addAll(testSet, mappings);
            ResourceMapping[] resourceMappingArray = inputMappings;
            int n = inputMappings.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceMapping mapping = resourceMappingArray[n2];
                if (!testSet.contains(mapping)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public ResourceMappingContext getContext() {
        return this.context;
    }

    @Override
    public ISynchronizationScope getScope() {
        return this.scope;
    }

    @Override
    public void dispose() {
        if (this.handler != null) {
            this.handler.shutdown();
        }
    }

    public void refresh(ResourceMapping[] mappings) {
        this.getHandler().refresh(mappings);
    }

    private synchronized ScopeManagerEventHandler getHandler() {
        if (this.handler == null) {
            this.handler = new ScopeManagerEventHandler(this);
        }
        return this.handler;
    }

    public String getName() {
        return this.name;
    }
}

