/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.fdw;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.ext.postgresql.tools.fdw.PostgreFDWConfigWizard;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;

class PostgreFDWConfigWizardPageInput
extends ActiveWizardPage<PostgreFDWConfigWizard> {
    private DatabaseObjectsSelectorPanel selectorPanel;
    private boolean activated;

    protected PostgreFDWConfigWizardPageInput(PostgreFDWConfigWizard wizard) {
        super("Settings");
        this.setTitle("Configure foreign data wrappers");
        this.setDescription("Choose which databases/tables you need to configure");
        this.setWizard((IWizard)wizard);
    }

    public boolean isPageComplete() {
        return !((PostgreFDWConfigWizard)this.getWizard()).getSelectedEntities().isEmpty();
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group databasesGroup = UIUtils.createControlGroup((Composite)composite, (String)"Foreign databases", (int)1, (int)1808, (int)0);
        this.selectorPanel = new DatabaseObjectsSelectorPanel((Composite)databasesGroup, ((PostgreFDWConfigWizard)this.getWizard()).getRunnableContext()){

            protected boolean isObjectVisible(DBSObject obj) {
                return super.isObjectVisible(obj);
            }

            protected void onSelectionChange() {
                PostgreFDWConfigWizardPageInput.this.updateState();
            }

            protected boolean isFolderVisible(DBNLocalFolder folder) {
                List<DBPDataSourceContainer> dataSources = ((PostgreFDWConfigWizard)PostgreFDWConfigWizardPageInput.this.getWizard()).getAvailableDataSources();
                for (DBNDataSource ds : folder.getNestedDataSources()) {
                    if (!dataSources.contains(ds.getDataSourceContainer())) continue;
                    return true;
                }
                return false;
            }

            protected boolean isDataSourceVisible(DBNDataSource dataSource) {
                return ((PostgreFDWConfigWizard)PostgreFDWConfigWizardPageInput.this.getWizard()).getAvailableDataSources().contains(dataSource.getDataSourceContainer());
            }
        };
        Composite buttonsPanel = UIUtils.createComposite((Composite)databasesGroup, (int)2);
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Add database", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPDataSourceContainer dataSource;
                SelectDataSourceDialog dialog = new SelectDataSourceDialog(PostgreFDWConfigWizardPageInput.this.getShell(), PostgreFDWConfigWizardPageInput.this.selectorPanel.getProject(), null);
                if (dialog.open() == 0 && (dataSource = dialog.getDataSource()) != null) {
                    ((PostgreFDWConfigWizard)PostgreFDWConfigWizardPageInput.this.getWizard()).addAvailableDataSource(dataSource);
                    PostgreFDWConfigWizardPageInput.this.refreshDataSources();
                }
            }
        });
        Button delButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Remove database", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBNNode selectedNode = NavigatorUtils.getSelectedNode((ISelection)PostgreFDWConfigWizardPageInput.this.selectorPanel.getSelection());
                if (selectedNode instanceof DBNDatabaseNode) {
                    ((PostgreFDWConfigWizard)PostgreFDWConfigWizardPageInput.this.getWizard()).removeAvailableDataSource(((DBNDatabaseNode)selectedNode).getDataSourceContainer());
                    PostgreFDWConfigWizardPageInput.this.refreshDataSources();
                }
            }
        });
        delButton.setEnabled(false);
        this.selectorPanel.addSelectionListener(event -> {
            DBNNode selectedNode = NavigatorUtils.getSelectedNode((ISelection)event.getSelection());
            delButton.setEnabled(selectedNode instanceof DBNDatabaseNode);
        });
        this.setControl((Control)composite);
    }

    public void activatePage() {
        if (!this.activated) {
            UIUtils.asyncExec(() -> this.refreshDataSources());
            this.activated = true;
        }
        super.activatePage();
    }

    private void refreshDataSources() {
        ArrayList selection = new ArrayList();
        try {
            ((PostgreFDWConfigWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                ((PostgreFDWConfigWizard)this.getWizard()).collectAvailableDataSources(monitor);
                List<DBSEntity> proposedEntities = ((PostgreFDWConfigWizard)this.getWizard()).getProposedEntities();
                for (DBSEntity entity : proposedEntities) {
                    DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)entity, (boolean)false);
                    if (node == null) continue;
                    selection.add(node);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Collect data sources", "Error collecting available data sources", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.selectorPanel.refreshNodes();
        this.selectorPanel.checkNodes(selection, true);
        this.selectorPanel.setSelection(selection);
        this.updateState();
    }

    protected void updateState() {
        ArrayList<DBNDatabaseNode> selectedEntities = new ArrayList<DBNDatabaseNode>();
        DBPDataSourceContainer dsContainer = null;
        for (DBNNode node : this.selectorPanel.getCheckedNodes()) {
            if (!(node instanceof DBNDatabaseNode) || !(((DBNDatabaseNode)node).getObject() instanceof DBSEntity)) continue;
            DBPDataSourceContainer nodeContainer = ((DBNDatabaseNode)node).getDataSourceContainer();
            if (dsContainer != null && dsContainer != nodeContainer) {
                selectedEntities.clear();
                this.setErrorMessage("You can't select tables from different data sources");
                break;
            }
            dsContainer = nodeContainer;
            selectedEntities.add((DBNDatabaseNode)node);
        }
        if (!selectedEntities.isEmpty()) {
            this.setErrorMessage(null);
        }
        ((PostgreFDWConfigWizard)this.getWizard()).setSelectedEntities(selectedEntities);
        this.getContainer().updateButtons();
    }
}

