/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.fdw;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreForeignTableManager;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableColumnManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.tools.fdw.PostgreFDWConfigWizard;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.editors.SimpleCommandContext;
import org.jkiss.utils.CommonUtils;

class PostgreFDWConfigWizardPageFinal
extends ActiveWizardPage<PostgreFDWConfigWizard> {
    private static final Log log = Log.getLog(PostgreFDWConfigWizardPageFinal.class);
    private boolean activated;
    private Object sqlPanel;

    protected PostgreFDWConfigWizardPageFinal(PostgreFDWConfigWizard wizard) {
        super("Script");
        this.setTitle("Foreign wrappers mapping SQL script");
        this.setDescription("Preview script and perform install");
        this.setWizard((IWizard)wizard);
    }

    public boolean isPageComplete() {
        return this.activated && this.getErrorMessage() == null;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)"Script", (int)2, (int)1808, (int)0);
        settingsGroup.setLayout((Layout)new FillLayout());
        UIServiceSQL service = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (service != null) {
            try {
                this.sqlPanel = service.createSQLPanel((Object)UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), (Object)settingsGroup, (DBPContextProvider)this.getWizard(), "FDW Script", true, "");
            }
            catch (DBException e) {
                log.debug((Object)e);
                this.setErrorMessage(e.getMessage());
            }
        }
        this.setControl((Control)composite);
    }

    public void activatePage() {
        if (!this.activated) {
            this.activated = true;
        }
        this.generateScript();
        super.activatePage();
    }

    private void generateScript() {
        StringBuilder script = new StringBuilder();
        try {
            ((PostgreFDWConfigWizard)this.getWizard()).getRunnableContext().run(false, true, monitor -> {
                try {
                    List<DBEPersistAction> actions = this.generateScript(monitor);
                    script.append(SQLUtils.generateScript((DBPDataSource)((PostgreFDWConfigWizard)this.getWizard()).getDatabase().getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false));
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            log.debug((Object)e.getTargetException());
            this.setErrorMessage(e.getTargetException().getMessage());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.setErrorMessage(null);
        String sql = script.toString();
        UIServiceSQL service = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (service != null) {
            service.setSQLPanelText(this.sqlPanel, sql);
        }
    }

    private List<DBEPersistAction> generateScript(DBRProgressMonitor monitor) throws DBException {
        PostgreDatabase database = ((PostgreFDWConfigWizard)this.getWizard()).getDatabase();
        PostgreDataSource curDataSource = database.getDataSource();
        ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
        PostgreFDWConfigWizard.FDWInfo selectedFDW = ((PostgreFDWConfigWizard)this.getWizard()).getSelectedFDW();
        PropertySourceCustom propertySource = ((PostgreFDWConfigWizard)this.getWizard()).getFdwPropertySource();
        Map propValues = propertySource.getPropertiesWithDefaults();
        String serverId = ((PostgreFDWConfigWizard)this.getWizard()).getFdwServerId();
        actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)curDataSource, "CREATE EXTENSION " + selectedFDW.getId()));
        StringBuilder script = new StringBuilder();
        script.append("CREATE SERVER ").append(serverId).append("\n\tFOREIGN DATA WRAPPER ").append(selectedFDW.getId()).append("\n\tOPTIONS(");
        boolean firstProp = true;
        for (Map.Entry pe : propValues.entrySet()) {
            String propName = CommonUtils.toString(pe.getKey());
            String propValue = CommonUtils.toString(pe.getValue());
            if (CommonUtils.isEmpty((String)propName) || CommonUtils.isEmpty((String)propValue)) continue;
            if (!firstProp) {
                script.append(", ");
            }
            script.append(propName).append(" '").append(propValue).append("'");
            firstProp = false;
        }
        script.append(")");
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create extension", script.toString()));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("CREATE USER MAPPING FOR CURRENT_USER SERVER " + serverId));
        SimpleCommandContext commandContext = new SimpleCommandContext(((PostgreFDWConfigWizard)this.getWizard()).getExecutionContext(), false);
        try {
            PostgreFDWConfigWizard.FDWInfo fdwInfo = ((PostgreFDWConfigWizard)this.getWizard()).getSelectedFDW();
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("skip.object.configuration", true);
            PostgreForeignTableManager tableManager = new PostgreForeignTableManager();
            PostgreTableColumnManager columnManager = new PostgreTableColumnManager();
            for (DBNDatabaseNode tableNode : ((PostgreFDWConfigWizard)this.getWizard()).getSelectedEntities()) {
                DBSEntity entity = (DBSEntity)tableNode.getObject();
                PostgreTableForeign pgTable = (PostgreTableForeign)tableManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)((PostgreFDWConfigWizard)this.getWizard()).getSelectedSchema(), null, options);
                if (pgTable == null) {
                    log.error((Object)"Internal error while creating new table");
                    continue;
                }
                pgTable.setName(entity.getName());
                pgTable.setForeignServerName(fdwInfo.getId());
                pgTable.setForeignOptions(new String[0]);
                for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)entity.getAttributes(monitor))) {
                    PostgreTableColumn newColumn = (PostgreTableColumn)columnManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)pgTable, null, options);
                    assert (newColumn != null);
                    newColumn.setName(attr.getName());
                    String defTypeName = database.getDefaultDataTypeName(attr.getDataKind());
                    PostgreDataType dataType = database.getDataType(monitor, defTypeName);
                    newColumn.setDataType(dataType);
                }
                DBEPersistAction[] tableDDL = tableManager.getTableDDL(monitor, (DBSEntity)pgTable, options);
                Collections.addAll(actions, tableDDL);
            }
        }
        finally {
            commandContext.resetChanges(true);
        }
        return actions;
    }
}

