/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class DialogSettingsMap
extends AbstractMap<String, Object> {
    private final IDialogSettings settings;

    public DialogSettingsMap(IDialogSettings settings) {
        this.settings = settings;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return new LinkedHashSet<Map.Entry<String, Object>>();
    }

    @Override
    public Object get(Object key) {
        return this.getOrDefault(key, (Object)null);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        String keyValue = this.settings.get((String)key);
        if (keyValue != null) {
            return keyValue;
        }
        IDialogSettings section = this.settings.getSection((String)key);
        if (section != null) {
            return new DialogSettingsMap(section);
        }
        return defaultValue;
    }

    @Override
    public Object put(String key, Object value) {
        return this.putIfAbsent(key, value);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        if (value instanceof Map) {
            IDialogSettings section = this.settings.getSection(key);
            if (section == null) {
                section = this.settings.addNewSection(key);
            }
            this.fillSection(section, (Map)value);
        } else {
            this.settings.put(key, CommonUtils.toString((Object)value));
        }
        return value;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return false;
    }

    private DialogSettingsMap fillSection(IDialogSettings section, Map<String, Object> value) {
        DialogSettingsMap settingsMap = new DialogSettingsMap(this.settings);
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            settingsMap.put(entry.getKey(), entry.getValue());
        }
        return settingsMap;
    }
}

