/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.task.DBTTaskDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskRegistry;
import org.jkiss.dbeaver.model.task.DBTTaskTypeDescriptor;
import org.jkiss.dbeaver.registry.task.TaskConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.task.TaskDescriptor;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;

public class TaskRegistry
implements DBTTaskRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.task";
    private static final Log log = Log.getLog(TaskRegistry.class);
    private static TaskRegistry instance = null;
    private final List<TaskTypeDescriptor> taskTypeDescriptors = new ArrayList<TaskTypeDescriptor>();
    private final Map<String, TaskDescriptor> taskDescriptors = new LinkedHashMap<String, TaskDescriptor>();

    public static synchronized TaskRegistry getInstance() {
        if (instance == null) {
            instance = new TaskRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private TaskRegistry(IExtensionRegistry registry) {
        IConfigurationElement ext;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("type".equals(ext.getName())) {
                TaskTypeDescriptor descriptor = new TaskTypeDescriptor(ext);
                this.taskTypeDescriptors.add(descriptor);
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            TaskTypeDescriptor taskType;
            String typeId;
            ext = iConfigurationElementArray[n2];
            if ("task".equals(ext.getName())) {
                typeId = ext.getAttribute("type");
                taskType = this.getTaskType(typeId);
                TaskDescriptor taskDescriptor = new TaskDescriptor(taskType, ext);
                this.taskDescriptors.put(taskDescriptor.getId(), taskDescriptor);
            } else if ("configurator".equals(ext.getName())) {
                typeId = ext.getAttribute("type");
                taskType = this.getTaskType(typeId);
                if (taskType == null) {
                    log.debug((Object)"");
                } else {
                    TaskConfiguratorDescriptor configDescriptor = new TaskConfiguratorDescriptor(taskType, ext);
                    taskType.setConfigurator(configDescriptor);
                }
            }
            ++n2;
        }
    }

    @NotNull
    public DBTTaskDescriptor[] getAllTasks() {
        return this.taskDescriptors.values().toArray(new DBTTaskDescriptor[0]);
    }

    @Nullable
    public DBTTaskDescriptor getTask(String id) {
        return this.taskDescriptors.get(id);
    }

    @NotNull
    public DBTTaskTypeDescriptor[] getTaskTypes() {
        return this.taskTypeDescriptors.toArray(new DBTTaskTypeDescriptor[0]);
    }

    @Nullable
    private TaskTypeDescriptor getTaskType(String id) {
        for (TaskTypeDescriptor ttd : this.taskTypeDescriptors) {
            if (!id.equals(ttd.getId())) continue;
            return ttd;
        }
        return null;
    }
}

