/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTaskConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskRegistry;
import org.jkiss.dbeaver.registry.ProjectMetadata;
import org.jkiss.dbeaver.registry.task.TaskConfigurationImpl;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.utils.IOUtils;

public class TaskManagerImpl
implements DBTTaskManager {
    private static final Log log = Log.getLog(TaskManagerImpl.class);
    public static final String CONFIG_FILE = "tasks.json";
    private static Gson CONFIG_GSON = new GsonBuilder().setLenient().serializeNulls().setPrettyPrinting().create();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.ENGLISH);
    private final ProjectMetadata projectMetadata;
    private final List<TaskConfigurationImpl> tasks = new ArrayList<TaskConfigurationImpl>();

    public TaskManagerImpl(ProjectMetadata projectMetadata) {
        this.projectMetadata = projectMetadata;
        this.loadConfiguration();
    }

    @NotNull
    public DBTTaskRegistry getRegistry() {
        return TaskRegistry.getInstance();
    }

    @NotNull
    public DBPProject getProject() {
        return this.projectMetadata;
    }

    @NotNull
    public DBTTaskConfiguration[] getTaskConfigurations() {
        return this.tasks.toArray(new DBTTaskConfiguration[0]);
    }

    @NotNull
    public DBTTaskDescriptor[] getExistingTaskTypes() {
        LinkedHashSet<DBTTaskDescriptor> result = new LinkedHashSet<DBTTaskDescriptor>();
        for (DBTTaskConfiguration dBTTaskConfiguration : this.tasks) {
            result.add(dBTTaskConfiguration.getDescriptor());
        }
        return result.toArray(new DBTTaskDescriptor[0]);
    }

    @NotNull
    public DBTTaskConfiguration[] getTaskConfigurations(DBTTaskDescriptor task) {
        ArrayList<DBTTaskConfiguration> result = new ArrayList<DBTTaskConfiguration>();
        for (DBTTaskConfiguration dBTTaskConfiguration : this.tasks) {
            if (dBTTaskConfiguration.getDescriptor() != task) continue;
            result.add(dBTTaskConfiguration);
        }
        return result.toArray(new DBTTaskConfiguration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBTTaskConfiguration createTaskConfiguration(DBTTaskDescriptor taskDescriptor, String label, String description, Map<String, Object> properties) throws DBException {
        Date createTime = new Date();
        String id = UUID.randomUUID().toString();
        TaskConfigurationImpl task = new TaskConfigurationImpl(taskDescriptor, id, label, description, createTime, createTime);
        task.setProperties(properties);
        List<TaskConfigurationImpl> list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
        }
        this.saveConfiguration();
        return task;
    }

    public void updateTaskConfiguration(DBTTaskConfiguration task) {
        this.saveConfiguration();
    }

    public void deleteTaskConfiguration(DBTTaskConfiguration task) {
        throw new RuntimeException("Not Implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        IFile configFile = this.getConfigFile(false);
        if (!configFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = configFile.getContents();){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (InputStreamReader configReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    Map jsonMap = JSONUtils.parseMap((Gson)CONFIG_GSON, (Reader)configReader);
                    for (Map.Entry taskMap : jsonMap.entrySet()) {
                        Map taskJSON = (Map)taskMap.getValue();
                        try {
                            String id = (String)taskMap.getKey();
                            String task = JSONUtils.getString((Map)taskJSON, (String)"task");
                            String label = JSONUtils.getString((Map)taskJSON, (String)"label");
                            String description = JSONUtils.getString((Map)taskJSON, (String)"description");
                            Date createTime = this.dateFormat.parse(JSONUtils.getString((Map)taskJSON, (String)"createTime"));
                            Date updateTime = this.dateFormat.parse(JSONUtils.getString((Map)taskJSON, (String)"updateTime"));
                            Map state = JSONUtils.getObject((Map)taskJSON, (String)"state");
                            DBTTaskDescriptor taskDescriptor = this.getRegistry().getTask(task);
                            if (taskDescriptor == null) {
                                log.error((Object)("Can't find task descriptor " + task));
                                continue;
                            }
                            TaskConfigurationImpl taskConfig = new TaskConfigurationImpl(taskDescriptor, id, label, description, createTime, updateTime);
                            taskConfig.setProperties(state);
                            List<TaskConfigurationImpl> list = this.tasks;
                            synchronized (list) {
                                this.tasks.add(taskConfig);
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"Error parsing task configuration", (Throwable)e);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading tasks configuration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfiguration() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFile configFile = this.getConfigFile(true);
        try {
            if (configFile.exists()) {
                IOUtils.makeFileBackup((File)configFile.getLocation().toFile());
            }
            if (this.tasks.isEmpty()) {
                configFile.delete(true, false, (IProgressMonitor)monitor);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error processing config file", (Throwable)e);
        }
        ByteArrayOutputStream dsConfigBuffer = new ByteArrayOutputStream(10000);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dsConfigBuffer, StandardCharsets.UTF_8);){
                Throwable throwable2 = null;
                Object var8_14 = null;
                try (JsonWriter jsonWriter = CONFIG_GSON.newJsonWriter((Writer)osw);){
                    List<TaskConfigurationImpl> list = this.tasks;
                    synchronized (list) {
                        this.serializeTasks((DBRProgressMonitor)new DefaultProgressMonitor((IProgressMonitor)monitor), jsonWriter);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        ByteArrayInputStream ifs = new ByteArrayInputStream(dsConfigBuffer.toByteArray());
        try {
            if (!configFile.exists()) {
                configFile.create((InputStream)ifs, true, (IProgressMonitor)monitor);
                configFile.setHidden(true);
            } else {
                configFile.setContents((InputStream)ifs, true, false, (IProgressMonitor)monitor);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error saving configuration to a file " + configFile.getFullPath()), (Throwable)e);
        }
    }

    private void serializeTasks(DBRProgressMonitor monitor, JsonWriter jsonWriter) throws IOException {
        jsonWriter.setIndent("\t");
        jsonWriter.beginObject();
        for (TaskConfigurationImpl task : this.tasks) {
            jsonWriter.name(task.getId());
            jsonWriter.beginObject();
            JSONUtils.field((JsonWriter)jsonWriter, (String)"task", (String)task.getDescriptor().getId());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"label", (String)task.getLabel());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"description", (String)task.getDescription());
            JSONUtils.field((JsonWriter)jsonWriter, (String)"createTime", (String)this.dateFormat.format(task.getCreateTime()));
            JSONUtils.field((JsonWriter)jsonWriter, (String)"updateTime", (String)this.dateFormat.format(task.getUpdateTime()));
            JSONUtils.serializeProperties((JsonWriter)jsonWriter, (String)"state", task.getProperties());
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    private IFile getConfigFile(boolean create) {
        return this.projectMetadata.getMetadataFolder(create).getFile(CONFIG_FILE);
    }
}

