/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;

public class SQLScriptContext {
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final Map<String, Object> pragmas = new HashMap<String, Object>();
    private Map<String, Object> statementPragmas;
    private final Map<String, Object> data = new HashMap<String, Object>();
    @Nullable
    private final SQLScriptContext parentContext;
    @NotNull
    private final DBPContextProvider contextProvider;
    @Nullable
    private final File sourceFile;
    @NotNull
    private final PrintWriter outputWriter;

    public SQLScriptContext(@Nullable SQLScriptContext parentContext, @NotNull DBPContextProvider contextProvider, @Nullable File sourceFile, @NotNull Writer outputWriter) {
        this.parentContext = parentContext;
        this.contextProvider = contextProvider;
        this.sourceFile = sourceFile;
        this.outputWriter = new PrintWriter(outputWriter);
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.contextProvider.getExecutionContext();
    }

    @Nullable
    public File getSourceFile() {
        return this.sourceFile;
    }

    public boolean hasVariable(String name) {
        if (this.variables.containsKey(name)) {
            return true;
        }
        return this.parentContext != null && this.parentContext.hasVariable(name);
    }

    public Object getVariable(String name) {
        Object value = this.variables.get(name);
        if (value == null && this.parentContext != null) {
            value = this.parentContext.getVariable(name);
        }
        return value;
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
        if (this.parentContext != null) {
            this.parentContext.setVariable(name, value);
        }
    }

    @NotNull
    public Map<String, Object> getPragmas() {
        return this.pragmas;
    }

    public void setStatementPragma(String name, Object value) {
        if (this.statementPragmas == null) {
            this.statementPragmas = new LinkedHashMap<String, Object>();
        }
        this.statementPragmas.put(name, value);
    }

    public Object getStatementPragma(String name) {
        return this.statementPragmas == null ? null : this.statementPragmas.get(name);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    @NotNull
    public PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    public void clearStatementContext() {
        this.statementPragmas = null;
    }

    public void copyFrom(SQLScriptContext context) {
        this.variables.clear();
        this.variables.putAll(context.variables);
        this.data.clear();
        this.data.putAll(context.data);
        this.pragmas.clear();
        this.pragmas.putAll(context.pragmas);
    }
}

