/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public final class DBFetchProgress {
    private DBRProgressMonitor monitor;
    private long startTime = System.currentTimeMillis();
    private long rowCount = 0L;
    private long lastMonitor = 0L;

    public DBFetchProgress(DBRProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void monitorRowFetch() {
        ++this.rowCount;
        if (DBFetchProgress.monitorFetchProgress(this.rowCount)) {
            this.monitor.subTask(String.valueOf(this.rowCount) + ModelMessages.model_jdbc__rows_fetched);
            this.monitor.worked((int)(this.rowCount - this.lastMonitor));
            this.lastMonitor = this.rowCount;
        }
    }

    public void dumpStatistics(DBCStatistics statistics) {
        statistics.setFetchTime(System.currentTimeMillis() - this.startTime);
        statistics.setRowsFetched(this.rowCount);
        statistics.addStatementsCount();
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public boolean isMaxRowsFetched(long maxRows) {
        return this.rowCount >= maxRows;
    }

    public static boolean monitorFetchProgress(long fetchedRows) {
        if (fetchedRows < 1000L) {
            return fetchedRows % 100L == 0L;
        }
        if (fetchedRows < 100000L) {
            return fetchedRows % 1000L == 0L;
        }
        return fetchedRows % 10000L == 0L;
    }
}

