/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDataManipulatorExt;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.serialize.DBPObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="databaseTransferConsumer")
public class DatabaseTransferConsumer
implements IDataTransferConsumer<DatabaseConsumerSettings, IDataTransferProcessor> {
    private static final Log log = Log.getLog(DatabaseTransferConsumer.class);
    private DBSDataContainer sourceObject;
    private DBSDataManipulator targetObject;
    private DatabaseConsumerSettings settings;
    private DatabaseMappingContainer containerMapping;
    private ColumnMapping[] columnMappings;
    private DBDAttributeBinding[] sourceBindings;
    private DBCExecutionContext targetContext;
    private DBCSession targetSession;
    private DBSDataManipulator.ExecuteBatch executeBatch;
    private long rowsExported = 0L;
    private boolean ignoreErrors = false;
    private List<DBSEntityAttribute> targetAttributes;
    private boolean useIsolatedConnection;

    public DatabaseTransferConsumer() {
    }

    public DatabaseTransferConsumer(DBSDataManipulator targetObject) {
        this.targetObject = targetObject;
    }

    @Override
    public DBSObject getDatabaseObject() {
        return this.targetObject;
    }

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        this.initExporter(session.getProgressMonitor());
        AbstractExecutionSource executionSource = new AbstractExecutionSource(this.sourceObject, this.targetContext, (Object)this);
        if (offset <= 0L && this.settings.isTruncateBeforeLoad() && (this.containerMapping == null || this.containerMapping.getMappingType() == DatabaseMappingType.existing)) {
            if ((this.targetObject.getSupportedFeatures() & 0x80000) != 0) {
                this.targetObject.truncateData(this.targetSession, (DBCExecutionSource)executionSource);
            } else {
                log.error((Object)("Table '" + this.targetObject.getName() + "' doesn't support truncate operation"));
            }
        }
        DBDAttributeBinding[] rsAttributes = DBUtils.makeLeafAttributeBindings((DBCSession)session, (DBSDataContainer)this.sourceObject, (DBCResultSet)resultSet);
        this.columnMappings = new ColumnMapping[rsAttributes.length];
        this.sourceBindings = rsAttributes;
        this.targetAttributes = new ArrayList<DBSEntityAttribute>(this.columnMappings.length);
        int i = 0;
        while (i < rsAttributes.length) {
            if (!this.isSkipColumn(rsAttributes[i])) {
                ColumnMapping columnMapping = new ColumnMapping(rsAttributes[i]);
                if (this.containerMapping == null) {
                    if (this.targetObject instanceof DBSEntity) {
                        try {
                            DBSEntityAttribute attribute = ((DBSEntity)this.targetObject).getAttribute(session.getProgressMonitor(), columnMapping.sourceAttr.getName());
                            if (attribute != null) {
                                columnMapping.targetAttr = new DatabaseMappingAttribute(null, (DBSAttributeBase)columnMapping.sourceAttr);
                                columnMapping.targetAttr.setTarget(attribute);
                                columnMapping.targetAttr.setMappingType(DatabaseMappingType.existing);
                            }
                        }
                        catch (DBException dBException) {
                            log.error((Object)"Error getting target attribute");
                        }
                    }
                    if (columnMapping.targetAttr == null) {
                        throw new DBCException("Can't resolve target attribute for [" + columnMapping.sourceAttr.getName() + "]");
                    }
                } else {
                    columnMapping.targetAttr = this.containerMapping.getAttributeMapping((DBSAttributeBase)columnMapping.sourceAttr);
                    if (columnMapping.targetAttr == null) {
                        throw new DBCException("Can't find target attribute [" + columnMapping.sourceAttr.getName() + "]");
                    }
                }
                if (columnMapping.targetAttr.getMappingType() != DatabaseMappingType.skip) {
                    DBSEntityAttribute targetAttr = columnMapping.targetAttr.getTarget();
                    if (targetAttr == null) {
                        if (columnMapping.targetAttr.getSource() instanceof DBSEntityAttribute) {
                            targetAttr = (DBSEntityAttribute)columnMapping.targetAttr.getSource();
                        } else {
                            throw new DBCException("Target attribute for [" + columnMapping.sourceAttr.getName() + "] wasn't resolved");
                        }
                    }
                    columnMapping.sourceValueHandler = columnMapping.sourceAttr.getValueHandler();
                    columnMapping.targetValueHandler = DBUtils.findValueHandler((DBPDataSource)this.targetSession.getDataSource(), (DBSTypedObject)targetAttr);
                    columnMapping.targetIndex = this.targetAttributes.size();
                    this.columnMappings[i] = columnMapping;
                    this.targetAttributes.add(targetAttr);
                }
            }
            ++i;
        }
        DBSAttributeBase[] attributes = this.targetAttributes.toArray(new DBSAttributeBase[0]);
        if (this.targetObject instanceof DBSDataManipulatorExt) {
            ((DBSDataManipulatorExt)this.targetObject).beforeDataChange(session, DBSManipulationType.INSERT, attributes, (DBCExecutionSource)executionSource);
        }
        this.executeBatch = this.targetObject.insertData(this.targetSession, attributes, null, (DBCExecutionSource)executionSource);
    }

    private boolean isSkipColumn(DBDAttributeBinding attr) {
        return attr.isPseudoAttribute() || !this.settings.isTransferAutoGeneratedColumns() && attr.isAutoGenerated();
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        Object[] rowValues = new Object[this.targetAttributes.size()];
        int i = 0;
        while (i < this.columnMappings.length) {
            ColumnMapping column = this.columnMappings[i];
            if (column != null && column.targetIndex >= 0) {
                Object attrValue = column.sourceValueHandler != null ? (column.sourceAttr instanceof DBDAttributeBindingCustom ? DBUtils.getAttributeValue((DBDAttributeBinding)column.sourceAttr, (DBDAttributeBinding[])this.sourceBindings, (Object[])rowValues) : column.sourceValueHandler.fetchValueObject(session, resultSet, (DBSTypedObject)column.sourceAttr, i)) : resultSet.getAttributeValue(i);
                DatabaseMappingAttribute targetAttr = column.targetAttr;
                rowValues[column.targetIndex] = column.targetValueHandler.getValueFromObject(this.targetSession, (DBSTypedObject)(targetAttr.getTarget() == null ? targetAttr.getSource() : targetAttr.getTarget()), attrValue, false);
            }
            ++i;
        }
        this.executeBatch.add(rowValues);
        ++this.rowsExported;
        this.insertBatch(false);
    }

    private void insertBatch(boolean force) throws DBCException {
        DBCTransactionManager txnManager;
        boolean needCommit;
        boolean bl = needCommit = force || this.rowsExported % (long)this.settings.getCommitAfterRows() == 0L;
        if (needCommit && this.executeBatch != null) {
            boolean retryInsert;
            do {
                retryInsert = false;
                try {
                    this.executeBatch.execute(this.targetSession);
                }
                catch (Throwable e) {
                    log.error((Object)"Error inserting row", e);
                    if (this.ignoreErrors) continue;
                    switch (DBWorkbench.getPlatformUI().showErrorStopRetryIgnore("Error occurred during data load", e, true)) {
                        case STOP: {
                            throw new DBCException("Can't insert row", e);
                        }
                        case RETRY: {
                            retryInsert = true;
                            break;
                        }
                        case IGNORE: {
                            retryInsert = false;
                            break;
                        }
                        case IGNORE_ALL: {
                            this.ignoreErrors = true;
                            retryInsert = false;
                        }
                    }
                }
            } while (retryInsert);
        }
        if (this.settings.isUseTransactions() && needCommit && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null && !txnManager.isAutoCommit()) {
            txnManager.commit(this.targetSession);
        }
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        try {
            if (this.rowsExported > 0L) {
                this.insertBatch(true);
            }
            if (this.executeBatch != null) {
                this.executeBatch.close();
                this.executeBatch = null;
            }
        }
        finally {
            if (this.targetObject instanceof DBSDataManipulatorExt) {
                ((DBSDataManipulatorExt)this.targetObject).afterDataChange(session, DBSManipulationType.INSERT, this.targetAttributes.toArray(new DBSAttributeBase[0]), (DBCExecutionSource)new AbstractExecutionSource(this.sourceObject, this.targetContext, (Object)this));
            }
        }
    }

    public void close() {
        this.closeExporter();
    }

    private void initExporter(DBRProgressMonitor monitor) throws DBCException {
        DBCTransactionManager txnManager;
        DBSObject targetDB = this.checkTargetContainer();
        DBPDataSourceContainer dataSourceContainer = targetDB.getDataSource().getContainer();
        if (!dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_IMPORT_DATA)) {
            throw new DBCException("Data transfer to database [" + dataSourceContainer.getName() + "] restricted by connection configuration");
        }
        try {
            this.useIsolatedConnection = this.settings.isOpenNewConnections() && !dataSourceContainer.getDriver().isEmbedded();
            this.targetContext = this.useIsolatedConnection ? DBUtils.getObjectOwnerInstance((DBSObject)targetDB).openIsolatedContext(monitor, "Data transfer consumer") : DBUtils.getDefaultContext((DBSObject)targetDB, (boolean)false);
        }
        catch (DBException e) {
            throw new DBCException("Error opening new connection", (Throwable)e);
        }
        this.targetSession = this.targetContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Data load");
        this.targetSession.enableLogging(false);
        if (this.settings.isUseTransactions() && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null) {
            txnManager.setAutoCommit(monitor, false);
        }
    }

    private DBSObject checkTargetContainer() throws DBCException {
        if (this.targetObject == null && this.settings.getContainer() == null) {
            throw new DBCException("Can't initialize database consumer. No target object and no taregt container");
        }
        this.containerMapping = this.sourceObject == null ? null : this.settings.getDataMapping(this.sourceObject);
        return this.targetObject == null ? this.settings.getContainer() : this.targetObject;
    }

    private void closeExporter() {
        try {
            if (this.targetSession != null) {
                this.targetSession.close();
                this.targetSession = null;
            }
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
        if (this.targetContext != null && this.useIsolatedConnection) {
            this.targetContext.close();
            this.targetContext = null;
        }
    }

    @Override
    public void initTransfer(DBSObject sourceObject, DatabaseConsumerSettings settings, IDataTransferConsumer.TransferParameters parameters, IDataTransferProcessor processor, Map<Object, Object> processorProperties) {
        this.sourceObject = (DBSDataContainer)sourceObject;
        this.settings = settings;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startTransfer(DBRProgressMonitor monitor) throws DBException {
        block25: {
            monitor.beginTask("Create necessary database objects", 1);
            try {
                dbObject = this.checkTargetContainer();
                hasNewObjects = false;
                if (this.containerMapping == null) break block25;
                container = this.settings.getContainer();
                if (container == null) {
                    throw new DBException("No target datasource - can't create target objects");
                }
                this.targetObject = this.containerMapping.getTarget();
                var5_5 = null;
                var6_7 = null;
                try {
                    session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)dbObject, (String)"Create target metadata");
                    try {
                        switch (DatabaseTransferConsumer.$SWITCH_TABLE$org$jkiss$dbeaver$tools$transfer$database$DatabaseMappingType()[this.containerMapping.getMappingType().ordinal()]) {
                            case 3: {
                                this.createTargetTable(session, this.containerMapping);
                                hasNewObjects = true;
                                ** break;
lbl20:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                for (DatabaseMappingAttribute attr : this.containerMapping.getAttributeMappings(monitor)) {
                                    if (attr.getMappingType() != DatabaseMappingType.create) continue;
                                    this.createTargetAttribute(session, attr);
                                    hasNewObjects = true;
                                }
                                break;
                            }
                            ** default:
lbl29:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                catch (Throwable var6_8) {
                    if (var5_5 == null) {
                        var5_5 = var6_8;
                    } else if (var5_5 != var6_8) {
                        var5_5.addSuppressed(var6_8);
                    }
                    throw var5_5;
                }
                if (!hasNewObjects) break block25;
                monitor.subTask("Refresh navigator model");
                this.settings.getContainerNode().refreshNode(monitor, (Object)this);
                switch (DatabaseTransferConsumer.$SWITCH_TABLE$org$jkiss$dbeaver$tools$transfer$database$DatabaseMappingType()[this.containerMapping.getMappingType().ordinal()]) {
                    case 3: {
                        newTarget = container.getChild(monitor, this.containerMapping.getTargetName());
                        if (newTarget == null) {
                            throw new DBCException("New table " + this.containerMapping.getTargetName() + " not found in container " + DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI));
                        }
                        if (!(newTarget instanceof DBSDataManipulator)) {
                            throw new DBCException("New table " + DBUtils.getObjectFullName((DBPNamedObject)newTarget, (DBPEvaluationContext)DBPEvaluationContext.UI) + " doesn't support data manipulation");
                        }
                        this.containerMapping.setTarget((DBSDataManipulator)newTarget);
                        this.containerMapping.setMappingType(DatabaseMappingType.existing);
                        this.targetObject = (DBSDataManipulator)newTarget;
                    }
                    case 2: {
                        for (DatabaseMappingAttribute attr : this.containerMapping.getAttributeMappings(monitor)) {
                            if (attr.getMappingType() != DatabaseMappingType.create) continue;
                            attr.updateMappingType(monitor);
                            if (attr.getTarget() != null) continue;
                            DatabaseTransferConsumer.log.debug((Object)("Can't find target attribute '" + attr.getTargetName() + "' in '" + this.containerMapping.getTargetName() + "'"));
                        }
                        break;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void createTargetTable(DBCSession session, DatabaseMappingContainer containerMapping) throws DBException {
        DBSObjectContainer schema = this.settings.getContainer();
        if (schema == null) {
            throw new DBException("No target container selected");
        }
        String sql = DatabaseTransferConsumer.generateTargetTableDDL(session.getProgressMonitor(), session.getDataSource(), schema, containerMapping);
        try {
            this.executeDDL(session, sql);
        }
        catch (DBCException e) {
            throw new DBCException("Can't create target table:\n" + sql, (Throwable)e);
        }
    }

    public static String generateTargetTableDDL(DBRProgressMonitor monitor, DBPDataSource dataSource, DBSObjectContainer schema, DatabaseMappingContainer containerMapping) throws DBException {
        if (containerMapping.getMappingType() == DatabaseMappingType.skip) {
            return "";
        }
        monitor.subTask("Create table " + containerMapping.getTargetName());
        StringBuilder sql = new StringBuilder(500);
        if (!(dataSource instanceof SQLDataSource)) {
            throw new DBException("Data source doesn't support SQL");
        }
        SQLDataSource targetDataSource = (SQLDataSource)dataSource;
        String tableName = DBObjectNameCaseTransformer.transformName((DBPDataSource)targetDataSource, (String)containerMapping.getTargetName());
        containerMapping.setTargetName(tableName);
        if (containerMapping.getMappingType() == DatabaseMappingType.create) {
            Collection identifier;
            sql.append("CREATE TABLE ");
            if (schema instanceof DBSSchema || schema instanceof DBSCatalog) {
                sql.append(DBUtils.getQuotedIdentifier((DBSObject)schema));
                sql.append(targetDataSource.getSQLDialect().getCatalogSeparator());
            }
            sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)targetDataSource, (String)tableName)).append("(\n");
            HashMap<DBSAttributeBase, DatabaseMappingAttribute> mappedAttrs = new HashMap<DBSAttributeBase, DatabaseMappingAttribute>();
            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                if (attr.getMappingType() != DatabaseMappingType.create) continue;
                if (!mappedAttrs.isEmpty()) {
                    sql.append(",\n");
                }
                sql.append("\t");
                DatabaseTransferConsumer.appendAttributeClause(dataSource, sql, attr);
                mappedAttrs.put(attr.getSource(), attr);
            }
            if (containerMapping.getSource() instanceof DBSEntity && !CommonUtils.isEmpty((Collection)(identifier = DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)containerMapping.getSource()))))) {
                boolean idMapped = true;
                for (DBSEntityAttribute idAttr : identifier) {
                    if (mappedAttrs.containsKey(idAttr)) continue;
                    idMapped = false;
                    break;
                }
                if (idMapped) {
                    sql.append(",\n\tPRIMARY KEY (");
                    boolean hasAttr = false;
                    for (DBSEntityAttribute idAttr : identifier) {
                        DatabaseMappingAttribute mappedAttr = (DatabaseMappingAttribute)mappedAttrs.get(idAttr);
                        if (hasAttr) {
                            sql.append(",");
                        }
                        sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)mappedAttr.getTargetName()));
                        hasAttr = true;
                    }
                    sql.append(")\n");
                }
            }
            sql.append(")");
        } else {
            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                if (attr.getMappingType() != DatabaseMappingType.create) continue;
                sql.append(DatabaseTransferConsumer.generateTargetAttributeDDL(dataSource, attr)).append(";\n");
            }
        }
        return sql.toString();
    }

    private static void appendAttributeClause(DBPDataSource dataSource, StringBuilder sql, DatabaseMappingAttribute attr) {
        sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)attr.getTargetName())).append(" ").append(attr.getTargetType(dataSource));
        if (SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource).supportsNullability() && attr.getSource().isRequired()) {
            sql.append(" NOT NULL");
        }
    }

    private void createTargetAttribute(DBCSession session, DatabaseMappingAttribute attribute) throws DBCException {
        session.getProgressMonitor().subTask("Create column " + DBUtils.getObjectFullName((DBPNamedObject)attribute.getParent().getTarget(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + attribute.getTargetName());
        String sql = DatabaseTransferConsumer.generateTargetAttributeDDL(session.getDataSource(), attribute);
        try {
            this.executeDDL(session, sql);
        }
        catch (DBCException e) {
            throw new DBCException("Can't create target column:\n" + sql, (Throwable)e);
        }
    }

    @NotNull
    private static String generateTargetAttributeDDL(DBPDataSource dataSource, DatabaseMappingAttribute attribute) {
        StringBuilder sql = new StringBuilder(500);
        sql.append("ALTER TABLE ").append(DBUtils.getObjectFullName((DBPNamedObject)attribute.getParent().getTarget(), (DBPEvaluationContext)DBPEvaluationContext.DDL)).append(" ADD ");
        DatabaseTransferConsumer.appendAttributeClause(dataSource, sql, attribute);
        return sql.toString();
    }

    private void executeDDL(DBCSession session, String sql) throws DBCException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBCStatement dbStat = DBUtils.makeStatement((DBCSession)session, (String)sql, (boolean)false);){
            dbStat.executeStatement();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
        if (txnManager != null && !txnManager.isAutoCommit()) {
            txnManager.commit(session);
        }
    }

    @Override
    public void finishTransfer(DBRProgressMonitor monitor, boolean last) {
        if (!last && this.settings.isOpenTableOnFinish() && this.containerMapping != null && this.containerMapping.getTarget() != null) {
            DBWorkbench.getPlatformUI().openEntityEditor((DBSObject)this.containerMapping.getTarget());
        }
    }

    public DBSDataManipulator getTargetObject() {
        return this.targetObject;
    }

    @Override
    public String getObjectName() {
        String targetName = null;
        if (this.targetObject != null) {
            targetName = DBUtils.getObjectFullName((DBPNamedObject)this.targetObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        if (this.settings == null) {
            return targetName;
        }
        if (targetName != null) {
            return targetName;
        }
        DatabaseMappingContainer dataMapping = this.settings.getDataMapping(this.sourceObject);
        if (dataMapping == null) {
            return "?";
        }
        targetName = dataMapping.getTargetName();
        switch (dataMapping.getMappingType()) {
            case create: {
                return String.valueOf(targetName) + " [Create]";
            }
            case existing: {
                for (DatabaseMappingAttribute attr : dataMapping.getAttributeMappings((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (attr.getMappingType() != DatabaseMappingType.create) continue;
                    return String.valueOf(targetName) + " [Alter]";
                }
                return targetName;
            }
            case skip: {
                return "[Skip]";
            }
        }
        return "?";
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.targetObject instanceof DBPImageProvider) {
            return DBValueFormatting.getObjectImage((DBPObject)this.targetObject);
        }
        return DBIcon.TREE_TABLE;
    }

    @Override
    public String getObjectContainerName() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getName() : "?";
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getDriver().getIcon() : null;
    }

    private DBPDataSourceContainer getDataSourceContainer() {
        if (this.targetObject != null) {
            return this.targetObject.getDataSource().getContainer();
        }
        DBSObjectContainer container = this.settings.getContainer();
        if (container != null) {
            return container.getDataSource().getContainer();
        }
        return null;
    }

    private static class ColumnMapping {
        DBDAttributeBinding sourceAttr;
        DatabaseMappingAttribute targetAttr;
        DBDValueHandler sourceValueHandler;
        DBDValueHandler targetValueHandler;
        int targetIndex = -1;

        private ColumnMapping(DBDAttributeBinding sourceAttr) {
            this.sourceAttr = sourceAttr;
        }
    }

    public static class ObjectSerializer
    implements DBPObjectSerializer<DatabaseTransferConsumer> {
        public void serializeObject(DatabaseTransferConsumer object, Map<String, Object> state) {
            if (object.targetObject instanceof DBSEntity) {
                state.put("entityId", DBUtils.getObjectFullId((DBSObject)object.targetObject));
            } else {
                log.error((Object)("Unsupported consumer data container: " + object.targetObject));
            }
        }

        public DatabaseTransferConsumer deserializeObject(Map<String, Object> state) {
            return null;
        }
    }
}

