/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

public class DataTransferJob
extends AbstractJob {
    private DataTransferSettings settings;
    private long elapsedTime;
    private boolean hasErrors;

    public DataTransferJob(DataTransferSettings settings) {
        super(DTMessages.data_transfer_wizard_job_name);
        this.settings = settings;
        this.setUser(true);
    }

    public DataTransferSettings getSettings() {
        return this.settings;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }

    public boolean belongsTo(Object family) {
        return family == this.settings;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        DataTransferPipe transferPipe;
        this.hasErrors = false;
        long startTime = System.currentTimeMillis();
        while ((transferPipe = this.settings.acquireDataPipe(monitor)) != null) {
            if (this.transferData(monitor, transferPipe)) continue;
            this.hasErrors = true;
        }
        this.elapsedTime = System.currentTimeMillis() - startTime;
        return Status.OK_STATUS;
    }

    private boolean transferData(DBRProgressMonitor monitor, DataTransferPipe transferPipe) {
        IDataTransferProducer producer = transferPipe.getProducer();
        IDataTransferConsumer consumer = transferPipe.getConsumer();
        this.settings.getNodeSettings(this.settings.getConsumer());
        this.setName(NLS.bind((String)DTMessages.data_transfer_wizard_job_container_name, (Object)CommonUtils.truncateString((String)producer.getObjectName(), (int)200), (Object)CommonUtils.truncateString((String)consumer.getObjectName(), (int)200)));
        IDataTransferSettings nodeSettings = this.settings.getNodeSettings(this.settings.getProducer());
        try {
            IDataTransferProcessor processor = this.settings.getProcessor() == null ? null : this.settings.getProcessor().getInstance();
            try {
                producer.transferData(monitor, consumer, processor, nodeSettings);
            }
            finally {
                consumer.finishTransfer(monitor, false);
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Data export error", e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

