/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTaskConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;

public class DatabaseTasksView
extends ViewPart {
    public static final String VIEW_ID = "org.jkiss.dbeaver.tasks";
    private Tree taskTree;
    private FilteredTree filteredTree;

    public void createPartControl(Composite parent) {
        Composite group = UIUtils.createComposite((Composite)parent, (int)1);
        this.filteredTree = new FilteredTree(group, 65536, (PatternFilter)new NamedObjectPatternFilter(), true);
        this.taskTree = this.filteredTree.getViewer().getTree();
        this.taskTree.setLayoutData((Object)new GridData(1808));
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof DBPProject) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT));
                    cell.setText(((DBPProject)element).getName());
                } else if (element instanceof TaskTypeInfo) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATA_TYPE));
                    cell.setText(((TaskTypeInfo)element).task.getName());
                } else if (element instanceof DBTTaskConfiguration) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_PACKAGE));
                    cell.setText(((DBTTaskConfiguration)element).getLabel());
                }
            }
        });
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof DBPProject) {
                    DBPProject project = (DBPProject)parentElement;
                    DBTTaskManager taskManager = project.getTaskManager();
                    DBTTaskDescriptor[] existingTaskTypes = taskManager.getExistingTaskTypes();
                    if (existingTaskTypes.length == 0) {
                        return null;
                    }
                    Object[] children = new TaskTypeInfo[existingTaskTypes.length];
                    int i = 0;
                    while (i < existingTaskTypes.length) {
                        children[i] = new TaskTypeInfo(project, existingTaskTypes[i]);
                        ++i;
                    }
                    return children;
                }
                if (parentElement instanceof TaskTypeInfo) {
                    return ((TaskTypeInfo)parentElement).project.getTaskManager().getTaskConfigurations(((TaskTypeInfo)parentElement).task);
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof DBPProject || element instanceof TaskTypeInfo;
            }
        });
        this.loadTasks();
    }

    public void setFocus() {
        this.taskTree.setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast(new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return "Database Tasks";
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    private void loadTasks() {
        ArrayList<DBPProject> projectsWithTasks = new ArrayList<DBPProject>();
        for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            DBTTaskManager taskManager = project.getTaskManager();
            DBTTaskDescriptor[] taskTypes = taskManager.getExistingTaskTypes();
            if (taskTypes.length == 0) continue;
            projectsWithTasks.add(project);
        }
        this.filteredTree.getViewer().setInput(projectsWithTasks);
        this.filteredTree.getViewer().expandAll();
    }

    public class NamedObjectPatternFilter
    extends PatternFilter {
        public NamedObjectPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DBPProject) {
                return this.wordMatches(((DBPProject)element).getName());
            }
            if (element instanceof DBTTaskDescriptor) {
                return this.wordMatches(((DBTTaskDescriptor)element).getName());
            }
            if (element instanceof DBTTaskConfiguration) {
                return this.wordMatches(((DBTTaskConfiguration)element).getLabel());
            }
            return true;
        }
    }

    private static class TaskTypeInfo {
        DBPProject project;
        DBTTaskDescriptor task;

        public TaskTypeInfo(DBPProject project, DBTTaskDescriptor task) {
            this.project = project;
            this.task = task;
        }
    }
}

