/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPResourceCreator;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.EmptyAction;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateBase;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectCreateNew
extends NavigatorHandlerObjectCreateBase
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerObjectCreateNew.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String objectType = event.getParameter("org.jkiss.dbeaver.core.object.type");
        boolean isFolder = CommonUtils.toBoolean((Object)event.getParameter("org.jkiss.dbeaver.core.object.folder"));
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        if (node != null) {
            Class newObjectType = null;
            if (objectType != null) {
                if (node instanceof DBNDatabaseNode) {
                    newObjectType = ((DBNDatabaseNode)node).getMeta().getSource().getObjectClass(objectType);
                } else {
                    try {
                        newObjectType = Class.forName(objectType);
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("Error detecting new object type " + objectType), (Throwable)e);
                    }
                }
            }
            this.createNewObject(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), node, newObjectType, null, isFolder);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        if (!updateUI) {
            return;
        }
        Object typeName = parameters.get("org.jkiss.dbeaver.core.object.typeName");
        Object objectIcon = parameters.get("org.jkiss.dbeaver.core.object.typeIcon");
        if (typeName != null) {
            element.setText(typeName.toString());
        } else {
            element.setText(NLS.bind((String)UINavigatorMessages.actions_navigator_create_new, (Object)NavigatorHandlerObjectCreateNew.getObjectTypeName(element)));
        }
        if (objectIcon != null) {
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)new DBIcon(objectIcon.toString())));
        } else {
            DBPImage image = NavigatorHandlerObjectCreateNew.getObjectTypeIcon(element);
            if (image == null) {
                image = DBIcon.TYPE_OBJECT;
            }
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)image));
        }
    }

    public static String getObjectTypeName(UIElement element) {
        DBNNode node = NavigatorUtils.getSelectedNode(element);
        if (node != null) {
            if (node instanceof DBNContainer && !(node instanceof DBNDataSource)) {
                return ((DBNContainer)node).getChildrenType();
            }
            return node.getNodeType();
        }
        return null;
    }

    public static DBPImage getObjectTypeIcon(UIElement element) {
        DBNNode node = NavigatorUtils.getSelectedNode(element);
        if (node != null) {
            if (node instanceof DBNDatabaseNode && node.getParentNode() instanceof DBNDatabaseFolder) {
                node = node.getParentNode();
            }
            if (node instanceof DBNDataSource) {
                return UIIcon.SQL_CONNECT;
            }
            if (node instanceof DBNDatabaseFolder) {
                List metaChildren = ((DBNDatabaseFolder)node).getMeta().getChildren(node);
                if (!CommonUtils.isEmpty((Collection)metaChildren)) {
                    return ((DBXTreeNode)metaChildren.get(0)).getIcon(null);
                }
                return null;
            }
            return node.getNodeIconDefault();
        }
        return null;
    }

    public static List<IContributionItem> fillCreateMenuItems(@Nullable IWorkbenchPartSite site, DBNNode node) {
        ArrayList<IContributionItem> createActions = new ArrayList<IContributionItem>();
        if (node instanceof DBNLocalFolder || node instanceof DBNProjectDatabases) {
            IContributionItem item = NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, DBPDataSourceContainer.class.getName(), ModelMessages.model_navigator_Connection, (DBPImage)UIIcon.SQL_NEW_CONNECTION, false);
            createActions.add(item);
        }
        if (node instanceof DBNDatabaseNode) {
            NavigatorHandlerObjectCreateNew.addDatabaseNodeCreateItems(site, createActions, (DBNDatabaseNode)node);
        }
        if (node instanceof DBNLocalFolder || node instanceof DBNProjectDatabases || node instanceof DBNDataSource) {
            createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.new.folder"));
        } else if (node instanceof DBNResource) {
            IResource resource;
            DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
            DBPResourceHandler handler = workspace.getResourceHandler(resource = ((DBNResource)node).getResource());
            if (handler instanceof DBPResourceCreator && (handler.getFeatures(resource) & 0x20) != 0) {
                createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.create.file"));
            }
            if (handler != null && (handler.getFeatures(resource) & 4) != 0) {
                createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.create.folder"));
            }
            if (resource instanceof IFolder) {
                if (site != null) {
                    createActions.add((IContributionItem)new Separator());
                }
                createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.link.file"));
                createActions.add(NavigatorHandlerObjectCreateNew.makeCommandContributionItem(site, "org.jkiss.dbeaver.core.resource.link.folder"));
            }
        }
        if (site != null) {
            if (!createActions.isEmpty() && !(createActions.get(createActions.size() - 1) instanceof Separator)) {
                createActions.add((IContributionItem)new Separator());
            }
            createActions.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)site, (String)"org.eclipse.ui.newWizard", (String)"Other ...", null));
        }
        return createActions;
    }

    private static void addDatabaseNodeCreateItems(@Nullable IWorkbenchPartSite site, List<IContributionItem> createActions, DBNDatabaseNode node) {
        block8: {
            List childNodeMetas;
            block7: {
                if (!(node instanceof DBNDatabaseFolder)) break block7;
                List metaChildren = ((DBNDatabaseFolder)node).getMeta().getChildren((DBNNode)node);
                if (CommonUtils.isEmpty((Collection)metaChildren)) break block8;
                Class nodeClass = ((DBNContainer)node).getChildrenClass();
                String nodeType = ((DBXTreeNode)metaChildren.get(0)).getChildrenType(node.getDataSource(), null);
                DBPImage nodeIcon = ((DBXTreeNode)metaChildren.get(0)).getIcon((DBNNode)node);
                if (nodeClass == null || nodeType == null || !NavigatorHandlerObjectCreateNew.isCreateSupported(node, nodeClass)) break block8;
                IContributionItem item = NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, nodeClass.getName(), nodeType, nodeIcon, false);
                createActions.add(item);
                break block8;
            }
            Class<?> nodeItemClass = node.getObject().getClass();
            DBPImage nodeIcon = node.getNodeIconDefault();
            if (node instanceof DBNDataSource) {
                nodeIcon = UIIcon.SQL_NEW_CONNECTION;
            }
            if (NavigatorHandlerObjectCreateNew.isCreateSupported(node.getParentNode() instanceof DBNDatabaseNode ? (DBNDatabaseNode)node.getParentNode() : null, nodeItemClass)) {
                createActions.add(NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, nodeItemClass.getName(), node.getNodeType(), nodeIcon, false));
            }
            if (!node.getDataSourceContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) {
                return;
            }
            if (site != null) {
                createActions.add((IContributionItem)new Separator());
            }
            if (!CommonUtils.isEmpty((Collection)(childNodeMetas = node.getMeta().getChildren((DBNNode)node)))) {
                for (DBXTreeNode childMeta : childNodeMetas) {
                    if (childMeta instanceof DBXTreeFolder) {
                        List folderChildMeta = childMeta.getChildren((DBNNode)node);
                        if (CommonUtils.isEmpty((Collection)folderChildMeta) || folderChildMeta.size() != 1 || !(folderChildMeta.get(0) instanceof DBXTreeItem)) continue;
                        NavigatorHandlerObjectCreateNew.addChildNodeCreateItem(site, createActions, node, (DBXTreeItem)folderChildMeta.get(0));
                        continue;
                    }
                    if (!(childMeta instanceof DBXTreeItem)) continue;
                    NavigatorHandlerObjectCreateNew.addChildNodeCreateItem(site, createActions, node, (DBXTreeItem)childMeta);
                }
            }
        }
    }

    private static boolean addChildNodeCreateItem(@Nullable IWorkbenchPartSite site, List<IContributionItem> createActions, DBNDatabaseNode node, DBXTreeItem childMeta) {
        if (childMeta.isVirtual()) {
            return false;
        }
        Class objectClass = node.getChildrenClass(childMeta);
        if (objectClass != null) {
            if (!NavigatorHandlerObjectCreateNew.isCreateSupported(node, objectClass)) {
                return false;
            }
            String typeName = childMeta.getNodeType(node.getDataSource(), null);
            if (typeName != null) {
                IContributionItem item = NavigatorHandlerObjectCreateNew.makeCreateContributionItem(site, objectClass.getName(), typeName, childMeta.getIcon(null), true);
                createActions.add(item);
                return true;
            }
        }
        return false;
    }

    private static boolean isCreateSupported(DBNDatabaseNode parentNode, Class<?> objectClass) {
        DBEObjectMaker objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(objectClass, DBEObjectMaker.class);
        return objectMaker != null && objectMaker.canCreateObject(parentNode == null ? null : parentNode.getValueObject());
    }

    private static IContributionItem makeCommandContributionItem(@Nullable IWorkbenchPartSite site, String commandId) {
        if (site == null) {
            return new ActionContributionItem((IAction)new EmptyAction(commandId));
        }
        return ActionUtils.makeCommandContribution((IServiceLocator)site, (String)commandId);
    }

    private static IContributionItem makeCreateContributionItem(@Nullable IWorkbenchPartSite site, String objectType, String objectTypeName, DBPImage objectIcon, boolean isFolder) {
        if (site == null) {
            return new ActionContributionItem((IAction)new EmptyAction(objectType));
        }
        CommandContributionItemParameter params = new CommandContributionItemParameter((IServiceLocator)site, "org.jkiss.dbeaver.core.object.create", "org.jkiss.dbeaver.core.object.create", 8);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.jkiss.dbeaver.core.object.type", objectType);
        parameters.put("org.jkiss.dbeaver.core.object.typeName", objectTypeName);
        if (objectIcon != null) {
            parameters.put("org.jkiss.dbeaver.core.object.typeIcon", objectIcon.getLocation());
        }
        if (isFolder) {
            parameters.put("org.jkiss.dbeaver.core.object.folder", String.valueOf(true));
        }
        params.parameters = parameters;
        return new CommandContributionItem(params);
    }

    private static boolean isReadOnly(DBSObject object) {
        if (object == null) {
            return true;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null || dataSource.getContainer().isConnectionReadOnly();
    }

    public static class MenuCreateContributor
    extends CompoundContributionItem {
        private static final IContributionItem[] EMPTY_MENU = new IContributionItem[0];

        protected IContributionItem[] getContributionItems() {
            IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
            IWorkbenchPart activePart = activePage.getActivePart();
            if (activePart == null) {
                return EMPTY_MENU;
            }
            IWorkbenchPartSite site = activePart.getSite();
            DBNNode node = NavigatorUtils.getSelectedNode(site.getSelectionProvider());
            List<IContributionItem> createActions = NavigatorHandlerObjectCreateNew.fillCreateMenuItems(site, node);
            return createActions.toArray(new IContributionItem[0]);
        }
    }
}

