/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.task.DBTTaskDescriptor;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.task.EditTaskConfigurationDialog;

public class DataTransferWizardDialog
extends ActiveWizardDialog {
    private static final int SAVE_TASK_BTN_ID = 1000;

    private DataTransferWizardDialog(IWorkbenchWindow window, DataTransferWizard wizard) {
        this(window, wizard, null);
    }

    private DataTransferWizardDialog(IWorkbenchWindow window, DataTransferWizard wizard, IStructuredSelection selection) {
        super(window, (IWizard)wizard, selection);
        this.setShellStyle(0xCF0 | DataTransferWizardDialog.getDefaultOrientation());
        this.setHelpAvailable(false);
    }

    protected DataTransferWizard getWizard() {
        return (DataTransferWizard)super.getWizard();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button cancelButton = this.getButton(1);
        cancelButton.setText(IDialogConstants.CLOSE_LABEL);
        Button finishButton = this.getButton(16);
        finishButton.setText(UIMessages.button_start);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            this.saveConfigurationAsTask();
            return;
        }
        super.buttonPressed(buttonId);
    }

    public void updateButtons() {
        super.updateButtons();
        Button saveAsButton = this.getButton(1000);
        if (saveAsButton != null) {
            saveAsButton.setEnabled(this.getWizard().canFinish());
        }
    }

    private void saveConfigurationAsTask() {
        DBTTaskManager taskManager = this.getWizard().getProject().getTaskManager();
        DBTTaskDescriptor task = taskManager.getRegistry().getTask(this.getWizard().getTaskId());
        if (task == null) {
            DBWorkbench.getPlatformUI().showError("Create task", "Task " + this.getWizard().getTaskId() + " not found");
            return;
        }
        this.getWizard().getSettings();
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        this.getWizard().saveState(state);
        EditTaskConfigurationDialog dialog = new EditTaskConfigurationDialog(this.getShell(), this.getWizard().getProject(), task, state);
        dialog.open();
    }

    public static int openWizard(@NotNull IWorkbenchWindow workbenchWindow, @Nullable Collection<IDataTransferProducer> producers, @Nullable Collection<IDataTransferConsumer> consumers) {
        DataTransferWizard wizard = new DataTransferWizard(producers, consumers, null);
        DataTransferWizardDialog dialog = new DataTransferWizardDialog(workbenchWindow, wizard);
        return dialog.open();
    }

    public static int openWizard(@NotNull IWorkbenchWindow workbenchWindow, @Nullable Collection<IDataTransferProducer> producers, @Nullable Collection<IDataTransferConsumer> consumers, @Nullable IStructuredSelection selection) {
        DataTransferWizard wizard = new DataTransferWizard(producers, consumers, null);
        DataTransferWizardDialog dialog = new DataTransferWizardDialog(workbenchWindow, wizard, selection);
        return dialog.open();
    }

    public static int openWizard(@NotNull IWorkbenchWindow workbenchWindow, @NotNull Map<String, Object> state) {
        DataTransferWizard wizard = new DataTransferWizard(state);
        DataTransferWizardDialog dialog = new DataTransferWizardDialog(workbenchWindow, wizard, null);
        return dialog.open();
    }
}

