/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.DataTransferJob;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIActivator;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferConfiguratorRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferNodeConfiguratorDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageType;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferPageFinal;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferPagePipes;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferPageSettings;
import org.jkiss.dbeaver.ui.DialogSettingsMap;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferWizard
extends BaseWizard
implements IExportWizard,
IImportWizard {
    private static final String RS_EXPORT_WIZARD_DIALOG_SETTINGS = "DataTransfer";
    private DataTransferSettings settings;
    private IStructuredSelection currentSelection;
    private Map<Class, NodePageSettings> nodeSettings = new LinkedHashMap<Class, NodePageSettings>();

    public DataTransferWizard(Map<String, Object> state) {
        this(DataTransferWizard.getNodesFromLocation(state, "producers", IDataTransferProducer.class), DataTransferWizard.getNodesFromLocation(state, "consumers", IDataTransferConsumer.class), JSONUtils.getObject(state, (String)"configuration"));
    }

    private static <T> List<T> getNodesFromLocation(Map<String, Object> config, String nodeType, Class<T> nodeClass) {
        ArrayList<T> result = new ArrayList<T>();
        Object nodeList = config.get(nodeType);
        if (nodeList instanceof Collection) {
            for (Object nodeObj : (Collection)nodeList) {
                Object node;
                if (!(nodeObj instanceof Map) || !nodeClass.isInstance(node = JSONUtils.deserializeObject((Map)((Map)nodeObj)))) continue;
                result.add(nodeClass.cast(node));
            }
        }
        return result;
    }

    DataTransferWizard(@Nullable Collection<IDataTransferProducer> producers, @Nullable Collection<IDataTransferConsumer> consumers, @Nullable Map<String, Object> configuration) {
        DataTransferNodeDescriptor node;
        this.settings = new DataTransferSettings(producers, consumers);
        this.setDialogSettings(UIUtils.getSettingsSection((IDialogSettings)DTUIActivator.getDefault().getDialogSettings(), (String)RS_EXPORT_WIZARD_DIALOG_SETTINGS));
        List objectTypes = this.settings.getSourceObjects();
        ArrayList<DataTransferNodeDescriptor> nodes = new ArrayList<DataTransferNodeDescriptor>();
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        if (CommonUtils.isEmpty(producers)) {
            nodes.addAll(registry.getAvailableProducers((Collection)objectTypes));
        } else {
            for (IDataTransferProducer source : producers) {
                node = registry.getNodeByType(source.getClass());
                if (node == null || nodes.contains(node)) continue;
                nodes.add(node);
            }
        }
        if (CommonUtils.isEmpty(consumers)) {
            nodes.addAll(registry.getAvailableConsumers((Collection)objectTypes));
        } else {
            for (IDataTransferConsumer target : consumers) {
                node = registry.getNodeByType(target.getClass());
                if (node == null || nodes.contains(node)) continue;
                nodes.add(node);
            }
        }
        for (DataTransferNodeDescriptor node2 : nodes) {
            this.addNodeSettings(node2);
        }
        if (configuration != null) {
            Map configMap = JSONUtils.getObject(configuration, (String)"configuration");
            this.loadConfiguration(UIUtils.getDefaultRunnableContext(), configMap);
        } else {
            this.loadSettings();
        }
    }

    public DBPProject getProject() {
        return NavigatorUtils.getSelectedProject();
    }

    public String getTaskId() {
        if (this.getSettings().isProducerOptional()) {
            return "dataImport";
        }
        return "dataExport";
    }

    public IStructuredSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public DataTransferSettings getSettings() {
        return this.settings;
    }

    public <T extends IDataTransferSettings> T getPageSettings(IWizardPage page, Class<T> type) {
        return (T)((IDataTransferSettings)type.cast(this.getNodeSettings(page)));
    }

    public boolean isProfileSelectorVisible() {
        return true;
    }

    public void addPages() {
        super.addPages();
        if (this.settings.isConsumerOptional() || this.settings.isProducerOptional()) {
            this.addPage((IWizardPage)new DataTransferPagePipes());
        }
        this.addWizardPages(this);
        this.addPage((IWizardPage)new DataTransferPageFinal());
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.setWindowTitle(DTMessages.data_transfer_wizard_name);
        this.setNeedsProgressMonitor(true);
        this.currentSelection = currentSelection;
    }

    @Nullable
    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int curIndex = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                curIndex = i;
                break;
            }
            ++i;
        }
        if (curIndex == pages.length - 1) {
            return null;
        }
        if (curIndex != -1) {
            i = curIndex + 1;
            while (i < pages.length) {
                if (this.isPageValid(pages[i])) {
                    return pages[i];
                }
                ++i;
            }
        }
        return pages[pages.length - 1];
    }

    @Nullable
    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int curIndex = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                curIndex = i;
                break;
            }
            ++i;
        }
        if (curIndex == 0) {
            return null;
        }
        if (curIndex != -1) {
            i = curIndex - 1;
            while (i > 0) {
                if (this.isPageValid(pages[i])) {
                    return pages[i];
                }
                --i;
            }
        }
        return pages[0];
    }

    public boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (this.isPageValid(page) && !page.isPageComplete()) {
                return false;
            }
            if (page instanceof DataTransferPageFinal && !((DataTransferPageFinal)page).isActivated()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean performFinish() {
        this.saveSettings();
        DTUIActivator.getDefault().saveDialogSettings();
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                try {
                    for (DataTransferPipe pipe : this.settings.getDataPipes()) {
                        pipe.getConsumer().startTransfer(monitor);
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Transfer init failed", "Can't start data transfer", e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.executeJobs();
        return true;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
    }

    private void loadSettings() {
        this.loadConfiguration(this.getRunnableContext(), (Map<String, Object>)new DialogSettingsMap(this.getDialogSettings()));
    }

    private void saveSettings() {
        this.saveConfiguration((Map<String, Object>)new DialogSettingsMap(this.getDialogSettings()));
    }

    private void executeJobs() {
        int totalJobs = this.settings.getDataPipes().size();
        if (totalJobs > this.settings.getMaxJobCount()) {
            totalJobs = this.settings.getMaxJobCount();
        }
        int i = 0;
        while (i < totalJobs) {
            final DataTransferJob job = new DataTransferJob(this.settings);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    UIUtils.asyncExec(() -> {
                        Display.getCurrent().beep();
                        long time = job.getElapsedTime();
                        boolean hasErrors = job.isHasErrors();
                        DBPPlatformUI platformUI = DBWorkbench.getPlatformUI();
                        if (time > platformUI.getLongOperationTimeout() * 1000L) {
                            platformUI.notifyAgent("Data transfer completed", !hasErrors ? 1 : 4);
                        }
                        if (DataTransferWizard.this.settings.isShowFinalMessage() && !hasErrors) {
                            UIUtils.showMessageBox(null, (String)DTMessages.data_transfer_wizard_name, (String)("Data transfer completed (" + RuntimeUtils.formatExecutionTime((long)time) + ")"), (int)2);
                        }
                    });
                }
            });
            job.schedule();
            ++i;
        }
    }

    private void addNodeSettings(DataTransferNodeDescriptor node) {
        if (node == null) {
            return;
        }
        Class nodeClass = node.getNodeClass();
        if (this.nodeSettings.containsKey(nodeClass)) {
            return;
        }
        DataTransferNodeConfiguratorDescriptor configurator = DataTransferConfiguratorRegistry.getInstance().getConfigurator(node.getId());
        this.nodeSettings.put(nodeClass, new NodePageSettings(node, configurator, this.settings.isConsumerOptional(), this.settings.isProducerOptional()));
    }

    void addWizardPages(DataTransferWizard wizard) {
        IWizardPage page;
        int n;
        int n2;
        IWizardPage[] iWizardPageArray;
        ArrayList<IWizardPage> settingPages = new ArrayList<IWizardPage>();
        for (NodePageSettings nodePageSettings : this.nodeSettings.values()) {
            iWizardPageArray = nodePageSettings.pages;
            n2 = nodePageSettings.pages.length;
            n = 0;
            while (n < n2) {
                page = iWizardPageArray[n];
                if (nodePageSettings.nodeConfigurator != null && nodePageSettings.nodeConfigurator.getPageDescriptor(page).getPageType() != DataTransferPageType.PREVIEW) {
                    wizard.addPage(page);
                }
                ++n;
            }
            if (nodePageSettings.settingsPage == null) continue;
            settingPages.add(nodePageSettings.settingsPage);
        }
        if (!CommonUtils.isEmpty(settingPages)) {
            wizard.addPage((IWizardPage)new DataTransferPageSettings());
        }
        for (NodePageSettings nodePageSettings : this.nodeSettings.values()) {
            iWizardPageArray = nodePageSettings.pages;
            n2 = nodePageSettings.pages.length;
            n = 0;
            while (n < n2) {
                page = iWizardPageArray[n];
                if (nodePageSettings.nodeConfigurator != null && nodePageSettings.nodeConfigurator.getPageDescriptor(page).getPageType() == DataTransferPageType.PREVIEW) {
                    wizard.addPage(page);
                }
                ++n;
            }
        }
    }

    public boolean isPageValid(IWizardPage page) {
        return page instanceof DataTransferPageSettings || this.isPageValid(page, this.settings.getProducer()) || this.isPageValid(page, this.settings.getConsumer());
    }

    private boolean isPageValid(IWizardPage page, DataTransferNodeDescriptor node) {
        NodePageSettings nodePageSettings;
        NodePageSettings nodePageSettings2 = nodePageSettings = node == null ? null : this.nodeSettings.get(node.getNodeClass());
        if (nodePageSettings != null && ArrayUtils.contains((Object[])nodePageSettings.pages, (Object)page)) {
            for (NodePageSettings ns : this.nodeSettings.values()) {
                DataTransferPageDescriptor pd;
                DataTransferPageDescriptor dataTransferPageDescriptor = pd = ns.nodeConfigurator == null ? null : ns.nodeConfigurator.getPageDescriptor(page);
                if (pd == null) continue;
                if (pd.getProducerType() != null && this.settings.getProducer() != null && !this.settings.getProducer().getId().equals(pd.getProducerType())) {
                    return false;
                }
                if (pd.getConsumerType() == null || this.settings.getConsumer() == null || this.settings.getConsumer().getId().equals(pd.getConsumerType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    NodePageSettings getNodeInfo(IDataTransferNode node) {
        return this.nodeSettings.get(node.getClass());
    }

    public IDataTransferSettings getNodeSettings(IWizardPage page) {
        for (NodePageSettings nodePageSettings : this.nodeSettings.values()) {
            if (page == nodePageSettings.settingsPage) {
                return this.settings.getNodeSettings(nodePageSettings.sourceNode);
            }
            if (nodePageSettings.pages == null) continue;
            IWizardPage[] iWizardPageArray = nodePageSettings.pages;
            int n = nodePageSettings.pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage nodePage = iWizardPageArray[n2];
                if (nodePage == page) {
                    return this.settings.getNodeSettings(nodePageSettings.sourceNode);
                }
                ++n2;
            }
        }
        return null;
    }

    public IDataTransferSettings getNodeSettings(IDataTransferNode node) {
        NodePageSettings nodePageSettings = this.nodeSettings.get(node.getClass());
        return nodePageSettings == null ? null : this.settings.getNodeSettings(nodePageSettings.sourceNode);
    }

    private void loadConfiguration(DBRRunnableContext runnableContext, Map<String, Object> config) {
        String processorId;
        this.settings.setMaxJobCount(CommonUtils.toInt((Object)config.get("maxJobCount"), (int)1));
        this.settings.setShowFinalMessage(CommonUtils.getBoolean((Object)config.get("showFinalMessage"), (boolean)this.settings.isShowFinalMessage()));
        if (this.settings.isConsumerOptional() || this.settings.isProducerOptional()) {
            DataTransferNodeDescriptor producerNode;
            String producerId;
            DataTransferNodeDescriptor consumerNode;
            String consumerId;
            DataTransferNodeDescriptor savedConsumer = null;
            DataTransferNodeDescriptor savedProducer = null;
            DataTransferNodeDescriptor savedNode = null;
            if (this.settings.isConsumerOptional() && !CommonUtils.isEmpty((String)(consumerId = CommonUtils.toString((Object)config.get("consumer")))) && (consumerNode = DataTransferRegistry.getInstance().getNodeById(consumerId)) != null) {
                savedNode = savedConsumer = consumerNode;
                this.settings.setConsumer(savedConsumer);
            }
            if (this.settings.isProducerOptional() && !CommonUtils.isEmpty((String)(producerId = CommonUtils.toString((Object)config.get("producer")))) && (producerNode = DataTransferRegistry.getInstance().getNodeById(producerId)) != null) {
                savedNode = savedProducer = producerNode;
                this.settings.setProducer(savedProducer);
            }
            DataTransferProcessorDescriptor savedProcessor = null;
            if (savedNode != null && !CommonUtils.isEmpty((String)(processorId = CommonUtils.toString((Object)config.get("processor"))))) {
                savedProcessor = savedNode.getProcessor(processorId);
            }
            if (savedConsumer != null) {
                this.settings.selectConsumer(savedConsumer, savedProcessor, false);
            }
            if (savedProducer != null) {
                this.settings.selectProducer(savedProducer, savedProcessor, false);
            }
        }
        for (Map.Entry<Class, NodePageSettings> entry : this.nodeSettings.entrySet()) {
            Map nodeSection = JSONUtils.getObject(config, (String)entry.getKey().getSimpleName());
            IDataTransferSettings settings = this.settings.getNodeSettings(entry.getValue().sourceNode);
            if (settings == null) continue;
            settings.loadSettings(runnableContext, this.settings, nodeSection);
        }
        Map processorsSection = JSONUtils.getObject(config, (String)"processors");
        for (Map.Entry procIter : processorsSection.entrySet()) {
            int divPos;
            Map procSection = (Map)procIter.getValue();
            processorId = (String)procIter.getKey();
            String nodeId = CommonUtils.toString(procSection.get("@node"));
            if (CommonUtils.isEmpty((String)nodeId) && (divPos = processorId.indexOf(58)) != -1) {
                nodeId = processorId.substring(0, divPos);
                processorId = processorId.substring(divPos + 1);
            }
            String propNamesId = CommonUtils.toString(procSection.get("@propNames"));
            DataTransferNodeDescriptor node = DataTransferRegistry.getInstance().getNodeById(nodeId);
            if (node == null) continue;
            HashMap props = new HashMap();
            DataTransferProcessorDescriptor nodeProcessor = node.getProcessor(processorId);
            if (nodeProcessor == null) continue;
            for (String prop : CommonUtils.splitString((String)propNamesId, (char)',')) {
                props.put(prop, procSection.get(prop));
            }
            this.settings.getProcessorPropsHistory().put(nodeProcessor, props);
            NodePageSettings nodePageSettings = this.nodeSettings.get(node.getNodeClass());
        }
    }

    void saveState(Map<String, Object> state) {
        DataTransferWizard.saveNodesLocation(state, this.settings.getInitProducers(), "producers");
        DataTransferWizard.saveNodesLocation(state, (IDataTransferNode[])this.settings.getInitConsumers(), "consumers");
        state.put("configuration", this.saveConfiguration(new LinkedHashMap<String, Object>()));
    }

    private static void saveNodesLocation(Map<String, Object> state, IDataTransferNode[] nodes, String nodeType) {
        if (nodes != null) {
            ArrayList<Map> inputObjects = new ArrayList<Map>();
            IDataTransferNode[] iDataTransferNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IDataTransferNode inputObject = iDataTransferNodeArray[n2];
                inputObjects.add(JSONUtils.serializeObject((Object)inputObject));
                ++n2;
            }
            state.put(nodeType, inputObjects);
        }
    }

    Map<String, Object> saveConfiguration(Map<String, Object> config) {
        config.put("maxJobCount", this.settings.getMaxJobCount());
        config.put("showFinalMessage", this.settings.isShowFinalMessage());
        for (Map.Entry<Class, NodePageSettings> entry : this.nodeSettings.entrySet()) {
            LinkedHashMap nodeSection = new LinkedHashMap();
            config.put(entry.getKey().getSimpleName(), nodeSection);
            IDataTransferSettings settings = this.settings.getNodeSettings(entry.getValue().sourceNode);
            if (settings == null) continue;
            settings.saveSettings(nodeSection);
        }
        if (this.settings.getProducer() != null) {
            config.put("producer", this.settings.getProducer().getId());
        }
        if (this.settings.getConsumer() != null) {
            config.put("consumer", this.settings.getConsumer().getId());
        }
        if (this.settings.getProcessor() != null) {
            config.put("processor", this.settings.getProcessor().getId());
        }
        LinkedHashMap processorsSection = new LinkedHashMap();
        config.put("processors", processorsSection);
        for (DataTransferProcessorDescriptor procDescriptor : this.settings.getProcessorPropsHistory().keySet()) {
            LinkedHashMap<String, String> procSettings = new LinkedHashMap<String, String>();
            processorsSection.put(procDescriptor.getFullId(), procSettings);
            Map props = (Map)this.settings.getProcessorPropsHistory().get(procDescriptor);
            if (CommonUtils.isEmpty((Map)props)) continue;
            StringBuilder propNames = new StringBuilder();
            for (Map.Entry prop : props.entrySet()) {
                propNames.append(prop.getKey()).append(',');
            }
            procSettings.put("@propNames", propNames.toString());
            for (Map.Entry prop : props.entrySet()) {
                procSettings.put(CommonUtils.toString(prop.getKey()), CommonUtils.toString(prop.getValue()));
            }
        }
        return config;
    }

    public static class NodePageSettings {
        DataTransferNodeDescriptor sourceNode;
        DataTransferNodeConfiguratorDescriptor nodeConfigurator;
        IWizardPage[] pages;
        IWizardPage settingsPage;

        private NodePageSettings(DataTransferNodeDescriptor sourceNode, DataTransferNodeConfiguratorDescriptor nodeConfigurator, boolean consumerOptional, boolean producerOptional) {
            this.sourceNode = sourceNode;
            this.nodeConfigurator = nodeConfigurator;
            this.pages = nodeConfigurator == null ? new IWizardPage[]{} : nodeConfigurator.createWizardPages(consumerOptional, producerOptional, false);
            IWizardPage[] sPages = nodeConfigurator == null ? new IWizardPage[]{} : nodeConfigurator.createWizardPages(consumerOptional, producerOptional, true);
            this.settingsPage = sPages.length == 0 ? null : sPages[0];
        }
    }
}

