/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectDDLExtension;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.sql.translate.SQLTranslateContext;
import org.jkiss.dbeaver.model.sql.translate.SQLTranslator;
import org.jkiss.utils.CommonUtils;

public class SQLQueryTranslator
implements SQLTranslator {
    @NotNull
    private SQLTranslateContext sqlTranslateContext;

    public SQLQueryTranslator(@NotNull SQLTranslateContext sqlTranslateContext) {
        this.sqlTranslateContext = sqlTranslateContext;
    }

    @NotNull
    public static String translateScript(@NotNull SQLDialect sourceDialect, @NotNull SQLDialect targetDialect, @NotNull DBPPreferenceStore preferenceStore, @NotNull String script) throws DBException {
        SQLTranslateContext context = new SQLTranslateContext(sourceDialect, targetDialect, preferenceStore);
        List<SQLScriptElement> sqlScriptElements = SQLScriptParser.parseScript(null, sourceDialect, preferenceStore, script);
        ArrayList<? extends SQLScriptElement> result = new ArrayList<SQLScriptElement>();
        SQLQueryTranslator defaultSQLQueryTranslator = new SQLQueryTranslator(context);
        for (SQLScriptElement element : sqlScriptElements) {
            result.addAll(defaultSQLQueryTranslator.translate(element));
        }
        String scriptDelimiter = targetDialect.getScriptDelimiters()[0];
        StringBuilder sql = new StringBuilder();
        for (SQLScriptElement sQLScriptElement : result) {
            sql.append(sQLScriptElement.getText());
            sql.append(scriptDelimiter).append("\n");
        }
        return sql.toString();
    }

    @Override
    @NotNull
    public List<? extends SQLScriptElement> translate(@NotNull SQLScriptElement element) throws DBException {
        if (element instanceof SQLQuery) {
            return this.translateQuery((SQLQuery)element);
        }
        return Collections.singletonList(element);
    }

    @NotNull
    private List<? extends SQLScriptElement> translateQuery(@NotNull SQLQuery query) {
        Statement statement = query.getStatement();
        if (statement != null) {
            return this.translateStatement(query, statement);
        }
        return Collections.singletonList(query);
    }

    @NotNull
    protected List<? extends SQLScriptElement> translateStatement(@NotNull SQLQuery query, @NotNull Statement statement) {
        ArrayList<SQLQuery> extraQueries;
        block35: {
            extraQueries = null;
            if (!(statement instanceof CreateTable)) break block35;
            boolean defChanged = false;
            CreateTable createTable = (CreateTable)statement;
            SQLDialect targetDialect = this.sqlTranslateContext.getTargetDialect();
            SQLDialectDDLExtension extendedDialect = null;
            if (targetDialect instanceof SQLDialectDDLExtension) {
                extendedDialect = (SQLDialectDDLExtension)targetDialect;
            }
            if (extendedDialect != null && extendedDialect.supportsCreateIfExists()) {
                createTable.setIfNotExists(false);
                defChanged = true;
            }
            for (ColumnDefinition cd : createTable.getColumnDefinitions()) {
                String newDataType = null;
                switch (cd.getColDataType().getDataType().toUpperCase(Locale.ENGLISH)) {
                    case "CLOB": {
                        newDataType = extendedDialect != null ? extendedDialect.getClobDataType() : "varchar";
                        break;
                    }
                    case "TEXT": {
                        String dialectName = targetDialect.getDialectName().toLowerCase();
                        if (extendedDialect == null || !dialectName.equals("oracle") && !dialectName.equals("sqlserver")) break;
                        newDataType = extendedDialect.getClobDataType();
                        break;
                    }
                    case "TIMESTAMP": {
                        if (extendedDialect == null) break;
                        newDataType = extendedDialect.getTimestampDataType();
                        break;
                    }
                    case "BIGINT": {
                        if (extendedDialect == null) break;
                        newDataType = extendedDialect.getBigIntegerType();
                        break;
                    }
                }
                if (newDataType != null) {
                    cd.getColDataType().setDataType(newDataType);
                    defChanged = true;
                }
                if (CommonUtils.isEmpty((Collection)cd.getColumnSpecs())) continue;
                for (String columnSpec : new ArrayList(cd.getColumnSpecs())) {
                    switch (columnSpec.toUpperCase(Locale.ENGLISH)) {
                        case "AUTO_INCREMENT": 
                        case "IDENTITY": {
                            if (!targetDialect.supportsColumnAutoIncrement()) {
                                String sequenceName = String.valueOf(CommonUtils.escapeIdentifier((String)createTable.getTable().getName())) + "_" + CommonUtils.escapeIdentifier((String)cd.getColumnName());
                                cd.getColumnSpecs().remove(columnSpec);
                                cd.getColumnSpecs().add("DEFAULT");
                                cd.getColumnSpecs().add("NEXTVAL('" + sequenceName + "')");
                                defChanged = true;
                                String createSeqQuery = "CREATE SEQUENCE " + sequenceName;
                                if (extraQueries == null) {
                                    extraQueries = new ArrayList();
                                }
                                extraQueries.add(new SQLQuery(null, createSeqQuery));
                                break;
                            }
                            if (extendedDialect == null) break;
                            int indexOf = cd.getColumnSpecs().indexOf(columnSpec);
                            defChanged = true;
                            cd.getColumnSpecs().set(indexOf, extendedDialect.getAutoIncrementKeyword());
                            break;
                        }
                    }
                }
            }
            if (defChanged) {
                String newQueryText = SQLFormatUtils.formatSQL(null, this.sqlTranslateContext.getSyntaxManager(), createTable.toString());
                query.setText(newQueryText);
                if (extraQueries == null) {
                    extraQueries = new ArrayList<SQLQuery>();
                }
                extraQueries.add(query);
            }
        }
        if (extraQueries == null) {
            return Collections.singletonList(query);
        }
        return extraQueries;
    }

    @NotNull
    public SQLTranslateContext getSqlTranslateContext() {
        return this.sqlTranslateContext;
    }

    public void setSqlTranslateContext(@NotNull SQLTranslateContext sqlTranslateContext) {
        this.sqlTranslateContext = sqlTranslateContext;
    }
}

