/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.List;
import org.jkiss.dbeaver.parser.common.GrammarAnalyzer;
import org.jkiss.dbeaver.parser.common.Parser;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfo;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaBuilder;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaTransition;

public class ParserFactory {
    private final GrammarInfo grammar;
    private final GrammarNfaBuilder.NfaFragment nfa;
    private final List<String> errors;

    private ParserFactory(GrammarInfo grammar, GrammarNfaBuilder.NfaFragment nfa, List<String> errors) {
        this.grammar = grammar;
        this.nfa = nfa;
        this.errors = errors;
    }

    public static ParserFactory getFactory(GrammarInfo grammar) {
        GrammarNfaBuilder builder = new GrammarNfaBuilder(grammar);
        GrammarNfaBuilder.NfaFragment root = builder.traverseGrammar();
        List<GrammarNfaTransition> terminalTransitions = builder.getTerminalTransitions();
        if (builder.getErrors().size() > 0) {
            return new ParserFactory(grammar, null, builder.getErrors());
        }
        GrammarAnalyzer analyzer = new GrammarAnalyzer(terminalTransitions, root);
        analyzer.discoverByTermRelations();
        if (analyzer.getErrors().size() > 0) {
            return new ParserFactory(grammar, null, analyzer.getErrors());
        }
        return new ParserFactory(grammar, root, List.of());
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Parser createParser() {
        return new Parser(this.grammar, this.nfa);
    }
}

