/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;

public class SpreadsheetAccessibleAdapter
extends AccessibleControlAdapter
implements AccessibleListener {
    private static final Map<String, String> lobMimeTypeNames = Map.of("text/html", "html", "text/xml", "xml", "text/css", "css", "text/json", "json", "application/json", "json", "application/octet-stream", "blob", "multipart/*", "multipart", "multipart/related", "multipart");
    private final Spreadsheet spreadsheet;
    private final GridPos lastPosition;

    private SpreadsheetAccessibleAdapter(@NotNull Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
        this.lastPosition = new GridPos(-1, -1);
    }

    public static void install(@NotNull Spreadsheet spreadsheet) {
        Accessible accessible = spreadsheet.getAccessible();
        SpreadsheetAccessibleAdapter adapter = new SpreadsheetAccessibleAdapter(spreadsheet);
        accessible.addAccessibleListener((AccessibleListener)adapter);
        accessible.addAccessibleControlListener((AccessibleControlListener)adapter);
        spreadsheet.addCursorChangeListener(event -> {
            accessible.selectionChanged();
            GridCell cell = spreadsheet.getFocusCell();
            if (cell != null) {
                Object[] objectArray = new Object[2];
                objectArray[1] = cell.getRow().getElement();
                accessible.sendEvent(32782, (Object)objectArray);
            }
        });
    }

    public void getValue(AccessibleControlEvent e) {
        int rowsCount = this.spreadsheet.getRowSelectionSize();
        int colsCount = this.spreadsheet.getColumnSelectionSize();
        int cellsCount = this.spreadsheet.getCellSelectionSize();
        if (cellsCount == 1) {
            String valueLink;
            String valueStr;
            String collectionType;
            IGridLabelProvider labelProvider = this.spreadsheet.getLabelProvider();
            IGridContentProvider contentProvider = this.spreadsheet.getContentProvider();
            GridPos position = this.spreadsheet.getCursorPosition();
            GridCell cell = this.spreadsheet.posToCell(position);
            Object value = contentProvider.getCellValue(cell.getColumn(), cell.getRow(), false);
            String valueType = "";
            String contentType = value instanceof DBDContent ? ((DBDContent)value).getContentType() : null;
            String string = collectionType = value instanceof DBDCollection ? ((DBDCollection)value).getComponentType().getName() : null;
            if (contentType != null && lobMimeTypeNames.get(contentType) != null) {
                valueStr = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_object_of_type, (Object)lobMimeTypeNames.get(contentType));
            } else if (collectionType != null) {
                valueStr = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_collection_of_type, (Object)collectionType);
            } else if (value instanceof Boolean) {
                valueType = DataEditorsMessages.spreadsheet_accessibility_boolean;
                valueStr = value.toString();
            } else {
                if (value instanceof String) {
                    valueType = DataEditorsMessages.spreadsheet_accessibility_string;
                } else if (value instanceof Number) {
                    valueType = DataEditorsMessages.spreadsheet_accessibility_numeric;
                }
                valueStr = contentProvider.getCellValue(cell.getColumn(), cell.getRow(), true).toString();
            }
            if (valueStr.isEmpty()) {
                valueStr = DataEditorsMessages.spreadsheet_accessibility_empty_string;
            }
            if (contentProvider.isElementReadOnly(cell.getColumn())) {
                valueType = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_readonly, (Object)valueType);
            }
            if (!(valueLink = contentProvider.getCellLinkText(cell.col, cell.row)).isEmpty()) {
                valueType = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_foreign_key, (Object)valueType, (Object)valueLink);
            }
            e.result = this.lastPosition.col != position.col && this.lastPosition.row == position.row ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_grid_value_col, (Object[])new Object[]{valueStr, labelProvider.getText(cell.getColumn())}) : (this.lastPosition.row != position.row && this.lastPosition.col == position.col ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_grid_value_row, (Object[])new Object[]{valueStr, labelProvider.getText(cell.getRow())}) : NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_grid_value_row_col, (Object[])new Object[]{valueStr, labelProvider.getText(cell.getRow()), labelProvider.getText(cell.getColumn()), valueType}));
            this.lastPosition.col = position.col;
            this.lastPosition.row = position.row;
        } else {
            e.result = rowsCount == 1 ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_rows_selected, (Object)colsCount) : (colsCount == 1 ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_rows_selected, (Object)rowsCount) : DataEditorsMessages.spreadsheet_accessibility_freeform_range_selected);
        }
    }

    public void getName(AccessibleEvent e) {
    }

    public void getHelp(AccessibleEvent e) {
    }

    public void getKeyboardShortcut(AccessibleEvent e) {
    }

    public void getDescription(AccessibleEvent e) {
        e.result = DataEditorsMessages.spreadsheet_accessibility_description;
    }
}

