/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class CheckConditionsContext {
    private Map<Class<? extends IConditionChecker>, IConditionChecker> fCheckers = new HashMap<Class<? extends IConditionChecker>, IConditionChecker>();

    public <T extends IConditionChecker> T getChecker(Class<T> clazz) {
        return (T)((IConditionChecker)clazz.cast(this.fCheckers.get(clazz)));
    }

    public void add(IConditionChecker checker) throws CoreException {
        IConditionChecker old = this.fCheckers.put(checker.getClass(), checker);
        if (old != null) {
            this.fCheckers.put(checker.getClass(), old);
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10003, Messages.format(RefactoringCoreMessages.CheckConditionContext_error_checker_exists, checker.getClass().toString()), null));
        }
    }

    public RefactoringStatus check(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        this.mergeResourceOperationAndValidateEdit();
        ArrayList<IConditionChecker> values = new ArrayList<IConditionChecker>(this.fCheckers.values());
        Collections.sort(values, (o1, o2) -> {
            if (o1 instanceof ResourceChangeChecker) {
                return -1;
            }
            if (o2 instanceof ResourceChangeChecker) {
                return 1;
            }
            return 0;
        });
        pm.beginTask("", values.size());
        for (IConditionChecker checker : values) {
            result.merge(checker.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return result;
    }

    private void mergeResourceOperationAndValidateEdit() throws CoreException {
        ValidateEditChecker validateEditChecker = this.getChecker(ValidateEditChecker.class);
        if (validateEditChecker == null) {
            return;
        }
        ResourceChangeChecker resourceChangeChecker = this.getChecker(ResourceChangeChecker.class);
        if (resourceChangeChecker == null) {
            return;
        }
        IFile[] changedFiles = resourceChangeChecker.getChangedFiles();
        validateEditChecker.addFiles(changedFiles);
    }
}

