/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.erd.ui.action.DiagramTogglePersistAction;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.model.DiagramLoader;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.IActiveWorkbenchPart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.IEntityStructureEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;

public class ERDEditorEmbedded
extends ERDEditorPart
implements IDatabaseEditor,
IEntityStructureEditor,
IActiveWorkbenchPart {
    private static final Log log = Log.getLog(ERDEditorEmbedded.class);
    private static final String PROP_DIAGRAM_STATE = "erd.diagram.state";
    private static final String PROPS_DIAGRAM_SERIALIZED = "serialized";
    private static final String GROUP_SAVE = "save";
    private Composite parent;

    public IDatabaseEditorInput getEditorInput() {
        return (IDatabaseEditorInput)super.getEditorInput();
    }

    public void recreateEditorControl() {
    }

    @Override
    public boolean isReadOnly() {
        DBPProject project = this.getDiagramProject();
        return project != null && !project.hasRealmPermission("project-resource-edit");
    }

    @Override
    protected void fillDefaultEditorContributions(IContributionManager toolBarManager) {
        super.fillDefaultEditorContributions(toolBarManager);
        toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new DiagramTogglePersistAction(this), (boolean)true));
        toolBarManager.add((IContributionItem)new Separator(GROUP_SAVE));
        DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)this.getSite(), (IContributionManager)toolBarManager);
    }

    public void activatePart() {
        if (this.progressControl == null) {
            super.createPartControl(this.parent);
            this.parent.layout();
        }
        if (this.isLoaded()) {
            return;
        }
        this.loadDiagram(false);
    }

    public void deactivatePart() {
    }

    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
    }

    public void setFocus() {
        if (this.progressControl != null) {
            super.setFocus();
        }
    }

    private DBSObject getRootObject() {
        DBSObject object = this.getEditorInput().getDatabaseObject();
        if (object == null) {
            return null;
        }
        if (object instanceof DBPDataSourceContainer && object.getDataSource() != null) {
            object = object.getDataSource();
        }
        return object;
    }

    @Override
    protected synchronized void loadDiagram(boolean refreshMetadata) {
        DBSObject object = this.getRootObject();
        if (object == null) {
            return;
        }
        if (this.diagramLoadingJob != null) {
            return;
        }
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)new DatabaseLoadService<EntityDiagram>("Load diagram '" + object.getName() + "'", object.getDataSource()){

            public EntityDiagram evaluate(DBRProgressMonitor monitor) {
                try {
                    return ERDEditorEmbedded.this.loadFromDatabase(monitor);
                }
                catch (DBException e) {
                    log.error((Object)"Error loading ER diagram", (Throwable)e);
                    return null;
                }
            }
        }, this.progressControl.createLoadVisualizer());
        this.diagramLoadingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ERDEditorEmbedded.this.diagramLoadingJob = null;
            }
        });
        this.diagramLoadingJob.schedule();
    }

    @Override
    @Nullable
    public DBPProject getDiagramProject() {
        if (this.getEditorInput() == null) {
            return null;
        }
        return this.getEditorInput().getNavigatorNode().getOwnerProject();
    }

    public DBCExecutionContext getExecutionContext() {
        return this.getEditorInput().getExecutionContext();
    }

    private EntityDiagram loadFromDatabase(DBRProgressMonitor monitor) throws DBException {
        EntityDiagram oldDiagram;
        monitor.beginTask("Load database entities", 1);
        DBSObject dbObject = this.getRootObject();
        if (dbObject == null) {
            log.error((Object)"Database object must be entity container to render ERD diagram");
            return null;
        }
        EntityDiagram diagram = oldDiagram = this.getDiagram();
        diagram.clear();
        if (dbObject.isPersisted()) {
            diagram.fillEntities(monitor, ERDUtils.collectDatabaseTables((DBRProgressMonitor)monitor, (DBSObject)dbObject, (ERDDiagram)diagram, (boolean)ERDUIActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.show.views"), (boolean)ERDUIActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.show.partitions")), dbObject);
            if (dbObject instanceof DBSObjectContainer) {
                diagram.setRootObjectContainer((DBSObjectContainer)dbObject);
            }
            boolean hasPersistedState = false;
            try {
                String serializedDiagram;
                Map diagramState;
                DBVObject vObject = this.getVirtualObject();
                if (vObject != null && (diagramState = (Map)vObject.getProperty(PROP_DIAGRAM_STATE)) != null && !CommonUtils.isEmpty((String)(serializedDiagram = (String)diagramState.get(PROPS_DIAGRAM_SERIALIZED)))) {
                    Document xmlDocument = XMLUtils.parseDocument((Reader)new StringReader(serializedDiagram));
                    DiagramLoader.loadDiagram(monitor, xmlDocument, dbObject.getDataSource().getContainer().getProject(), diagram);
                    hasPersistedState = true;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error loading ER diagram from saved state", (Throwable)e);
            }
            diagram.setLayoutManualAllowed(true);
            diagram.setNeedsAutoLayout(!hasPersistedState);
        }
        monitor.done();
        return diagram;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        try {
            DBVObject vObject = this.getVirtualObject();
            if (vObject == null) {
                return;
            }
            LinkedHashMap<String, String> diagramStateMap = new LinkedHashMap<String, String>();
            vObject.setProperty(PROP_DIAGRAM_STATE, diagramStateMap);
            String diagramState = DiagramLoader.serializeDiagram(RuntimeUtils.makeMonitor((IProgressMonitor)monitor), this.getDiagramPart(), this.getDiagram(), false, true);
            diagramStateMap.put(PROPS_DIAGRAM_SERIALIZED, diagramState);
            vObject.persistConfiguration();
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            log.error((Object)"Error saving diagram", (Throwable)e);
        }
        this.updateToolbarActions();
    }

    public boolean isStateSaved() {
        DBVObject vObject = this.getVirtualObject();
        return vObject != null && vObject.getProperty(PROP_DIAGRAM_STATE) != null;
    }

    public void resetSavedState(boolean refreshDiagram) {
        try {
            DBVObject vObject = this.getVirtualObject();
            if (vObject != null && vObject.getProperty(PROP_DIAGRAM_STATE) != null) {
                vObject.setProperty(PROP_DIAGRAM_STATE, null);
                vObject.persistConfiguration();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error resetting diagram state", (Throwable)e);
        }
        if (refreshDiagram) {
            this.refreshDiagram(true, true);
        }
    }

    @Nullable
    private DBVObject getVirtualObject() {
        DBSObject rootObject = this.getRootObject();
        if (rootObject instanceof DBSEntity) {
            return DBVUtils.getVirtualEntity((DBSEntity)((DBSEntity)rootObject), (boolean)true);
        }
        return DBVUtils.getVirtualObject((DBSObject)rootObject, (boolean)true);
    }
}

