/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.eclipse.core.internal.runtime.Activator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.IPropertySourceEditable;
import org.jkiss.dbeaver.runtime.properties.ObjectAttributeDescriptor;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyGroupDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ObjectPropertyDescriptor
extends ObjectAttributeDescriptor
implements DBPPropertyDescriptor,
IPropertyValueListProvider<Object> {
    private final Property propInfo;
    private final String propName;
    private final String propDescription;
    private Method setter;
    private IPropertyValueTransformer valueTransformer;
    private IPropertyValueTransformer valueRenderer;
    private IPropertyValueValidator valueValidator;
    private final Class<?> declaringClass;
    private Format displayFormat = null;

    public ObjectPropertyDescriptor(DBPPropertySource source, ObjectPropertyGroupDescriptor parent, Property propInfo, Method getter, String locale) {
        super(source, parent, getter, propInfo.id(), propInfo.order());
        Class<? extends IPropertyValueValidator> valueValidatorClass;
        Class<? extends IPropertyValueTransformer> valueRendererClass;
        this.propInfo = propInfo;
        String propertyName = BeanUtils.getPropertyNameFromGetter((String)getter.getName());
        this.declaringClass = getter.getDeclaringClass();
        Class<?> c = this.declaringClass;
        while (this.setter == null && c != Object.class && c != null) {
            this.setter = BeanUtils.getSetMethod(c, (String)propertyName);
            if (this.setter != null) continue;
            c = c.getSuperclass();
        }
        Class<? extends IPropertyValueTransformer> valueTransformerClass = propInfo.valueTransformer();
        if (valueTransformerClass != IPropertyValueTransformer.class) {
            try {
                this.valueTransformer = valueTransformerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                log.warn("Can't create value transformer", e);
            }
        }
        if ((valueRendererClass = propInfo.valueRenderer()) != IPropertyValueTransformer.class) {
            try {
                this.valueRenderer = valueRendererClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                log.warn("Can't create value renderer", e);
            }
        }
        if ((valueValidatorClass = propInfo.valueValidator()) != IPropertyValueValidator.class) {
            try {
                this.valueValidator = valueValidatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                log.warn("Can't create value validator", e);
            }
        }
        this.propName = this.getLocalizedString(propInfo.name(), "name", this.getId(), !propInfo.hidden(), locale);
        this.propDescription = CommonUtils.isEmpty((String)propInfo.description()) ? this.propName : this.getLocalizedString(propInfo.name(), "description", this.propName, false, locale);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isViewable() {
        return this.propInfo.viewable() && !this.propInfo.hidden();
    }

    public boolean isHidden() {
        return this.propInfo.hidden();
    }

    public boolean isExpensive() {
        return this.propInfo.expensive();
    }

    public boolean isNumeric() {
        Class<?> propType = this.getGetter().getReturnType();
        return propType != null && BeanUtils.isNumericType(propType);
    }

    public boolean isDateTime() {
        Class<?> propType = this.getGetter().getReturnType();
        return propType != null && Date.class.isAssignableFrom(propType);
    }

    public boolean isBoolean() {
        Class<?> propType = this.getGetter().getReturnType();
        return propType == Boolean.class || propType == Boolean.TYPE;
    }

    @Override
    @NotNull
    public PropertyLength getLength() {
        return this.propInfo.length();
    }

    public boolean isSpecific() {
        return this.propInfo.specific();
    }

    public boolean isOptional() {
        return this.propInfo.optional();
    }

    public boolean isLinkPossible() {
        return this.propInfo.linkPossible();
    }

    public boolean isHref() {
        return this.propInfo.href();
    }

    public boolean supportsPreview() {
        return this.propInfo.supportsPreview();
    }

    public boolean isPassword() {
        return this.propInfo.password();
    }

    public boolean isNonSecuredProperty() {
        return this.propInfo.nonSecuredProperty();
    }

    public IPropertyValueTransformer getValueTransformer() {
        return this.valueTransformer;
    }

    public IPropertyValueTransformer getValueRenderer() {
        return this.valueRenderer;
    }

    public IPropertyValueValidator getValueValidator() {
        return this.valueValidator;
    }

    public boolean isPropertyVisible(Object object, Object value) {
        Class<? extends IPropertyValueValidator> visiblityCheckerClass = this.propInfo.visibleIf();
        if (visiblityCheckerClass != IPropertyValueValidator.class) {
            try {
                IPropertyValueValidator checker = visiblityCheckerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return checker.isValidValue(object, value);
            }
            catch (Throwable e) {
                log.debug(e);
            }
        }
        return true;
    }

    @Override
    public boolean isEditable(Object object) {
        DBPPropertySource propertySource = this.getSource();
        if (!(propertySource instanceof IPropertySourceEditable) || !((IPropertySourceEditable)((Object)propertySource)).isEditable(object)) {
            return false;
        }
        return this.getEditableValue(object);
    }

    @Override
    @Nullable
    public String[] getFeatures() {
        List<String> features = Arrays.stream(this.propInfo.features()).collect(Collectors.toList());
        if (this.isRequired()) {
            features.add("required");
        }
        if (this.isSpecific()) {
            features.add("specific");
        }
        if (this.isOptional()) {
            features.add("optional");
        }
        if (this.isHidden()) {
            features.add("hidden");
        }
        if (this.isRemote()) {
            features.add("remote");
        }
        if (this.isDateTime()) {
            features.add("datetme");
        }
        if (this.isNumeric()) {
            features.add("numeric");
        }
        if (this.isNameProperty()) {
            features.add("name");
        }
        if (this.getLength() == PropertyLength.MULTILINE) {
            features.add("multiline");
        }
        if (this.isExpensive()) {
            features.add("expensive");
        }
        if (this.isEditPossible()) {
            features.add("editPossible");
        }
        if (this.isLinkPossible()) {
            features.add("linkPossible");
        }
        if (this.isHref()) {
            features.add("href");
        }
        if (this.isViewable()) {
            features.add("viewable");
        }
        if (this.isPassword()) {
            features.add("password");
        }
        if (this.isNonSecuredProperty()) {
            features.add("nonSecuredProperty");
        }
        return features.toArray(new String[0]);
    }

    @Override
    public boolean hasFeature(@NotNull String feature) {
        switch (feature) {
            case "required": {
                return this.isRequired();
            }
            case "specific": {
                return this.isSpecific();
            }
            case "optional": {
                return this.isOptional();
            }
            case "hidden": {
                return this.isHidden();
            }
            case "datetme": {
                return this.isDateTime();
            }
            case "numeric": {
                return this.isNumeric();
            }
            case "name": {
                return this.isNameProperty();
            }
            case "multiline": {
                return this.getLength() == PropertyLength.MULTILINE;
            }
            case "expensive": {
                return this.isExpensive();
            }
            case "editPossible": {
                return this.isEditPossible();
            }
            case "linkPossible": {
                return this.isLinkPossible();
            }
            case "href": {
                return this.isHref();
            }
            case "viewable": {
                return this.isViewable();
            }
            case "password": {
                return this.isPassword();
            }
            case "nonSecuredProperty": {
                return this.isNonSecuredProperty();
            }
        }
        return ArrayUtils.contains((Object[])this.propInfo.features(), (Object)feature);
    }

    private boolean getEditableValue(Object object) {
        String expr;
        boolean isNew = this.isNewObject(object);
        String string = expr = isNew ? this.propInfo.editableExpr() : this.propInfo.updatableExpr();
        if (!expr.isEmpty()) {
            return Boolean.TRUE.equals(this.evaluateExpression(object, expr));
        }
        return isNew ? this.propInfo.editable() : this.propInfo.updatable();
    }

    private Object evaluateExpression(Object object, String exprString) {
        return AbstractDescriptor.evalExpression(exprString, object, this);
    }

    public boolean isEditPossible() {
        return this.propInfo.editable();
    }

    private boolean isNewObject(Object object) {
        return object instanceof DBPPersistedObject && !((DBPPersistedObject)object).isPersisted();
    }

    public boolean isEditPossible(Object context) {
        String expr = this.propInfo.editableExpr();
        if (!CommonUtils.isEmpty((String)expr)) {
            return Boolean.TRUE.equals(this.evaluateExpression(context, expr));
        }
        return this.propInfo.editable();
    }

    @Override
    public String getCategory() {
        return CommonUtils.isEmpty((String)this.propInfo.category()) ? null : this.propInfo.category();
    }

    @Override
    public String getDescription() {
        return this.propDescription;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.propName;
    }

    public Format getDisplayFormat() {
        Class<? extends Format> formatClass;
        if (this.displayFormat == null && (formatClass = this.propInfo.formatter()) != Format.class) {
            try {
                this.displayFormat = formatClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        if (this.displayFormat == null) {
            String format = this.propInfo.format();
            if (format.isEmpty()) {
                return null;
            }
            if (this.isNumeric()) {
                this.displayFormat = new DecimalFormat(format);
            } else if (this.isDateTime()) {
                this.displayFormat = new SimpleDateFormat(format);
            } else {
                log.debug("Don't know how to apply format to property " + this.getId());
                this.displayFormat = null;
            }
        }
        return this.displayFormat;
    }

    public Object readValue(Object object, @Nullable DBRProgressMonitor progressMonitor, boolean formatValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object value;
        Object[] params;
        if (object == null) {
            return null;
        }
        if (this.getParent() != null && (object = this.getParent().getGroupObject(object, progressMonitor)) == null) {
            return null;
        }
        Method getter = this.getGetter();
        Object[] objectArray = params = getter.getParameterCount() > 0 ? new Object[getter.getParameterCount()] : null;
        if (this.isLazy() && params != null) {
            if (this.isLazy(object, true) && progressMonitor == null && !this.supportsPreview()) {
                throw new IllegalAccessException("Lazy property can't be read with null progress monitor");
            }
            params[0] = progressMonitor;
        }
        if (progressMonitor != null && this.isLazy() && object instanceof DBSObject) {
            Object finalObject = object;
            Object[] finalResult = new Object[1];
            try {
                DBExecUtils.tryExecuteRecover(progressMonitor, ((DBSObject)object).getDataSource(), param -> {
                    try {
                        objectArray[0] = getter.invoke(finalObject, params);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
            value = finalResult[0];
        } else {
            value = getter.invoke(object, params);
        }
        if (formatValue) {
            value = this.formatValue(object, value);
        }
        return value;
    }

    public Object formatValue(Object object, Object value) {
        Format displayFormat;
        if (this.valueRenderer != null) {
            value = this.valueRenderer.transform(object, value);
        }
        if (value instanceof Number && (displayFormat = this.getDisplayFormat()) != null) {
            value = displayFormat.format(value);
        }
        return value;
    }

    public void writeValue(Object object, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.setter != null) {
            if (value == null) {
                Annotation[] valueAnnotations;
                Annotation[] annotationArray = valueAnnotations = this.setter.getParameterAnnotations()[0];
                int n = valueAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation va = annotationArray[n2];
                    if (va.annotationType() == NotNull.class) {
                        throw new IllegalArgumentException("Property '" + this.getId() + "' can't be set into NULL");
                    }
                    ++n2;
                }
            }
            if (this.getParent() != null) {
                object = this.getParent().getGroupObject(object, new VoidProgressMonitor());
            }
            Class<?> argType = this.setter.getParameterTypes()[0];
            if (value == null) {
                if (argType == Integer.TYPE) {
                    value = 0;
                } else if (argType == Short.TYPE) {
                    value = (short)0;
                } else if (argType == Long.TYPE) {
                    value = 0L;
                } else if (argType == Float.TYPE) {
                    value = Float.valueOf(0.0f);
                } else if (argType == Double.TYPE) {
                    value = 0.0;
                } else if (argType == Boolean.TYPE) {
                    value = false;
                } else if (argType == Character.TYPE) {
                    value = Character.valueOf(' ');
                }
            } else if (argType == Boolean.TYPE || argType == Boolean.class && !(value instanceof Boolean)) {
                value = CommonUtils.toBoolean((Object)value);
            } else if (argType == Long.TYPE) {
                value = CommonUtils.toLong((Object)value);
            } else if (argType == Integer.TYPE) {
                value = CommonUtils.toInt((Object)value);
            }
        } else {
            throw new IllegalAccessError("No setter found for property " + this.getId());
        }
        this.setter.invoke(object, value);
    }

    public String toString() {
        return String.valueOf(this.getId()) + " (" + this.propInfo.name() + ")";
    }

    @Override
    public Class<?> getDataType() {
        return this.getGetter().getReturnType();
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public boolean allowCustomValue() {
        if (this.propInfo.listProvider() != IPropertyValueListProvider.class) {
            try {
                return this.propInfo.listProvider().getConstructor(new Class[0]).newInstance(new Object[0]).allowCustomValue();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return false;
    }

    public boolean hasListValueProvider() {
        return this.propInfo.listProvider() != IPropertyValueListProvider.class;
    }

    @Override
    public Object[] getPossibleValues(Object object) {
        if (this.propInfo.listProvider() != IPropertyValueListProvider.class) {
            try {
                return this.propInfo.listProvider().getConstructor(new Class[0]).newInstance(new Object[0]).getPossibleValues(object);
            }
            catch (Exception e) {
                log.error(e);
            }
        } else {
            Class<?> dataType = this.getDataType();
            if (dataType != null && dataType.isEnum()) {
                return dataType.getEnumConstants();
            }
        }
        return null;
    }

    public int hashCode() {
        return this.propInfo.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ObjectPropertyDescriptor && this.propInfo.equals(((ObjectPropertyDescriptor)obj).propInfo) && CommonUtils.equalObjects((Object)this.getGetter(), (Object)((ObjectPropertyDescriptor)obj).getGetter());
    }

    /*
     * Unable to fully structure code
     */
    private String getLocalizedString(String string, String type, String defaultValue, boolean warnMissing, String locale) {
        if ("#".equals(string)) {
            block12: {
                getter = this.getGetter();
                propertyName = BeanUtils.getPropertyNameFromGetter((String)getter.getName());
                propOwner = getter.getDeclaringClass();
                bundle = FrameworkUtil.getBundle(propOwner);
                resourceBundle = this.getPluginResourceBundle(bundle, propOwner, locale);
                messageID = "meta." + propOwner.getName() + "." + propertyName + "." + type;
                result = null;
                try {
                    result = resourceBundle.getString(messageID);
                    break block12;
                }
                catch (Exception v0) {
                    parent = getter.getDeclaringClass().getSuperclass();
                    ** while (parent != null && parent != Object.class)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        parentGetter = parent.getMethod(getter.getName(), getter.getParameterTypes());
                        parentOwner = parentGetter.getDeclaringClass();
                        parentBundle = FrameworkUtil.getBundle(parentOwner);
                        if (parentBundle != null && parentBundle != bundle) {
                            parentResourceBundle = this.getPluginResourceBundle(parentBundle, parentOwner, locale);
                            messageID = "meta." + parentOwner.getName() + "." + propertyName + "." + type;
                            try {
                                result = parentResourceBundle.getString(messageID);
                                break;
                            }
                            catch (Exception v1) {}
                        }
                    }
                    catch (Exception v2) {}
                    parent = parent.getSuperclass();
                    continue;
                }
lbl30:
                // 2 sources

                if (result == null) {
                    if (type.equals("name")) {
                        ObjectPropertyDescriptor.log.debug("Resource '" + messageID + "' not found in bundle " + bundle.getSymbolicName());
                    }
                    return defaultValue;
                }
            }
            if (!result.equals(messageID)) {
                return result;
            }
            return defaultValue;
        }
        return string;
    }

    private ResourceBundle getPluginResourceBundle(Bundle bundle, Class<?> ownerClass, String language) {
        return Activator.getDefault().getLocalization(bundle, language);
    }
}

