/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.qm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMConfigurationProvider;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMMCollector;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.qm.DefaultExecutionHandler;
import org.jkiss.utils.LongKeyMap;

public class QMMCollectorImpl
extends DefaultExecutionHandler
implements QMMCollector {
    private static final Log log = Log.getLog(QMMCollectorImpl.class);
    private static final int MAX_HISTORY_EVENTS = 10000;
    private LongKeyMap<QMMConnectionInfo> connectionMap = new LongKeyMap();
    private List<Long> closedConnections = new ArrayList<Long>();
    private final List<QMMetaListener> listeners = new ArrayList<QMMetaListener>();
    private List<QMMetaEvent> eventPool = new ArrayList<QMMetaEvent>();
    private final Object historySync = new Object();
    private List<QMMetaEvent> pastEvents = new ArrayList<QMMetaEvent>();
    private boolean running = true;
    private long eventDispatchPeriod = 250L;

    public QMMCollectorImpl() {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        QMConfigurationProvider qmConfigurationProvider = DBUtils.getAdapter(QMConfigurationProvider.class, application);
        if (qmConfigurationProvider != null) {
            this.eventDispatchPeriod = qmConfigurationProvider.getEventDispatchPeriod();
        }
        new EventDispatcher().schedule(this.eventDispatchPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (!this.connectionMap.isEmpty()) {
            ArrayList<QMMConnectionInfo> openSessions = new ArrayList<QMMConnectionInfo>();
            for (QMMConnectionInfo connection : this.connectionMap.values()) {
                if (connection.isClosed()) continue;
                openSessions.add(connection);
            }
            if (!openSessions.isEmpty()) {
                log.warn("Some sessions are still open: " + openSessions);
            }
        }
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.isEmpty()) {
                log.warn("Some QM meta collector listeners are still open: " + this.listeners);
                this.listeners.clear();
            }
        }
        this.running = false;
    }

    boolean isRunning() {
        return this.running;
    }

    @Override
    @NotNull
    public String getHandlerName() {
        return "Meta info collector";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(QMMetaListener listener) {
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(QMMetaListener listener) {
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.remove(listener)) {
                log.warn("Listener '" + listener + "' is not registered in QM meta collector");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QMMetaListener> getListeners() {
        List<QMMetaListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.listeners.size() == 1) {
                return Collections.singletonList(this.listeners.get(0));
            }
            return new ArrayList<QMMetaListener>(this.listeners);
        }
    }

    private synchronized void tryFireMetaEvent(QMMObject object, QMEventAction action, DBCExecutionContext context) {
        try {
            String sessionId = QMUtils.getQmSessionId(context);
            this.eventPool.add(new QMMetaEvent(object, action, sessionId));
        }
        catch (DBException e) {
            log.error("Failed to fire qm meta event", e);
        }
    }

    private synchronized List<QMMetaEvent> obtainEvents() {
        if (this.eventPool.isEmpty()) {
            return Collections.emptyList();
        }
        List<QMMetaEvent> events = this.eventPool;
        this.eventPool = new ArrayList<QMMetaEvent>();
        return events;
    }

    @Override
    public QMMConnectionInfo getConnectionInfo(DBCExecutionContext context) {
        QMMConnectionInfo connectionInfo = (QMMConnectionInfo)this.connectionMap.get(context.getContextId());
        if (connectionInfo == null) {
            log.debug("Can't find connectionInfo meta information: " + context.getContextId() + " (" + context.getContextName() + ")");
        }
        return connectionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QMMetaEvent> getPastEvents() {
        Object object = this.historySync;
        synchronized (object) {
            return new ArrayList<QMMetaEvent>(this.pastEvents);
        }
    }

    @Override
    public synchronized void handleContextOpen(@NotNull DBCExecutionContext context, boolean transactional) {
        long contextId = context.getContextId();
        QMMConnectionInfo connection = (QMMConnectionInfo)this.connectionMap.get(contextId);
        if (connection == null) {
            connection = new QMMConnectionInfo(context, transactional);
            this.connectionMap.put(contextId, (Object)connection);
        } else {
            connection.reopen(context);
        }
        this.closedConnections.remove(contextId);
        this.tryFireMetaEvent(connection, QMEventAction.BEGIN, context);
    }

    @Override
    public synchronized void handleContextClose(@NotNull DBCExecutionContext context) {
        QMMConnectionInfo session = this.getConnectionInfo(context);
        if (session != null) {
            session.close();
            this.tryFireMetaEvent(session, QMEventAction.END, context);
        }
        this.closedConnections.add(context.getContextId());
    }

    @Override
    public synchronized void handleTransactionAutocommit(@NotNull DBCExecutionContext context, boolean autoCommit) {
        QMMConnectionInfo sessionInfo = this.getConnectionInfo(context);
        if (sessionInfo != null) {
            QMMTransactionInfo oldTxn = sessionInfo.changeTransactional(!autoCommit);
            if (oldTxn != null) {
                this.tryFireMetaEvent(oldTxn, QMEventAction.END, context);
            }
            this.tryFireMetaEvent(sessionInfo, QMEventAction.UPDATE, context);
        }
    }

    @Override
    public synchronized void handleTransactionCommit(@NotNull DBCExecutionContext context) {
        QMMTransactionInfo oldTxn;
        QMMConnectionInfo sessionInfo = this.getConnectionInfo(context);
        if (sessionInfo != null && (oldTxn = sessionInfo.commit()) != null) {
            this.tryFireMetaEvent(oldTxn, QMEventAction.END, context);
        }
    }

    @Override
    public synchronized void handleTransactionRollback(@NotNull DBCExecutionContext context, DBCSavepoint savepoint) {
        QMMObject oldTxn;
        QMMConnectionInfo sessionInfo = this.getConnectionInfo(context);
        if (sessionInfo != null && (oldTxn = sessionInfo.rollback(savepoint)) != null) {
            this.tryFireMetaEvent(oldTxn, QMEventAction.END, context);
        }
    }

    @Override
    public synchronized void handleStatementOpen(@NotNull DBCStatement statement) {
        QMMConnectionInfo session = this.getConnectionInfo(statement.getSession().getExecutionContext());
        if (session != null) {
            QMMStatementInfo stat = session.openStatement(statement);
            this.tryFireMetaEvent(stat, QMEventAction.BEGIN, statement.getSession().getExecutionContext());
        }
    }

    @Override
    public synchronized void handleStatementClose(@NotNull DBCStatement statement, long rows) {
        QMMConnectionInfo session = this.getConnectionInfo(statement.getSession().getExecutionContext());
        if (session != null) {
            QMMStatementInfo stat = session.closeStatement(statement, rows);
            if (stat == null) {
                log.warn("Can't properly handle statement close");
            } else {
                this.tryFireMetaEvent(stat, QMEventAction.END, statement.getSession().getExecutionContext());
            }
        }
    }

    @Override
    public synchronized void handleStatementExecuteBegin(@NotNull DBCStatement statement) {
        QMMStatementExecuteInfo exec;
        QMMConnectionInfo session = this.getConnectionInfo(statement.getSession().getExecutionContext());
        if (session != null && (exec = session.beginExecution(statement)) != null) {
            this.tryFireMetaEvent(exec, QMEventAction.BEGIN, statement.getSession().getExecutionContext());
        }
    }

    @Override
    public synchronized void handleStatementExecuteEnd(@NotNull DBCStatement statement, long rows, Throwable error) {
        QMMStatementExecuteInfo exec;
        QMMConnectionInfo session = this.getConnectionInfo(statement.getSession().getExecutionContext());
        if (session != null && (exec = session.endExecution(statement, rows, error)) != null) {
            this.tryFireMetaEvent(exec, QMEventAction.END, statement.getSession().getExecutionContext());
        }
    }

    @Override
    public synchronized void handleResultSetOpen(@NotNull DBCResultSet resultSet) {
        QMMStatementExecuteInfo exec;
        QMMConnectionInfo session = this.getConnectionInfo(resultSet.getSession().getExecutionContext());
        if (session != null && (exec = session.beginFetch(resultSet)) != null) {
            this.tryFireMetaEvent(exec, QMEventAction.UPDATE, resultSet.getSession().getExecutionContext());
        }
    }

    @Override
    public synchronized void handleResultSetClose(@NotNull DBCResultSet resultSet, long rowCount) {
        QMMStatementExecuteInfo exec;
        QMMConnectionInfo session = this.getConnectionInfo(resultSet.getSession().getExecutionContext());
        if (session != null && (exec = session.endFetch(resultSet, rowCount)) != null) {
            this.tryFireMetaEvent(exec, QMEventAction.UPDATE, resultSet.getSession().getExecutionContext());
        }
    }

    private class EventDispatcher
    extends AbstractJob {
        protected EventDispatcher() {
            super("QM meta events dispatcher");
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IStatus run(DBRProgressMonitor monitor) {
            List<Long> sessionsToClose;
            List<QMMetaEvent> events;
            QMMCollectorImpl qMMCollectorImpl = QMMCollectorImpl.this;
            synchronized (qMMCollectorImpl) {
                events = QMMCollectorImpl.this.obtainEvents();
                sessionsToClose = QMMCollectorImpl.this.closedConnections;
                QMMCollectorImpl.this.closedConnections.clear();
            }
            if (!events.isEmpty()) {
                List<QMMetaListener> listeners = QMMCollectorImpl.this.getListeners();
                if (!listeners.isEmpty() && !events.isEmpty()) {
                    Collections.reverse(events);
                    for (QMMetaListener qMMetaListener : listeners) {
                        try {
                            qMMetaListener.metaInfoChanged(monitor, events);
                        }
                        catch (Throwable e) {
                            log.error("Error notifying event listener", e);
                        }
                    }
                }
                Object object = QMMCollectorImpl.this.historySync;
                synchronized (object) {
                    QMMCollectorImpl.this.pastEvents.addAll(events);
                    int size = QMMCollectorImpl.this.pastEvents.size();
                    if (size > 10000) {
                        QMMCollectorImpl.this.pastEvents = new ArrayList<QMMetaEvent>(QMMCollectorImpl.this.pastEvents.subList(size - 10000, size));
                    }
                }
            }
            qMMCollectorImpl = QMMCollectorImpl.this;
            synchronized (qMMCollectorImpl) {
                for (Long l : sessionsToClose) {
                    QMMConnectionInfo session = (QMMConnectionInfo)QMMCollectorImpl.this.connectionMap.get((Object)l);
                    if (session == null || session.isClosed()) continue;
                    QMMCollectorImpl.this.connectionMap.remove((Object)l);
                }
            }
            if (QMMCollectorImpl.this.isRunning()) {
                this.schedule(QMMCollectorImpl.this.eventDispatchPeriod);
            }
            return Status.OK_STATUS;
        }
    }
}

