/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMResource;

public class RMEvent {
    @NotNull
    private final Action action;
    @NotNull
    private final RMProject project;
    @NotNull
    private final List<RMResource> resourceTree;
    @NotNull
    private final Map<String, Object> parameters;

    public RMEvent(@NotNull Action action, @NotNull RMProject project, @NotNull List<RMResource> resourceTree, @NotNull Map<String, Object> parameters) {
        this.action = action;
        this.project = project;
        this.resourceTree = resourceTree;
        this.parameters = parameters;
    }

    public RMEvent(@NotNull Action action, @NotNull RMProject project) {
        this(action, project, List.of(), Map.of());
    }

    public RMEvent(@NotNull Action action, @NotNull RMProject project, @NotNull List<RMResource> resourceTree) {
        this(action, project, resourceTree, Map.of());
    }

    @NotNull
    public Action getAction() {
        return this.action;
    }

    @NotNull
    public RMProject getProject() {
        return this.project;
    }

    @NotNull
    public List<RMResource> getResourceTree() {
        return this.resourceTree;
    }

    public Map<String, Object> getParameters() {
        return Map.copyOf(this.parameters);
    }

    public static enum Action {
        RESOURCE_DELETE,
        RESOURCE_ADD,
        PROJECT_DELETE,
        PROJECT_ADD;

    }
}

