/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreDependency
implements PostgreObject,
DBPOverloadedObject,
DBPImageProvider {
    private static final Log log = Log.getLog(PostgreDependency.class);
    private final PostgreDatabase database;
    private final long objectId;
    private String depType;
    private String name;
    private String description;
    private String objectType;
    private String tableName;
    private String schemaName;
    private PostgreObject targetObject;

    public PostgreDependency(PostgreDatabase database, long objectId, String depType, String name, String description, String objectType, String tableName, String schemaName) {
        this.database = database;
        this.objectId = objectId;
        this.depType = depType;
        this.name = name;
        this.description = description;
        this.objectType = objectType;
        this.tableName = tableName;
        this.schemaName = schemaName;
    }

    @Property(viewable=false)
    public long getObjectId() {
        return this.objectId;
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return this.name;
    }

    public String getOverloadedName() {
        return String.valueOf(this.name) + " (" + this.depType + ")";
    }

    @Property(viewable=true, order=2)
    public String getObjectType() {
        if (this.objectType.startsWith("i")) {
            return "Index";
        }
        if (this.objectType.startsWith("R")) {
            return "Rule";
        }
        if (this.objectType.startsWith("C")) {
            if (this.objectType.endsWith("f")) {
                return "Foreign Key";
            }
            if (this.objectType.endsWith("p")) {
                return "Primary Key";
            }
            return "Constraint";
        }
        if (this.objectType.startsWith("r")) {
            return "Table";
        }
        if (this.objectType.startsWith("A")) {
            return "Attribute";
        }
        if (this.objectType.startsWith("T")) {
            return "Trigger";
        }
        return this.objectType;
    }

    @Property(viewable=true, order=3)
    public String getTableName() {
        return this.tableName;
    }

    @Property(viewable=true, order=4)
    public String getSchemaName() {
        return this.schemaName;
    }

    @Property(viewable=true, order=5)
    public PostgreObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        if (this.targetObject == null) {
            this.targetObject = this.findTargetObject(monitor);
        }
        return this.targetObject;
    }

    private PostgreObject findTargetObject(DBRProgressMonitor monitor) throws DBException {
        if (CommonUtils.isEmpty((String)this.schemaName)) {
            return null;
        }
        PostgreSchema schema = this.database.getSchema(monitor, this.schemaName);
        if (schema == null) {
            return null;
        }
        PostgreTableBase tableBase = null;
        if (!CommonUtils.isEmpty((String)this.tableName)) {
            tableBase = (PostgreTableBase)schema.getTableCache().getObject(monitor, schema, this.tableName);
        }
        if (this.objectType.startsWith("i")) {
            if (tableBase instanceof PostgreTable) {
                return (PostgreObject)DBUtils.findObject(((PostgreTable)tableBase).getIndexes(monitor), (String)this.name);
            }
            return null;
        }
        if (this.objectType.startsWith("R")) {
            return schema.getProcedure(monitor, this.name);
        }
        if (this.objectType.startsWith("C")) {
            if (this.objectType.endsWith("f")) {
                if (tableBase instanceof PostgreTable) {
                    return (PostgreObject)DBUtils.findObject(((PostgreTable)tableBase).getForeignKeys(monitor), (String)this.name);
                }
            } else if (tableBase != null) {
                Collection<PostgreTableConstraint> constraints = tableBase.getConstraints(monitor);
                return constraints == null ? null : (PostgreObject)DBUtils.findObject(constraints, (String)this.name);
            }
            return null;
        }
        if (this.objectType.startsWith("r")) {
            return tableBase;
        }
        if (this.objectType.startsWith("A")) {
            if (tableBase != null) {
                return tableBase.getAttribute(monitor, this.name);
            }
            return null;
        }
        if (this.objectType.startsWith("T")) {
            if (tableBase instanceof PostgreTable) {
                return ((PostgreTable)tableBase).getTrigger(monitor, this.name);
            }
            return null;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getObjectImage() {
        if (this.objectType.startsWith("i")) {
            return DBIcon.TREE_INDEX;
        }
        if (this.objectType.startsWith("R")) {
            return DBIcon.TREE_FUNCTION;
        }
        if (this.objectType.startsWith("C")) {
            if (this.objectType.endsWith("f")) {
                return DBIcon.TREE_FOREIGN_KEY;
            }
            if (this.objectType.endsWith("p")) {
                return DBIcon.TREE_UNIQUE_KEY;
            }
            return DBIcon.TREE_CONSTRAINT;
        }
        if (this.objectType.startsWith("r")) {
            return DBIcon.TREE_TABLE;
        }
        if (this.objectType.startsWith("A")) {
            return DBIcon.TREE_COLUMN;
        }
        if (this.objectType.startsWith("T")) {
            return DBIcon.TREE_TRIGGER;
        }
        return DBIcon.TREE_REFERENCE;
    }

    public DBSObject getParentObject() {
        return this.database;
    }

    public static List<PostgreDependency> readDependencies(DBRProgressMonitor monitor, PostgreObject object, boolean dependents) throws DBCException {
        ArrayList<PostgreDependency> dependencies = new ArrayList<PostgreDependency>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)"Load object dependencies");){
                String queryObjId = dependents ? "objid" : "refobjid";
                String condObjId = dependents ? "refobjid" : "objid";
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DISTINCT dep.deptype, dep.classid, dep." + queryObjId + ", cl.relkind, attr.attname,pg_get_expr(ad.adbin, ad.adrelid) adefval,\n" + "    CASE WHEN cl.relkind IS NOT NULL THEN cl.relkind::text || COALESCE(dep.objsubid::text, '')::text\n" + "        WHEN tg.oid IS NOT NULL THEN 'T'::text\n" + "        WHEN ty.oid IS NOT NULL THEN 'y'::text\n" + "        WHEN ns.oid IS NOT NULL THEN 'n'::text\n" + "        WHEN pr.oid IS NOT NULL THEN 'p'::text\n" + "        WHEN la.oid IS NOT NULL THEN 'l'::text\n" + "        WHEN rw.oid IS NOT NULL THEN 'R'::text\n" + "        WHEN co.oid IS NOT NULL THEN 'C'::text || contype::text\n" + "        WHEN ad.oid IS NOT NULL THEN 'A'::text\n" + "        ELSE ''\n" + "    END AS type,\n" + "    COALESCE(coc.relname, clrw.relname, tgr.relname) AS ownertable,\n" + "    CASE WHEN cl.relname IS NOT NULL AND att.attname IS NOT NULL THEN cl.relname || '.' || att.attname\n" + "    ELSE COALESCE(cl.relname, co.conname, pr.proname, tg.tgname, ty.typname, la.lanname, rw.rulename, ns.nspname)\n" + "    END AS refname,\n" + "    COALESCE(nsc.nspname, nso.nspname, nsp.nspname, nst.nspname, nsrw.nspname, tgrn.nspname) AS nspname\n" + "FROM pg_depend dep\n" + "LEFT JOIN pg_class cl ON dep." + queryObjId + "=cl.oid\n" + "LEFT JOIN pg_attribute att ON dep." + queryObjId + "=att.attrelid AND dep.objsubid=att.attnum\n" + "LEFT JOIN pg_namespace nsc ON cl.relnamespace=nsc.oid\n" + "LEFT JOIN pg_proc pr ON dep." + queryObjId + "=pr.oid\n" + "LEFT JOIN pg_namespace nsp ON pr.pronamespace=nsp.oid\n" + "LEFT JOIN pg_trigger tg ON dep." + queryObjId + "=tg.oid\n" + "LEFT JOIN pg_class tgr ON tg.tgrelid=tgr.oid\n" + "LEFT JOIN pg_namespace tgrn ON tgr.relnamespace=tgrn.oid\n" + "LEFT JOIN pg_type ty ON dep." + queryObjId + "=ty.oid\n" + "LEFT JOIN pg_namespace nst ON ty.typnamespace=nst.oid\n" + "LEFT JOIN pg_constraint co ON dep." + queryObjId + "=co.oid\n" + "LEFT JOIN pg_class coc ON co.conrelid=coc.oid\n" + "LEFT JOIN pg_namespace nso ON co.connamespace=nso.oid\n" + "LEFT JOIN pg_rewrite rw ON dep." + queryObjId + "=rw.oid\n" + "LEFT JOIN pg_class clrw ON clrw.oid=rw.ev_class\n" + "LEFT JOIN pg_namespace nsrw ON clrw.relnamespace=nsrw.oid\n" + "LEFT JOIN pg_language la ON dep." + queryObjId + "=la.oid\n" + "LEFT JOIN pg_namespace ns ON dep." + queryObjId + "=ns.oid\n" + "LEFT JOIN pg_attrdef ad ON ad.oid=dep." + queryObjId + "\n" + "LEFT JOIN pg_attribute attr ON attr.attrelid=ad.adrelid and attr.attnum=ad.adnum\n" + "WHERE dep." + condObjId + "=?\n" + "ORDER BY type");){
                    dbStat.setLong(1, object.getObjectId());
                    Throwable throwable3 = null;
                    Object var13_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ownertable");
                            String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"nspname");
                            String objName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"refname");
                            if (CommonUtils.isEmpty((String)objName)) {
                                objName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attname");
                            }
                            String objDesc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"adefval");
                            PostgreDependency dependency = new PostgreDependency(object.getDatabase(), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)queryObjId), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"deptype"), objName, objDesc, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"type"), tableName, schemaName);
                            dependencies.add(dependency);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException("Error reading dependencies", (Throwable)e);
        }
        return dependencies;
    }
}

