/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.mysql.model;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class OceanbaseMySQLViewColumn
extends MySQLTableColumn {
    OceanbaseMySQLViewColumn(MySQLTableBase table, ResultSet dbResult) throws DBException {
        super(table);
        this.loadInfo(dbResult);
        this.setPersisted(true);
    }

    OceanbaseMySQLViewColumn(DBRProgressMonitor monitor, MySQLTableBase table, DBSEntityAttribute source) throws DBException {
        super(monitor, table, source);
    }

    private void loadInfo(ResultSet dbResult) throws DBException {
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Field"));
        String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Type");
        assert (typeName != null);
        this.setTypeName(typeName);
        this.setFullTypeName(typeName);
        this.setValueType(MySQLUtils.typeNameToValueType((String)typeName.split("\\(")[0]));
        DBSDataType dataType = this.getDataSource().getLocalDataType(typeName);
        long charLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CHARACTER_MAXIMUM_LENGTH");
        if (charLength <= 0L) {
            if (dataType != null) {
                this.setMaxLength(CommonUtils.toInt((Object)dataType.getPrecision()));
            }
        } else {
            this.setMaxLength(charLength);
        }
        this.setRequired(!"YES".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Null")));
        String defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Default");
        if (defaultValue != null) {
            DBPDataKind dataKind = this.getDataKind();
            if (dataKind == DBPDataKind.STRING && !"NULL".equals(defaultValue) && !SQLUtils.isStringQuoted((DBSObject)this.getDataSource(), (String)defaultValue)) {
                defaultValue = SQLUtils.quoteString((DBPDataSource)this.getDataSource(), (String)defaultValue);
            } else if (dataKind == DBPDataKind.DATETIME && !defaultValue.isEmpty() && Character.isDigit(defaultValue.charAt(0))) {
                defaultValue = "'" + defaultValue + "'";
            }
            this.setDefaultValue(defaultValue);
        }
        this.setExtraInfo(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Extra"));
    }
}

