/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2dl.AbsoluteBendpoint;
import org.eclipse.draw2dl.Bendpoint;
import org.eclipse.draw2dl.RelativeBendpoint;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDConstants;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDLogicalAssociation;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.erd.model.ERDPersistedState;
import org.jkiss.dbeaver.erd.ui.model.ERDContainerDecorated;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.part.NotePart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.ui.SharedFonts;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiagramLoader
extends ERDPersistedState {
    private static final Log log = Log.getLog(DiagramLoader.class);

    public static void load(DBRProgressMonitor monitor, DBPProject projectMeta, DiagramPart diagramPart, Reader reader) throws XMLException, DBException {
        monitor.beginTask("Parse diagram", 1);
        EntityDiagram diagram = diagramPart.getDiagram();
        Document document = XMLUtils.parseDocument((Reader)reader);
        monitor.done();
        DiagramLoader.loadDiagram(monitor, document, projectMeta, diagram);
    }

    public static void loadDiagram(DBRProgressMonitor monitor, Document document, DBPProject projectMeta, EntityDiagram diagram) throws DBException {
        ERDNote targetEntity;
        ERDNote sourceEntity;
        Element relationsElem;
        Element notesElem;
        Element diagramElem = document.getDocumentElement();
        String diagramVersion = diagramElem.getAttribute("version");
        if (CommonUtils.isEmpty((String)diagramVersion)) {
            throw new DBException("Diagram version not found");
        }
        if (!diagramVersion.equals(String.valueOf(1))) {
            throw new DBException("Unsupported diagram version: " + diagramVersion);
        }
        ArrayList<ElementLoadInfo> tableInfos = new ArrayList<ElementLoadInfo>();
        ArrayList<RelationLoadInfo> relInfos = new ArrayList<RelationLoadInfo>();
        HashMap<String, ElementLoadInfo> elementMap = new HashMap<String, ElementLoadInfo>();
        Element entitiesElem = XMLUtils.getChildElement((Element)diagramElem, (String)"entities");
        if (entitiesElem != null) {
            for (Element dsElem : XMLUtils.getChildElementList((Element)entitiesElem, (String)"data-source")) {
                DBPDataSource dataSource;
                String dsId = dsElem.getAttribute("id");
                if (CommonUtils.isEmpty((String)dsId)) {
                    log.warn((Object)"Missing datasource ID");
                    continue;
                }
                DBPDataSourceContainer dBPDataSourceContainer = projectMeta.getDataSourceRegistry().getDataSource(dsId);
                if (dBPDataSourceContainer == null) {
                    log.warn((Object)("Datasource '" + dsId + "' not found"));
                    continue;
                }
                if (!dBPDataSourceContainer.isConnected()) {
                    monitor.subTask("Connect to '" + dBPDataSourceContainer.getName() + "'");
                    try {
                        dBPDataSourceContainer.connect(monitor, true, true);
                    }
                    catch (DBException e) {
                        log.debug((Object)e);
                        diagram.addErrorMessage("Can't connect to '" + dBPDataSourceContainer.getName() + "': " + e.getMessage());
                        continue;
                    }
                }
                if (!((dataSource = dBPDataSourceContainer.getDataSource()) instanceof DBSObjectContainer)) {
                    diagram.addErrorMessage("Datasource '" + dBPDataSourceContainer.getName() + "' entities cannot be loaded - no entity container found");
                    continue;
                }
                DBSObjectContainer rootContainer = (DBSObjectContainer)dataSource;
                List entityElemList = XMLUtils.getChildElementList((Element)dsElem, (String)"entity");
                monitor.beginTask("Parse entities", entityElemList.size());
                for (Element entityElem : entityElemList) {
                    String tableId = entityElem.getAttribute("id");
                    String tableName = entityElem.getAttribute("name");
                    monitor.subTask("Load " + tableName);
                    ArrayList<String> path = new ArrayList<String>();
                    for (Element pathElem : XMLUtils.getChildElementList((Element)entityElem, (String)"path")) {
                        path.add(0, pathElem.getAttribute("name"));
                    }
                    DBSObjectContainer container = rootContainer;
                    for (String conName : path) {
                        DBSObject child = container.getChild(monitor, conName);
                        if (child == null) {
                            diagram.addErrorMessage("Container '" + conName + "' not found within '" + container.getName() + "'. Skip table '" + tableName + "'.");
                            container = null;
                            break;
                        }
                        if (child instanceof DBSObjectContainer) {
                            container = (DBSObjectContainer)child;
                            continue;
                        }
                        diagram.addErrorMessage("Object '" + child.getName() + "' is not a container");
                        container = null;
                        break;
                    }
                    if (container == null) continue;
                    DBSObject child = container.getChild(monitor, tableName);
                    if (!(child instanceof DBSEntity)) {
                        log.debug((Object)("Cannot find table '" + tableName + "' in '" + container.getName() + "'"));
                        continue;
                    }
                    String locX = entityElem.getAttribute("x");
                    String locY = entityElem.getAttribute("y");
                    DBSEntity table = (DBSEntity)child;
                    ERDContainerDecorated.NodeVisualInfo visualInfo = new ERDContainerDecorated.NodeVisualInfo();
                    visualInfo.initBounds = new Rectangle();
                    if (CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY)) {
                        diagram.setNeedsAutoLayout(true);
                    } else {
                        visualInfo.initBounds.x = Integer.parseInt(locX);
                        visualInfo.initBounds.y = Integer.parseInt(locY);
                    }
                    String attrVis = entityElem.getAttribute("showAttrs");
                    if (!CommonUtils.isEmpty((String)attrVis)) {
                        visualInfo.attributeVisibility = ERDAttributeVisibility.valueOf((String)attrVis);
                    }
                    UIUtils.syncExec(() -> DiagramLoader.loadNodeVisualInfo(entityElem, visualInfo));
                    ElementLoadInfo info = new ElementLoadInfo(tableId, table, null, visualInfo);
                    tableInfos.add(info);
                    elementMap.put(info.objectId, info);
                    diagram.addVisualInfo(table, info.visualInfo);
                    monitor.worked(1);
                }
                monitor.done();
            }
        }
        if ((notesElem = XMLUtils.getChildElement((Element)diagramElem, (String)"notes")) != null) {
            List noteElemList = XMLUtils.getChildElementList((Element)notesElem, (String)"note");
            monitor.beginTask("Parse notes", noteElemList.size());
            for (Element noteElem : noteElemList) {
                String noteText = XMLUtils.getElementBody((Element)noteElem);
                ERDNote note = new ERDNote(noteText);
                diagram.addNote(note, false);
                String noteId = noteElem.getAttribute("id");
                String locX = noteElem.getAttribute("x");
                String locY = noteElem.getAttribute("y");
                String locW = noteElem.getAttribute("w");
                String locH = noteElem.getAttribute("h");
                ERDContainerDecorated.NodeVisualInfo visualInfo = new ERDContainerDecorated.NodeVisualInfo();
                if (!(CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY) || CommonUtils.isEmpty((String)locW) || CommonUtils.isEmpty((String)locH))) {
                    visualInfo.initBounds = new Rectangle(Integer.parseInt(locX), Integer.parseInt(locY), Integer.parseInt(locW), Integer.parseInt(locH));
                }
                DiagramLoader.loadNodeVisualInfo(noteElem, visualInfo);
                diagram.addVisualInfo(note, visualInfo);
                if (CommonUtils.isEmpty((String)noteId)) continue;
                ElementLoadInfo info = new ElementLoadInfo(noteId, null, note, visualInfo);
                tableInfos.add(info);
                elementMap.put(info.objectId, info);
            }
        }
        if ((relationsElem = XMLUtils.getChildElement((Element)diagramElem, (String)"relations")) != null) {
            List relElemList = XMLUtils.getChildElementList((Element)relationsElem, (String)"relation");
            monitor.beginTask("Parse relations", relElemList.size());
            for (Element element : relElemList) {
                String relName = element.getAttribute("name");
                monitor.subTask("Load " + relName);
                String relType = element.getAttribute("type");
                String pkRefId = element.getAttribute("pk-ref");
                String fkRefId = element.getAttribute("fk-ref");
                if (CommonUtils.isEmpty((String)relName) || CommonUtils.isEmpty((String)pkRefId) || CommonUtils.isEmpty((String)fkRefId)) {
                    log.warn((Object)"Missing relation ID");
                    continue;
                }
                ElementLoadInfo pkTable = (ElementLoadInfo)elementMap.get(pkRefId);
                ElementLoadInfo fkTable = (ElementLoadInfo)elementMap.get(fkRefId);
                if (pkTable == null || fkTable == null) {
                    log.debug((Object)("PK (" + pkRefId + ") or FK (" + fkRefId + ") table(s) not found for relation " + relName));
                    continue;
                }
                RelationLoadInfo relationLoadInfo = new RelationLoadInfo(relName, relType, pkTable, fkTable);
                relInfos.add(relationLoadInfo);
                for (Element columnElem : XMLUtils.getChildElementList((Element)element, (String)"column")) {
                    String name = columnElem.getAttribute("name");
                    String refName = columnElem.getAttribute("ref-name");
                    relationLoadInfo.columns.put(name, refName);
                }
                for (Element bendElem : XMLUtils.getChildElementList((Element)element, (String)"bend")) {
                    String type = bendElem.getAttribute("type");
                    if ("rel".equals(type)) continue;
                    String locX = bendElem.getAttribute("x");
                    String locY = bendElem.getAttribute("y");
                    if (CommonUtils.isEmpty((String)locX) || CommonUtils.isEmpty((String)locY)) continue;
                    relationLoadInfo.bends.add(new int[]{Integer.parseInt(locX), Integer.parseInt(locY)});
                }
                monitor.worked(1);
            }
            monitor.done();
        }
        ArrayList<DBSEntity> tableList = new ArrayList<DBSEntity>();
        for (ElementLoadInfo elementLoadInfo : tableInfos) {
            if (elementLoadInfo.entity == null) continue;
            tableList.add(elementLoadInfo.entity);
        }
        diagram.fillEntities(monitor, tableList, null);
        for (RelationLoadInfo relationLoadInfo : relInfos) {
            if (!relationLoadInfo.type.equals(ERDConstants.CONSTRAINT_LOGICAL_FK.getId())) continue;
            sourceEntity = relationLoadInfo.pkTable.entity != null ? diagram.getEntity(relationLoadInfo.pkTable.entity) : relationLoadInfo.pkTable.note;
            Object object = targetEntity = relationLoadInfo.fkTable.entity != null ? diagram.getEntity(relationLoadInfo.fkTable.entity) : relationLoadInfo.fkTable.note;
            if (sourceEntity != null && targetEntity != null) {
                new ERDAssociation((ERDElement)targetEntity, (ERDElement)sourceEntity, false);
            }
            diagram.addInitRelationBends((ERDElement<?>)sourceEntity, (ERDElement<?>)targetEntity, relationLoadInfo.name, relationLoadInfo.bends);
        }
        for (RelationLoadInfo relationLoadInfo : relInfos) {
            if (CommonUtils.isEmpty(relationLoadInfo.bends) || relationLoadInfo.pkTable.entity == null || relationLoadInfo.fkTable.entity == null) continue;
            sourceEntity = diagram.getEntity(relationLoadInfo.pkTable.entity);
            if (sourceEntity == null) {
                log.warn((Object)("Source table " + relationLoadInfo.pkTable.entity.getName() + " not found"));
                continue;
            }
            targetEntity = diagram.getEntity(relationLoadInfo.fkTable.entity);
            if (targetEntity == null) {
                log.warn((Object)("Target table " + relationLoadInfo.pkTable.entity.getName() + " not found"));
                continue;
            }
            diagram.addInitRelationBends((ERDElement<?>)sourceEntity, (ERDElement<?>)targetEntity, relationLoadInfo.name, relationLoadInfo.bends);
        }
    }

    public static String serializeDiagram(DBRProgressMonitor monitor, @Nullable DiagramPart diagramPart, EntityDiagram diagram, boolean verbose, boolean compact) throws IOException {
        List allNodeFigures = diagramPart == null ? new ArrayList() : diagramPart.getFigure().getChildren();
        Map<DBPDataSourceContainer, DataSourceObjects> dsMap = DiagramLoader.createDataSourceObjectMap(diagram);
        IdentityHashMap<Object, ElementSaveInfo> elementInfoMap = new IdentityHashMap<Object, ElementSaveInfo>();
        int elementCounter = 1;
        StringWriter out = new StringWriter(1000);
        XMLBuilder xml = new XMLBuilder((Writer)out, GeneralUtils.UTF8_ENCODING, !compact);
        xml.setButify(!compact);
        if (verbose) {
            xml.addContent((CharSequence)"\n<!DOCTYPE diagram [\n<!ATTLIST diagram version CDATA #REQUIRED\n name CDATA #IMPLIED\n time CDATA #REQUIRED>\n<!ELEMENT diagram (entities, relations, notes)>\n<!ELEMENT entities (data-source*)>\n<!ELEMENT data-source (entity*)>\n<!ATTLIST data-source id CDATA #REQUIRED>\n<!ELEMENT entity (path*)>\n<!ATTLIST entity id ID #REQUIRED\n name CDATA #REQUIRED\n fq-name CDATA #REQUIRED>\n<!ELEMENT relations (relation*)>\n<!ELEMENT relation (bend*)>\n<!ATTLIST relation name CDATA #REQUIRED\n fq-name CDATA #REQUIRED\n pk-ref IDREF #REQUIRED\n fk-ref IDREF #REQUIRED>\n]>\n");
        }
        xml.startElement("diagram");
        xml.addAttribute("version", 1);
        if (diagram != null) {
            xml.addAttribute("name", diagram.getName());
        }
        if (compact) {
            xml.addAttribute("time", RuntimeUtils.getCurrentTimeStamp());
        }
        if (diagram != null) {
            xml.startElement("entities");
            for (DBPDataSourceContainer dsContainer : dsMap.keySet()) {
                xml.startElement("data-source");
                xml.addAttribute("id", dsContainer.getId());
                DataSourceObjects desc = dsMap.get(dsContainer);
                for (ERDEntity erdEntity : desc.entities) {
                    ERDContainerDecorated.NodeVisualInfo visualInfo;
                    DBSEntity table = (DBSEntity)erdEntity.getObject();
                    EntityPart tablePart = diagramPart == null ? null : diagramPart.getEntityPart(erdEntity);
                    ElementSaveInfo info = new ElementSaveInfo((ERDElement)erdEntity, tablePart, elementCounter++);
                    elementInfoMap.put(erdEntity, info);
                    xml.startElement("entity");
                    xml.addAttribute("id", info.objectId);
                    xml.addAttribute("name", table.getName());
                    if (table instanceof DBPQualifiedObject) {
                        xml.addAttribute("fq-name", ((DBPQualifiedObject)table).getFullyQualifiedName(DBPEvaluationContext.UI));
                    }
                    if (!CommonUtils.isEmpty((String)erdEntity.getAlias())) {
                        xml.addAttribute("alias", erdEntity.getAlias());
                    }
                    if (erdEntity.getAttributeVisibility() != null) {
                        xml.addAttribute("showAttrs", erdEntity.getAttributeVisibility().name());
                    }
                    if (tablePart != null) {
                        visualInfo = new ERDContainerDecorated.NodeVisualInfo();
                        visualInfo.initBounds = tablePart.getBounds();
                        visualInfo.bgColor = tablePart.getCustomBackgroundColor();
                        DiagramLoader.saveColorAndOrder(allNodeFigures, xml, tablePart);
                    } else {
                        visualInfo = diagram.getVisualInfo((DBSEntity)erdEntity.getObject());
                    }
                    if (visualInfo != null && visualInfo.initBounds != null) {
                        xml.addAttribute("x", visualInfo.initBounds.x);
                        xml.addAttribute("y", visualInfo.initBounds.y);
                    }
                    Object parent = table.getParentObject();
                    while (parent != null && DBUtils.getPublicObjectContainer((DBSObject)parent) != dsContainer) {
                        xml.startElement("path");
                        xml.addAttribute("name", parent.getName());
                        xml.endElement();
                        parent = parent.getParentObject();
                    }
                    xml.endElement();
                }
                xml.endElement();
            }
            xml.endElement();
            if (!CommonUtils.isEmpty((Collection)diagram.getNotes())) {
                xml.startElement("notes");
                for (ERDNote note : diagram.getNotes()) {
                    NotePart notePart = diagramPart == null ? null : diagramPart.getNotePart(note);
                    xml.startElement("note");
                    if (notePart != null) {
                        ElementSaveInfo info = new ElementSaveInfo((ERDElement)note, notePart, elementCounter++);
                        elementInfoMap.put(note, info);
                        xml.addAttribute("id", info.objectId);
                        DiagramLoader.saveColorAndOrder(allNodeFigures, xml, notePart);
                        Rectangle noteBounds = notePart.getBounds();
                        if (noteBounds != null) {
                            xml.addAttribute("x", noteBounds.x);
                            xml.addAttribute("y", noteBounds.y);
                            xml.addAttribute("w", noteBounds.width);
                            xml.addAttribute("h", noteBounds.height);
                        }
                    }
                    xml.addText((CharSequence)note.getObject());
                    xml.endElement();
                }
                xml.endElement();
            }
            xml.startElement("relations");
            ArrayList allElements = new ArrayList();
            allElements.addAll(diagram.getEntities());
            allElements.addAll(diagram.getNotes());
            for (ERDElement element : allElements) {
                for (ERDAssociation rel : element.getReferences()) {
                    List<Bendpoint> bendpoints;
                    AssociationPart associationPart;
                    ElementSaveInfo pkInfo = (ElementSaveInfo)elementInfoMap.get(rel.getTargetEntity());
                    if (pkInfo == null) {
                        log.error((Object)("Cannot find PK table '" + rel.getTargetEntity().getName() + "' in info map"));
                        continue;
                    }
                    ElementSaveInfo fkInfo = (ElementSaveInfo)elementInfoMap.get(rel.getSourceEntity());
                    if (fkInfo == null) {
                        log.error((Object)("Cannot find FK table '" + rel.getSourceEntity().getName() + "' in info map"));
                        continue;
                    }
                    DBSEntityAssociation association = (DBSEntityAssociation)rel.getObject();
                    xml.startElement("relation");
                    xml.addAttribute("name", association.getName());
                    if (association instanceof DBPQualifiedObject) {
                        xml.addAttribute("fq-name", ((DBPQualifiedObject)association).getFullyQualifiedName(DBPEvaluationContext.UI));
                    }
                    xml.addAttribute("type", association.getConstraintType().getId());
                    xml.addAttribute("pk-ref", pkInfo.objectId);
                    xml.addAttribute("fk-ref", fkInfo.objectId);
                    if (association instanceof ERDLogicalAssociation) {
                        for (DBSEntityAttributeRef column : ((ERDLogicalAssociation)association).getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor())) {
                            xml.startElement("column");
                            xml.addAttribute("name", column.getAttribute().getName());
                            try {
                                DBSEntityAttribute referenceAttribute = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)column.getAttribute(), (boolean)false);
                                if (referenceAttribute != null) {
                                    xml.addAttribute("ref-name", referenceAttribute.getName());
                                }
                            }
                            catch (DBException e) {
                                log.warn((Object)"Error getting reference attribute", (Throwable)e);
                            }
                            xml.endElement();
                        }
                    }
                    if (pkInfo.nodePart != null && (associationPart = pkInfo.nodePart.getConnectionPart(rel, false)) != null && !CommonUtils.isEmpty(bendpoints = associationPart.getBendpoints())) {
                        for (Bendpoint bendpoint : bendpoints) {
                            xml.startElement("bend");
                            if (bendpoint instanceof AbsoluteBendpoint) {
                                xml.addAttribute("type", "abs");
                                xml.addAttribute("x", bendpoint.getLocation().x);
                                xml.addAttribute("y", bendpoint.getLocation().y);
                            } else if (bendpoint instanceof RelativeBendpoint) {
                                xml.addAttribute("type", "rel");
                                xml.addAttribute("x", bendpoint.getLocation().x);
                                xml.addAttribute("y", bendpoint.getLocation().y);
                            }
                            xml.endElement();
                        }
                    }
                    xml.endElement();
                }
            }
            xml.endElement();
        }
        xml.endElement();
        xml.flush();
        return out.toString();
    }

    private static Map<DBPDataSourceContainer, DataSourceObjects> createDataSourceObjectMap(EntityDiagram diagram) {
        IdentityHashMap<DBPDataSourceContainer, DataSourceObjects> dsMap = new IdentityHashMap<DBPDataSourceContainer, DataSourceObjects>();
        if (diagram != null) {
            for (ERDEntity erdEntity : diagram.getEntities()) {
                DBPDataSourceContainer dsContainer = ((DBSEntity)erdEntity.getObject()).getDataSource().getContainer();
                DataSourceObjects desc = dsMap.computeIfAbsent(dsContainer, k -> new DataSourceObjects());
                desc.entities.add(erdEntity);
            }
        }
        return dsMap;
    }

    private static void saveColorAndOrder(List allNodeFigures, XMLBuilder xml, NodePart nodePart) throws IOException {
        if (nodePart != null) {
            int defBorderWidth;
            Color defFgColor;
            Color fgColor;
            Color defBgColor;
            Color bgColor;
            xml.addAttribute("order", allNodeFigures.indexOf(nodePart.getFigure()));
            if (nodePart.getCustomTransparency()) {
                xml.addAttribute("transparent", true);
            }
            if ((bgColor = nodePart.getCustomBackgroundColor()) != null && !CommonUtils.equalObjects((Object)bgColor, (Object)(defBgColor = UIUtils.getColorRegistry().get(nodePart instanceof NotePart ? "org.jkiss.dbeaver.erd.diagram.notes.background" : "org.jkiss.dbeaver.erd.diagram.entity.regular.background")))) {
                xml.addAttribute("color-bg", StringConverter.asString((RGB)bgColor.getRGB()));
            }
            if ((fgColor = nodePart.getCustomForegroundColor()) != null && !CommonUtils.equalObjects((Object)fgColor, (Object)(defFgColor = UIUtils.getColorRegistry().get(nodePart instanceof NotePart ? "org.jkiss.dbeaver.erd.diagram.notes.foreground" : "org.jkiss.dbeaver.erd.diagram.entity.name.foreground")))) {
                xml.addAttribute("color-fg", StringConverter.asString((RGB)fgColor.getRGB()));
            }
            int borderWidth = nodePart.getCustomBorderWidth();
            int n = defBorderWidth = nodePart instanceof NotePart ? 1 : 2;
            if (borderWidth != defBorderWidth) {
                xml.addAttribute("border-width", borderWidth);
            }
            if (!SharedFonts.equalFonts((Font)nodePart.getCustomFont(), (Font)Display.getCurrent().getSystemFont())) {
                xml.addAttribute("font", SharedFonts.toString((Font)nodePart.getCustomFont()));
            }
        }
    }

    private static void loadNodeVisualInfo(Element entityElem, ERDContainerDecorated.NodeVisualInfo visualInfo) {
        String orderStr;
        String fontStr;
        String borderWidth;
        String colorFg;
        String colorBg;
        String isTransparent = entityElem.getAttribute("transparent");
        if (!CommonUtils.isEmpty((String)isTransparent)) {
            visualInfo.transparent = CommonUtils.toBoolean((Object)isTransparent);
        }
        if (!CommonUtils.isEmpty((String)(colorBg = entityElem.getAttribute("color-bg")))) {
            visualInfo.bgColor = UIUtils.getSharedColor((String)colorBg);
        }
        if (!CommonUtils.isEmpty((String)(colorFg = entityElem.getAttribute("color-fg")))) {
            visualInfo.fgColor = UIUtils.getSharedColor((String)colorFg);
        }
        if (!CommonUtils.isEmpty((String)(borderWidth = entityElem.getAttribute("border-width")))) {
            visualInfo.borderWidth = CommonUtils.toInt((Object)borderWidth);
        }
        if (!CommonUtils.isEmpty((String)(fontStr = entityElem.getAttribute("font")))) {
            visualInfo.font = UIUtils.getSharedFonts().getFont((Device)Display.getCurrent(), fontStr);
        }
        if (!CommonUtils.isEmpty((String)(orderStr = entityElem.getAttribute("order")))) {
            visualInfo.zOrder = Integer.parseInt(orderStr);
        }
    }

    private static class DataSourceObjects {
        List<ERDEntity> entities = new ArrayList<ERDEntity>();

        private DataSourceObjects() {
        }
    }

    private static class ElementLoadInfo {
        final String objectId;
        final DBSEntity entity;
        final ERDNote note;
        final ERDContainerDecorated.NodeVisualInfo visualInfo;

        private ElementLoadInfo(String objectId, DBSEntity entity, ERDNote note, ERDContainerDecorated.NodeVisualInfo visualInfo) {
            this.objectId = objectId;
            this.entity = entity;
            this.note = note;
            this.visualInfo = visualInfo;
        }
    }

    private static class ElementSaveInfo {
        final ERDElement element;
        final NodePart nodePart;
        final int objectId;

        private ElementSaveInfo(ERDElement element, NodePart nodePart, int objectId) {
            this.element = element;
            this.nodePart = nodePart;
            this.objectId = objectId;
        }
    }

    private static class RelationLoadInfo {
        final String name;
        final String type;
        final ElementLoadInfo pkTable;
        final ElementLoadInfo fkTable;
        final Map<String, String> columns = new LinkedHashMap<String, String>();
        final List<int[]> bends = new ArrayList<int[]>();

        private RelationLoadInfo(String name, String type, ElementLoadInfo pkTable, ElementLoadInfo fkTable) {
            this.name = name;
            this.type = type;
            this.pkTable = pkTable;
            this.fkTable = fkTable;
        }
    }
}

