/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProcessor;

public class SQLContentAssistant
extends ContentAssistant {
    private final SQLEditorBase editor;

    public SQLContentAssistant(SQLEditorBase editor) {
        this.editor = editor;
        this.enableColoredLabels(true);
    }

    protected ContentAssistant.AutoAssistListener createAutoAssistListener() {
        return new SQLAutoAssistListener();
    }

    public String showContextInformation() {
        SQLCompletionProcessor.setLookupTemplates(true);
        try {
            String string = super.showPossibleCompletions();
            return string;
        }
        finally {
            SQLCompletionProcessor.setLookupTemplates(false);
        }
    }

    private class SQLAutoAssistListener
    extends ContentAssistant.AutoAssistListener {
        private SQLAutoAssistListener() {
            super((ContentAssistant)SQLContentAssistant.this);
        }

        protected void showAssist(int showStyle) {
            if (!(showStyle != 1 || SQLEditorUtils.isSQLSyntaxParserApplied(SQLContentAssistant.this.editor.getEditorInput()) && SQLContentAssistant.this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ContentAssistant.auto.activation.enable"))) {
                return;
            }
            SQLCompletionProcessor.setSimpleMode(true);
            try {
                super.showAssist(showStyle);
            }
            finally {
                SQLCompletionProcessor.setSimpleMode(false);
            }
        }
    }
}

