/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCTransaction;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaConnectionProvider;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaScriptSource;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaVersionManager;
import org.jkiss.dbeaver.model.sql.translate.SQLQueryTranslator;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.IOUtils;

public final class SQLSchemaManager {
    private static final Log log = Log.getLog(SQLSchemaManager.class);
    private final String schemaId;
    private final SQLSchemaScriptSource scriptSource;
    private final SQLSchemaConnectionProvider connectionProvider;
    private final SQLSchemaVersionManager versionManager;
    private SQLDialect targetDatabaseDialect;
    private String targetDatabaseName;
    private int schemaVersionActual;
    private int schemaVersionObsolete;

    public SQLSchemaManager(String schemaId, SQLSchemaScriptSource scriptSource, SQLSchemaConnectionProvider connectionProvider, SQLSchemaVersionManager versionManager, SQLDialect targetDatabaseDialect, String targetDatabaseName, int schemaVersionActual, int schemaVersionObsolete) {
        this.schemaId = schemaId;
        this.scriptSource = scriptSource;
        this.connectionProvider = connectionProvider;
        this.versionManager = versionManager;
        this.targetDatabaseDialect = targetDatabaseDialect;
        this.targetDatabaseName = targetDatabaseName;
        this.schemaVersionActual = schemaVersionActual;
        this.schemaVersionObsolete = schemaVersionObsolete;
    }

    public void updateSchema(DBRProgressMonitor monitor) throws DBException {
        try {
            Connection dbCon = this.connectionProvider.getDatabaseConnection(monitor);
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCTransaction txn = new JDBCTransaction(dbCon);){
                int currentSchemaVersion = this.versionManager.getCurrentSchemaVersion(monitor, dbCon, this.targetDatabaseName);
                txn.rollback();
                if (currentSchemaVersion < 0) {
                    this.createNewSchema(monitor, dbCon);
                    this.versionManager.updateCurrentSchemaVersion(monitor, dbCon, this.targetDatabaseName);
                } else if (this.schemaVersionObsolete > 0 && currentSchemaVersion < this.schemaVersionObsolete) {
                    this.dropSchema(monitor, dbCon);
                    this.createNewSchema(monitor, dbCon);
                    this.versionManager.updateCurrentSchemaVersion(monitor, dbCon, this.targetDatabaseName);
                } else if (this.schemaVersionActual > currentSchemaVersion) {
                    this.upgradeSchemaVersion(monitor, dbCon, currentSchemaVersion);
                }
                txn.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SQLException e) {
            throw new DBException("Error updating " + this.schemaId + " schema version", (Throwable)e);
        }
    }

    private void upgradeSchemaVersion(DBRProgressMonitor monitor, Connection connection, int currentSchemaVersion) throws IOException, DBException, SQLException {
        int curVer = currentSchemaVersion;
        while (curVer < this.schemaVersionActual) {
            int updateToVer = curVer + 1;
            Reader ddlStream = this.scriptSource.openSchemaUpdateScript(monitor, updateToVer);
            if (ddlStream != null) {
                log.debug((Object)("Update schema " + this.schemaId + " version from " + curVer + " to " + updateToVer));
                try {
                    try {
                        this.executeScript(monitor, connection, ddlStream, true);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error updating " + this.schemaId + " schema version from " + curVer + " to " + updateToVer), (Throwable)e);
                        throw e;
                    }
                }
                finally {
                    ContentUtils.close((Closeable)ddlStream);
                }
                this.versionManager.updateCurrentSchemaVersion(monitor, connection, this.targetDatabaseName);
            }
            ++curVer;
        }
    }

    private void createNewSchema(DBRProgressMonitor monitor, Connection connection) throws IOException, DBException, SQLException {
        log.debug((Object)("Create new schema " + this.schemaId));
        Throwable throwable = null;
        Object var4_5 = null;
        try (Reader ddlStream = this.scriptSource.openSchemaCreateScript(monitor);){
            this.executeScript(monitor, connection, ddlStream, false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.versionManager.fillInitialSchemaData(monitor, connection);
    }

    private void dropSchema(DBRProgressMonitor monitor, Connection connection) throws DBException, SQLException, IOException {
        log.debug((Object)("Drop schema " + this.schemaId));
        this.executeScript(monitor, connection, new StringReader("DROP ALL OBJECTS"), true);
    }

    private void executeScript(DBRProgressMonitor monitor, Connection connection, Reader ddlStream, boolean logQueries) throws SQLException, IOException, DBException {
        String[] ddl;
        String ddlText = IOUtils.readToString((Reader)ddlStream);
        SimplePreferenceStore prefStore = new SimplePreferenceStore(){

            public void save() throws IOException {
            }
        };
        prefStore.setValue("sql.format.formatter", "default");
        BasicSQLDialect sourceDialect = new BasicSQLDialect(){};
        ddlText = SQLQueryTranslator.translateScript((SQLDialect)sourceDialect, this.targetDatabaseDialect, (DBPPreferenceStore)prefStore, ddlText);
        String[] stringArray = ddl = ddlText.split(";");
        int n = ddl.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(line = line.trim()).isEmpty()) {
                if (logQueries) {
                    log.debug((Object)("Process [" + line + "]"));
                }
                Throwable throwable = null;
                Object var14_15 = null;
                try (Statement dbStat = connection.createStatement();){
                    try {
                        dbStat.execute(line);
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error during sql migration", (Throwable)e);
                        log.info((Object)"Trying to apply the migration again");
                        dbStat.execute(line);
                        log.error((Object)"The second attempt was successful");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++n2;
        }
    }
}

