/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.io.IOException;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCConnectException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCConnectionConfigurer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCConnectionImpl;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCFactoryDefault;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SecurityManagerUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public abstract class JDBCDataSource
extends AbstractDataSource
implements DBPDataTypeProvider,
DBPErrorAssistant,
DBPRefreshableObject,
DBSObject,
DBSObjectContainer,
DBSInstanceContainer,
DBCQueryTransformProvider,
IAdaptable {
    private static final Log log = Log.getLog(JDBCDataSource.class);
    private static final boolean REFRESH_CREDENTIALS_ON_CONNECT = false;
    @NotNull
    protected volatile DBPDataSourceInfo dataSourceInfo;
    protected final SQLDialect sqlDialect;
    protected final JDBCFactory jdbcFactory;
    private JDBCRemoteInstance defaultRemoteInstance;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    private final transient List<Connection> closingConnections = new ArrayList<Connection>();
    private List<Path> tempFiles;

    protected JDBCDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull SQLDialect dialect) throws DBException {
        this(monitor, container, dialect, true);
    }

    protected JDBCDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull SQLDialect dialect, boolean initContext) throws DBException {
        this(container, dialect);
        if (initContext) {
            try {
                this.initializeRemoteInstance(monitor);
            }
            catch (DBException e) {
                this.shutdown(monitor);
                throw e;
            }
        }
    }

    protected JDBCDataSource(@NotNull DBPDataSourceContainer container, @NotNull SQLDialect dialect) {
        super(container);
        this.dataSourceInfo = new JDBCDataSourceInfo(container);
        this.sqlDialect = dialect;
        this.jdbcFactory = this.createJdbcFactory();
    }

    @Override
    @NotNull
    public JDBCDataSource getDataSource() {
        return this;
    }

    protected void initializeRemoteInstance(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.defaultRemoteInstance = new JDBCRemoteInstance(monitor, this, true);
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        DBPDriver driver = this.getContainer().getDriver();
        DBPConnectionConfiguration connectionInfo = new DBPConnectionConfiguration(this.container.getActualConnectionConfiguration());
        Properties connectProps = this.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
        JDBCConnectionConfigurer connectionConfigurer = GeneralUtils.adapt(this, JDBCConnectionConfigurer.class);
        DBPAuthModelDescriptor authModelDescriptor = driver.getDataSourceProvider().detectConnectionAuthModel(driver, connectionInfo);
        DBAAuthModel authModel = authModelDescriptor.getInstance();
        try {
            boolean openTaskFinished;
            if (connectionConfigurer != null) {
                connectionConfigurer.beforeConnection(monitor, connectionInfo, connectProps);
            }
            String url = this.getConnectionURL(connectionInfo);
            boolean isInvalidURL = false;
            monitor.subTask("Connecting " + purpose);
            Connection[] connection = new Connection[1];
            Exception[] error = new Exception[1];
            int openTimeout = this.getContainer().getPreferenceStore().getInt("connection.open.timeout");
            try {
                Object credentials = authModel.loadCredentials(this.getContainer(), connectionInfo);
                authModel.initAuthentication(monitor, this, credentials, connectionInfo, connectProps);
            }
            catch (DBException e) {
                throw new DBCException("Authentication error: " + e.getMessage(), e);
            }
            Driver driverInstance = null;
            if (driver.isInstantiable() && !CommonUtils.isEmpty((String)driver.getDriverClassName())) {
                try {
                    driverInstance = this.getDriverInstance(monitor);
                }
                catch (DBException e) {
                    throw new DBCConnectException("Can't create driver instance", (Throwable)e, this);
                }
            }
            if (!CommonUtils.isEmpty((String)driver.getDriverClassName())) {
                try {
                    driver.loadDriver(monitor);
                    Class.forName(driver.getDriverClassName(), true, driver.getClassLoader());
                }
                catch (Exception e) {
                    throw new DBCException("Driver class '" + driver.getDriverClassName() + "' not found", e);
                }
            }
            if (driverInstance != null) {
                try {
                    if (!driverInstance.acceptsURL(url)) {
                        isInvalidURL = true;
                    }
                }
                catch (Throwable e) {
                    log.debug("Error in " + driverInstance.getClass().getName() + ".acceptsURL() - " + url, e);
                }
            }
            Driver driverInstanceFinal = driverInstance;
            DBRRunnableWithProgress connectTask = monitor1 -> {
                block13: {
                    try {
                        try {
                            if (driverInstanceFinal == null) {
                                connectionArray[0] = DriverManager.getConnection(url, connectProps);
                                break block13;
                            }
                            connectionArray[0] = driverInstanceFinal.connect(url, connectProps);
                        }
                        catch (Exception e) {
                            exceptionArray[0] = e;
                            if (connectionConfigurer == null) break block13;
                            try {
                                connectionConfigurer.afterConnection(monitor, connectionInfo, connectProps, connection[0], error[0]);
                            }
                            catch (Exception e2) {
                                log.debug(e2);
                            }
                        }
                    }
                    finally {
                        if (connectionConfigurer != null) {
                            try {
                                connectionConfigurer.afterConnection(monitor, connectionInfo, connectProps, connection[0], error[0]);
                            }
                            catch (Exception e) {
                                log.debug(e);
                            }
                        }
                    }
                }
            };
            try {
                openTaskFinished = SecurityManagerUtils.wrapDriverActions(this.getContainer(), () -> {
                    if (openTimeout <= 0) {
                        connectTask.run(monitor);
                        return true;
                    }
                    return RuntimeUtils.runTask(connectTask, "Opening database connection", openTimeout + 2000);
                });
            }
            finally {
                authModel.endAuthentication(this.container, connectionInfo, connectProps);
            }
            if (error[0] != null) {
                throw error[0];
            }
            if (!openTaskFinished) {
                throw new DBCException("Connection has timed out");
            }
            if (connection[0] == null) {
                if (isInvalidURL) {
                    throw new DBCException("Invalid JDBC URL: " + url);
                }
                throw new DBCException("Null connection returned");
            }
            if (this.container.isConnectionReadOnly() && !this.isConnectionReadOnlyBroken()) {
                connection[0].setReadOnly(true);
            }
            return connection[0];
        }
        catch (SQLException ex) {
            throw new DBCConnectException(ex.getMessage(), (Throwable)ex, this);
        }
        catch (DBCException ex) {
            throw ex;
        }
        catch (Throwable e) {
            throw new DBCConnectException("Unexpected driver error occurred while connecting to the database", e);
        }
    }

    protected void fillConnectionProperties(DBPConnectionConfiguration connectionInfo, Properties connectProps) {
        Map<String, Object> driverProperties = this.container.getDriver().getConnectionProperties();
        for (Map.Entry<String, Object> prop : driverProperties.entrySet()) {
            connectProps.setProperty(prop.getKey(), CommonUtils.toString((Object)prop.getValue()));
        }
        for (Map.Entry<String, String> prop : connectionInfo.getProperties().entrySet()) {
            connectProps.setProperty(CommonUtils.toString((Object)prop.getKey()), CommonUtils.toString((Object)prop.getValue()));
        }
    }

    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        Properties connectProps = new Properties();
        Map<String, String> internalProps = this.getInternalConnectionProperties(monitor, this.getContainer().getDriver(), context, purpose, connectionInfo);
        if (internalProps != null) {
            connectProps.putAll(internalProps);
        }
        this.fillConnectionProperties(connectionInfo, connectProps);
        return connectProps;
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String url = connectionInfo.getUrl();
        if (CommonUtils.isEmpty((String)url)) {
            url = this.getContainer().getDriver().getConnectionURL(connectionInfo);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection(Connection connection, String purpose, boolean doRollback) {
        if (connection != null) {
            List<Connection> list = this.closingConnections;
            synchronized (list) {
                block5: {
                    if (!this.closingConnections.contains(connection)) break block5;
                    return true;
                }
                this.closingConnections.add(connection);
            }
            return RuntimeUtils.runTask(monitor -> {
                if (doRollback) {
                    try {
                        connection.rollback();
                    }
                    catch (Throwable e) {
                        log.debug("Error closing active transaction", e);
                    }
                }
                try {
                    SecurityManagerUtils.wrapDriverActions(this.getContainer(), () -> {
                        connection.close();
                        return null;
                    });
                }
                catch (Throwable ex) {
                    log.debug("Error closing connection", ex);
                }
                List<Connection> list = this.closingConnections;
                synchronized (list) {
                    this.closingConnections.remove(connection);
                }
            }, "Close JDBC connection (" + purpose + ")", this.getContainer().getPreferenceStore().getInt("connection.close.timeout"));
        }
        log.debug("Null connection parameter");
        return true;
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
    }

    @NotNull
    protected JDBCConnectionImpl createConnection(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new JDBCConnectionImpl(context, monitor, purpose, taskTitle);
    }

    @Override
    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.dataSourceInfo;
    }

    @Override
    @NotNull
    public SQLDialect getSQLDialect() {
        return this.sqlDialect;
    }

    @NotNull
    public JDBCFactory getJdbcFactory() {
        return this.jdbcFactory;
    }

    @Override
    @NotNull
    public JDBCRemoteInstance getDefaultInstance() {
        return this.defaultRemoteInstance;
    }

    @NotNull
    public List<? extends JDBCRemoteInstance> getAvailableInstances() {
        JDBCRemoteInstance defaultInstance = this.getDefaultInstance();
        return defaultInstance == null ? Collections.emptyList() : Collections.singletonList(defaultInstance);
    }

    @Override
    public void shutdown(DBRProgressMonitor monitor) {
        for (JDBCRemoteInstance instance : this.getAvailableInstances()) {
            Object exclusiveLock = instance.getExclusiveLock().acquireExclusiveLock();
            try {
                monitor.subTask("Disconnect from '" + instance.getName() + "'");
                instance.shutdown(monitor);
                monitor.worked(1);
            }
            finally {
                instance.getExclusiveLock().releaseExclusiveLock(exclusiveLock);
            }
        }
        this.defaultRemoteInstance = null;
        if (this.tempFiles != null) {
            for (Path tmpFile : this.tempFiles) {
                try {
                    if (Files.isDirectory(tmpFile, new LinkOption[0])) {
                        IOUtils.deleteDirectory((Path)tmpFile);
                        continue;
                    }
                    Files.delete(tmpFile);
                }
                catch (IOException e) {
                    log.debug("Error deleting temp file for '" + this.getContainer().getName() + "'", e);
                }
            }
            this.tempFiles = null;
        }
    }

    @Override
    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getDefaultInstance().initializeMetaContext(monitor);
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession(monitor, this, ModelMessages.model_jdbc_read_database_meta_data);){
                    JDBCDatabaseMetaData metaData = session.getMetaData();
                    this.readDatabaseServerVersion(metaData);
                    if (this.sqlDialect instanceof JDBCSQLDialect) {
                        try {
                            ((JDBCSQLDialect)this.sqlDialect).initDriverSettings(session, this, metaData);
                        }
                        catch (Throwable e) {
                            log.error("Error initializing dialect driver settings", e);
                        }
                    }
                    try {
                        this.dataSourceInfo = this.createDataSourceInfo(monitor, metaData);
                    }
                    catch (Throwable e) {
                        log.error("Error obtaining database info", e);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException ex) {
                throw new DBException("Error getting JDBC meta data", ex, this);
            }
        }
        finally {
            if (this.dataSourceInfo == null) {
                log.warn("NULL datasource info was created");
                this.dataSourceInfo = new JDBCDataSourceInfo(this.container);
            }
        }
    }

    protected void readDatabaseServerVersion(DatabaseMetaData metaData) {
        if (this.databaseMajorVersion <= 0 && this.databaseMinorVersion <= 0) {
            try {
                this.databaseMajorVersion = metaData.getDatabaseMajorVersion();
                this.databaseMinorVersion = metaData.getDatabaseMinorVersion();
            }
            catch (Throwable e) {
                log.error("Error determining server version", e);
            }
        }
    }

    public boolean isServerVersionAtLeast(int major, int minor) {
        if (this.databaseMajorVersion < major) {
            return false;
        }
        return this.databaseMajorVersion != major || this.databaseMinorVersion >= minor;
    }

    public boolean isDriverVersionAtLeast(int major, int minor) {
        int majorVersion;
        Driver driver;
        block3: {
            try {
                driver = this.getDriverInstance(new VoidProgressMonitor());
                majorVersion = driver.getMajorVersion();
                if (majorVersion >= major) break block3;
                return false;
            }
            catch (DBException e) {
                log.debug("Can't obtain driver instance", e);
                return false;
            }
        }
        return majorVersion != major || driver.getMinorVersion() >= minor;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.dataSourceInfo = new JDBCDataSourceInfo(this.container);
        return this;
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new JDBCExecutionContext(instance, type);
    }

    @Override
    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        return null;
    }

    private static int getValueTypeByTypeName(@NotNull String typeName, int valueType) {
        if (valueType == 1111 || valueType == 12) {
            if ("BLOB".equalsIgnoreCase(typeName)) {
                return 2004;
            }
            if ("CLOB".equalsIgnoreCase(typeName)) {
                return 2005;
            }
            if ("NCLOB".equalsIgnoreCase(typeName)) {
                return 2011;
            }
        } else if (valueType == -7 && "TINYINT".equalsIgnoreCase(typeName)) {
            return -6;
        }
        return valueType;
    }

    @Override
    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        return JDBCDataSource.getDataKind(typeName, valueType);
    }

    @NotNull
    public static DBPDataKind getDataKind(@NotNull String typeName, int valueType) {
        switch (JDBCDataSource.getValueTypeByTypeName(typeName, valueType)) {
            case 16: {
                return DBPDataKind.BOOLEAN;
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return DBPDataKind.STRING;
            }
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return DBPDataKind.NUMERIC;
            }
            case -7: 
            case -6: {
                if (typeName.toLowerCase().contains("bool")) {
                    return DBPDataKind.BOOLEAN;
                }
                return DBPDataKind.NUMERIC;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return DBPDataKind.DATETIME;
            }
            case -4: 
            case -3: 
            case -2: {
                return DBPDataKind.BINARY;
            }
            case 2004: 
            case 2005: 
            case 2011: {
                return DBPDataKind.CONTENT;
            }
            case 2009: {
                return DBPDataKind.CONTENT;
            }
            case 2002: {
                return DBPDataKind.STRUCT;
            }
            case 2003: {
                return DBPDataKind.ARRAY;
            }
            case -8: {
                return DBPDataKind.ROWID;
            }
            case 2006: {
                return DBPDataKind.REFERENCE;
            }
            case 1111: {
                return DBPDataKind.OBJECT;
            }
        }
        return DBPDataKind.UNKNOWN;
    }

    @Override
    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.getLocalDataType(typeFullName);
    }

    @Override
    public DBSDataType getLocalDataType(int typeID) {
        for (DBSDataType dBSDataType : this.getLocalDataTypes()) {
            if (dBSDataType.getTypeID() != typeID) continue;
            return dBSDataType;
        }
        return null;
    }

    @Override
    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        String typeName = this.getStandardSQLDataTypeName(dataKind);
        DBSDataType dataType = this.getLocalDataType(typeName);
        if (dataType == null) {
            for (DBSDataType dBSDataType : this.getLocalDataTypes()) {
                if (dBSDataType.getDataKind() != dataKind) continue;
                return dBSDataType.getName();
            }
        }
        return typeName;
    }

    @NotNull
    protected String getStandardSQLDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case NUMERIC: {
                return "NUMERIC";
            }
            case STRING: {
                return "VARCHAR";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case BINARY: {
                return "BLOB";
            }
            case CONTENT: {
                return "BLOB";
            }
            case STRUCT: {
                return "VARCHAR";
            }
            case ARRAY: {
                return "VARCHAR";
            }
            case OBJECT: {
                return "VARCHAR";
            }
            case REFERENCE: {
                return "VARCHAR";
            }
            case ROWID: {
                return "ROWID";
            }
            case ANY: {
                return "VARCHAR";
            }
        }
        return "VARCHAR";
    }

    protected boolean isConnectionReadOnlyBroken() {
        return false;
    }

    @Nullable
    protected Driver getDriverInstance(@NotNull DBRProgressMonitor monitor) throws DBException {
        return (Driver)this.container.getDriver().getDriverInstance(monitor);
    }

    @Nullable
    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        return null;
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new JDBCDataSourceInfo(metaData);
    }

    @NotNull
    protected JDBCFactory createJdbcFactory() {
        return new JDBCFactoryDefault();
    }

    @Override
    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        Throwable rootCause;
        String sqlState = SQLState.getStateFromException(error);
        if (sqlState != null) {
            if (SQLState.SQL_08000.getCode().equals(sqlState) || SQLState.SQL_08003.getCode().equals(sqlState) || SQLState.SQL_08006.getCode().equals(sqlState) || SQLState.SQL_08007.getCode().equals(sqlState) || SQLState.SQL_08S01.getCode().equals(sqlState)) {
                return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
            }
            if (SQLState.SQL_23000.getCode().equals(sqlState) || SQLState.SQL_23505.getCode().equals(sqlState)) {
                return DBPErrorAssistant.ErrorType.UNIQUE_KEY_VIOLATION;
            }
        }
        if (GeneralUtils.getRootCause(error) instanceof SocketException) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        if (error instanceof DBCConnectException && (rootCause = GeneralUtils.getRootCause(error)) instanceof ClassNotFoundException) {
            return DBPErrorAssistant.ErrorType.DRIVER_CLASS_MISSING;
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    @Override
    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBCTransactionManager.class) {
            return adapter.cast(DBUtils.getDefaultContext(this.getDefaultInstance(), false));
        }
        if (adapter == DBCQueryTransformProvider.class) {
            return adapter.cast(this);
        }
        return null;
    }

    public void cancelStatementExecute(DBRProgressMonitor monitor, JDBCStatement statement) throws DBException {
        try {
            statement.cancel();
        }
        catch (SQLException e) {
            throw new DBException(e, this);
        }
    }

    protected String saveCertificateToFile(String rootCertProp) throws IOException {
        Path certPath = Files.createTempFile(DBWorkbench.getPlatform().getCertificateStorage().getStorageFolder(), String.valueOf(this.getContainer().getDriver().getId()) + "-" + this.getContainer().getId(), ".cert", new FileAttribute[0]);
        Files.writeString(certPath, (CharSequence)rootCertProp, new OpenOption[0]);
        this.trackTempFile(certPath);
        return certPath.toAbsolutePath().toString();
    }

    public void trackTempFile(Path file) {
        if (this.tempFiles == null) {
            this.tempFiles = new ArrayList<Path>();
        }
        this.tempFiles.add(file);
    }
}

