/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumDataSource;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumExternalTable;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumFunction;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GreenplumSchema
extends PostgreSchema {
    public GreenplumSchema(PostgreDatabase owner, String name, JDBCResultSet resultSet) throws SQLException {
        super(owner, name, (ResultSet)resultSet);
    }

    @NotNull
    protected PostgreSchema.ProceduresCache createProceduresCache() {
        return new GreenplumFunctionsCache();
    }

    @NotNull
    protected PostgreSchema.TableCache createTableCache() {
        return new GreenplumTableCache();
    }

    @NotNull
    public GreenplumDataSource getDataSource() {
        return (GreenplumDataSource)super.getDataSource();
    }

    @Association
    public Collection<? extends JDBCTable> getExternalTables(DBRProgressMonitor monitor) throws DBException {
        return new ArrayList(this.getTableCache().getTypedObjects(monitor, (DBSObject)this, GreenplumExternalTable.class));
    }

    public class GreenplumFunctionsCache
    extends PostgreSchema.ProceduresCache {
        GreenplumFunctionsCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @Nullable PostgreProcedure object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.oid as poid,p.*," + (session.getDataSource().isServerVersionAtLeast(8, 4) ? "pg_catalog.pg_get_expr(p.proargdefaults, 0)" : "NULL") + " as arg_defaults,d.description\n" + "FROM pg_catalog.pg_proc p\n" + "LEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=p.oid\n" + "WHERE p.pronamespace=?" + (object == null ? "" : " AND p.oid=?") + "\nORDER BY p.proname");
            dbStat.setLong(1, owner.getObjectId());
            if (object != null) {
                dbStat.setLong(2, object.getObjectId());
            }
            return dbStat;
        }

        protected GreenplumFunction fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) {
            return new GreenplumFunction(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    public class GreenplumTableCache
    extends PostgreSchema.TableCache {
        GreenplumTableCache() {
            super((PostgreSchema)GreenplumSchema.this);
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreTableContainer container, @Nullable PostgreTableBase object, @Nullable String objectName) throws SQLException {
            GreenplumDataSource dataSource = GreenplumSchema.this.getDataSource();
            String uriLocationColumn = dataSource.isGreenplumVersionAtLeast(session.getProgressMonitor(), 5, 0) ? "urilocation" : "location";
            String execLocationColumn = dataSource.isGreenplumVersionAtLeast(session.getProgressMonitor(), 5, 0) ? "execlocation" : "location";
            boolean serverSupportFmterrtblColumn = dataSource.isServerSupportFmterrtblColumn(session);
            StringBuilder sqlQuery = new StringBuilder("SELECT c.oid,d.description,p.partitiontablename,c.*,\nCASE WHEN x." + uriLocationColumn + " IS NOT NULL THEN array_to_string(x." + uriLocationColumn + ", ',') ELSE '' END AS urilocation,\n" + "CASE WHEN x.command IS NOT NULL THEN x.command ELSE '' END AS command,\n" + "x.fmttype, x.fmtopts,\n" + "coalesce(x.rejectlimit, 0) AS rejectlimit,\n" + "coalesce(x.rejectlimittype, '') AS rejectlimittype,\n" + "array_to_string(x." + execLocationColumn + ", ',') AS execlocation,\n" + "pg_encoding_to_char(x.encoding) AS encoding,\n" + "x.writable,\n").append(serverSupportFmterrtblColumn ? "case when x.fmterrtbl is not NULL then true else false end as \"is_logging_errors\",\n" : "").append("case when c.relstorage = 'x' then true else false end as \"is_ext_table\",\ncase when (ns.nspname !~ '^pg_toast' and ns.nspname like 'pg_temp%') then true else false end as \"is_temp_table\"\nFROM pg_catalog.pg_class c\nINNER JOIN pg_catalog.pg_namespace ns\n\ton ns.oid = c.relnamespace\nLEFT OUTER JOIN pg_catalog.pg_description d\n\tON d.objoid=c.oid AND d.objsubid=0\nLEFT OUTER JOIN pg_catalog.pg_exttable x\n\ton x.reloid = c.oid\nLEFT OUTER JOIN pg_catalog.pg_partitions p\n\ton c.relname = p.partitiontablename and ns.nspname = p.schemaname\nWHERE c.relnamespace= ? AND c.relkind not in ('i','c') ").append(object == null && objectName == null ? "" : " AND relname=?");
            JDBCPreparedStatement dbStat = session.prepareStatement(sqlQuery.toString());
            dbStat.setLong(1, GreenplumSchema.this.getObjectId());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected boolean isPartitionTableRow(@NotNull JDBCResultSet dbResult) {
            return !CommonUtils.isEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"partitiontablename"));
        }
    }
}

