/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSetting;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.output.DBCOutputSeverity;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReaderExt;
import org.jkiss.dbeaver.model.impl.AsyncServerOutputReader;
import org.jkiss.utils.BeanUtils;

public class PostgreServerOutputReader
extends AsyncServerOutputReader
implements DBCServerOutputReaderExt {
    private static final String PSQL_WARNING_CLASS = "org.postgresql.util.PSQLWarning";
    private static final String PSQL_WARNING_GET_SERVER_ERROR_MESSAGE_METHOD = "getServerErrorMessage";
    private static final String SERVER_ERROR_MESSAGE_GET_SEVERITY_METHOD = "getSeverity";

    @NotNull
    public DBCOutputSeverity[] getSupportedSeverities(@NotNull DBCExecutionContext context) {
        PostgreDataSource dataSource = (PostgreDataSource)context.getDataSource();
        PostgreSetting setting = dataSource.getSetting("client_min_messages");
        DBCOutputSeverity[] values = PostgreOutputSeverity.values();
        if (setting != null) {
            int i = 0;
            while (i < values.length) {
                if (values[i].name().equalsIgnoreCase(setting.getValue())) {
                    return Arrays.copyOfRange(values, i, values.length);
                }
                ++i;
            }
        }
        return values;
    }

    protected void dumpWarning(@NotNull DBCOutputWriter output, @NotNull Throwable warning) {
        output.println(PostgreServerOutputReader.getSeverity(warning), warning.getMessage());
    }

    @Nullable
    private static DBCOutputSeverity getSeverity(@NotNull Throwable warning) {
        if (!PSQL_WARNING_CLASS.equals(warning.getClass().getName())) {
            return null;
        }
        try {
            Object obj = BeanUtils.invokeObjectMethod((Object)warning, (String)PSQL_WARNING_GET_SERVER_ERROR_MESSAGE_METHOD);
            String severity = (String)BeanUtils.invokeObjectMethod((Object)obj, (String)SERVER_ERROR_MESSAGE_GET_SEVERITY_METHOD);
            return PostgreOutputSeverity.valueOf(severity);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static enum PostgreOutputSeverity implements DBCOutputSeverity
    {
        DEBUG("Debug"),
        LOG("Log"),
        NOTICE("Notice"),
        WARNING("Warning"),
        ERROR("Error"),
        INFO("Info");

        private final String name;

        private PostgreOutputSeverity(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

