/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.AbstractRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridItem;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.utils.CommonUtils;

class GridColumnRenderer
extends AbstractRenderer {
    public static final int LEFT_MARGIN = 6;
    public static final int RIGHT_MARGIN = 6;
    public static final int BOTTOM_MARGIN = 6;
    public static final int TOP_MARGIN = 6;
    public static final int ARROW_MARGIN = 6;
    public static final int IMAGE_SPACING = 3;
    public static final Image IMAGE_ASTERISK = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_UNKNOWN);
    public static final Image IMAGE_DESC = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_INCREASE);
    public static final Image IMAGE_ASC = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_DECREASE);
    public static final Image IMAGE_FILTER = DBeaverIcons.getImage((DBPImage)UIIcon.DROP_DOWN);
    public static final int SORT_WIDTH = GridColumnRenderer.IMAGE_DESC.getBounds().width;
    public static final int FILTER_WIDTH = GridColumnRenderer.IMAGE_FILTER.getBounds().width;
    private static final boolean PAINT_COLUMN_FOCUS_BORDER = false;

    public GridColumnRenderer(LightGrid grid) {
        super(grid);
    }

    public static Rectangle getSortControlBounds() {
        return IMAGE_DESC.getBounds();
    }

    public static Rectangle getFilterControlBounds() {
        return IMAGE_FILTER.getBounds();
    }

    @Nullable
    protected Image getColumnImage(IGridItem element) {
        return this.grid.getLabelProvider().getImage(element);
    }

    protected String getColumnText(IGridItem item) {
        return this.grid.getLabelProvider().getText(item);
    }

    protected String getColumnDescription(IGridColumn item) {
        return this.grid.getLabelProvider().getDescription(item);
    }

    protected Font getColumnFont(IGridColumn element) {
        Font font = this.grid.getLabelProvider().getFont(element);
        return font != null ? font : this.grid.normalFont;
    }

    public void paint(GC gc, Rectangle bounds, boolean selected, boolean hovering, IGridColumn element) {
        boolean hasFilters = this.grid.getContentProvider().isElementSupportsFilter(element);
        int sortOrder = this.grid.getContentProvider().getSortOrder(element);
        Rectangle sortBounds = sortOrder == 0 ? null : GridColumnRenderer.getSortControlBounds();
        Rectangle filterBounds = GridColumnRenderer.getFilterControlBounds();
        boolean drawSelected = false;
        gc.setBackground(this.grid.getLabelProvider().getHeaderBackground(element, selected || hovering));
        gc.setForeground(this.grid.getLabelProvider().getHeaderForeground(element, selected || hovering));
        gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        int pushedDrawingOffset = 0;
        if (hovering) {
            pushedDrawingOffset = 1;
        }
        int x = 6;
        Image columnImage = this.getColumnImage(element);
        if (columnImage != null) {
            int y = bounds.y + pushedDrawingOffset + 6;
            gc.drawImage(columnImage, bounds.x + x + pushedDrawingOffset, y);
            x += columnImage.getBounds().width + 3;
        }
        int width = bounds.width - x;
        width = sortOrder == 0 ? (width -= 6) : (width -= 6 + sortBounds.width);
        if (hasFilters) {
            width -= filterBounds.width;
        }
        int y = bounds.y + 6;
        String text = this.getColumnText(element);
        text = UITextUtils.getShortString((FontMetrics)this.grid.fontMetrics, (String)text, (int)width);
        gc.setFont(this.getColumnFont(element));
        gc.setClipping(bounds.x + x + pushedDrawingOffset, y + pushedDrawingOffset, width, this.grid.fontMetrics.getHeight());
        gc.drawString(text, bounds.x + x + pushedDrawingOffset, y + pushedDrawingOffset, isTransparent);
        gc.setClipping(null);
        gc.setForeground(this.grid.getLabelProvider().getHeaderBorder(element));
        gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        if (sortOrder != 0) {
            sortBounds.x = bounds.x + bounds.width - sortBounds.width - filterBounds.width - 3;
            sortBounds.y = y;
            if (drawSelected) {
                ++sortBounds.x;
            }
            GridColumnRenderer.paintSort(gc, sortBounds, sortOrder, false);
        }
        if (hasFilters) {
            gc.drawImage(IMAGE_FILTER, bounds.x + bounds.width - filterBounds.width - 3, y);
        }
        if (!CommonUtils.isEmpty((String)(text = this.getColumnDescription(element)))) {
            text = UITextUtils.getShortString((FontMetrics)this.grid.fontMetrics, (String)text, (int)width);
            gc.setFont(this.grid.normalFont);
            gc.drawString(text, bounds.x + x + pushedDrawingOffset, (y += 6 + this.grid.fontMetrics.getHeight()) + pushedDrawingOffset, isTransparent);
        }
        gc.setFont(this.grid.normalFont);
    }

    public static void paintSort(GC gc, Rectangle bounds, int sort, boolean forcePaintDefault) {
        switch (sort) {
            case -1: {
                if (!forcePaintDefault) break;
                gc.drawImage(IMAGE_ASTERISK, bounds.x, bounds.y);
                break;
            }
            case 128: {
                gc.drawImage(IMAGE_ASC, bounds.x, bounds.y);
                break;
            }
            case 1024: {
                gc.drawImage(IMAGE_DESC, bounds.x, bounds.y);
            }
        }
    }
}

