/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh.jsch;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.ssh.JSCHUserInfoPromptProvider;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.net.ssh.SSHUIMessages;
import org.jkiss.utils.CommonUtils;

public class JSCHUIPromptProvider
implements JSCHUserInfoPromptProvider {
    @NotNull
    public UserInfo createUserInfoPrompt(@NotNull SSHAuthConfiguration configuration, @NotNull Session session) {
        return new UIPrompter(configuration, session);
    }

    private static class UIPrompter
    extends UserInfoPrompter {
        private static final Log log = Log.getLog(JSCHUIPromptProvider.class);
        private final SSHAuthConfiguration configuration;

        UIPrompter(@NotNull SSHAuthConfiguration configuration, Session session) {
            super(session);
            this.configuration = configuration;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (this.shouldUsePassword()) {
                this.setPassword(this.configuration.getPassword());
            }
            return super.promptKeyboardInteractive(destination, name, instruction, prompt, echo);
        }

        public boolean promptPassword(String message) {
            this.setPassword(this.configuration.getPassword());
            return true;
        }

        public boolean promptPassphrase(String message) {
            this.setPassphrase(this.configuration.getPassword());
            return true;
        }

        public void showMessage(String message) {
            log.debug((Object)"SSH server message:");
            log.debug((Object)message);
        }

        private boolean shouldUsePassword() {
            return this.configuration.getType().usesPassword() && (this.configuration.isSavePassword() || CommonUtils.isNotEmpty((String)this.configuration.getPassword()));
        }

        public boolean promptYesNo(String question) {
            return DBWorkbench.getPlatformUI().confirmAction(SSHUIMessages.jsch_remote_host_identifier_changed_warning_title, question);
        }
    }
}

