/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.LocaleSelectorControl;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDataFormat
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageDataFormat.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.dataformat";
    private final String HELP_DATA_FORMAT_LINK = "Managing-Data-Formats";
    private DBDDataFormatterProfile formatterProfile;
    private Font boldFont;
    private Combo typeCombo;
    private PropertyTreeViewer propertiesControl;
    private Text sampleText;
    private List<DataFormatterDescriptor> formatterDescriptors;
    private LocaleSelectorControl localeSelector;
    private String profileName;
    private Locale profileLocale;
    private Map<String, Map<String, Object>> profileProperties = new HashMap<String, Map<String, Object>>();
    private Combo profilesCombo;
    private PropertySourceCustom propertySource;
    private Button datetimeNativeFormatCheck;
    private Button numericNativeFormatCheck;
    private Button numericScientificFormatCheck;

    public PrefPageDataFormat() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.format.datetime.native") || store.contains("resultset.format.numeric.native") || store.contains("resultset.format.numeric.scientific") || dataSourceDescriptor.getDataFormatterProfile().isOverridesParent();
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected void createPreferenceHeader(Composite composite) {
        if (!this.isDataSourcePreferencePage()) {
            Composite profileGroup = UIUtils.createComposite((Composite)composite, (int)3);
            profileGroup.setLayoutData((Object)new GridData(768));
            UIUtils.createControlLabel((Composite)profileGroup, (String)ResultSetMessages.pref_page_data_format_label_profile);
            this.profilesCombo = new Combo(profileGroup, 12);
            this.profilesCombo.setLayoutData((Object)new GridData(768));
            this.profilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PrefPageDataFormat.this.changeProfile();
                }
            });
            if (DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                UIUtils.createDialogButton((Composite)profileGroup, (String)ResultSetMessages.pref_page_data_format_button_manage_profiles, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PrefPageDataFormat.this.manageProfiles();
                    }
                });
            }
        }
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        this.localeSelector = new LocaleSelectorControl(composite, null);
        this.localeSelector.addListener(13, event -> {
            if (event.data instanceof Locale) {
                this.onLocaleChange((Locale)event.data);
            }
        });
        Group settingsGroup = new Group(composite, 0);
        settingsGroup.setText(ResultSetMessages.pref_page_data_format_group_settings);
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        settingsGroup.setLayoutData((Object)new GridData(770));
        this.datetimeNativeFormatCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)ResultSetMessages.pref_page_data_format_datetime_use_native_formatting, (String)ResultSetMessages.pref_page_data_format_datetime_use_native_formatting_tip, (boolean)false, (int)2);
        this.numericNativeFormatCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)ResultSetMessages.pref_page_data_format_numeric_use_native_formatting, (String)ResultSetMessages.pref_page_data_format_numeric_use_native_formatting_tip, (boolean)false, (int)2);
        this.numericScientificFormatCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)ResultSetMessages.pref_page_data_format_numeric_use_scientific_notation, (String)ResultSetMessages.pref_page_data_format_numeric_use_scientific_notation_tip, (boolean)false, (int)2);
        this.numericNativeFormatCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageDataFormat.this.numericScientificFormatCheck.setEnabled(PrefPageDataFormat.this.numericNativeFormatCheck.getSelection());
            }
        });
        Group formatGroup = new Group(composite, 0);
        formatGroup.setText(ResultSetMessages.pref_page_data_format_group_format);
        formatGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(770);
        gd.horizontalSpan = 2;
        formatGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)formatGroup, (String)ResultSetMessages.pref_page_data_format_label_type);
        this.typeCombo = new Combo((Composite)formatGroup, 12);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageDataFormat.this.reloadFormatter();
            }
        });
        Label propsLabel = UIUtils.createControlLabel((Composite)formatGroup, (String)ResultSetMessages.pref_page_data_format_label_settingt);
        propsLabel.setLayoutData((Object)new GridData(2));
        this.propertiesControl = new PropertyTreeViewer((Composite)formatGroup, 2048);
        UIUtils.createControlLabel((Composite)formatGroup, (String)ResultSetMessages.pref_page_data_format_label_sample);
        this.sampleText = new Text((Composite)formatGroup, 2056);
        this.sampleText.setLayoutData((Object)new GridData(768));
        Link urlHelpLabel = UIUtils.createLink((Composite)formatGroup, (String)("<a href=\"" + HelpUtils.getHelpExternalReference((String)"Managing-Data-Formats") + "\">" + ResultSetMessages.pref_page_data_format_link_patterns + "</a>"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Managing-Data-Formats"));
            }
        });
        urlHelpLabel.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
        return composite;
    }

    private void manageProfiles() {
        DataFormatProfilesEditDialog dialog = new DataFormatProfilesEditDialog(this.getShell());
        dialog.open();
        this.refreshProfileList();
    }

    private DBDDataFormatterProfile getDefaultProfile() {
        if (this.isDataSourcePreferencePage()) {
            return this.getDataSourceContainer().getDataFormatterProfile();
        }
        return DataFormatterRegistry.getInstance().getGlobalProfile();
    }

    private void changeProfile() {
        DBDDataFormatterProfile newProfile;
        int selectionIndex = this.profilesCombo.getSelectionIndex();
        if (selectionIndex < 0) {
            return;
        }
        if (selectionIndex == 0) {
            newProfile = this.getDefaultProfile();
        } else {
            String newProfileName = this.profilesCombo.getItem(selectionIndex);
            newProfile = DataFormatterRegistry.getInstance().getCustomProfile(newProfileName);
        }
        if (newProfile != this.formatterProfile) {
            boolean editable = selectionIndex == 0 || DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
            this.setCurrentProfile(newProfile);
            this.localeSelector.setEnabled(editable);
            this.datetimeNativeFormatCheck.setEnabled(editable);
            this.numericNativeFormatCheck.setEnabled(editable);
            this.numericScientificFormatCheck.setEnabled(editable && this.numericNativeFormatCheck.getSelection());
            this.propertiesControl.getTree().setEnabled(editable);
        }
    }

    @NotNull
    protected DBPPreferenceStore getTargetPreferenceStore() {
        if (this.isDataSourcePreferencePage()) {
            return this.getDataSourceContainer().getPreferenceStore();
        }
        if (this.formatterProfile == null) {
            return DBWorkbench.getPlatform().getPreferenceStore();
        }
        return this.formatterProfile.getPreferenceStore();
    }

    private void setCurrentProfile(DBDDataFormatterProfile profile) {
        if (this.formatterProfile == profile) {
            return;
        }
        this.formatterProfile = profile;
        this.formatterDescriptors = new ArrayList<DataFormatterDescriptor>(DataFormatterRegistry.getInstance().getDataFormatters());
        this.profileName = this.formatterProfile.getProfileName();
        this.profileLocale = this.formatterProfile.getLocale();
        this.profileProperties.clear();
        DBPPreferenceStore store = this.getTargetPreferenceStore();
        for (DataFormatterDescriptor dfd : this.formatterDescriptors) {
            Map formatterProps = this.formatterProfile.getFormatterProperties(store, dfd.getId());
            if (formatterProps == null) continue;
            this.profileProperties.put(dfd.getId(), formatterProps);
        }
        try {
            this.localeSelector.setLocale(this.profileLocale);
            this.typeCombo.removeAll();
            for (DataFormatterDescriptor formatter : this.formatterDescriptors) {
                this.typeCombo.add(formatter.getName());
            }
            if (this.typeCombo.getItemCount() > 0) {
                this.typeCombo.select(0);
            }
            this.reloadFormatter();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    private void refreshProfileList() {
        if (this.isDataSourcePreferencePage()) {
            return;
        }
        int selectionIndex = this.profilesCombo.getSelectionIndex();
        String oldProfile = null;
        if (selectionIndex > 0) {
            oldProfile = this.profilesCombo.getItem(selectionIndex);
        }
        this.profilesCombo.removeAll();
        this.profilesCombo.add("<" + DataFormatterRegistry.getInstance().getGlobalProfile().getProfileName() + ">");
        for (DBDDataFormatterProfile profile : DataFormatterRegistry.getInstance().getCustomProfiles()) {
            this.profilesCombo.add(profile.getProfileName());
        }
        if (oldProfile != null) {
            this.profilesCombo.setText(oldProfile);
        }
        if (this.profilesCombo.getSelectionIndex() < 0) {
            this.profilesCombo.select(0);
        }
        this.profilesCombo.setEnabled(this.profilesCombo.getItemCount() >= 2);
        this.changeProfile();
    }

    private DataFormatterDescriptor getCurrentFormatter() {
        int selectionIndex = this.typeCombo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return this.formatterDescriptors.get(selectionIndex);
    }

    private void reloadFormatter() {
        DataFormatterDescriptor formatterDescriptor = this.getCurrentFormatter();
        if (formatterDescriptor == null) {
            return;
        }
        Map<String, Object> formatterProps = this.profileProperties.get(formatterDescriptor.getId());
        Map defaultProps = formatterDescriptor.getSample().getDefaultProperties(this.localeSelector.getSelectedLocale());
        this.propertySource = new VerifyingPropertySourceCustom(formatterDescriptor.getProperties(), formatterProps);
        this.propertySource.setDefaultValues(defaultProps);
        this.propertiesControl.loadProperties((DBPPropertySource)this.propertySource);
        this.reloadSample();
    }

    private void reloadSampleThrowable() throws Exception {
        DataFormatterDescriptor formatterDescriptor = this.getCurrentFormatter();
        if (formatterDescriptor == null) {
            return;
        }
        DBDDataFormatter formatter = formatterDescriptor.createFormatter();
        Map defProps = formatterDescriptor.getSample().getDefaultProperties(this.profileLocale);
        Map<String, Object> props = this.profileProperties.get(formatterDescriptor.getId());
        HashMap<String, Object> formatterProps = new HashMap<String, Object>();
        if (defProps != null && !defProps.isEmpty()) {
            formatterProps.putAll(defProps);
        }
        if (props != null && !props.isEmpty()) {
            formatterProps.putAll(props);
        }
        formatter.init(null, this.profileLocale, formatterProps);
        String sampleValue = formatter.formatValue(formatterDescriptor.getSample().getSampleValue());
        this.sampleText.setText(CommonUtils.notEmpty((String)sampleValue));
    }

    private void reloadSample() {
        try {
            this.reloadSampleThrowable();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Data formats", "Can't apply formatter values to the sample", (Throwable)e);
            log.warn((Object)"Can't render sample value", (Throwable)e);
        }
    }

    private void saveFormatterProperties() throws Exception {
        DataFormatterDescriptor formatterDescriptor = this.getCurrentFormatter();
        if (formatterDescriptor == null) {
            return;
        }
        Map props = this.propertySource.getPropertyValues();
        this.profileProperties.put(formatterDescriptor.getId(), props);
        this.reloadSampleThrowable();
    }

    private void onLocaleChange(Locale locale) {
        if (!locale.equals(this.profileLocale)) {
            this.profileLocale = locale;
            DataFormatterDescriptor formatter = this.getCurrentFormatter();
            if (formatter != null) {
                this.propertySource.setDefaultValues(formatter.getSample().getDefaultProperties(locale));
                this.propertiesControl.refresh();
            }
            this.reloadSample();
        }
    }

    protected void performDefaults() {
        DBPPreferenceStore targetPreferenceStore = this.getTargetPreferenceStore();
        this.clearPreferences(targetPreferenceStore);
        this.formatterProfile = null;
        this.loadPreferences(targetPreferenceStore);
        this.reloadSample();
        super.performDefaults();
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.refreshProfileList();
        this.setCurrentProfile(this.getDefaultProfile());
        this.datetimeNativeFormatCheck.setSelection(store.getBoolean("resultset.format.datetime.native"));
        this.numericNativeFormatCheck.setSelection(store.getBoolean("resultset.format.numeric.native"));
        this.numericScientificFormatCheck.setSelection(store.getBoolean("resultset.format.numeric.scientific"));
        this.numericScientificFormatCheck.setEnabled(this.numericNativeFormatCheck.getSelection());
    }

    protected void savePreferences(DBPPreferenceStore store) {
        this.propertiesControl.saveEditorValues();
        try {
            this.formatterProfile.setProfileName(this.profileName);
            this.formatterProfile.setLocale(this.profileLocale);
            for (String typeId : this.profileProperties.keySet()) {
                this.formatterProfile.setFormatterProperties(store, typeId, this.profileProperties.get(typeId));
            }
            this.formatterProfile.saveProfile(store);
            store.setValue("resultset.format.datetime.native", this.datetimeNativeFormatCheck.getSelection());
            store.setValue("resultset.format.numeric.native", this.numericNativeFormatCheck.getSelection());
            store.setValue("resultset.format.numeric.scientific", this.numericScientificFormatCheck.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        if (this.formatterProfile != null) {
            this.formatterProfile.reset(store);
        }
        store.setToDefault("resultset.format.datetime.native");
        store.setToDefault("resultset.format.numeric.native");
        store.setToDefault("resultset.format.numeric.scientific");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof DBDDataFormatterProfile) {
            UIUtils.setComboSelection((Combo)this.profilesCombo, (String)((DBDDataFormatterProfile)data).getProfileName());
            this.changeProfile();
        }
    }

    public void dispose() {
        this.boldFont.dispose();
        super.dispose();
    }

    public static class DataFormatProfilesEditDialog
    extends Dialog {
        private static final int NEW_ID = 1025;
        private static final int DELETE_ID = 1026;
        private org.eclipse.swt.widgets.List profileList;

        DataFormatProfilesEditDialog(Shell parentShell) {
            super(parentShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(ResultSetMessages.dialog_data_format_profiles_title);
            Composite group = new Composite(parent, 0);
            group.setLayout((Layout)new GridLayout(1, false));
            group.setLayoutData((Object)new GridData(1808));
            this.profileList = new org.eclipse.swt.widgets.List(group, 2052);
            GridData gd = new GridData(1808);
            gd.widthHint = 300;
            gd.heightHint = 200;
            this.profileList.setLayoutData((Object)gd);
            this.profileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.getButton(1026).setEnabled(profileList.getSelectionIndex() >= 0);
                }
            });
            this.loadProfiles();
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1025, ResultSetMessages.dialog_data_format_profiles_button_new_profile, false);
            this.createButton(parent, 1026, ResultSetMessages.dialog_data_format_profiles_button_delete_profile, false);
            this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
            this.getButton(1026).setEnabled(false);
        }

        protected void buttonPressed(int buttonId) {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                log.warn((Object)"The user has no permission to edit custom data format profiles configuration");
                return;
            }
            DataFormatterRegistry registry = DataFormatterRegistry.getInstance();
            if (buttonId == 1025) {
                String profileName = EnterNameDialog.chooseName((Shell)this.getShell(), (String)ResultSetMessages.dialog_data_format_profiles_dialog_name_chooser_title);
                if (CommonUtils.isEmpty((String)profileName)) {
                    return;
                }
                if (registry.getCustomProfile(profileName) != null) {
                    UIUtils.showMessageBox((Shell)this.getShell(), (String)ResultSetMessages.dialog_data_format_profiles_error_title, (String)NLS.bind((String)ResultSetMessages.dialog_data_format_profiles_error_message, (Object)profileName), (int)1);
                } else {
                    registry.createCustomProfile(profileName);
                    this.loadProfiles();
                }
            } else if (buttonId == 1026) {
                DBDDataFormatterProfile profile;
                int selectionIndex = this.profileList.getSelectionIndex();
                if (selectionIndex >= 0 && (profile = registry.getCustomProfile(this.profileList.getItem(selectionIndex))) != null && UIUtils.confirmAction((Shell)this.getShell(), (String)ResultSetMessages.dialog_data_format_profiles_confirm_delete_title, (String)ResultSetMessages.dialog_data_format_profiles_confirm_delete_message)) {
                    registry.deleteCustomProfile(profile);
                    this.loadProfiles();
                }
            } else {
                super.buttonPressed(buttonId);
            }
        }

        private void loadProfiles() {
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("public")) {
                log.warn((Object)"The user has no permission to load custom data format profiles configuration");
                return;
            }
            this.profileList.removeAll();
            List profiles = DataFormatterRegistry.getInstance().getCustomProfiles();
            for (DBDDataFormatterProfile profile : profiles) {
                this.profileList.add(profile.getProfileName());
            }
            Button deleteButton = this.getButton(1026);
            if (deleteButton != null) {
                deleteButton.setEnabled(false);
            }
        }
    }

    private class VerifyingPropertySourceCustom
    extends PropertySourceCustom {
        public VerifyingPropertySourceCustom(DBPPropertyDescriptor[] properties, Map<String, ?> values) {
            super(properties, values);
        }

        public void setPropertyValue(@Nullable DBRProgressMonitor monitor, String id, Object value) {
            Object previousValue = this.getPropertyValue(monitor, id);
            super.setPropertyValue(monitor, id, value);
            try {
                PrefPageDataFormat.this.saveFormatterProperties();
            }
            catch (Exception e) {
                super.setPropertyValue(monitor, id, previousValue);
                throw new IllegalArgumentException(e);
            }
        }

        public void resetPropertyValueToDefault(String id) {
            super.resetPropertyValueToDefault(id);
            try {
                PrefPageDataFormat.this.saveFormatterProperties();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

