/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Dictionary;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.bundle.ModelActivator;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class GeneralUtils {
    private static final Log log = Log.getLog(GeneralUtils.class);
    public static final String UTF8_ENCODING;
    public static final String DEFAULT_ENCODING;
    public static final Charset UTF8_CHARSET;
    public static final Charset DEFAULT_FILE_CHARSET;
    public static final Charset ASCII_CHARSET;
    public static final String DEFAULT_TIMESTAMP_PATTERN = "yyyyMMddHHmm";
    public static final String DEFAULT_DATE_PATTERN = "yyyyMMdd";
    public static final String[] byteToHex;
    public static final char[] nibbleToHex;
    private static final char[] HEX_CHAR_TABLE;
    public static final String PROP_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String PROP_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static Pattern VAR_PATTERN;

    static {
        DEFAULT_ENCODING = UTF8_ENCODING = StandardCharsets.UTF_8.name();
        DEFAULT_FILE_CHARSET = UTF8_CHARSET = Charset.forName(UTF8_ENCODING);
        ASCII_CHARSET = Charset.forName("US-ASCII");
        byteToHex = new String[256];
        nibbleToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HEX_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int i = 0;
        while (i < 256) {
            GeneralUtils.byteToHex[i] = String.valueOf(Character.toString(nibbleToHex[i >>> 4])) + nibbleToHex[i & 0xF];
            ++i;
        }
        VAR_PATTERN = Pattern.compile("(\\$\\{([\\w\\.\\-]+)(\\:[^\\}]+)?\\})", 2);
    }

    public static String getDefaultFileEncoding() {
        return UTF8_ENCODING;
    }

    public static String getDefaultLocalFileEncoding() {
        return System.getProperty("file.encoding", GeneralUtils.getDefaultFileEncoding());
    }

    public static String getDefaultConsoleEncoding() {
        String consoleEncoding = System.getProperty("console.encoding");
        if (CommonUtils.isEmpty((String)consoleEncoding)) {
            consoleEncoding = System.getProperty("file.encoding");
        }
        if (CommonUtils.isEmpty((String)consoleEncoding)) {
            consoleEncoding = GeneralUtils.getDefaultFileEncoding();
        }
        return consoleEncoding;
    }

    public static String getDefaultLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static void writeByteAsHex(Writer out, byte b) throws IOException {
        int v = b & 0xFF;
        out.write(HEX_CHAR_TABLE[v >>> 4]);
        out.write(HEX_CHAR_TABLE[v & 0xF]);
    }

    public static void writeBytesAsHex(Writer out, byte[] buf, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            byte b = buf[off + i];
            int v = b & 0xFF;
            out.write(HEX_CHAR_TABLE[v >>> 4]);
            out.write(HEX_CHAR_TABLE[v & 0xF]);
            ++i;
        }
    }

    public static String convertToString(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return "";
        }
        char[] chars = new char[length];
        int i = offset;
        while (i < offset + length) {
            int b = bytes[i];
            if (b < 0) {
                b += 256;
            }
            if (b < 32 || b >= 127 && b <= 160) {
                b = 32;
            }
            chars[i - offset] = (char)b;
            ++i;
        }
        return new String(chars);
    }

    public static byte[] convertToBytes(String strValue) {
        int length = strValue.length();
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            int c = strValue.charAt(i) & 0xFF;
            if (c > 127) {
                c = -(c - 127);
            }
            bytes[i] = (byte)c;
            ++i;
        }
        return bytes;
    }

    public static Object makeDisplayString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Number) {
            return NumberFormat.getInstance().format(object);
        }
        Class<?> eClass = object.getClass();
        if (eClass.isArray()) {
            if (eClass == byte[].class) {
                return Arrays.toString((byte[])object);
            }
            if (eClass == short[].class) {
                return Arrays.toString((short[])object);
            }
            if (eClass == int[].class) {
                return Arrays.toString((int[])object);
            }
            if (eClass == long[].class) {
                return Arrays.toString((long[])object);
            }
            if (eClass == char[].class) {
                return Arrays.toString((char[])object);
            }
            if (eClass == float[].class) {
                return Arrays.toString((float[])object);
            }
            if (eClass == double[].class) {
                return Arrays.toString((double[])object);
            }
            if (eClass == boolean[].class) {
                return Arrays.toString((boolean[])object);
            }
            return Arrays.deepToString((Object[])object);
        }
        return object;
    }

    public static Object convertString(String value, Class<?> valueType) {
        block19: {
            try {
                if (!CommonUtils.isEmpty((String)value)) break block19;
                return null;
            }
            catch (RuntimeException e) {
                log.error("Error converting value", e);
                return value;
            }
        }
        if (valueType == null || CharSequence.class.isAssignableFrom(valueType)) {
            return value;
        }
        if (valueType == Boolean.class || valueType == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (valueType == Long.class) {
            return Long.valueOf(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Long.TYPE) {
            return Long.parseLong(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Integer.class) {
            return Integer.valueOf(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Integer.TYPE) {
            return Integer.parseInt(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Short.class) {
            return Short.valueOf(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Short.TYPE) {
            return Short.parseShort(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Byte.class) {
            return Byte.valueOf(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Byte.TYPE) {
            return Byte.parseByte(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == Double.class) {
            return Double.valueOf(value);
        }
        if (valueType == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (valueType == Float.class) {
            return Float.valueOf(value);
        }
        if (valueType == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueType == BigInteger.class) {
            return new BigInteger(GeneralUtils.normalizeIntegerString(value));
        }
        if (valueType == BigDecimal.class) {
            return new BigDecimal(value);
        }
        return value;
    }

    private static String normalizeIntegerString(String value) {
        int divPos = value.lastIndexOf(46);
        return divPos == -1 ? value : value.substring(0, divPos);
    }

    public static Throwable getRootCause(Throwable ex) {
        Throwable e = ex;
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    @NotNull
    public static IStatus makeInfoStatus(String message) {
        return new Status(1, "org.jkiss.dbeaver.model", message, null);
    }

    @NotNull
    public static IStatus makeErrorStatus(String message) {
        return new Status(4, "org.jkiss.dbeaver.model", message, null);
    }

    @NotNull
    public static IStatus makeErrorStatus(String message, Throwable e) {
        return new Status(4, "org.jkiss.dbeaver.model", message, e);
    }

    @NotNull
    public static String getProductTitle() {
        return String.valueOf(GeneralUtils.getProductName()) + " " + GeneralUtils.getPlainVersion();
    }

    @NotNull
    public static String getProductName() {
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            return ApplicationRegistry.getInstance().getApplication().getName();
        }
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getName();
        }
        return "DBeaver";
    }

    @NotNull
    public static Version getProductVersion() {
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            return application.getContributorBundle().getVersion();
        }
        IProduct product = Platform.getProduct();
        if (product == null) {
            return ModelActivator.getInstance().getBundle().getVersion();
        }
        return product.getDefiningBundle().getVersion();
    }

    @NotNull
    public static String getPlainVersion(String versionStr) {
        try {
            Version version = new Version(versionStr);
            return String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro();
        }
        catch (Exception exception) {
            return versionStr;
        }
    }

    @NotNull
    public static String getPlainVersion() {
        Version version = GeneralUtils.getProductVersion();
        return String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro();
    }

    @NotNull
    public static String getMajorVersion() {
        Version version = GeneralUtils.getProductVersion();
        return String.valueOf(version.getMajor()) + "." + version.getMinor();
    }

    @NotNull
    public static Date getProductReleaseDate() {
        String buildTime;
        Bundle definingBundle = null;
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            definingBundle = application.getContributorBundle();
        } else {
            IProduct product = Platform.getProduct();
            if (product != null) {
                definingBundle = product.getDefiningBundle();
            }
        }
        if (definingBundle == null) {
            return new Date();
        }
        Dictionary headers = definingBundle.getHeaders();
        String releaseDate = (String)headers.get("Bundle-Release-Date");
        if (releaseDate != null) {
            try {
                return new SimpleDateFormat(DEFAULT_DATE_PATTERN).parse(releaseDate);
            }
            catch (ParseException e) {
                log.debug(e);
            }
        }
        if ((buildTime = (String)headers.get("Build-Time")) != null) {
            try {
                return new SimpleDateFormat(DEFAULT_TIMESTAMP_PATTERN).parse(buildTime);
            }
            catch (ParseException e) {
                log.debug(e);
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2017);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    @Nullable
    public static Date getProductBuildTime() {
        Bundle definingBundle = null;
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            definingBundle = application.getContributorBundle();
        } else {
            IProduct product = Platform.getProduct();
            if (product != null) {
                definingBundle = product.getDefiningBundle();
            }
        }
        if (definingBundle == null) {
            return null;
        }
        Dictionary headers = definingBundle.getHeaders();
        String buildTime = (String)headers.get("Build-Time");
        if (buildTime != null) {
            try {
                return new SimpleDateFormat(DEFAULT_TIMESTAMP_PATTERN).parse(buildTime);
            }
            catch (ParseException e) {
                log.debug(e);
            }
        }
        return null;
    }

    public static String getExpressionParseMessage(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        int divPos = message.indexOf(64);
        return divPos == -1 ? message : message.substring(divPos + 1);
    }

    public static String replaceSystemEnvironmentVariables(String string) {
        if (string == null) {
            return null;
        }
        return GeneralUtils.replaceVariables(string, System::getenv);
    }

    public static String replaceSystemPropertyVariables(String string) {
        if (string == null) {
            return null;
        }
        return GeneralUtils.replaceVariables(string, System::getProperty);
    }

    @NotNull
    public static String variablePattern(String name) {
        return "${" + name + "}";
    }

    @NotNull
    public static boolean isVariablePattern(String pattern) {
        return pattern.startsWith("${") && pattern.endsWith("}");
    }

    @NotNull
    public static String generateVariablesLegend(@NotNull String[][] vars) {
        String[] varPatterns = new String[vars.length];
        int patternMaxLength = 0;
        int i = 0;
        while (i < vars.length) {
            varPatterns[i] = GeneralUtils.variablePattern(vars[i][0]);
            patternMaxLength = Math.max(patternMaxLength, varPatterns[i].length());
            ++i;
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < vars.length) {
            text.append(varPatterns[i2]);
            int k = 0;
            while (k < patternMaxLength - varPatterns[i2].length()) {
                text.append(' ');
                ++k;
            }
            text.append(" - ").append(vars[i2][1]).append("\n");
            ++i2;
        }
        return text.toString();
    }

    @Nullable
    public static String extractVariableName(@NotNull String string) {
        Matcher matcher = VAR_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    @NotNull
    public static String replaceVariables(@NotNull String string, IVariableResolver resolver) {
        if (CommonUtils.isEmpty((String)string)) {
            return string;
        }
        ArrayList<String> resolvedVars = null;
        try {
            Matcher matcher = VAR_PATTERN.matcher(string);
            int pos = 0;
            while (matcher.find(pos)) {
                pos = matcher.end();
                String varName = matcher.group(2);
                if (resolvedVars != null && resolvedVars.contains(varName)) continue;
                String varValue = resolver.get(varName);
                if (varValue == null && (varValue = matcher.group(3)) != null && varValue.startsWith(":")) {
                    varValue = varValue.substring(1);
                }
                if (varValue == null) continue;
                if (resolvedVars == null) {
                    resolvedVars = new ArrayList<String>();
                    resolvedVars.add(varName);
                }
                string = matcher.start() == 0 && matcher.end() >= string.length() - 1 ? varValue : String.valueOf(string.substring(0, matcher.start())) + varValue + string.substring(matcher.end());
                matcher = VAR_PATTERN.matcher(string);
                pos = 0;
            }
            return string;
        }
        catch (Exception e) {
            log.warn("Error matching regex", e);
            return string;
        }
    }

    public static IStatus makeExceptionStatus(Throwable ex) {
        return GeneralUtils.makeExceptionStatus(4, ex);
    }

    public static IStatus makeExceptionStatus(int severity, Throwable ex) {
        return GeneralUtils.makeExceptionStatus(severity, ex, false);
    }

    /*
     * Unable to fully structure code
     */
    private static IStatus makeExceptionStatus(int severity, Throwable ex, boolean nested) {
        if (!(ex instanceof CoreException)) ** GOTO lbl4
        return ((CoreException)ex).getStatus();
lbl-1000:
        // 1 sources

        {
            ex = ex.getCause();
lbl4:
            // 2 sources

            ** while (ex.getCause() != null && ex.getMessage() != null && ex.getMessage().equals((Object)ex.getCause().getMessage()))
        }
lbl5:
        // 1 sources

        cause = ex.getCause();
        nextError = null;
        if (ex instanceof SQLException) {
            nextError = ((SQLException)ex).getNextException();
        } else if (cause instanceof SQLException) {
            nextError = ((SQLException)cause).getNextException();
        }
        if (cause == null && nextError == null) {
            return new Status(severity, "org.jkiss.dbeaver.model", GeneralUtils.getExceptionMessage(ex), ex);
        }
        if (nextError != null) {
            errorChain = new ArrayList<Object>();
            if (cause != null) {
                errorChain.add(GeneralUtils.makeExceptionStatus(severity, cause, true));
            }
            error = nextError;
            while (error != null) {
                errorChain.add(new Status(severity, "org.jkiss.dbeaver.model", GeneralUtils.getExceptionMessage(error)));
                error = error.getNextException();
            }
            return new MultiStatus("org.jkiss.dbeaver.model", 0, errorChain.toArray(new IStatus[0]), GeneralUtils.getExceptionMessage(ex), ex);
        }
        return new MultiStatus("org.jkiss.dbeaver.model", 0, new IStatus[]{GeneralUtils.makeExceptionStatus(severity, cause, true)}, GeneralUtils.getExceptionMessage(ex), nested == false ? null : ex);
    }

    public static IStatus makeExceptionStatus(String message, Throwable ex) {
        return GeneralUtils.makeExceptionStatus(4, message, ex);
    }

    public static IStatus makeExceptionStatus(int severity, String message, Throwable ex) {
        return new MultiStatus("org.jkiss.dbeaver.model", 0, new IStatus[]{GeneralUtils.makeExceptionStatus(severity, ex)}, message, null);
    }

    public static IStatus getRootStatus(IStatus status) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status;
        }
        return GeneralUtils.getRootStatus(children[0]);
    }

    public static String getStatusText(IStatus status) {
        StringBuilder text = new StringBuilder(status.getMessage());
        IStatus[] children = status.getChildren();
        if (children != null && children.length > 0) {
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                text.append("\n").append(GeneralUtils.getStatusText(child));
                ++n2;
            }
        }
        return text.toString();
    }

    public static String getFirstMessage(Throwable ex) {
        Throwable e = ex;
        while (e != null) {
            String message = e.getMessage();
            if (!CommonUtils.isEmpty((String)message)) {
                return message;
            }
            e = e.getCause();
        }
        return null;
    }

    public static String getExceptionMessage(@NotNull Throwable ex) {
        try {
            ex.getClass().getDeclaredMethod("toString", new Class[0]);
            return ex.toString();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return ex.getMessage();
        }
    }

    @NotNull
    public static String serializeObject(@NotNull Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream os = new ObjectOutputStream(baos);){
                os.writeObject(object);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return Base64.encode((byte[])baos.toByteArray());
        }
        catch (Throwable e) {
            log.warn("Error serializing object [" + object + "]", e);
            return "";
        }
    }

    public static Object deserializeObject(String text) {
        try {
            byte[] bytes = Base64.decode((String)text);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Throwable throwable = null;
            Object var4_6 = null;
            try (ObjectInputStream is = new ObjectInputStream(bais);){
                return is.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            log.warn("Error deserializing object [" + text + "]", e);
            return null;
        }
    }

    public static Path getMetadataFolder() {
        try {
            File workspacePath = RuntimeUtils.getLocalFileFromURL(Platform.getInstanceLocation().getURL());
            Path metaDir = GeneralUtils.getMetadataFolder(workspacePath.toPath());
            if (!Files.exists(metaDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(metaDir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    return Platform.getLogFileLocation().toFile().toPath();
                }
            }
            return metaDir;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't parse workspace location URL", e);
        }
    }

    public static Path getMetadataFolder(Path workspaceFolder) {
        return workspaceFolder.resolve(".metadata");
    }

    @NotNull
    public static URI makeURIFromFilePath(@NotNull String path) throws URISyntaxException {
        return new URI(path.replace(" ", "%20"));
    }

    public static <T> T adapt(Object sourceObject, Class<T> adapter, boolean allowActivation) {
        IAdaptable adaptable;
        Object result;
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return adapter.cast(sourceObject);
        }
        if (sourceObject instanceof IAdaptable && (result = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException(String.valueOf(adaptable.getClass().getName()) + ".getAdapter(" + adapter.getName() + ".class) returned " + result.getClass().getName() + " that is not an instance the requested type");
            }
            return (T)result;
        }
        if (sourceObject instanceof PlatformObject && !allowActivation) {
            return null;
        }
        String adapterId = adapter.getName();
        result = GeneralUtils.queryAdapterManager(sourceObject, adapterId, allowActivation);
        if (result != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException("An adapter factory for " + sourceObject.getClass().getName() + " returned " + result.getClass().getName() + " that is not an instance of " + adapter.getName());
            }
            return adapter.cast(result);
        }
        return null;
    }

    public static <T> T adapt(Object sourceObject, Class<T> adapter) {
        return GeneralUtils.adapt(sourceObject, adapter, true);
    }

    public static Object queryAdapterManager(Object sourceObject, String adapterId, boolean allowActivation) {
        AdapterManager adapterManager = AdapterManager.getDefault();
        if (adapterManager == null) {
            return null;
        }
        Object result = allowActivation ? adapterManager.loadAdapter(sourceObject, adapterId) : adapterManager.getAdapter(sourceObject, adapterId);
        return result;
    }

    public static byte[] getBytesFromUUID(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID getUUIDFromBytes(byte[] bytes) throws IllegalArgumentException {
        if (bytes.length < 16) {
            throw new IllegalArgumentException("UUID length must be at least 16 bytes (actual length = " + bytes.length + ")");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
    }

    public static UUID getMixedEndianUUIDFromBytes(byte[] bytes) {
        ByteBuffer source = ByteBuffer.wrap(bytes);
        ByteBuffer target = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putInt(source.getInt()).putShort(source.getShort()).putShort(source.getShort()).order(ByteOrder.BIG_ENDIAN).putLong(source.getLong());
        target.rewind();
        return new UUID(target.getLong(), target.getLong());
    }

    public static interface IParameterHandler {
        public boolean setParameter(String var1, String var2);
    }

    public static class MapResolver
    implements IVariableResolver {
        private final Map<String, Object> variables;

        public MapResolver(Map<String, Object> variables) {
            this.variables = variables;
        }

        @Override
        public String get(String name) {
            Object value = this.variables.get(name);
            return value == null ? null : CommonUtils.toString((Object)value);
        }
    }
}

