/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class BaseDialog
extends Dialog {
    private String title;
    private DBPImage icon;
    protected int buttonBarPlaceholderColumns = 2;

    public BaseDialog(Shell parentShell, String title, @Nullable DBPImage icon) {
        super(parentShell);
        this.title = title;
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DBPImage getImage() {
        return this.icon;
    }

    public void setImage(DBPImage image) {
        this.icon = image;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        BaseDialog.applyDialogFont((Control)this.dialogArea);
        return contents;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea1 = (Composite)super.createDialogArea(parent);
        return dialogArea1;
    }

    public void create() {
        super.create();
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        if (this.icon != null) {
            this.getShell().setImage(DBeaverIcons.getImage(this.icon));
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, this.buttonBarPlaceholderColumns, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createButtonsForButtonBar(this.createButtonBarComposite(composite, 16384), 16384);
        this.createButtonsForButtonBar(this.createButtonBarComposite(composite, 131072), 131072);
        return composite;
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent, int alignment) {
        if (alignment == 131072) {
            this.createButtonsForButtonBar(parent);
        }
    }

    @NotNull
    protected Composite createButtonBarComposite(@NotNull Composite parent, int alignment) {
        GridLayout layout = new GridLayout(0, true);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        GridData data = new GridData(alignment, 0x1000000, true, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        return composite;
    }

    @Nullable
    protected Button getButton(int id) {
        return super.getButton(id);
    }
}

