/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongKeyMap<VALUE>
implements Map<Long, VALUE> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient LongEntry<VALUE>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<LongEntry<VALUE>> entrySet = null;
    volatile transient Set<Long> keySet = null;
    volatile transient Collection<VALUE> values = null;

    public LongKeyMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new LongEntry[capacity];
    }

    public LongKeyMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongKeyMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new LongEntry[16];
    }

    static int hash(long x) {
        int h = (int)(x ^ x >>> 32);
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(((Number)key).longValue());
    }

    public VALUE get(long key) {
        int hash = LongKeyMap.hash(key);
        int i = LongKeyMap.indexFor(hash, this.table.length);
        LongEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(long key) {
        int hash = LongKeyMap.hash(key);
        int i = LongKeyMap.indexFor(hash, this.table.length);
        LongEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    LongEntry<VALUE> getEntry(long key) {
        int hash = LongKeyMap.hash(key);
        int i = LongKeyMap.indexFor(hash, this.table.length);
        LongEntry<VALUE> e = this.table[i];
        while (e != null && (e.hash != hash || key != e.key)) {
            e = e.next;
        }
        return e;
    }

    @Override
    public VALUE put(long key, VALUE value) {
        int hash = LongKeyMap.hash(key);
        int i = LongKeyMap.indexFor(hash, this.table.length);
        LongEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    private void putForCreate(long key, VALUE value) {
        int hash = LongKeyMap.hash(key);
        int i = LongKeyMap.indexFor(hash, this.table.length);
        LongEntry<VALUE> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && key == e.key) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    void putAllForCreate(LongKeyMap<VALUE> m) {
        for (LongEntry e : m.entrySet()) {
            this.putForCreate(e.key, e.value);
        }
    }

    void resize(int newCapacity) {
        LongEntry<VALUE>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        LongEntry[] newTable = new LongEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(LongEntry[] newTable) {
        LongEntry<VALUE>[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            LongEntry<VALUE> e = src[j];
            if (e != null) {
                LongEntry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = LongKeyMap.indexFor(e.hash, newCapacity);
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    public void putAll(LongKeyMap<VALUE> t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            int capacity = this.table.length;
            while (capacity < n) {
                capacity <<= 1;
            }
            this.resize(capacity);
        }
        for (LongEntry e : t.entrySet()) {
            this.put(e.key, (VALUE)e.value);
        }
    }

    public VALUE remove(long key) {
        LongEntry<VALUE> e = this.removeEntryForKey(key);
        return e == null ? null : (VALUE)e.value;
    }

    LongEntry<VALUE> removeEntryForKey(long key) {
        LongEntry<VALUE> prev;
        int hash = LongKeyMap.hash(key);
        int i = LongKeyMap.indexFor(hash, this.table.length);
        LongEntry<VALUE> e = prev = this.table[i];
        while (e != null) {
            LongEntry next = e.next;
            if (e.hash == hash && key == e.key) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    LongEntry<VALUE> removeMapping(Object o) {
        LongEntry<VALUE> prev;
        if (!(o instanceof LongEntry)) {
            return null;
        }
        LongEntry entry = (LongEntry)o;
        int hash = LongKeyMap.hash(entry.key);
        int i = LongKeyMap.indexFor(hash, this.table.length);
        LongEntry<VALUE> e = prev = this.table[i];
        while (e != null) {
            LongEntry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        LongEntry<VALUE>[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        LongEntry<VALUE>[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            LongEntry<VALUE> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    @Override
    public VALUE get(Object key) {
        return this.get(((Number)key).longValue());
    }

    @Override
    public VALUE put(Long key, VALUE value) {
        return this.put((long)key, value);
    }

    @Override
    public VALUE remove(Object key) {
        return this.remove(((Number)key).longValue());
    }

    @Override
    public void putAll(Map<? extends Long, ? extends VALUE> t) {
        throw new UnsupportedOperationException();
    }

    private boolean containsNullValue() {
        LongEntry<VALUE>[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            LongEntry<VALUE> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    void addEntry(int hash, long key, VALUE value, int bucketIndex) {
        this.table[bucketIndex] = new LongEntry<VALUE>(hash, key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, long key, VALUE value, int bucketIndex) {
        this.table[bucketIndex] = new LongEntry<VALUE>(hash, key, value, this.table[bucketIndex]);
        ++this.size;
    }

    Iterator<Long> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<VALUE> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<LongEntry<VALUE>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<Long> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<VALUE> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class EntryIterator
    extends HashIterator<LongEntry<VALUE>> {
        private EntryIterator() {
        }

        @Override
        public LongEntry<VALUE> next() {
            return this.nextEntry();
        }
    }

    private class EntrySet
    extends AbstractSet<LongEntry<VALUE>> {
        private EntrySet() {
        }

        @Override
        public Iterator<LongEntry<VALUE>> iterator() {
            return LongKeyMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof LongEntry)) {
                return false;
            }
            LongEntry e = (LongEntry)o;
            LongEntry candidate = LongKeyMap.this.getEntry(e.key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return LongKeyMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return LongKeyMap.this.size;
        }

        @Override
        public void clear() {
            LongKeyMap.this.clear();
        }
    }

    private abstract class HashIterator<X>
    implements Iterator<X> {
        LongEntry<VALUE> next;
        int expectedModCount;
        int index;
        LongEntry<VALUE> current;

        HashIterator() {
            this.expectedModCount = LongKeyMap.this.modCount;
            LongEntry<VALUE>[] t = LongKeyMap.this.table;
            int i = t.length;
            LongEntry n = null;
            if (LongKeyMap.this.size != 0) {
                while (i > 0 && (n = t[--i]) == null) {
                }
            }
            this.next = n;
            this.index = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        LongEntry<VALUE> nextEntry() {
            if (LongKeyMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LongEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            LongEntry n = e.next;
            LongEntry<VALUE>[] t = LongKeyMap.this.table;
            int i = this.index;
            while (n == null && i > 0) {
                n = t[--i];
            }
            this.index = i;
            this.next = n;
            this.current = e;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (LongKeyMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            long k = this.current.key;
            this.current = null;
            LongKeyMap.this.removeEntryForKey(k);
            this.expectedModCount = LongKeyMap.this.modCount;
        }
    }

    private class KeyIterator
    extends HashIterator<Long> {
        private KeyIterator() {
        }

        @Override
        public Long next() {
            return this.nextEntry().key;
        }

        public long nextLong() {
            return this.nextEntry().key;
        }
    }

    private class KeySet
    extends AbstractSet<Long> {
        private KeySet() {
        }

        @Override
        public Iterator<Long> iterator() {
            return LongKeyMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return LongKeyMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Number) {
                return LongKeyMap.this.containsKey(((Number)o).longValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Number) {
                return LongKeyMap.this.removeEntryForKey(((Number)o).longValue()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            LongKeyMap.this.clear();
        }
    }

    public static class LongEntry<VALUE>
    implements Map.Entry<Long, VALUE> {
        final long key;
        VALUE value;
        final int hash;
        LongEntry<VALUE> next;

        LongEntry(int h, long k, VALUE v, LongEntry<VALUE> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public long getLong() {
            return this.key;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public VALUE getValue() {
            return this.value;
        }

        @Override
        public VALUE setValue(VALUE newValue) {
            VALUE oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            VALUE v2;
            VALUE v1;
            if (!(o instanceof LongEntry)) {
                return false;
            }
            LongEntry e = (LongEntry)o;
            return this.key == e.key && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return LongKeyMap.hash(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.key)) + "=" + this.getValue();
        }
    }

    private class ValueIterator
    extends HashIterator<VALUE> {
        private ValueIterator() {
        }

        @Override
        public VALUE next() {
            return this.nextEntry().value;
        }
    }

    private class Values
    extends AbstractCollection<VALUE> {
        private Values() {
        }

        @Override
        public Iterator<VALUE> iterator() {
            return LongKeyMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return LongKeyMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return LongKeyMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            LongKeyMap.this.clear();
        }
    }
}

