/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Layer;
import org.eclipse.draw2dl.StackLayout;

public class LayeredPane
extends Layer {
    private List layerKeys = new ArrayList();

    public LayeredPane() {
        this.setLayoutManager(new StackLayout());
    }

    @Override
    public void add(IFigure figure, Object layerKey, int index) {
        if (index == -1) {
            index = this.layerKeys.size();
        }
        super.add(figure, null, index);
        this.layerKeys.add(index, layerKey);
    }

    public void addLayerAfter(Layer layer, Object key, Object after) {
        int index = this.layerKeys.indexOf(after);
        this.add(layer, key, ++index);
    }

    public void addLayerBefore(Layer layer, Object key, Object before) {
        int index = this.layerKeys.indexOf(before);
        this.add(layer, key, index);
    }

    public Layer getLayer(Object key) {
        int index = this.layerKeys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return (Layer)this.getChildren().get(index);
    }

    protected Layer getLayer(int index) {
        return (Layer)this.getChildren().get(index);
    }

    @Override
    public void remove(IFigure figure) {
        int index = this.getChildren().indexOf(figure);
        if (index != -1) {
            this.layerKeys.remove(index);
        }
        super.remove(figure);
    }

    public void removeLayer(Object key) {
        this.removeLayer(this.layerKeys.indexOf(key));
    }

    public void removeLayer(IFigure layer) {
        this.remove(layer);
    }

    protected void removeLayer(int index) {
        Layer removeLayer = this.getLayer(index);
        this.remove(removeLayer);
    }
}

