/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.fs.DBFRemoteFileStore;
import org.jkiss.dbeaver.model.fs.nio.NIOResource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNResource
extends DBNNode
implements DBNNodeWithResource {
    private static final Log log = Log.getLog(DBNResource.class);
    private static final DBNNode[] EMPTY_NODES = new DBNNode[0];
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final NumberFormat numberFormat = new DecimalFormat();
    private IResource resource;
    private DBPResourceHandler handler;
    private DBNNode[] children;
    private DBPImage resourceImage;

    public DBNResource(DBNNode parentNode, IResource resource, DBPResourceHandler handler) {
        super(parentNode);
        this.resource = resource;
        this.handler = handler;
    }

    protected IResource getContentLocationResource() {
        return this.resource;
    }

    @Override
    public boolean isDisposed() {
        return this.resource == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        if (this.children != null) {
            DBNNode[] dBNNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode child = dBNNodeArray[n2];
                child.dispose(reflect);
                ++n2;
            }
            this.children = null;
        }
        if (reflect) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, this));
        }
        this.resource = null;
        this.handler = null;
        super.dispose(reflect);
    }

    public int getFeatures() {
        return this.handler == null ? 0 : this.handler.getFeatures(this.resource);
    }

    @Override
    public String getNodeType() {
        return this.handler == null ? this.getResourceNodeType() : this.handler.getTypeName(this.resource);
    }

    protected String getResourceNodeType() {
        return "resource";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        if (this.resource == null || this.handler == null) {
            return null;
        }
        return this.resource.getName();
    }

    @Override
    public String getNodeDescription() {
        if (this.getOwnerProject().isVirtual()) {
            return null;
        }
        return this.handler == null || this.resource == null ? null : this.handler.getResourceDescription(this.resource);
    }

    @Override
    @NotNull
    public DBPImage getNodeIcon() {
        DBPImage iconImage = this.getResourceNodeIcon();
        DBPProject project = this.getOwnerProject();
        if (project != null && !project.hasRealmPermission("project-resource-edit")) {
            iconImage = new DBIconComposite(iconImage, false, null, null, null, DBIcon.OVER_LOCK);
        }
        return iconImage;
    }

    @NotNull
    protected DBPImage getResourceNodeIcon() {
        if (this.resourceImage != null) {
            return this.resourceImage;
        }
        if (this.resource == null) {
            if (this.hasChildren(false)) {
                return DBIcon.TREE_FOLDER;
            }
            return DBIcon.TREE_PAGE;
        }
        switch (this.resource.getType()) {
            case 2: {
                return this.resource.isLinked() ? DBIcon.TREE_FOLDER_LINK : DBIcon.TREE_FOLDER;
            }
            case 4: {
                return DBIcon.PROJECT;
            }
        }
        return DBIcon.TREE_PAGE;
    }

    @Override
    public String getNodeTargetName() {
        File localFile;
        IPath location;
        IResource resource = this.getResource();
        if (resource != null && (location = resource.getLocation()) != null && (localFile = location.toFile()) != null) {
            return localFile.getAbsolutePath();
        }
        return super.getNodeTargetName();
    }

    @Override
    public boolean allowsChildren() {
        return this.resource instanceof IContainer;
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBNNode> result = new ArrayList<DBNNode>();
        try {
            IResource contentLocation = this.getContentLocationResource();
            if (contentLocation instanceof IContainer && contentLocation.exists()) {
                IResource[] members = ((IContainer)contentLocation).members(false);
                IResource[] iResourceArray = members = this.addImplicitMembers(members);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    DBNNode newChild = this.makeNode(member);
                    if (newChild != null) {
                        result.add(newChild);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't read container's members", e);
        }
        if (result.isEmpty()) {
            return EMPTY_NODES;
        }
        this.filterChildren(result);
        DBNNode[] childNodes = result.toArray(new DBNNode[0]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    protected IResource[] addImplicitMembers(IResource[] members) {
        return members;
    }

    DBNResource getChild(IResource resource) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNResource && resource.equals((Object)((DBNResource)child).getResource())) {
                return (DBNResource)child;
            }
            ++n2;
        }
        return null;
    }

    private DBNNode makeNode(IResource resource) {
        DBPResourceHandler resourceHandler;
        block5: {
            boolean isRootResource = this.isRootResource(resource);
            if (isRootResource && resource.getName().startsWith(".")) {
                return null;
            }
            try {
                if (resource instanceof IFolder && !isRootResource) {
                    return this.handler.makeNavigatorNode(this, resource);
                }
                resourceHandler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(resource);
                if (resourceHandler != null) break block5;
                log.debug("Skip resource '" + resource.getName() + "'");
                return null;
            }
            catch (Exception e) {
                log.error("Error creating navigator node for resource '" + resource.getName() + "'", e);
                return null;
            }
        }
        return resourceHandler.makeNavigatorNode(this, resource);
    }

    public boolean isRootResource(IResource resource) {
        return CommonUtils.equalObjects((Object)resource.getParent(), (Object)this.getOwnerProject().getRootResource()) || CommonUtils.equalObjects((Object)resource.getParent(), (Object)this.getOwnerProject().getEclipseProject());
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        if (this.children != null) {
            this.children = null;
        }
        this.refreshThisResource(monitor);
        return this;
    }

    protected void refreshThisResource(DBRProgressMonitor monitor) throws DBException {
        if (this.resource == null) {
            return;
        }
        try {
            this.refreshFileStore(monitor);
            this.resource.refreshLocal(2, monitor.getNestedMonitor());
            IPath resourceLocation = this.resource.getLocation();
            if (resourceLocation != null && !resourceLocation.toFile().exists()) {
                log.debug("Resource '" + this.resource.getName() + "' doesn't exists on file system");
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't refresh resource", e);
        }
    }

    protected void refreshFileStore(@NotNull DBRProgressMonitor monitor) throws DBException {
        DBFRemoteFileStore remoteFileStore;
        if (this.resource instanceof Resource && (remoteFileStore = GeneralUtils.adapt(((Resource)this.resource).getStore(), DBFRemoteFileStore.class)) != null) {
            remoteFileStore.refresh(monitor);
        }
    }

    @Override
    public String getNodeItemPath() {
        String projectPath = this.getRawNodeItemPath();
        return String.valueOf(DBNNode.NodePathType.resource.getPrefix()) + projectPath;
    }

    @NotNull
    public String getRawNodeItemPath() {
        StringBuilder pathName = new StringBuilder();
        DBNNode node = this;
        while (node instanceof DBNResource) {
            IResource resource;
            if (pathName.length() > 0) {
                pathName.insert(0, '/');
            }
            if ((resource = node.getResource()) != null) {
                pathName.insert(0, resource.getName());
            } else {
                pathName.insert(0, "?");
            }
            node = node.getParentNode();
        }
        String projectPath = pathName.toString();
        return projectPath;
    }

    @Override
    public boolean supportsRename() {
        return (this.getFeatures() & 8) != 0;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        try {
            String ext;
            if (newName.indexOf(46) == -1 && this.resource instanceof IFile && !CommonUtils.isEmpty((String)(ext = this.resource.getFileExtension()))) {
                newName = String.valueOf(newName) + "." + ext;
            }
            if (!newName.equals(this.resource.getName())) {
                if (this.resource.isLinked()) {
                    this.resource.move(this.resource.getFullPath().removeLastSegments(1).append(newName), 32, monitor.getNestedMonitor());
                } else {
                    this.resource.move(this.resource.getFullPath().removeLastSegments(1).append(newName), true, monitor.getNestedMonitor());
                }
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't rename resource", e);
        }
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        if (!(this.resource instanceof IFolder) || (this.getFeatures() & 0x10) == 0) {
            return false;
        }
        if (otherNode == null) {
            return true;
        }
        return otherNode.getAdapter(IResource.class) != null && otherNode != this && otherNode.getParentNode() != this;
    }

    @Override
    public void dropNodes(final Collection<DBNNode> nodes) throws DBException {
        new AbstractJob("Drop files to workspace"){
            {
                super($anonymous0);
                this.setUser(true);
            }

            @Override
            protected IStatus run(DBRProgressMonitor monitor) {
                monitor.beginTask("Copy files", nodes.size());
                try {
                    try {
                        for (DBNNode node : nodes) {
                            IResource otherResource = node.getAdapter(IResource.class);
                            if (otherResource != null) {
                                try {
                                    if (otherResource instanceof NIOResource) {
                                        otherResource.copy(DBNResource.this.resource.getRawLocation().append(otherResource.getName()), true, monitor.getNestedMonitor());
                                    } else {
                                        otherResource.move(DBNResource.this.resource.getFullPath().append(otherResource.getName()), true, monitor.getNestedMonitor());
                                    }
                                    DBNResource.this.refreshFileStore(monitor);
                                    DBNResource.this.resource.refreshLocal(1, monitor.getNestedMonitor());
                                }
                                catch (CoreException e) {
                                    throw new DBException("Can't copy " + otherResource.getName() + " to " + DBNResource.this.resource.getName(), e);
                                }
                            } else {
                                throw new DBException("Can't get resource from node " + node.getName());
                            }
                            monitor.worked(1);
                        }
                    }
                    catch (Exception e) {
                        IStatus iStatus = GeneralUtils.makeExceptionStatus(e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Override
    @NotNull
    public IResource getResource() {
        return this.resource;
    }

    protected void filterChildren(List<DBNNode> list) {
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, (o1, o2) -> {
            if (o1 instanceof DBNProjectDatabases) {
                return -1;
            }
            if (o2 instanceof DBNProjectDatabases) {
                return 1;
            }
            if (o1 instanceof DBNResource && o2 instanceof DBNResource) {
                IResource res1 = ((DBNResource)o1).getResource();
                IResource res2 = ((DBNResource)o2).getResource();
                if (res1 instanceof IFolder && !(res2 instanceof IFolder)) {
                    return -1;
                }
                if (res2 instanceof IFolder && !(res1 instanceof IFolder)) {
                    return 1;
                }
            }
            return o1.getSortName().compareToIgnoreCase(o2.getSortName());
        });
    }

    @Override
    public DBPImage getResourceImage() {
        return this.resourceImage;
    }

    @Override
    public void setResourceImage(DBPImage resourceImage) {
        this.resourceImage = resourceImage;
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return this.handler == null ? null : this.handler.getAssociatedDataSources(this);
    }

    public void refreshResourceState(Object source) {
        DBPResourceHandler newHandler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(this.resource);
        if (newHandler != this.handler) {
            this.handler = newHandler;
        }
        if (this.handler != null) {
            this.handler.updateNavigatorNodeFromResource(this, this.resource);
        } else {
            log.error("Can't find handler for resource " + this.resource.getFullPath());
        }
        this.getModel().fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    protected void handleResourceChange(IResourceDelta delta) {
        if (delta.getKind() == 4) {
            this.refreshResourceState(delta);
        }
        if (this.children == null) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(31, 8);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            this.handleChildResourceChange(childDelta);
            ++n2;
        }
    }

    protected void handleChildResourceChange(IResourceDelta delta) {
        IResource deltaResource = delta.getResource();
        DBNResource childResource = this.getChild(deltaResource);
        if (childResource == null) {
            DBNNode newChild;
            if ((delta.getKind() == 1 || delta.getKind() == 4) && (newChild = this.makeNode(deltaResource)) != null) {
                this.children = (DBNNode[])ArrayUtils.add(DBNNode.class, (Object[])this.children, (Object)newChild);
                this.sortChildren(this.children);
                this.getModel().fireNodeEvent(new DBNEvent(delta, DBNEvent.Action.ADD, newChild));
                if (delta.getKind() == 4 && (childResource = this.getChild(deltaResource)) != null) {
                    childResource.handleResourceChange(delta);
                }
            }
        } else if (delta.getKind() == 2) {
            this.children = (DBNNode[])ArrayUtils.remove(DBNNode.class, (Object[])this.children, (Object)childResource);
            childResource.dispose(true);
        } else {
            childResource.handleResourceChange(delta);
        }
    }

    @Property(viewable=true, order=10)
    public String getResourcePath() {
        return this.resource == null ? "" : this.resource.getFullPath().toOSString();
    }

    @Property(viewable=false, order=11)
    public String getResourceLocation() {
        if (this.resource == null) {
            return null;
        }
        IPath location = this.resource.getLocation();
        return location == null ? null : location.toString();
    }

    @Property(viewable=true, order=11)
    public String getResourceSize() throws CoreException {
        if (this.resource instanceof IFile) {
            return numberFormat.format(ResourceUtils.getFileLength(this.resource));
        }
        return null;
    }

    @Property(viewable=true, order=11)
    public String getResourceLastModified() throws CoreException {
        if (this.resource instanceof IFile) {
            long lastModified = ResourceUtils.getResourceLastModified(this.resource);
            return lastModified <= 0L ? "" : DATE_FORMAT.format(lastModified);
        }
        return null;
    }

    protected boolean isResourceExists() {
        return this.resource != null && this.resource.exists();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.resource != null && adapter.isAssignableFrom(this.resource.getClass())) {
            return adapter.cast(this.resource);
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.resource == null ? super.toString() : this.resource.toString();
    }
}

