/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.utils.CommonUtils;

public class QMMStatementInfo
extends QMMObject {
    private final QMMConnectionInfo connection;
    private final DBCExecutionPurpose purpose;
    private final QMMStatementInfo previous;
    private transient DBCStatement reference;

    public QMMStatementInfo(QMMConnectionInfo connection, DBCStatement reference, QMMStatementInfo previous) {
        this.connection = connection;
        this.reference = reference;
        this.purpose = reference.getSession().getPurpose();
        this.previous = previous;
    }

    public QMMStatementInfo(long openTime, long closeTime, QMMConnectionInfo session, DBCExecutionPurpose purpose) {
        super(openTime, closeTime);
        this.connection = session;
        this.purpose = purpose;
        this.previous = null;
    }

    private QMMStatementInfo(Builder builder) {
        super(builder.openTime, builder.closeTime);
        this.connection = builder.connection;
        this.purpose = builder.purpose;
        this.previous = builder.previous;
        this.reference = builder.reference;
    }

    @Override
    public void close() {
        super.close();
        this.reference = null;
    }

    @Override
    public String getText() {
        return this.connection.getText();
    }

    @Override
    public QMMObject.ObjectType getObjectType() {
        return QMMObject.ObjectType.StatementInfo;
    }

    DBCStatement getReference() {
        return this.reference;
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this.connection;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> serializedInfo = new LinkedHashMap<String, Object>();
        serializedInfo.put("connection", this.connection.toMap());
        serializedInfo.put("openTime", this.getOpenTime());
        serializedInfo.put("closeTime", this.getCloseTime());
        serializedInfo.put("purposeId", this.getPurpose().getId());
        return serializedInfo;
    }

    public static QMMStatementInfo fromMap(Map<String, Object> objectMap) {
        QMMConnectionInfo connectionInfo = QMMConnectionInfo.fromMap(JSONUtils.getObject(objectMap, "connection"));
        DBCExecutionPurpose purpose = DBCExecutionPurpose.getById(CommonUtils.toInt((Object)objectMap.get("purposeId")));
        long openTime = CommonUtils.toLong((Object)objectMap.get("openTime"));
        long closeTime = CommonUtils.toLong((Object)objectMap.get("closeTime"));
        return QMMStatementInfo.builder().setConnection(connectionInfo).setPurpose(purpose).setOpenTime(openTime).setCloseTime(closeTime).build();
    }

    public DBCExecutionPurpose getPurpose() {
        return this.purpose;
    }

    public QMMStatementInfo getPrevious() {
        return this.previous;
    }

    public String toString() {
        return "STATEMENT";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class Builder {
        private QMMConnectionInfo connection;
        private DBCExecutionPurpose purpose;
        private QMMStatementInfo previous;
        private DBCStatement reference;
        private long openTime;
        private long closeTime;

        public Builder() {
        }

        public Builder(QMMStatementInfo copy) {
            this.connection = copy.getConnection();
            this.purpose = copy.getPurpose();
            this.previous = copy.getPrevious();
            this.reference = copy.getReference();
        }

        public Builder setConnection(QMMConnectionInfo connection) {
            this.connection = connection;
            return this;
        }

        public Builder setPurpose(DBCExecutionPurpose purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder setPrevious(QMMStatementInfo previous) {
            this.previous = previous;
            return this;
        }

        public Builder setReference(DBCStatement reference) {
            this.reference = reference;
            return this;
        }

        public Builder setOpenTime(long openTime) {
            this.openTime = openTime;
            return this;
        }

        public Builder setCloseTime(long closeTime) {
            this.closeTime = closeTime;
            return this;
        }

        public QMMStatementInfo build() {
            return new QMMStatementInfo(this);
        }
    }
}

