/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.secret.DBPSecretHolder;
import org.jkiss.utils.CommonUtils;

public abstract class DBPConfigurationProfile
implements DBPSecretHolder {
    private final DBPProject project;
    private String profileId;
    private String profileName;
    private String profileDescription;
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public DBPConfigurationProfile(DBPProject project) {
        this.project = project;
    }

    public DBPConfigurationProfile(DBPConfigurationProfile source) {
        this.project = source.project;
        this.profileId = source.profileId;
        this.profileName = source.profileName;
        this.profileDescription = source.profileDescription;
        if (!CommonUtils.isEmpty(source.properties)) {
            this.properties = new LinkedHashMap<String, String>(source.properties);
        }
    }

    public DBPProject getProject() {
        return this.project;
    }

    public String getProfileId() {
        if (CommonUtils.isEmpty((String)this.profileId)) {
            return this.profileName;
        }
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileDescription() {
        return this.profileDescription;
    }

    public void setProfileDescription(String profileDescription) {
        this.profileDescription = profileDescription;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.profileName;
    }
}

