/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJob;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobSchedule;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobStep;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreJobManager
extends SQLStructEditor<PostgreJob, PostgreDataSource>
implements DBEObjectRenamer<PostgreJob> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{PostgreJobStep.class, PostgreJobSchedule.class});

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreJob> getObjectsCache(PostgreJob object) {
        return object.getDatabase().jobCache;
    }

    protected PostgreJob createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        PostgreDatabase database = ((PostgreDataSource)((Object)container)).getDefaultInstance();
        String name = DBUtils.makeNewObjectName((DBRProgressMonitor)monitor, (String)"Job{0}", (DBSObject)database, PostgreJob.class, PostgreDatabase::getJob, (DBECommandContext)context);
        return new PostgreJob(monitor, database, name);
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, final SQLStructEditor.StructCreateCommand command, Map<String, Object> options) {
        PostgreJob job = (PostgreJob)command.getObject();
        StringJoiner values = new StringJoiner(", ", "(", ")");
        values.add(String.valueOf(job.getJobClass().getObjectId()));
        values.add(SQLUtils.quoteString((DBPDataSource)job.getDataSource(), (String)job.getName()));
        values.add(SQLUtils.quoteString((DBPDataSource)job.getDataSource(), (String)job.getDescription()));
        values.add(SQLUtils.quoteString((DBPDataSource)job.getDataSource(), (String)job.getHostAgent()));
        values.add(String.valueOf(job.isEnabled()));
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        queries.add("INSERT INTO pgagent.pga_job(jobjclid, jobname, jobdesc, jobhostagent, jobenabled)\nVALUES " + values + "\nRETURNING jobid");
        for (SQLObjectEditor.NestedObjectCommand nestedCommand : this.getNestedOrderedCommands(command)) {
            String nestedDeclaration;
            if (nestedCommand.getObject() == job || CommonUtils.isEmpty((String)(nestedDeclaration = nestedCommand.getNestedDeclaration(monitor, (DBSObject)job, options)))) continue;
            queries.add(nestedDeclaration);
        }
        if (queries.size() > 1) {
            buffer.append("WITH\n\n");
            int i = 0;
            while (i < queries.size()) {
                buffer.append("job");
                if (i > 0) {
                    buffer.append("_").append(i);
                }
                buffer.append(" AS (\n").append((String)queries.get(i)).append(")");
                if (i < queries.size() - 1) {
                    buffer.append(",");
                }
                buffer.append("\n\n");
                ++i;
            }
            buffer.append("SELECT jobid FROM job");
        } else {
            buffer.append((String)queries.get(0));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create job", buffer.toString()){

            public void afterExecute(@NotNull DBCSession session, @Nullable DBCStatement stmt, @Nullable Throwable error) throws DBCException {
                if (stmt == null || error != null) {
                    return;
                }
                Throwable throwable = null;
                Object var5_6 = null;
                try (DBCResultSet resultSet = stmt.openResultSet();){
                    if (resultSet != null && resultSet.nextRow()) {
                        ((PostgreJob)command.getObject()).setId(CommonUtils.toLong((Object)resultSet.getAttributeValue(0)));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        PostgreJob job = (PostgreJob)command.getObject();
        StringJoiner values = new StringJoiner(",\n\t");
        if (command.getProperty((Object)"jobClass") != null) {
            values.add("jobjclid=" + job.getJobClass().getObjectId());
        }
        if (command.hasProperty((Object)"description")) {
            values.add("jobdesc=" + SQLUtils.quoteString((DBPDataSource)job.getDataSource(), (String)CommonUtils.notEmpty((String)job.getDescription())));
        }
        if (command.hasProperty((Object)"hostAgent")) {
            values.add("jobhostagent=" + SQLUtils.quoteString((DBPDataSource)job.getDataSource(), (String)CommonUtils.notEmpty((String)job.getHostAgent())));
        }
        if (command.getProperty((Object)"enabled") != null) {
            values.add("jobenabled=" + job.isEnabled());
        }
        if (values.length() > 0) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter job", "UPDATE pgagent.pga_job\nSET\n\t" + values + "\nWHERE jobid=" + job.getObjectId()));
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        PostgreJob job = (PostgreJob)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Delete job", "DELETE FROM pgagent.pga_job\nWHERE jobid=" + job.getObjectId()));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreJob job = (PostgreJob)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename job", "UPDATE pgagent.pga_job\nSET\n\tjobname=" + SQLUtils.quoteString((DBPDataSource)job.getDataSource(), (String)command.getNewName()) + "\nWHERE jobid=" + job.getObjectId()));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreJob object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }
}

